/*
 * File: app/controller/GUI.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.controller.GUI', {
	extend: 'Ext.app.Controller',

	refs: [
		{
			ref: 'content',
			selector: '#content'
		}
	],

	init: function(application) {
		this.control({
			'#logFileTree': {
				select: this.select
			},
			'#showPHP': {
				click: this.showPHP
			}
		});
	},

	select: function(component, selected) {
		var data = {
			action: 'show',
			filename : selected.get('filename')
		};
		if(!Ext.isEmpty(data.filename))
			this.load(data);
	},

	showPHP: function(btn) {
		var data = {
			action: 'showPHP'
		};
		this.load(data);
	},

	load: function(data) {
		Ext.Ajax.request({
			url: '../../service/system_logs.php',
			method: 'POST',
			params: Ext.Object.fromQueryString(document.location.search),
			jsonData: data,
			success: function(response, object){
				var content = Ext.JSON.decode(response.responseText).result;
				this.getContent().update(content);
			},
			failure: function(response, object){
				var text = response.responseText;
				Ext.Error.raise({
					msg: 'Failed to get log content',
					option: text,   // whatever was passed into the method
					'object': object // other arbitrary info
				});
			},
			scope: this
		});

	}

});
