/*
 * File: app/controller/Download.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.controller.Download', {
	extend: 'Ext.app.Controller',

	refs: [
		{
			ref: 'leftSide',
			selector: '#leftSide'
		}
	],

	init: function(application) {
		this.control({
			'#downloadZip': {
				click: this.downloadZip
			},
			'#downloadWeek': {
				click: this.downloadWeek
			},
			'#downloadLatest': {
				click: this.downloadLatest
			}
		});
	},

	downloadZip: function(btn) {
		var data = {
			action: 'monthZip'
		};

		this.download(btn, data);
	},

	downloadWeek: function(btn) {
		var data = {
			action: 'weekZip'
		};

		this.download(btn, data);
	},

	downloadLatest: function(btn) {
		var data = {
			action: 'latestZip'
		};

		this.download(btn, data);
	},

	download: function(btn, data) {
		btn.blur();
		btn.disable();

		var panel = this.getLeftSide();
		panel.setLoading(true);

		Ext.Ajax.request({
			url: '../../service/system_logs.php',
			method: 'POST',
			params: Ext.Object.fromQueryString(document.location.search),
			jsonData: data,
			success: function(response, object){
				var filename = Ext.JSON.decode(response.responseText).result;
				if(!Ext.isEmpty(filename)) {
					var url = '../../service/system_logs.php'+document.location.search+'&action='+data.action+'&filename='+filename;

					var iframe = document.getElementById("hiddenIFrameCurrent");
					if(iframe === null) {
						iframe = document.createElement('iframe');
						iframe.id = "hiddenIFrameCurrent";
						iframe.style.display = 'none';
						document.body.appendChild(iframe);
					}
					iframe.src = url;

					setTimeout(function(){
						panel.setLoading(false);
						btn.enable();
					}, 1500);
				}
				else {
					btn.enable();
					panel.setLoading(false);
				}
			},
			failure: function(response, object){
				panel.setLoading(false);
				var text = response.responseText;
				Ext.Error.raise({
					msg: 'Failed to get log content',
					option: text,   // whatever was passed into the method
					'object': object // other arbitrary info
				});
			},
			scope: this
		});

	}

});
