/**
 * Translator object that performs no translations - no-op. 
 */
Ext.define('CCS.Translator', {
	singleton: true,
	/**
	 * @public
	 * No-op translator that simply returns the input text.
	 *
	 * Placeholders must be formatted {1}, {2}, {3}, etc. 
	 * Note that placeholder numbers start from 1!
	 *
	 * @param {String} english language text to be translated
	 * @param {Array} [replacementValues] array of values to replace placeholders
	 * @return {String} 
	 */
	getText: function(english, replacementValues) {
		if (replacementValues !== undefined) {
			english = this.replacePlaceholders(english, replacementValues);
		}
		return english;
	},
	/**
	 * @private
	 * Replaces a variable number of placeholders in text with values from replacementValues array.
	 * Placeholders must be formatted {1}, {2}, {3}, etc. and numbering begins with 1! 
	 *
	 * @param {String} text string with placeholders
	 * @param {Array} [replacementValues] array of values to replace placeholders
	 * @return {String} 
	 */
	replacePlaceholders: function(text, replacementValues) {
		// replaces a variable number of placeholders in text with values from replacementValues array
		// placeholders must be formatted {1}, {2}, {3}, etc. - numbers start from 1!
		for (i = 0; i < replacementValues.length; i++) {
			// replace {i} with arguments[i]
			text = text.replace('{' + (i+1) + '}', replacementValues[i]);
		}
		return text;
	},
	/**
	 * @public
	 * Translates nothing.
	 * 
	 * @param {Object} object
	 * @param {String} property name of property to translate
	 */
	translate: function(object, property) {
		// no-op
	}
});
