Ext.define("MyApp.view.AttributeManagementWindow",{extend:Ext.window.Window,alias:"widget.AttributeManagementWindow",singleton:true,height:500,hidden:false,itemId:"attributeManagementWindow",width:500,resizable:false,closeAction:"hide",title:"Manage Attributes",modal:true,initComponent:function(){var a=this;Ext.applyIf(a,{dockedItems:[{xtype:"container",dock:"top",items:[{xtype:"treepanel",border:false,height:422,itemId:"attributeManagementTree",autoScroll:true,frameHeader:false,header:false,title:"My Tree Grid Panel",allowDeselect:true,scroll:"vertical",rootVisible:false,viewConfig:{},columns:[{xtype:"treecolumn",dataIndex:"name",text:"Attributes",flex:1,editor:{xtype:"textfield",allowBlank:false,allowOnlyWhitespace:false,enforceMaxLength:true,maxLength:100}},{xtype:"gridcolumn",cls:"gridNumber",align:"right",dataIndex:"usage",text:"Usage"}],selModel:Ext.create("Ext.selection.RowModel",{allowDeselect:true,mode:"SINGLE"}),plugins:[Ext.create("Ext.grid.plugin.CellEditing",{})]}]},{xtype:"toolbar",dock:"bottom",border:true,items:[{xtype:"container",flex:1,margins:"5",layout:{type:"hbox",align:"stretch"},items:[{xtype:"button",itemId:"attributeManagementBtnAttributeCreate",icon:"../gfx/attribute.png",scale:"medium",text:"Create attribute",textAlign:"left"},{xtype:"tbspacer",flex:0.1},{xtype:"button",disabled:true,itemId:"attributeManagementBtnAttributeDelete",icon:"../gfx/attribute_red.png",scale:"medium",text:"Delete attribute",textAlign:"left"},{xtype:"tbspacer",flex:1},{xtype:"button",disabled:true,itemId:"attributeManagementBtnChoiceCreate",icon:"../gfx/attribute_choice.png",scale:"medium",text:"Create choice",textAlign:"left"},{xtype:"tbspacer",flex:0.1},{xtype:"button",disabled:true,itemId:"attributeManagementBtnChoiceDelete",icon:"../gfx/attribute_choice_red.png",scale:"medium",text:"Delete choice",textAlign:"left"}]}]}]});a.callParent(arguments)}});Ext.define("MyApp.controller.Attributes",{extend:Ext.app.Controller,refs:[{ref:"manageAttributesBtnOpenWindow",selector:"#manageAttributesBtnOpenWindow"},{autoCreate:true,ref:"attributeManagementWindow",selector:"#attributeManagementWindow",xtype:"AttributeManagementWindow"},{ref:"attributeManagementTree",selector:"#attributeManagementTree"},{ref:"attributeManagementBtnAttributeCreate",selector:"#attributeManagementBtnAttributeCreate"},{ref:"attributeManagementBtnAttributeDelete",selector:"#attributeManagementBtnAttributeDelete"},{ref:"attributeManagementBtnChoiceCreate",selector:"#attributeManagementBtnChoiceCreate"},{ref:"attributeManagementBtnChoiceDelete",selector:"#attributeManagementBtnChoiceDelete"},{ref:"advancedSearchAttributesPanel",selector:"#advancedSearchAttributesPanel"},{ref:"journalRoleAttributes",selector:"#journalRoleAttributes"},{ref:"journalRoleAttributesCombos",selector:"#journalRoleAttributesCombos"},{ref:"roleJournal",selector:"#RoleJournalMainPanel"}],init:function(a){this.control({"#manageAttributesBtnOpenWindow":{click:function(){this.getAttributeManagementWindow().animateTarget=this.getManageAttributesBtnOpenWindow();this.getAttributeManagementWindow().show();this.getAttributeManagementTree().getStore().load();this.getAttributeManagementTree().expandAll()}},"#attributeManagementTree":{selectionchange:function(b,d,c){this.selectionChanged(d[0])}},"#attributeManagementBtnAttributeCreate":{click:function(){this.attributeCreate()}},"#attributeManagementBtnAttributeDelete":{click:function(){this.attributeDelete()}},"#attributeManagementBtnChoiceCreate":{click:function(){this.choiceCreate()}},"#attributeManagementBtnChoiceDelete":{click:function(){this.choiceDelete()}},"#attributeManagementWindow":{beforeclose:function(){this.getRoleJournal().setLoading(CCS.Translator.getText("Loading..."))},close:this.onCloseAttributeWindow}})},selectionChanged:function(b){this.getAttributeManagementBtnAttributeDelete().disable();this.getAttributeManagementBtnChoiceCreate().disable();this.getAttributeManagementBtnChoiceDelete().disable();if(b!==null&&b!==undefined){this.getAttributeManagementBtnChoiceCreate().enable();if(b.isLeaf()){if(b.get("usage")==0){this.getAttributeManagementBtnChoiceDelete().enable()}}else{var a=true;for(i=0;i<b.childNodes.length;i++){if(b.childNodes[i].get("usage")>0){a=false}}if(a){this.getAttributeManagementBtnAttributeDelete().enable()}}}},attributeCreate:function(){Ext.MessageBox.show({title:CCS.Translator.getText("Create new attribute"),msg:CCS.Translator.getText("Please enter attribute name")+":",width:300,buttons:Ext.MessageBox.OKCANCEL,multiline:false,prompt:true,fn:function(a,b){if(a=="ok"){this.attributeCreateOK(b)}},animateTarget:this.getAttributeManagementBtnAttributeCreate(),scope:this})},attributeCreateOK:function(b){this.getAttributeManagementTree().getSelectionModel().deselectAll();var c=this.getAttributeManagementTree().getStore().getRootNode();var a=this.getAttributeManagementTree().getStore().model;c.appendChild(new a({id:null,name:b,parent_id:c.get("id"),leaf:false,icon:"../gfx/attribute.png"}))},attributeDelete:function(){var a=this.getAttributeManagementTree().getSelectionModel().selected.items[0];Ext.MessageBox.show({title:CCS.Translator.getText("Delete attribute"),msg:CCS.Translator.getText("Are you sure you want to delete attribute {1}?",[a.get("name")]),width:300,buttons:Ext.MessageBox.OKCANCEL,multiline:false,fn:function(b,c){if(b=="ok"){a.set("status","Delete")}},animateTarget:this.getAttributeManagementBtnAttributeDelete(),scope:this})},choiceCreate:function(){var a=this.getAttributeManagementTree().getSelectionModel().selected.items[0];if(a.isLeaf()){a=a.parentNode}Ext.MessageBox.show({title:CCS.Translator.getText("Create new choice for attribute {1}",[a.get("name")]),msg:CCS.Translator.getText("Please enter choice")+":",width:300,buttons:Ext.MessageBox.OKCANCEL,multiline:false,prompt:true,fn:function(c,d){if(c=="ok"){var b=this.getAttributeManagementTree().getStore().model;a.appendChild(new b({id:null,name:d,parent_id:a.get("id"),leaf:true,icon:"../gfx/attribute_choice.png"}))}},animateTarget:this.getAttributeManagementBtnChoiceCreate(),scope:this})},choiceDelete:function(){var a=this.getAttributeManagementTree().getSelectionModel().selected.items[0];Ext.MessageBox.show({title:CCS.Translator.getText("Delete choice"),msg:CCS.Translator.getText("Are you sure you want to delete {1} from attribute {2}?",[a.get("name"),a.parentNode.get("name")]),width:300,buttons:Ext.MessageBox.OKCANCEL,multiline:false,fn:function(b,c){if(b=="ok"){a.set("status","Delete")}},animateTarget:this.getAttributeManagementBtnChoiceDelete(),scope:this})},onLaunch:function(){Ext.getStore("Attributes").load({callback:function(){this.createAttributeCombos(Ext.getStore("Attributes"));this.getAttributeManagementTree().bindStore(Ext.getStore("Attributes"))},scope:this})},createAttributeCombos:function(h){if(!this.advancedSearchAttributes){this.advancedSearchAttributes={}}if(!this.journalAttributes){this.journalAttributes={}}var c=this.getAdvancedSearchAttributesPanel();for(var l in this.advancedSearchAttributes){this.advancedSearchAttributes[l].destroy()}var g=this.getJournalRoleAttributesCombos();for(var l in this.journalAttributes){this.journalAttributes[l].destroy()}var b=[];var f=[];var d=h.getRootNode().childNodes;if(d.length>0){Ext.suspendLayouts();for(i=0;i<d.length;i++){var a=[{attributetreeid:0,attributetreename:"\xa0"}];for(j=0;j<d[i].childNodes.length;j++){a.push({attributetreeid:d[i].childNodes[j].get("real_id"),attributetreename:d[i].childNodes[j].get("name")})}var h=Ext.create("Ext.data.Store",{fields:["attributetreeid","attributetreename"],id:"attributetreeid",data:a});var e=Ext.create("Ext.form.field.ComboBox",{fieldLabel:" "+d[i].get("name"),labelSeparator:" ",margin:"0 0 10 0",labelWidth:150,labelAlign:"right",width:380,store:h,emptyText:"any",displayField:"attributetreename",valueField:"attributetreeid",editable:false,listeners:{change:{fn:function(q,p,n,o){if(p===0){q.reset()}MyApp.app.getController("Search").checkAdvancedFields()}}}});b.push(e);this.advancedSearchAttributes[d[i].get("real_id")]=e;var m=Ext.create("Ext.form.field.ComboBox",{name:"attribute"+d[i].get("real_id"),fieldLabel:" "+d[i].get("name"),labelSeparator:" ",margin:"0 0 10 0",labelWidth:150,labelAlign:"right",width:380,store:h,displayField:"attributetreename",valueField:"attributetreeid",editable:false});f.push(m);this.journalAttributes[d[i].get("real_id")]=m}c.add(b);g.add(f);this.getJournalRoleAttributes().show();Ext.resumeLayouts(true)}else{this.getJournalRoleAttributes().hide()}},getSearchAttributes:function(){if(Ext.isEmpty(this.advancedSearchAttributes)){this.advancedSearchAttributes={}}return this.advancedSearchAttributes},getJournalAttributes:function(){if(Ext.isEmpty(this.journalAttributes)){this.journalAttributes={}}return this.journalAttributes},onCloseAttributeWindow:function(){var a=this;Ext.defer(function(){a.createAttributeCombos(Ext.getStore("Attributes"));a.getRoleJournal().setLoading(false);MyApp.app.getController("Journal").journalLoadActual();MyApp.app.getController("Search").getRoleTreeBarBtnRoleSearch().focus()},50)}});Ext.define("MyApp.controller.Journal",{extend:Ext.app.Controller,refs:[{ref:"roleTreeBarBtnRetrieveJournal",selector:"#roleTreeBarBtnRetrieveJournal"},{ref:"roleTreeBarBtnSaveJournal",selector:"#roleTreeBarBtnSaveJournal"},{ref:"rolejournalform",selector:"#rolejournalform"},{ref:"orglevelspanel",selector:"#orglevelspanel"},{ref:"orgLvlGrid",selector:"#orgLvlGrid"},{ref:"compositeroles",selector:"#compositeroles"},{ref:"orgLvlMsg",selector:"#orgLvlMsg"},{ref:"commentsExtra",selector:"#commentsExtra"},{ref:"commentsExtraText",selector:"#commentsExtraText"},{ref:"businessdescriptionExtra",selector:"#businessdescriptionExtra"},{ref:"businessdescriptionExtraText",selector:"#businessdescriptionExtraText"},{ref:"businessdescriptionExtraImage",selector:"#businessdescriptionExtraImage"},{ref:"commentsExtraImage",selector:"#commentsExtraImage"},{ref:"journalRoleAttributesExtraEmpty",selector:"#journalRoleAttributesExtraEmpty"},{ref:"journalRoleAttributesExtraDifferent",selector:"#journalRoleAttributesExtraDifferent"},{ref:"roleTreeBarBtnClearJournal",selector:"#roleTreeBarBtnClearJournal"}],init:function(a){this.control({"#roleTreeBarBtnRetrieveJournal":{click:function(){this.journalLoad()}},"#roleTreeBarBtnSaveJournal":{click:function(){this.journalSave()}},"#rolejournalform":{dirtychange:function(b,c){if(c&&this.activeJournalRoleIds.length>0){this.getRoleTreeBarBtnSaveJournal().enable()}else{this.getRoleTreeBarBtnSaveJournal().disable()}},actioncomplete:function(b,d,c){this.journalLoadActual()}},"#roleTreeBarBtnClearJournal":{click:function(){this.journalReset()}}})},journalSave:function(){this.getRolejournalform().disable();this.getRoleTreeBarBtnSaveJournal().disable();var c=[];for(i=0;i<this.activeJournalRoleIds.length;i++){c.push(this.activeJournalRoleIds[i])}attributes={};for(var a in this.getJournalAttributes()){attributes[a]=this.getJournalAttributes()[a].getValue()}var b=Ext.Object.fromQueryString(document.location.search);b.comments=this.getRolejournalform().getForm().findField("comments").getValue();b.business_description=this.getRolejournalform().getForm().findField("businessdescription").getValue();b.attributes=attributes;b.id=c;b.method="POST";Ext.Ajax.request({url:"../../service/rolejournal_rolejournal.php",method:"POST",params:Ext.Object.fromQueryString(document.location.search),jsonData:b,success:function(d,e){this.journalLoadActual()},failure:function(d,e){var f=d.responseText;alert("Journal saving failed!");this.getRolejournalform().enable();Ext.Error.raise({msg:"Failed to get report parameters",option:f,object:e})},scope:this})},journalLoad:function(){var a=this.getRoleTreeSelection();var b=[];Ext.each(a,function(c){b.push(c.get("id"))});this.activeJournalRoleIds=b;this.journalLoadActual()},journalLoadActual:function(a){this.getRoleTreeBarBtnRetrieveJournal().blur();this.getRoleTreeBarBtnSaveJournal().disable();this.getRoleTreeBarBtnSaveJournal().disable();this.getRolejournalform().disable();var b={};b.ids=this.activeJournalRoleIds;b.method="GET";if(this.activeJournalRoleIds.length>0){Ext.Ajax.request({url:"../../service/rolejournal_rolejournal.php?",method:"POST",params:Ext.Object.fromQueryString(document.location.search),jsonData:b,success:function(c,d){var e=Ext.JSON.decode(c.responseText);this.journalValues=e.result;this.journalDisplay()},failure:function(c,d){var e=c.responseText;alert("Journal fetching failed!");this.getRolejournalform().enable();Ext.Error.raise({msg:"Failed to get report parameters",option:e,object:d})},scope:this})}else{this.getRolejournalform().enable()}},journalDisplay:function(){Ext.suspendLayouts();var o=this.getJournalAttributes();currentAttributesLength=o.length;var q=this.journalValues;var m=q.length;var d=q[0].transactioncode.split(", ");var p=q[0];var l;var n=(Ext.isEmpty(q[0].rolename))?[]:[q[0].rolename];var b=(Ext.isEmpty(q[0].technicalname))?[]:[q[0].technicalname];var f=(Ext.isEmpty(q[0].roledescription))?[]:[q[0].roledescription];var a=(Ext.isEmpty(q[0].sapStarLicense))?[]:[q[0].sapStarLicense];p.derivedroles=(q[0].derivedroles===null)?0:parseInt(q[0].derivedroles,10);p.usersassigned=(q[0].usersassigned===null)?0:parseInt(q[0].usersassigned,10);p.roleusage=(q[0].roleusage===null)?0:parseInt(q[0].roleusage,10);p.transactions=(q[0].transactions===null)?0:parseInt(q[0].transactions,10);p.transaction12=(q[0].transaction12===null)?0:parseInt(q[0].transaction12,10);this.getCommentsExtra().hide();this.getBusinessdescriptionExtra().hide();this.getJournalRoleAttributesExtraEmpty().hide();this.getJournalRoleAttributesExtraDifferent().hide();for(l in o){o[l].setFieldStyle("border-color:#bbbbbb");var c="attribute"+l;p[c]=(p[c]===undefined)?0:p[c]}if(m>1){var s;var r=[];r.push(q[0].licencetype);p.licencetype="";for(i=1;i<m;i++){if(!Ext.isEmpty(q[i].rolename)){n.push(q[i].rolename)}if(!Ext.isEmpty(q[i].technicalname)){b.push(q[i].technicalname)}if(!Ext.isEmpty(q[i].roledescription)){f.push(q[i].roledescription)}if(!Ext.isEmpty(q[i].sapStarLicense)){a.push(q[i].sapStarLicense)}if(p.masterrole===null){p.masterrole=q[i].masterrole}else{if(p.masterrole!=q[i].masterrole&&q[i].masterrole!==null){p.masterrole="More than one role selected"}}if(p.roletype===null){p.roletype=q[i].roletype}else{if(p.roletype!=q[i].roletype&&q[i].roletype!==null){p.roletype="More than one role selected"}}if(p.lastused===null){p.lastused=q[i].lastused}else{if(q[i].lastused!==null){var h=Ext.Date.parse(p.lastused,"Y-d-m");var e=Ext.Date.parse(q[i].lastused,"Y-d-m");if(h<e){p.lastused=q[i].lastused}}}if(p.comments!=q[i].comments&&(q[i].comments===null||p.comments===""||q[i].comments===""||p.comments===null)){this.getCommentsExtraText().setText(this.getEmptyJournalsErrorMsg());this.getCommentsExtraImage().setSrc("../gfx/orange_info.png");this.getCommentsExtra().show()}if(p.comments===null||p.comments===""){p.comments=q[i].comments}else{if(p.comments!==q[i].comments&&q[i].comments!==null&&p.comments!==""&&q[i].comments!==""){p.comments+="\n\n"+q[i].comments;this.getCommentsExtraText().setText(this.getMultipleJournalsErrorMsg());this.getCommentsExtraImage().setSrc("../gfx/red_info.png");this.getCommentsExtra().show()}}if(p.businessdescription!=q[i].businessdescription&&(q[i].businessdescription===null||p.businessdescription===""||p.businessdescription===null||q[i].businessdescription==="")){this.getBusinessdescriptionExtraText().setText(this.getEmptyJournalsErrorMsg());this.getBusinessdescriptionExtraImage().setSrc("../gfx/orange_info.png");this.getBusinessdescriptionExtra().show()}if(p.businessdescription===null||p.businessdescription===""){p.businessdescription=q[i].businessdescription}else{if(p.businessdescription!=q[i].businessdescription&&q[i].businessdescription!==null&&p.businessdescription!==""&&q[i].businessdescription!==""){p.businessdescription+="\n\n"+q[i].businessdescription;this.getBusinessdescriptionExtraText().setText(this.getMultipleJournalsErrorMsg());this.getBusinessdescriptionExtraImage().setSrc("../gfx/red_info.png");this.getBusinessdescriptionExtra().show()}}var g=q[i].transactioncode.split(", ");for(k=0;k<g.length;k++){s=false;for(j=0;j<d.length;j++){if(d[j]==g[k]){s=true}}if(!s){d.push(g[k])}}s=false;for(j=0;j<r.length;j++){if(r[j]==q[i].licencetype){s=true}}if(!s){r.push(q[i].licencetype)}for(l in o){var c="attribute"+l;if((p[c]===0&&q[i][c]===undefined)||(p[c]===undefined&&q[i][c]===undefined)){p[c]=0}else{if((p[c]===0&&q[i][c]!==undefined)||(p[c]!==0&&q[i][c]===undefined)){p[c]=q[i][c];o[l].setFieldStyle("border-color:#DD9900");this.getJournalRoleAttributesExtraEmpty().show()}else{if(p[c]!=q[i][c]&&p[c]!==0&&q[i][c]!==undefined){p[c]=null;o[l].setFieldStyle("border-color:#DD0000");this.getJournalRoleAttributesExtraDifferent().show()}}}}}for(i=0;i<r.length;i++){p.licencetype+=r[i];if(i<r.length-1){p.licencetype+=", "}}}p.transactioncode="";for(i=0;i<d.length;i++){p.transactioncode+=d[i];if(i<d.length-1){p.transactioncode+=", "}}p.rolename=n.join(", ");if(p.rolename.length>1000){p.rolename=p.rolename.substring(0,1000)+"..."}p.technicalname=b.join(", ");if(p.technicalname.length>1000){p.technicalname=p.technicalname.substring(0,1000)+"..."}p.roledescription=f.join(", ");if(p.roledescription.length>1000){p.roledescription=p.roledescription.substring(0,1000)+"..."}p.sapStarLicense=a.join(", ");if(p.sapStarLicense.length>1000){p.sapStarLicense=p.sapStarLicense.substring(0,1000)+"..."}if(m>1){p.derivedroles="-";p.usersassigned="-";p.roleusage="-";p.transactions="-";p.transaction12="-"}if(p.compositeroles!==""&&p.compositeroles!==undefined){this.setCompositeRoles()}else{this.loadOrgLvls()}this.getRolejournalform().getForm().setValues(p);this.getRolejournalform().getForm().reset(true);this.getRolejournalform().enable();this.getRoleTreeBarBtnClearJournal().enable();Ext.resumeLayouts(true)},loadOrgLvls:function(){this.getOrglevelspanel().setTitle(CCS.Translator.getText("Organizational levels"));this.getCompositeroles().hide();if(this.journalValues.length===0){this.getOrgLvlGrid().hide();this.getOrgLvlMsg().setText(CCS.Translator.getText("No role(s) selected"));this.getOrgLvlMsg().show()}else{if(this.journalValues.length==1){this.getOrgLvlMsg().hide();this.getOrgLvlGrid().getStore().removeAll();this.getOrgLvlGrid().getStore().add(this.journalValues[0].orglvls);this.getOrgLvlGrid().show()}else{this.getOrgLvlGrid().hide();this.getOrgLvlMsg().setText(CCS.Translator.getText("More than one role selected"));this.getOrgLvlMsg().show()}}},setCompositeRoles:function(){this.getOrglevelspanel().setTitle(CCS.Translator.getText("Composite of"));this.getOrgLvlGrid().hide();this.getOrgLvlMsg().hide();this.getCompositeroles().show()},getMultipleJournalsErrorMsg:function(){return CCS.Translator.getText("WARNING!")+" "+CCS.Translator.getText("Journals are different.")+" "+CCS.Translator.getText("The text above is a composite of the different entries.")+" "+CCS.Translator.getText("Saving journal will affect all selected roles.")},getEmptyJournalsErrorMsg:function(){return CCS.Translator.getText("WARNING! Entry is not on the journals of all the selected roles. This field is empty in some journals. Saving the journal will put this text on all journals.")},getRoleTreeSelection:function(){return MyApp.app.getController("Selection").getRoleSelection()},getJournalAttributes:function(){return MyApp.app.getController("Attributes").getJournalAttributes()},journalReset:function(){this.getRoleTreeBarBtnClearJournal().disable();this.getRolejournalform().disable();this.getRoleTreeBarBtnSaveJournal().disable();this.getCommentsExtra().hide();this.getBusinessdescriptionExtra().hide();this.getJournalRoleAttributesExtraEmpty().hide();this.getJournalRoleAttributesExtraDifferent().hide();for(var a in this.getJournalAttributes()){this.getJournalAttributes()[a].setFieldStyle("border-color:#bbbbbb")}Ext.each(this.getRolejournalform().getForm().getFields().items,function(b){b.setValue(null)});this.activeJournalRoleIds=[];this.journalValues=[];this.loadOrgLvls();this.getRolejournalform().enable()},onLaunch:function(){this.activeJournalRoleIds=[]}});Ext.define("MyApp.controller.Search",{extend:Ext.app.Controller,refs:[{ref:"roleTreePaging",selector:"#roleTreePaging"},{ref:"roleTreeBarBtnRoleSearch",selector:"#roleTreeBarBtnRoleSearch"},{ref:"roleTreeBarCheckIncludeDerivedRoles",selector:"#roleTreeBarCheckIncludeDerivedRoles"},{ref:"roleTreeBarCheckShowCompositeOnly",selector:"#roleTreeBarCheckShowCompositeOnly"},{ref:"advancedSearchPanel",selector:"#advancedSearchPanel"},{ref:"advancedSearchTriggerField",selector:"#advancedSearchTriggerField"},{ref:"advancedSearchLicenseCategory",selector:"#advancedSearchLicenseCategory"},{ref:"advancedSearchBtnSearch",selector:"#advancedSearchBtnSearch"},{ref:"advancedSearchBtnClear",selector:"#advancedSearchBtnClear"},{ref:"roleTree",selector:"#roleTree"},{ref:"btnActionExcelAll",selector:"#btnActionExcelAll"},{ref:"btnActionPdfAll",selector:"#btnActionPdfAll"},{ref:"fastSearchTriggerField",selector:"#fastSearchTriggerField"},{ref:"roleTreePagingCombo",selector:"#roleTreePagingCombo"}],init:function(a){this.control({"#roleTreeBarBtnRoleSearch":{specialkey:function(c,b){if(b.getKey()==b.ENTER){this.searchSimple()}},change:function(e,d,b,c){if(d.length>0){this.getFastSearchTriggerField().disable()}else{if(this.getRoleTreeBarCheckIncludeDerivedRoles().getValue()===true&&this.getRoleTreeBarCheckShowCompositeOnly().getValue()===false){this.getFastSearchTriggerField().enable()}}}},"#roleTreeBarCheckIncludeDerivedRoles":{change:function(e,d,b,c){if(d===true){this.getRoleTreeBarCheckShowCompositeOnly().setValue(false);if(this.getRoleTreeBarBtnRoleSearch().getValue().length===0){this.getFastSearchTriggerField().enable()}}else{this.getFastSearchTriggerField().disable()}}},"#roleTreeBarCheckShowCompositeOnly":{change:function(e,d,b,c){if(d===true){this.getRoleTreeBarCheckIncludeDerivedRoles().setValue(false);if(this.getRoleTreeBarBtnRoleSearch().getValue().length>0){this.getFastSearchTriggerField().disable()}}else{if(this.getRoleTreeBarBtnRoleSearch().getValue().length===0&&this.getRoleTreeBarCheckIncludeDerivedRoles().getValue()===true){this.getFastSearchTriggerField().enable()}}}},"#fastSearchTriggerField":{specialkey:function(c,b){if(b.getKey()==b.ENTER){if(!Ext.isEmpty(c.getValue())){this.searchAdvanced()}}},change:function(e,d,b,c){if(d.length>0){this.getRoleTreeBarBtnRoleSearch().disable();this.getRoleTreeBarCheckIncludeDerivedRoles().disable();this.getRoleTreeBarCheckShowCompositeOnly().disable()}else{this.getRoleTreeBarBtnRoleSearch().enable();this.getRoleTreeBarCheckIncludeDerivedRoles().enable();this.getRoleTreeBarCheckShowCompositeOnly().enable()}}},"#advancedSearchPanel":{collapse:function(){this.toggleAdvancedPanel(false)},expand:function(){this.toggleAdvancedPanel(true)}},"#advancedSearchTriggerField":{specialkey:function(c,b){if(b.getKey()==b.ENTER){this.searchAdvanced()}},change:this.checkAdvancedFields},"#advancedSearchLicenseCategory":{change:this.checkAdvancedFields},"#advancedSearchBtnSearch":{click:function(){this.searchAdvanced()}},"#advancedSearchBtnClear":{click:function(){this.clearAdvancedFields()}},"#roleTreePagingCombo":{specialkey:function(c,b){if(b.getKey()==b.ENTER){this.pageSizeChanged()}},select:function(){this.pageSizeChanged()},change:function(){this.pageSizeChanged()}}})},onLaunch:function(){var a=this;this.getRoleTreeBarBtnRoleSearch().onTriggerClick=function(b){a.searchSimple()};this.getFastSearchTriggerField().onTriggerClick=function(b){if(!Ext.isEmpty(a.getFastSearchTriggerField().getValue())){a.searchAdvanced()}};this.getAdvancedSearchTriggerField().onTriggerClick=function(b){a.searchAdvanced()};this.getRoleTreeBarBtnRoleSearch().focus();this.getRoleTreePagingCombo().setValue(50)},search:function(a){this.getRoleTree().setLoading();this.getRoleTreePaging().getStore().getProxy().extraParams=a;this.getRoleTreePaging().getStore().loadPage(1);if(this.getBtnActionExcelAll()!==undefined){this.getBtnActionExcelAll().disable()}if(this.getBtnActionPdfAll()!==undefined){this.getBtnActionPdfAll().disable()}},searchSimple:function(){if(!Ext.isEmpty(this.getRoleTreeBarBtnRoleSearch().getValue())){var a={searchType:"simple",rolefilter:this.getRoleTreeBarBtnRoleSearch().getValue(),includeDerivedRoles:this.getRoleTreeBarCheckIncludeDerivedRoles().getValue(),showCompositeOnly:this.getRoleTreeBarCheckShowCompositeOnly().getValue()};this.setPageSize(a)}},searchAdvanced:function(){if(Ext.isEmpty(this.getFastSearchTriggerField().getValue())){this.getAdvancedSearchBtnSearch().blur();var b={searchType:"advanced",searchstring:this.getAdvancedSearchTriggerField().getValue(),licensecategory:this.getAdvancedSearchLicenseCategory().getValue()};attributeKeys=[];for(var a in this.getSearchAttributes()){if(this.getSearchAttributes()[a].getValue()!==null){attributeKeys.push(this.getSearchAttributes()[a].getValue())}}b.attributeKeys=Ext.JSON.encode(attributeKeys)}else{var b={searchType:"advanced",searchstring:this.getFastSearchTriggerField().getValue()}}this.setPageSize(b)},toggleAdvancedPanel:function(a){if(a){this.getRoleTreeBarBtnRoleSearch().reset();this.getRoleTreeBarCheckIncludeDerivedRoles().reset();this.getRoleTreeBarCheckShowCompositeOnly().reset();this.getFastSearchTriggerField().reset();this.getRoleTreeBarBtnRoleSearch().disable();this.getRoleTreeBarCheckIncludeDerivedRoles().disable();this.getRoleTreeBarCheckShowCompositeOnly().disable();this.getFastSearchTriggerField().disable();this.getAdvancedSearchTriggerField().focus()}else{this.clearAdvancedFields();this.getRoleTreeBarBtnRoleSearch().enable();this.getRoleTreeBarCheckIncludeDerivedRoles().enable();this.getRoleTreeBarCheckShowCompositeOnly().enable();this.getFastSearchTriggerField().enable();this.getRoleTreeBarBtnRoleSearch().focus()}},clearAdvancedFields:function(){this.getAdvancedSearchBtnClear().blur();this.getAdvancedSearchTriggerField().reset();this.getAdvancedSearchLicenseCategory().reset();for(var a in this.getSearchAttributes()){this.getSearchAttributes()[a].reset()}},checkAdvancedFields:function(){this.getAdvancedSearchBtnSearch().disable();if(this.getAdvancedSearchTriggerField().getValue().length>0){this.getAdvancedSearchBtnSearch().enable()}if(this.getAdvancedSearchLicenseCategory().getValue()!==null){this.getAdvancedSearchBtnSearch().enable()}for(var a in this.getSearchAttributes()){if(this.getSearchAttributes()[a].getValue()!==null){this.getAdvancedSearchBtnSearch().enable()}}},getSearchAttributes:function(){return MyApp.app.getController("Attributes").getSearchAttributes()},receiveSearchResult:function(c){this.totalRoleIds=c.get("totalRoleIds");var a=this.getRoleTree().getStore().model;var b=Ext.create("Ext.data.TreeStore",{model:a,root:c.get("entries"),data:c.get("entries")});this.getRoleTree().bindStore(b);MyApp.app.getController("Selection").checkSelection();if(this.totalRoleIds.length>0&&this.getBtnActionExcelAll()!==undefined){this.getBtnActionExcelAll().enable()}if(this.totalRoleIds.length>0&&this.getBtnActionPdfAll()!==undefined){this.getBtnActionPdfAll().enable()}this.getRoleTree().setLoading(false)},clearSearchResults:function(){this.totalRoleIds=[];var c={roleid:"root",children:[]};var a=this.getRoleTree().getStore().model;var b=Ext.create("Ext.data.TreeStore",{model:a,root:c,data:c});this.getRoleTree().bindStore(b);this.getRoleTree().setLoading(false)},getTotalRoleIds:function(){return(this.totalRoleIds!==undefined)?this.totalRoleIds:0},setPageSize:function(b){var a=parseInt(this.getRoleTreePagingCombo().getValue(),10);b.limit=a;this.search(b)},pageSizeChanged:function(){if(this.getAdvancedSearchPanel().collapsed&&Ext.isEmpty(this.getFastSearchTriggerField().getValue())){this.searchSimple()}else{this.searchAdvanced()}}});Ext.define("MyApp.controller.Selection",{extend:Ext.app.Controller,refs:[{ref:"roleTree",selector:"#roleTree"},{ref:"roleTreeView",selector:"#roleTreeView"},{ref:"roleTreeBarBtnViewSelection",selector:"#roleTreeBarBtnViewSelection"},{ref:"roleTreeBarBtnClearSelection",selector:"#roleTreeBarBtnClearSelection"},{ref:"roleTreeBarBtnSelectAll",selector:"#roleTreeBarBtnSelectAll"},{ref:"roleSelectionWindow",selector:"#roleSelectionWindow"},{ref:"roleSelectionWindowGridPanel",selector:"#roleSelectionWindowGridPanel"},{ref:"roleSelectionWindowBtnRemove",selector:"#roleSelectionWindowBtnRemove"},{ref:"roleSelectionWindowBtnClear",selector:"#roleSelectionWindowBtnClear"},{ref:"roleTreeBarBtnRetrieveJournal",selector:"#roleTreeBarBtnRetrieveJournal"}],init:function(a){this.control({"#roleTree":{select:function(e,b,c,d){this.select(b)},deselect:function(e,b,c,d){this.deselect(b)},selectionchange:function(b,d,c){this.roleSelectionChanged(b,d)},beforeitemdblclick:function(c,b,g,d,h,f){this.dblClick(b);return false}},"#roleTreeBarBtnViewSelection":{click:function(){this.roleSelectionWindowToggle()}},"#roleTreeBarBtnClearSelection":{click:function(){this.clearSelection()}},"#roleSelectionWindowBtnClear":{click:function(){this.clearSelection()}},"#roleSelectionWindowBtnRemove":{click:function(){var b=this.getRoleSelectionWindowGridPanel().getSelectionModel().getSelection();this.getRoleTree().getSelectionModel().deselect(b,false);var c=this;Ext.Array.forEach(b,function(d){c.deselect(d)});this.getRoleSelectionWindowBtnRemove().blur()}},"#roleSelectionWindow":{hide:function(){this.RoleSelectionWindowAlreadyShowing=false}}})},onLaunch:function(){this.getRoleSelectionWindowGridPanel().bindStore(Ext.getStore("Selection"))},getRoleSelection:function(){var a=[];Ext.getStore("Selection").each(function(b){a.push(b)});return a},roleSelectionWindowToggle:function(){if(!this.roleSelectionWindowCreated){this.getRoleSelectionWindow().animateTarget=this.getRoleTreeBarBtnViewSelection();this.roleSelectionWindowCreated=true}if(this.RoleSelectionWindowAlreadyShowing){this.getRoleSelectionWindow().hide();this.getRoleTreeBarBtnViewSelection().blur()}else{this.getRoleSelectionWindow().show();this.RoleSelectionWindowAlreadyShowing=true}},roleSelectionChanged:function(){var b=this.getRoleSelection();var d=b.length;this.getRoleTreeBarBtnClearSelection().setText("("+d+")");if(d<1){this.getRoleTreeBarBtnClearSelection().disable();this.getRoleTreeBarBtnRetrieveJournal().disable()}else{if(d>0){this.getRoleTreeBarBtnClearSelection().enable();this.getRoleTreeBarBtnRetrieveJournal().enable()}}var a="root";for(var c=0;c<d;c++){if(a=="root"&&b[c].raw.parentroleid=="root"){a=b[c].raw.technicalname}else{if(a=="root"&&b[c].raw.parentroleid!="root"){a=b[c].raw.parentroleid}}if(b[c].raw.parentroleid!=a&&b[c].raw.technicalname!=a){this.getRoleTreeBarBtnRetrieveJournal().disable()}}},select:function(a){var c=this.getRoleSelection();var b=true;Ext.Array.each(c,function(d){if(a.data.id==d.data.id){b=false}});if(b){Ext.getStore("Selection").insert(0,a)}this.roleSelectionChanged()},deselect:function(a){Ext.getStore("Selection").remove(a);this.roleSelectionChanged()},clearSelection:function(){this.getRoleTree().getSelectionModel().deselectAll();this.getRoleTreeBarBtnClearSelection().blur();if(this.roleSelectionWindowCreated){this.getRoleSelectionWindowBtnClear().blur()}var a=this.getRoleSelection();var b=a.length;for(i=0;i<b;i++){this.deselect(a[i])}this.roleSelectionChanged()},checkSelection:function(){var d=this.getRoleSelection();var b=this.getRoleTree().getStore();var c=this.getRoleTree().getSelectionModel();var a;Ext.Array.each(d,function(e){if(e!==undefined){a=b.getNodeById(e.data.id);if(a){c.select(a,true,false)}}})},dblClick:function(a){var b=this.getRoleTree().getSelectionModel();a.eachChild(function(c){b.select(c,true)});b.select(a,true);if(!a.isExpanded()){a.expand()}}});Ext.define("MyApp.controller.pdf",{extend:Ext.app.Controller,refs:[{ref:"openButton",selector:"#roleTreeBarBtnPDFgenerator"},{ref:"statusContainer",selector:"#cntPdfStatus"},{ref:"actionButton",selector:"#btnActionPdf"},{ref:"downloadPdfBtn",selector:"#btnDownloadPdf"},{ref:"btnActionPdfAll",selector:"#btnActionPdfAll"}],init:function(a){this.control({"#roleTreeBarBtnPDFgenerator":{click:this.onOpenButtonClick},"#roleTree":{selectionchange:this.setActionButtonStatus},"#btnActionPdf":{click:this.onActionButtonClick},"#btnActionPdfAll":{click:this.onActionButtonAllClick}})},onOpenButtonClick:function(){if(!this.popup||!this.popup.getEl()){this.popup=Ext.create("MyApp.view.PdfWindow",{animateTarget:this.getOpenButton()})}this.popup.showBy(this.getOpenButton(),"tc-bc?");if(this.serviceStatus){this.updateStatus(this.serviceStatus)}this.callService({action:"status"})},updateStatus:function(a){var c=false;if(a.id){switch(a.status){case 0:this.actionButtonStatus=false;this.getOpenButton().setIcon("../gfx/pdf-working.gif");this.setStatusText(CCS.Translator.getText("Waiting in queue"));if(this.popup!==undefined){this.popup.setIcon("../gfx/pdf-working.gif")}c=true;break;case 1:this.actionButtonStatus=false;this.getOpenButton().setIcon("../gfx/pdf-working.gif");if(this.popup!==undefined){this.popup.setIcon("../gfx/pdf-working.gif")}if(a.progress.total==1){this.setStatusText(CCS.Translator.getText("Generating PDF"))}else{this.setStatusText(CCS.Translator.getText("Generating {1} of {2} PDFs",[a.progress.current,a.progress.total]))}c=true;break;case 2:this.actionButtonStatus=true;var b=(a.total>1)?"../gfx/pdf-zip.png":"../gfx/pdf-document.png";this.getOpenButton().setIcon(b);if(this.popup!==undefined){this.popup.setIcon("../gfx/pdf.png")}if(this.getDownloadPdfBtn()!==null&&this.getDownloadPdfBtn()!==undefined){this.getDownloadPdfBtn().enable();this.getDownloadPdfBtn().setIcon(b);this.getDownloadPdfBtn().show();this.getDownloadPdfBtn().setHandler(function(){var e="hiddenDownloader",d=document.getElementById(e);if(d===null){d=document.createElement("iframe");d.id=e;d.style.display="none";document.body.appendChild(d)}d.src="../../service/rolejournal_pdf.php"+document.location.search+"&id="+a.id})}this.setStatusText(CCS.Translator.getText("PDF ready"));break;case 4:this.actionButtonStatus=true;this.getOpenButton().setIcon("../gfx/pdf.png");if(this.popup!==undefined){this.popup.setIcon("../gfx/pdf.png")}this.setStatusText(CCS.Translator.getText("PDF generation failed"));break;case 5:this.actionButtonStatus=true;this.getOpenButton().setIcon("../gfx/pdf.png");if(this.popup!==undefined){this.popup.setIcon("../gfx/pdf.png")}this.setStatusText(CCS.Translator.getText("PDF generation cancelled"));break}}else{this.actionButtonStatus=true;this.getOpenButton().setIcon("../gfx/pdf.png");this.setStatusText(CCS.Translator.getText("No PDF requested"))}this.setActionButtonStatus();this.serviceStatus=a;return c},callService:function(b){if(this.serviceRequest&&Ext.Ajax.isLoading(this.serviceRequest)){var a=this.serviceRequest;delete this.serviceRequest;Ext.Ajax.abort(a)}var c={data:Ext.JSON.encode(b)};this.serviceRequest=Ext.Ajax.request({url:"../../service/rolejournal_pdf.php",method:"POST",params:Ext.merge({},c,Ext.Object.fromQueryString(document.location.search)),success:function(f,g){var l=f.responseText;var d=Ext.JSON.decode(l);var h=this.updateStatus(d);if(h){var e=new Ext.util.DelayedTask(this.callService,this,[{action:"status"}]);e.delay(2000)}},failure:function(d,e){},scope:this})},setCancelButtonVisible:function(b){var a=this.getCancelButton();if(a){if(b){a.show()}else{a.hide()}}},setStatusText:function(a){var b=this.getStatusContainer();if(b){b.update('<p align="center">'+a+"</p>")}},setActionButtonStatus:function(){var a=this.getActionButton();if(a){a.setText(CCS.Translator.getText(this.actionButtonStatus?"Generate PDF for selected role(s)":"Cancel PDF generation"));a.show();if(this.getRoleTreeSelection().length>0||!this.actionButtonStatus){a.enable()}else{a.disable()}}a=this.getBtnActionPdfAll();if(a){if(this.getTotelSearchedRoleIds().length>0&&this.actionButtonStatus){a.enable()}else{a.disable()}}},onActionButtonClick:function(){this.getDownloadPdfBtn().disable();var c={action:this.actionButtonStatus?"start":"stop"};if(this.actionButtonStatus){var a=this.getRoleTreeSelection();var b=[];Ext.each(a,function(d){b.push(d.data.id)});c.roles=b}this.getActionButton().disable();this.setStatusText(CCS.Translator.getText("Updating"));this.callService(c)},onActionButtonAllClick:function(){this.getDownloadPdfBtn().disable();var a={action:"start",roles:this.getTotelSearchedRoleIds(),addChildren:true};this.getBtnActionPdfAll().disable();this.setStatusText(CCS.Translator.getText("Updating"));this.callService(a)},onLaunch:function(){this.callService({action:"status"})},getRoleTreeSelection:function(){return MyApp.app.getController("Selection").getRoleSelection()},getTotelSearchedRoleIds:function(){return MyApp.app.getController("Search").getTotalRoleIds()}});Ext.define("MyApp.controller.xlsx",{extend:Ext.app.Controller,refs:[{ref:"openButton",selector:"#roleTreeBarBtnXLSXgenerator"},{ref:"statusContainer",selector:"#cntExcelStatus"},{ref:"actionButton",selector:"#btnActionExcel"},{ref:"downloadExcelBtn",selector:"#btnDownloadExcel"},{ref:"btnActionExcelAll",selector:"#btnActionExcelAll"}],init:function(a){this.control({"#roleTreeBarBtnXLSXgenerator":{click:this.onOpenButtonClick},"#roleTree":{selectionchange:this.setActionButtonStatus},"#btnActionExcel":{click:this.onActionButtonClick},"#btnActionExcelAll":{click:this.onActionButtonAllClick}})},onOpenButtonClick:function(){if(!this.popup||!this.popup.getEl()){this.popup=Ext.create("MyApp.view.ExcelWindow",{animateTarget:this.getOpenButton()})}this.popup.showBy(this.getOpenButton(),"tc-bc?");if(this.serviceStatus){this.updateStatus(this.serviceStatus)}this.callService({action:"status"});if(this.getTotelSearchedRoleIds().length>0){this.getBtnActionExcelAll().enable()}},updateStatus:function(a){var b=false;if(a.id){switch(a.status){case 0:this.actionButtonStatus=false;this.getOpenButton().setIcon("../gfx/pdf-working.gif");this.setStatusText(CCS.Translator.getText("Waiting in queue"));if(this.popup!==undefined){this.popup.setIcon("../gfx/pdf-working.gif")}b=true;break;case 1:this.actionButtonStatus=false;this.getOpenButton().setIcon("../gfx/pdf-working.gif");var c=CCS.Translator.getText(a.progress.task)+"<br>";c+='<span style="color: #99bbe8; font-size:10px; font-weigth: bold;"> ';c+=(a.progress.current>0)?(a.progress.current/a.progress.total*100).toFixed(1)+"%":"";c+="</span>";this.setStatusText(c);if(this.popup!==undefined){this.popup.setIcon("../gfx/pdf-working.gif")}b=true;break;case 2:this.actionButtonStatus=true;this.getOpenButton().setIcon("../gfx/xlsx.png");if(this.popup!==undefined){this.popup.setIcon("../gfx/xlsx.png")}if(this.getDownloadExcelBtn()!==null&&this.getDownloadExcelBtn()!==undefined){this.getDownloadExcelBtn().show();this.getDownloadExcelBtn().setHandler(function(){var e="hiddenDownloader",d=document.getElementById(e);if(d===null){d=document.createElement("iframe");d.id=e;d.style.display="none";document.body.appendChild(d)}d.src="../../service/rj_excel.php"+document.location.search+"&id="+a.id})}this.setStatusText(CCS.Translator.getText("Excel document ready"));break;case 4:this.actionButtonStatus=true;this.getOpenButton().setIcon("../gfx/xlsx.png");if(this.popup!==undefined){this.popup.setIcon("../gfx/xlsx.png")}this.setStatusText(CCS.Translator.getText("Excel generation failed"));break;case 5:this.actionButtonStatus=true;this.getOpenButton().setIcon("../gfx/xlsx.png");if(this.popup!==undefined){this.popup.setIcon("../gfx/xlsx.png")}this.setStatusText(CCS.Translator.getText("Excel generation cancelled"));break}}else{this.actionButtonStatus=true;this.getOpenButton().setIcon("../gfx/xlsx.png");this.setStatusText(CCS.Translator.getText("No Excel requested"))}this.setActionButtonStatus();this.serviceStatus=a;return b},callService:function(b){if(this.serviceRequest&&Ext.Ajax.isLoading(this.serviceRequest)){var a=this.serviceRequest;delete this.serviceRequest;Ext.Ajax.abort(a)}var c={data:Ext.JSON.encode(b)};this.serviceRequest=Ext.Ajax.request({url:"../../service/rj_excel.php",method:"POST",params:Ext.merge({},c,Ext.Object.fromQueryString(document.location.search)),success:function(f,g){var l=f.responseText;var d=Ext.JSON.decode(l);var h=this.updateStatus(d);if(h){var e=new Ext.util.DelayedTask(this.callService,this,[{action:"status"}]);e.delay(2000)}},failure:function(d,e){},scope:this})},setCancelButtonVisible:function(b){var a=this.getCancelButton();if(a){if(b){a.show()}else{a.hide()}}},setStatusText:function(a){var b=this.getStatusContainer();if(b){b.update('<p align="center">'+a+"</p>")}},setActionButtonStatus:function(){var a=this.getActionButton();if(a){a.setText(CCS.Translator.getText(this.actionButtonStatus?"Generate Excel for selected role(s)":"Cancel Excel generation"));a.show();if(this.getRoleTreeSelection().length>0||!this.actionButtonStatus){a.enable()}else{a.disable()}}a=this.getBtnActionExcelAll();if(a){if(this.getTotelSearchedRoleIds().length>0&&this.actionButtonStatus){a.enable()}else{a.disable()}}},onActionButtonClick:function(){var c={action:this.actionButtonStatus?"start":"stop",addChildren:false};if(this.actionButtonStatus){var a=this.getRoleTreeSelection();var b=[];Ext.each(a,function(d){b.push(d.data.id)});c.roles=b}this.getActionButton().disable();this.getBtnActionExcelAll().disable();this.setStatusText(CCS.Translator.getText("Updating"));this.callService(c)},onActionButtonAllClick:function(){var a={action:"start",roles:this.getTotelSearchedRoleIds(),addChildren:true};this.getBtnActionExcelAll().disable();this.setStatusText(CCS.Translator.getText("Updating"));this.callService(a)},onLaunch:function(){this.callService({action:"status"})},getRoleTreeSelection:function(){return MyApp.app.getController("Selection").getRoleSelection()},getTotelSearchedRoleIds:function(){return MyApp.app.getController("Search").getTotalRoleIds()}});Ext.define("MyApp.model.Attribute",{extend:Ext.data.Model,fields:[{name:"id"},{name:"name"},{name:"parent_id"},{name:"status"},{name:"usage"},{name:"real_id"}]});Ext.define("MyApp.model.LicenseCategory",{extend:Ext.data.Model,fields:[{name:"id"},{name:"category"}]});Ext.define("MyApp.model.OrgLevel",{extend:Ext.data.Model,fields:[{name:"varbl"},{name:"vtext"},{mapping:"delete",name:"del"},{name:"low"},{name:"high"}]});Ext.define("MyApp.model.Role",{extend:Ext.data.Model,fields:[{name:"id"},{name:"technicalname"},{name:"name"},{name:"derivatives"},{name:"licensetype"}]});Ext.define("MyApp.model.RoleData",{extend:Ext.data.Model,fields:[{name:"total"},{name:"entries"},{name:"totalRoleIds"}]});Ext.define("MyApp.store.Attributes",{extend:Ext.data.TreeStore,constructor:function(a){var b=this;a=a||{};b.callParent([Ext.apply({autoLoad:false,autoSync:true,model:"MyApp.model.Attribute",storeId:"Attributes",proxy:{type:"ajax",url:"../../service/rolejournal_attributes.php",reader:{type:"json"}},listeners:{beforeload:{fn:b.onTreeStoreBeforeLoad,scope:b},write:{fn:b.onTreeStoreWrite,scope:b},load:{fn:b.onTreeStoreLoad,scope:b}}},a)])},onTreeStoreBeforeLoad:function(b,a,c){b.proxy.extraParams=Ext.Object.fromQueryString(document.location.search)},onTreeStoreWrite:function(c,b,d){var a=Ext.decode(b.response.responseText);switch(a.status){case -1:Ext.Msg.alert("Status",CCS.Translator.getText('Attribute "{1}" already exists!',[a.children.name]));break}c.load()},onTreeStoreLoad:function(a,d,b,e,c){d.expand(true)}});Ext.define("MyApp.store.DummyRoleTreeStore",{extend:Ext.data.TreeStore,constructor:function(a){var b=this;a=a||{};b.callParent([Ext.apply({model:"MyApp.model.Role",remoteFilter:true,storeId:"DummyRoleTreeStore",listeners:{beforeload:{fn:b.onTreeStoreBeforeLoad,scope:b}}},a)])},onTreeStoreBeforeLoad:function(b,a,c){return false}});Ext.define("MyApp.store.LicenseCategory",{extend:Ext.data.Store,constructor:function(a){var b=this;a=a||{};b.callParent([Ext.apply({autoLoad:true,model:"MyApp.model.LicenseCategory",storeId:"LicenseCategory",proxy:{type:"ajax",url:"../../service/license_category.php",reader:{type:"json",root:"result"}},listeners:{beforeload:{fn:b.onJsonstoreBeforeLoad,scope:b},load:{fn:b.onJsonstoreLoad,scope:b}}},a)])},onJsonstoreBeforeLoad:function(b,a,c){b.proxy.extraParams=Ext.Object.fromQueryString(document.location.search)},onJsonstoreLoad:function(c,b,f,d){var a=c.model;var e=new a({id:-1,category:"\xa0"});c.insert(0,e)}});Ext.define("MyApp.store.OrgLevel",{extend:Ext.data.Store,constructor:function(a){var b=this;a=a||{};b.callParent([Ext.apply({model:"MyApp.model.OrgLevel",storeId:"MyArrayStore"},a)])}});Ext.define("MyApp.store.Role",{extend:Ext.data.Store,constructor:function(a){var b=this;a=a||{};b.callParent([Ext.apply({autoLoad:false,model:"MyApp.model.RoleData",storeId:"Role",pageSize:50,proxy:{type:"ajax",url:"../../service/rj_roles.php",reader:{type:"json"}},listeners:{beforeload:{fn:b.onJsonstoreBeforeLoad,scope:b},load:{fn:b.onJsonstoreLoad,scope:b}}},a)])},onJsonstoreBeforeLoad:function(c,b,e){var h=0;var g=c.lastOptions.page;var a=parseInt(MyApp.app.getController("Search").getRoleTreePagingCombo().getValue(),10);if(g!==1){var d=g-1;h=d*a}c.proxy.extraParams.start=h;c.pageSize=a;var f=Ext.merge(Ext.Object.fromQueryString(document.location.search),c.proxy.extraParams);c.proxy.extraParams=f;c.proxy.actionMethods={create:"POST",read:"POST",update:"POST",destroy:"POST"};MyApp.app.getController("Search").getRoleTree().setLoading(CCS.Translator.getText("Loading..."))},onJsonstoreLoad:function(b,a,d,c){if(a.length>0){MyApp.app.getController("Search").receiveSearchResult(a[0])}else{MyApp.app.getController("Search").clearSearchResults()}}});Ext.define("MyApp.store.Selection",{extend:Ext.data.Store,constructor:function(a){var b=this;a=a||{};b.callParent([Ext.apply({model:"MyApp.model.Role",storeId:"Selection",proxy:{type:"memory",reader:{type:"array"}}},a)])}});Ext.define("MyApp.view.ExcelWindow",{extend:Ext.window.Window,width:230,animCollapse:true,icon:"../gfx/xlsx.png",title:"Excel generator",initComponent:function(){var a=this;Ext.applyIf(a,{items:[{xtype:"container",padding:"5 5 5 5",items:[{xtype:"container",height:40,html:'<p align="center">No Excel requested</p>',itemId:"cntExcelStatus",padding:0}]}],dockedItems:[{xtype:"container",dock:"bottom",border:false,shrinkWrap:0,layout:{type:"vbox",align:"stretch"},items:[{xtype:"button",flex:1,margins:"10 5 5 5",hidden:true,itemId:"btnActionExcel",icon:"../gfx/xlsx.png",scale:"medium",text:"Create .xlsx file"},{xtype:"button",flex:1,margins:"10 5 5 5",disabled:true,itemId:"btnActionExcelAll",icon:"../gfx/xlsx.png",scale:"medium",text:"Create Excel file for search result"},{xtype:"button",flex:1,margins:"5 5 5 5",hidden:true,itemId:"btnDownloadExcel",icon:"../gfx/xlsx.png",scale:"medium",text:"Download Excel file"}]}]});a.callParent(arguments)}});Ext.define("MyApp.view.PdfWindow",{extend:Ext.window.Window,width:230,animCollapse:true,icon:"../gfx/pdf.png",title:"PDF generator",initComponent:function(){var a=this;Ext.applyIf(a,{items:[{xtype:"container",padding:"5 5 5 5",items:[{xtype:"container",height:40,html:'<p align="center">No PDF requested</p>',itemId:"cntPdfStatus",padding:0}]}],dockedItems:[{xtype:"container",dock:"bottom",border:false,shrinkWrap:0,layout:{type:"vbox",align:"stretch"},items:[{xtype:"button",flex:1,margins:"10 5 5 5",hidden:true,itemId:"btnActionPdf",icon:"../gfx/pdf.png",scale:"medium",text:"Create .pdf file"},{xtype:"button",flex:1,margins:"10 5 5 5",disabled:true,itemId:"btnActionPdfAll",icon:"../gfx/pdf.png",scale:"medium",text:"Create PDFs for search results"},{xtype:"button",flex:1,margins:"5 5 5 5",hidden:true,itemId:"btnDownloadPdf",icon:"../gfx/pdf-document.png",scale:"medium",text:"Download PDF"}]}]});a.callParent(arguments)}});Ext.define("MyApp.view.RoleJournal",{extend:Ext.panel.Panel,itemId:"RoleJournalMainPanel",autoScroll:true,bodyPadding:"5 5 0 5",header:false,title:"Role Journal",layout:{type:"vbox",align:"stretch"},initComponent:function(){var a=this;Ext.applyIf(a,{items:[{xtype:"fieldset",padding:"3 10 10 10",layout:"fit",title:"Role list",items:[{xtype:"treepanel",border:false,height:400,itemId:"roleTree",margin:0,autoScroll:true,animCollapse:true,header:false,manageHeight:false,title:"My Tree Grid Panel",hideHeaders:false,scroll:"vertical",store:"DummyRoleTreeStore",animate:true,rootVisible:false,useArrows:true,viewConfig:{itemId:"roleTreeView"},columns:[{xtype:"treecolumn",renderer:function(g,d,c,h,f,e,b){return Ext.util.Format.htmlEncode(g)},dataIndex:"technicalname",text:"Role",flex:1},{xtype:"gridcolumn",dataIndex:"name",text:"Description",flex:1},{xtype:"numbercolumn",cls:"gridNumber",width:80,align:"right",dataIndex:"derivatives",text:"Derived roles",format:"0,000"},{xtype:"gridcolumn",width:210,dataIndex:"licensetype",text:"License category"}],dockedItems:[{xtype:"toolbar",dock:"bottom",items:[{xtype:"container",flex:1,margins:"7 0 0 0",items:[{xtype:"container",layout:{type:"hbox",align:"stretch"},items:[{xtype:"tbspacer",minWidth:5},{xtype:"triggerfield",flex:1,itemId:"fastSearchTriggerField",fieldLabel:"Smart search",labelAlign:"right",labelSeparator:" ",labelWidth:75,triggerCls:"x-form-search-trigger"},{xtype:"triggerfield",itemId:"roleTreeBarBtnRoleSearch",width:380,fieldLabel:"Role search",labelAlign:"right",labelSeparator:" ",labelWidth:150,triggerCls:"x-form-search-trigger"},{xtype:"tbspacer",flex:0.1},{xtype:"checkboxfield",itemId:"roleTreeBarCheckIncludeDerivedRoles",boxLabel:"also search in derived roles",checked:true,inputValue:"true",uncheckedValue:"false"},{xtype:"tbspacer",flex:0.1},{xtype:"checkboxfield",itemId:"roleTreeBarCheckShowCompositeOnly",boxLabel:"show composite roles only",inputValue:"true",uncheckedValue:"false"},{xtype:"tbspacer",flex:0.1},{xtype:"button",itemId:"manageAttributesBtnOpenWindow",icon:"../gfx/attribute.png",text:"Manage Attributes"},{xtype:"tbspacer",minWidth:5}]},{xtype:"fieldset",border:false,itemId:"advancedSearchPanel",margin:0,padding:"0 10 0 10",collapsed:true,collapsible:true,title:"Advanced search",layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",flex:1,itemId:"advancedSearchAttributesPanel",maxHeight:280,overflowY:"auto",layout:{type:"column",manageOverflow:1},items:[{xtype:"triggerfield",itemId:"advancedSearchTriggerField",margin:"0 0 10 0",width:380,fieldLabel:"Smart search",labelAlign:"right",labelSeparator:" ",labelWidth:150,triggerCls:"x-form-search-trigger"},{xtype:"combobox",itemId:"advancedSearchLicenseCategory",margin:"0 0 10 0",width:380,fieldLabel:"License Category",labelAlign:"right",labelSeparator:" ",labelWidth:150,emptyText:"any",editable:false,displayField:"category",forceSelection:true,queryMode:"local",store:"LicenseCategory",valueField:"id",listeners:{change:{fn:a.onAdvancedSearchLicenseCategoryChange,scope:a}}}]},{xtype:"container",flex:1,margin:"0 10 10 0",layout:{type:"hbox",align:"bottom",pack:"end"},items:[{xtype:"tbspacer",flex:10},{xtype:"button",itemId:"advancedSearchBtnClear",icon:"../gfx/clear.png",scale:"medium",text:"Reset search criteria",textAlign:"left"},{xtype:"tbspacer",flex:1},{xtype:"button",disabled:true,itemId:"advancedSearchBtnSearch",icon:"../gfx/search.png",scale:"medium",text:"Advanced search",textAlign:"left",tooltip:"Search in rolename, description, license type and attributes for roles, derived roles and composite roles."}]}]}]}]},{xtype:"pagingtoolbar",dock:"bottom",itemId:"roleTreePaging",width:360,displayInfo:true,store:"Role",items:[{xtype:"button",itemId:"roleTreeBarBtnViewSelection",icon:"../gfx/view.png",tooltip:"View Selection"},{xtype:"button",disabled:true,itemId:"roleTreeBarBtnClearSelection",icon:"../gfx/clear.png",tooltip:"Clear Selection"},{xtype:"tbseparator"},{xtype:"tbspacer",width:5},{xtype:"combobox",itemId:"roleTreePagingCombo",width:50,labelSeparator:" ",value:25,store:[10,50,100,250,500,1000,5000]},{xtype:"tbspacer",width:3},{xtype:"label",text:"per page"},{xtype:"tbspacer",width:5},{xtype:"container",flex:10,layout:{type:"hbox",align:"stretch"},items:[{xtype:"button",disabled:true,itemId:"roleTreeBarBtnRetrieveJournal",icon:"../gfx/document.png",text:"Load Journal"},{xtype:"tbspacer",width:10},{xtype:"button",disabled:true,itemId:"roleTreeBarBtnClearJournal",icon:"../gfx/document_clear.png",text:"Clear current Journal",tooltip:"The current journal will no longer loaded. Last saved version will still be available by reloading it."},{xtype:"tbspacer",width:10},{xtype:"button",disabled:true,itemId:"roleTreeBarBtnSaveJournal",icon:"../gfx/save.png",text:"Save Journal"},{xtype:"tbspacer",flex:1},{xtype:"button",itemId:"roleTreeBarBtnXLSXgenerator",icon:"../gfx/xlsx.png",text:"Excel generator"},{xtype:"tbspacer",width:10},{xtype:"button",itemId:"roleTreeBarBtnPDFgenerator",icon:"../gfx/pdf.png",text:"PDF generator"},{xtype:"tbspacer"}]}]}],selModel:Ext.create("Ext.selection.CheckboxModel",{pruneRemoved:false,toggleOnClick:false,injectCheckbox:"first",showHeaderCheckbox:false})}]},{xtype:"form",border:false,itemId:"rolejournalform",header:false,title:"My Form",pollForChanges:true,jsonSubmit:true,trackResetOnLoad:true,url:"../../service/rolejournal_rolejournal.php",layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",layout:{type:"hbox",align:"stretch"},items:[{xtype:"fieldset",flex:2,margins:"0 12 0 0",padding:"3 10 10 10",title:"Basic information",items:[{xtype:"displayfield",anchor:"100%",fieldLabel:"Master role",labelSeparator:" ",labelWidth:150,name:"masterrole"},{xtype:"displayfield",anchor:"100%",fieldLabel:"Role",labelSeparator:" ",labelWidth:150,name:"technicalname"},{xtype:"displayfield",anchor:"100%",fieldLabel:"Role type",labelSeparator:" ",labelWidth:150,name:"roletype"},{xtype:"displayfield",anchor:"100%",fieldLabel:"Role description",labelSeparator:" ",labelWidth:150,name:"rolename"},{xtype:"displayfield",anchor:"100%",fieldLabel:"Role SAP star license",labelSeparator:" ",labelWidth:150,name:"sapStarLicense"},{xtype:"displayfield",anchor:"100%",fieldLabel:"Role UM license category",labelSeparator:" ",labelWidth:150,name:"licencetype"},{xtype:"displayfield",anchor:"100%",fieldLabel:"Source system",labelSeparator:" ",labelWidth:150,name:"sourcesystem"}]},{xtype:"fieldset",flex:1,padding:"3 10 10 10",title:"Statistical information",items:[{xtype:"displayfield",anchor:"100%",fieldLabel:"No. of derived roles",labelSeparator:" ",labelWidth:300,name:"derivedroles",value:0,fieldStyle:"text-align:right"},{xtype:"displayfield",anchor:"100%",fieldLabel:"No. of users assigned",labelSeparator:" ",labelWidth:300,name:"usersassigned",value:0,fieldStyle:"text-align:right"},{xtype:"displayfield",anchor:"100%",fieldLabel:"Usage last 12 months",labelSeparator:" ",labelWidth:300,name:"roleusage",value:0,fieldStyle:"text-align:right"},{xtype:"displayfield",anchor:"100%",fieldLabel:"Transactions assigned",labelSeparator:" ",labelWidth:300,name:"transactions",value:0,fieldStyle:"text-align:right"},{xtype:"displayfield",anchor:"100%",fieldLabel:"Transactions used last 12 months",labelSeparator:" ",labelWidth:300,name:"transaction12",value:0,fieldStyle:"text-align:right"},{xtype:"displayfield",anchor:"100%",fieldLabel:"Last usage",labelSeparator:" ",labelWidth:300,name:"lastused",fieldStyle:"text-align:right"}]}]},{xtype:"container",layout:{type:"hbox",align:"stretch"},items:[{xtype:"fieldset",flex:2,margins:"0 12 0 0",height:150,padding:"3 10 5 10",title:"Business description",layout:{type:"vbox",align:"stretch"},items:[{xtype:"textareafield",flex:3,name:"businessdescription"},{xtype:"container",flex:1,height:32,hidden:true,itemId:"businessdescriptionExtra",layout:{type:"hbox",align:"stretch"},items:[{xtype:"image",itemId:"businessdescriptionExtraImage",margin:"0 5 0 0",maxHeight:22,maxWidth:22,src:"../gfx/red_info.png"},{xtype:"label",itemId:"businessdescriptionExtraText",text:"WARNING! Entry is not on the journals of all the selected roles. This field is empty in some journals. Saving the journal will put this text on all journals."}]}]},{xtype:"fieldset",flex:1,height:150,padding:"3 10 5 10",title:"Comments",layout:{type:"vbox",align:"stretch"},items:[{xtype:"textareafield",flex:2,name:"comments"},{xtype:"container",hidden:true,itemId:"commentsExtra",layout:{type:"hbox",align:"stretch"},items:[{xtype:"image",itemId:"commentsExtraImage",margin:"0 5 0 0",maxHeight:22,maxWidth:22,src:"../gfx/red_info.png"},{xtype:"label",flex:1,itemId:"commentsExtraText",text:"WARNING! Entry is not on the journals of all the selected roles. This field is empty in some journals. Saving the journal will put this text on all journals."}]}]}]},{xtype:"fieldset",hidden:true,itemId:"journalRoleAttributes",padding:"3 10 1 10",title:"Role attributes",layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",flex:1,margins:"0",itemId:"journalRoleAttributesCombos",margin:0,padding:0,layout:"column"},{xtype:"container",flex:1,hidden:true,itemId:"journalRoleAttributesExtraEmpty",layout:{type:"hbox",align:"stretch",padding:"5 0 5 0"},items:[{xtype:"image",margins:"0 5 0 0",src:"../gfx/orange_info.png"},{xtype:"label",flex:1,text:"Orange marked attributes are empty on some journals. Saving will update entry to all active journals."}]},{xtype:"container",flex:1,hidden:true,itemId:"journalRoleAttributesExtraDifferent",layout:{type:"hbox",align:"stretch",padding:"5 0 5 0"},items:[{xtype:"image",margins:"0 5 0 0",src:"../gfx/red_info.png"},{xtype:"label",flex:1,text:"Red marked attributes are different on some journals. If these attriibutes are set they will be set on all active journals."}]}]},{xtype:"container",layout:{type:"hbox",align:"stretch"},items:[{xtype:"fieldset",flex:1,margins:"0 12 0 0",padding:"3 10 7 10",layout:"fit",title:"PFCG role description",items:[{xtype:"textareafield",maxHeight:200,name:"roledescription",readOnly:true}]},{xtype:"fieldset",flex:1,margins:"0 12 0 0",itemId:"orglevelspanel",padding:"3 10 7 10",title:"Organizational levels",layout:{type:"hbox",align:"stretch",pack:"center"},items:[{xtype:"textareafield",flex:1,hidden:true,itemId:"compositeroles",maxHeight:200,name:"compositeroles",readOnly:true},{xtype:"label",itemId:"orgLvlMsg",text:"No role(s) selected"},{xtype:"gridpanel",flex:1,border:false,hidden:true,itemId:"orgLvlGrid",maxHeight:200,header:false,title:"My Grid Panel",store:"OrgLevel",columns:[{xtype:"gridcolumn",dataIndex:"varbl",text:"Variable",flex:1},{xtype:"gridcolumn",dataIndex:"vtext",text:"Vtext",flex:2},{xtype:"gridcolumn",dataIndex:"low",text:"Low",flex:1},{xtype:"gridcolumn",dataIndex:"high",text:"High",flex:1}]}]},{xtype:"fieldset",flex:1,padding:"3 10 7 10",layout:"fit",title:"Transaction code assignment",items:[{xtype:"textareafield",maxHeight:200,name:"transactioncode",readOnly:true}]}]}]}]});a.callParent(arguments)},onAdvancedSearchLicenseCategoryChange:function(d,c,a,b){if(c===-1){d.reset()}}});Ext.define("MyApp.view.RoleSelectionWindow",{extend:Ext.window.Window,alias:"widget.RoleSelectionWindow",singleton:true,itemId:"roleSelectionWindow",width:400,animCollapse:true,closeAction:"hide",title:"Role selection",layout:{type:"vbox",align:"stretch"},initComponent:function(){var a=this;Ext.applyIf(a,{items:[{xtype:"gridpanel",flex:1,border:false,height:400,itemId:"roleSelectionWindowGridPanel",overflowY:"scroll",title:"",columns:[{xtype:"gridcolumn",dataIndex:"technicalname",text:"Role",flex:1}],selModel:Ext.create("Ext.selection.RowModel",{mode:"MULTI"})},{xtype:"container",margin:5,layout:{type:"hbox",align:"stretch",pack:"end"},items:[{xtype:"button",itemId:"roleSelectionWindowBtnRemove",icon:"../gfx/remove.png",scale:"medium",text:"Remove from selection",textAlign:"left"},{xtype:"tbspacer",flex:1},{xtype:"button",itemId:"roleSelectionWindowBtnClear",icon:"../gfx/clear.png",scale:"medium",text:"Remove all",textAlign:"left"}]}]});a.callParent(arguments)}});