/*
 * File: app.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

// @require @packageOverrides
Ext.Loader.setConfig({
	enabled: true
});


Ext.application({
	models: [
		'ReportHistory',
		'User',
		'UserSelect',
		'Tcode',
		'RoleSelect',
		'Role',
		'UserGroup',
		'LicenseCategory',
		'UsageSystem',
		'Language'
	],
	stores: [
		'ReportHistoryStore',
		'User',
		'UserSelect',
		'Favorites',
		'Tcode',
		'TcodeSelect',
		'Role',
		'RoleSelect',
		'UserGroup',
		'LicenseCategory',
		'UsageSystem',
		'LanguageStore'
	],
	views: [
		'UMReportsPanel',
		'StatusWindow',
		'SelectionPanel'
	],
	controllers: [
		'ReportsController',
		'FavoriteHistorySync',
		'BackgroundStatus',
		'GUI'
	],
	name: 'MyApp',

	getParams: function() {
		return Ext.Object.fromQueryString(document.location.search);
	},

	launch: function() {
		Ext.create('MyApp.view.UMReportsPanel', {renderTo: Ext.getBody()});
		this.msgCt = Ext.DomHelper.insertFirst(document.body, {id:'msg-div'}, true);
	},

	message: function(title, message) {
		var s = Ext.String.format.apply(String, Array.prototype.slice.call(arguments, 1));
		var m = Ext.DomHelper.append(this.msgCt, '<div class="msg"><h3>' + title + '</h3><p>' + s + '</p></div>', true);
		m.hide();
		m.slideIn('t').ghost("t", { delay: 2000, remove: true});
	}

});
