/*
 * File: app/view/MainPanel.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.view.MainPanel', {
	extend: 'Ext.panel.Panel',

	requires: [
		'Ext.form.FieldSet',
		'Ext.tree.Panel',
		'Ext.tree.View',
		'Ext.tree.Column',
		'Ext.button.Button',
		'Ext.toolbar.Spacer',
		'Ext.resizer.Splitter',
		'Ext.grid.Panel',
		'Ext.grid.View',
		'Ext.grid.plugin.CellEditing',
		'Ext.form.Panel',
		'Ext.form.field.File',
		'Ext.form.field.Date',
		'Ext.form.field.Number'
	],

	border: false,
	height: 567,
	itemId: 'dashboardPanel',
	padding: '3 10 0 10',
	width: 997,
	autoScroll: true,
	layout: 'fit',
	header: false,
	title: 'License Archive',

	initComponent: function() {
		var me = this;

		Ext.applyIf(me, {
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					items: [
						{
							xtype: 'fieldset',
							flex: 2,
							title: 'License mapping',
							layout: {
								type: 'vbox',
								align: 'stretch'
							},
							items: [
								{
									xtype: 'treepanel',
									flex: 1,
									border: false,
									height: 250,
									itemId: 'licenseMap',
									margin: '0 0 10 0',
									width: 400,
									header: false,
									title: 'My Tree Grid Panel',
									store: 'LicenseMapping',
									rootVisible: false,
									viewConfig: {

									},
									columns: [
										{
											xtype: 'treecolumn',
											width: 376,
											dataIndex: 'category',
											text: 'Consolidated license category',
											flex: 1
										},
										{
											xtype: 'gridcolumn',
											dataIndex: 'dash_abbr',
											text: 'Abbr.'
										},
										{
											xtype: 'gridcolumn',
											renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
												if(value)
												return '<img src = "../gfx/green_checkmark.png" title="'+CCS.Translator.getText('This category is included on dashboards.')+'" />';
												else
												return '';
											},
											cls: 'setLeft',
											width: 30,
											align: 'center',
											dataIndex: 'dash_incl',
											text: ''
										},
										{
											xtype: 'gridcolumn',
											dataIndex: 'sapLicense',
											text: 'SAP license',
											flex: 1
										},
										{
											xtype: 'gridcolumn',
											dataIndex: 'syscli',
											text: 'System / Client'
										},
										{
											xtype: 'gridcolumn',
											cls: 'setLeft',
											align: 'right',
											dataIndex: 'mapped_roles',
											text: 'Roles'
										},
										{
											xtype: 'gridcolumn',
											dataIndex: 'license_type',
											text: 'License type'
										},
										{
											xtype: 'gridcolumn',
											cls: 'setLeft',
											align: 'right',
											dataIndex: 'quantity',
											text: 'Quantity'
										},
										{
											xtype: 'gridcolumn',
											cls: 'setLeft',
											align: 'right',
											dataIndex: 'cost',
											text: 'Cost'
										}
									]
								},
								{
									xtype: 'container',
									margin: '0 0 10 0',
									layout: {
										type: 'hbox',
										align: 'stretch'
									},
									items: [
										{
											xtype: 'button',
											itemId: 'btnCreateCategory',
											icon: '../gfx/license_consolidated.png',
											scale: 'medium',
											text: 'New consolidated'
										},
										{
											xtype: 'tbspacer',
											width: 10
										},
										{
											xtype: 'button',
											disabled: true,
											itemId: 'btnEditCategory',
											icon: '../gfx/license_consolidated.png',
											scale: 'medium',
											text: 'Edit consolidated'
										},
										{
											xtype: 'tbspacer',
											width: 10
										},
										{
											xtype: 'button',
											disabled: true,
											itemId: 'btnDeleteCategory',
											icon: '../gfx/delete.png',
											scale: 'medium',
											text: 'Delete consolidated'
										},
										{
											xtype: 'tbspacer',
											flex: 1
										},
										{
											xtype: 'button',
											disabled: true,
											itemId: 'btnCreate',
											icon: '../gfx/license.png',
											scale: 'medium',
											text: 'Create'
										},
										{
											xtype: 'tbspacer',
											width: 10
										},
										{
											xtype: 'button',
											disabled: true,
											itemId: 'btnEdit',
											icon: '../gfx/license.png',
											scale: 'medium',
											text: 'Edit'
										},
										{
											xtype: 'tbspacer',
											width: 10
										},
										{
											xtype: 'button',
											disabled: true,
											itemId: 'btnMapSap',
											icon: '../gfx/sap_license.png',
											scale: 'medium',
											text: 'Map to SU01 license'
										},
										{
											xtype: 'tbspacer',
											width: 10
										},
										{
											xtype: 'button',
											disabled: true,
											itemId: 'btnMapExisting',
											icon: '../gfx/link.png',
											scale: 'medium',
											text: 'Link existing UM category',
											tooltip: 'Map to an existing UM category'
										},
										{
											xtype: 'tbspacer',
											width: 10
										},
										{
											xtype: 'button',
											disabled: true,
											itemId: 'btnUnmap',
											icon: '../gfx/unlink.png',
											scale: 'medium',
											text: 'Unlink'
										},
										{
											xtype: 'tbspacer',
											width: 10
										},
										{
											xtype: 'button',
											disabled: true,
											itemId: 'btnDeleteLocal',
											icon: '../gfx/delete.png',
											scale: 'medium',
											text: 'Delete'
										}
									]
								}
							]
						},
						{
							xtype: 'splitter'
						},
						{
							xtype: 'fieldset',
							flex: 1,
							width: 10,
							title: 'License purchases',
							layout: {
								type: 'vbox',
								align: 'stretch'
							},
							items: [
								{
									xtype: 'container',
									flex: 1,
									itemId: 'GridContainer',
									layout: 'fit',
									items: [
										{
											xtype: 'gridpanel',
											itemId: 'GridPanel',
											header: false,
											title: 'My Grid Panel',
											store: 'fileStore',
											columns: [
												{
													xtype: 'gridcolumn',
													hidden: true,
													itemId: 'fileID',
													dataIndex: 'FID',
													text: 'FileID'
												},
												{
													xtype: 'gridcolumn',
													itemId: 'invoiceDate',
													dataIndex: 'purchaseDate',
													text: 'Purchase date'
												},
												{
													xtype: 'gridcolumn',
													itemId: 'name',
													width: 135,
													dataIndex: 'name',
													text: 'Name',
													editor: {
														xtype: 'textfield',
														itemId: 'nameInputField'
													}
												},
												{
													xtype: 'gridcolumn',
													itemId: 'commentDesciption',
													dataIndex: 'comment',
													text: 'Comment / Description',
													flex: 1,
													editor: {
														xtype: 'textfield',
														itemId: 'commentInputField'
													}
												},
												{
													xtype: 'gridcolumn',
													itemId: 'amount',
													dataIndex: 'amount',
													text: 'Amount'
												},
												{
													xtype: 'gridcolumn',
													renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
														var encodedData = record.data.file_data;
														var FID = record.data.FID;

														button = "<img border='0' src='../gfx/tool-down.gif' title='"+CCS.Translator.getText('Download')+"' " +
														"onmouseover=this.style.cursor='pointer' "+
														"onclick="+'"'+
														"MyApp.app.getController('GridController').downloadFile('"+FID+"');"+
														'"'+
														" />";

														return button;





													},
													itemId: 'file',
													width: 70,
													align: 'center',
													dataIndex: 'file_name',
													text: 'File'
												},
												{
													xtype: 'gridcolumn',
													itemId: 'uploadCreateDate',
													width: 140,
													dataIndex: 'uploadDate',
													text: 'Upload date / Create date'
												}
											],
											plugins: [
												Ext.create('Ext.grid.plugin.CellEditing', {

												})
											]
										}
									]
								},
								{
									xtype: 'container',
									flex: 1,
									itemId: 'uploadBtnContainer',
									maxHeight: 45,
									layout: {
										type: 'hbox',
										align: 'stretch',
										padding: '7 7 7 7'
									},
									items: [
										{
											xtype: 'button',
											itemId: 'newLicBtn',
											icon: '../gfx/add.png',
											scale: 'medium',
											text: 'New license'
										},
										{
											xtype: 'tbspacer',
											width: 10
										},
										{
											xtype: 'button',
											disabled: true,
											hidden: true,
											itemId: 'editLicBtn',
											icon: '../gfx/license_consolidated.png',
											scale: 'medium',
											text: 'Edit license'
										},
										{
											xtype: 'tbspacer',
											width: 10
										},
										{
											xtype: 'button',
											disabled: true,
											itemId: 'deleteLicBtn',
											icon: '../gfx/delete.png',
											scale: 'medium',
											text: 'Delete license'
										}
									]
								},
								{
									xtype: 'container',
									disabled: true,
									hidden: true,
									itemId: 'uploadContainer',
									layout: {
										type: 'hbox',
										align: 'stretch'
									},
									items: [
										{
											xtype: 'form',
											flex: 1,
											border: false,
											itemId: 'uploadForm',
											bodyPadding: 10,
											header: false,
											title: 'Upload file',
											layout: {
												type: 'hbox',
												align: 'stretch'
											},
											items: [
												{
													xtype: 'filefield',
													flex: 1,
													itemId: 'fileUploadField',
													fieldLabel: 'File',
													labelWidth: 50,
													msgTarget: 'side',
													name: 'file',
													allowBlank: false,
													buttonText: 'Select file'
												},
												{
													xtype: 'datefield',
													itemId: 'invoiceDateField',
													padding: '0 0 0 10',
													fieldLabel: 'Purchase date',
													name: 'invoicedate',
													allowBlank: false,
													format: 'Y-m-d'
												},
												{
													xtype: 'numberfield',
													itemId: 'amountField',
													padding: '0 0 0 10',
													fieldLabel: 'Amount',
													labelWidth: 50,
													name: 'amount',
													allowBlank: false
												},
												{
													xtype: 'tbspacer',
													width: 10
												},
												{
													xtype: 'button',
													handler: function(button, e) {
														var orgParams = Ext.Object.fromQueryString(document.location.search);

														var tempurl = '../../service/upload_file.php?user=' + orgParams.user;

														var form = this.up('form').getForm();
														var gridPanel = MyApp.app.getController('GridController').getGridPanel();

														/*var uploadField = MyApp.app.getController('GridController').getFileUploadField();
														console.log(uploadField);
														console.log(uploadField.getEl());*/



														if (form.isValid())
														{
															gridPanel.setLoading(CCS.Translator.getText('Loading...'));

															//console.log('UPLOAD FILE');

															form.submit({
																url: tempurl,
																waitMsg: 'Uploading file',
																success: function(fp, o) {
																	console.log(o.result.data);

																	gridPanel.setLoading(false);
																	gridPanel.getStore().load();
																	if (o.result.data !== undefined || o.result.data !== null)
																	{
																		var convertedSize = convertSize(o.result.data.size);
																		Ext.Msg.alert(o.result.msg, 'Upload: <b>' + o.result.data.name + '</b> <br> Size: <b>' + convertedSize + '</b>');

																		var periodDateField = MyApp.app.getController('GridController').getPeriodDateField();
																		//periodDateField.reset();
																		var invoiceDateField = MyApp.app.getController('GridController').getInvoiceDateField();
																		//invoiceDateField.reset();
																		var amountField = MyApp.app.getController('GridController').getAmountField();
																		//amountField.reset();
																	}
																},
																failure: function(fp, o) {
																	//console.log('FAILURE');

																	gridPanel.setLoading(false);
																	var message = "";
																	if (o.result.data !== undefined || o.result.data !== null)
																	{
																		var convertedSize = convertSize(o.result.data.size);
																		if (o.result.data.error == "size")
																		{
																			var convetedMaxSize = convertSize(o.result.data.maxsize);
																			message = 'The file <b>' + o.result.data.name + '</b> is <b>' + convertedSize + '</b><br>';
																			message += 'Max file size is <b>'+ convetedMaxSize +'</b>';
																		}
																		else if (o.result.data.error == "file")
																		{
																			message = o.result.data.errormsg;
																		}

																		Ext.Msg.alert(o.result.msg, message);
																	}
																}
															});
														}


														function convertSize(size) {
															if (size >= (1024*1024)) // 1 MB
															{
																value = size / (1024 * 1024);
																return value.toFixed(1) + " MB";
															}
															else if (size >= 1024) // 1 KB
															{
																value = size / 1024;
																return value.toFixed(1) + " KB";
															}
															else
															{
																return size + " B";
															}
														}
													},
													itemId: 'uploadButton',
													text: 'Upload'
												},
												{
													xtype: 'tbspacer',
													flex: 1
												}
											]
										}
									]
								},
								{
									xtype: 'container',
									hidden: true,
									itemId: 'emptyContainer'
								}
							]
						}
					]
				}
			]
		});

		me.callParent(arguments);
	}

});