/*
 * File: app/view/LicenseWindow.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.view.LicenseWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.LicenseWindow',

	requires: [
		'Ext.form.Panel',
		'Ext.form.field.File',
		'Ext.form.field.Date',
		'Ext.form.field.Number',
		'Ext.form.field.TextArea',
		'Ext.toolbar.Spacer',
		'Ext.button.Button'
	],

	itemId: 'LicenseWindow',
	width: 400,
	layout: 'fit',
	title: 'Add/Edit License',
	modal: true,

	initComponent: function() {
		var me = this;

		Ext.applyIf(me, {
			items: [
				{
					xtype: 'form',
					itemId: 'licenseCategoryForm',
					bodyPadding: 10,
					header: false,
					title: 'My Form',
					items: [
						{
							xtype: 'container',
							layout: {
								type: 'vbox',
								align: 'stretch',
								pack: 'end'
							},
							items: [
								{
									xtype: 'form',
									flex: 1,
									border: false,
									itemId: 'uploadForm1',
									header: false,
									title: 'Upload file',
									layout: {
										type: 'vbox',
										align: 'stretch'
									},
									items: [
										{
											xtype: 'filefield',
											flex: 1,
											itemId: 'fileUploadField',
											fieldLabel: 'File',
											labelSeparator: ' ',
											msgTarget: 'side',
											name: 'file',
											allowBlank: false,
											buttonText: 'Select file'
										},
										{
											xtype: 'datefield',
											itemId: 'invoiceDateField',
											fieldLabel: 'Purchase date',
											labelSeparator: ' ',
											name: 'invoicedate',
											allowBlank: false,
											format: 'Y-m-d'
										},
										{
											xtype: 'numberfield',
											itemId: 'amountField',
											fieldLabel: 'Amount',
											labelSeparator: ' ',
											name: 'amount',
											allowBlank: false
										},
										{
											xtype: 'textareafield',
											itemId: 'commentField',
											fieldLabel: 'Comment',
											labelSeparator: ' ',
											name: 'comment'
										},
										{
											xtype: 'tbspacer',
											flex: 1
										}
									]
								},
								{
									xtype: 'container',
									flex: 1,
									layout: {
										type: 'hbox',
										align: 'stretch'
									},
									items: [
										{
											xtype: 'tbspacer',
											flex: 1
										},
										{
											xtype: 'button',
											handler: function(button, e) {
												var orgParams = Ext.Object.fromQueryString(document.location.search);

												var tempurl = '../../service/upload_file.php?user=' + orgParams.user;

												var form = this.up('form').getForm();
												var gridPanel = MyApp.app.getController('GridController').getGridPanel();

												/*var uploadField = MyApp.app.getController('GridController').getFileUploadField();
												console.log(uploadField);
												console.log(uploadField.getEl());*/


												if (form.isValid())
												{
													gridPanel.setLoading(CCS.Translator.getText('Loading...'));

													//console.log('UPLOAD FILE');

													form.submit({
														url: tempurl,
														waitMsg: 'Uploading file',
														success: function(fp, o) {
															console.log(o.result.data);

															gridPanel.setLoading(false);
															gridPanel.getStore().load();
															if (o.result.data !== undefined || o.result.data !== null)
															{
																var convertedSize = convertSize(o.result.data.size);
																Ext.Msg.alert(o.result.msg, 'Upload: <b>' + o.result.data.name + '</b> <br> Size: <b>' + convertedSize + '</b>');

																var periodDateField = MyApp.app.getController('GridController').getPeriodDateField();
																//periodDateField.reset();
																var invoiceDateField = MyApp.app.getController('GridController').getInvoiceDateField();
																//invoiceDateField.reset();
																var amountField = MyApp.app.getController('GridController').getAmountField();
																//amountField.reset();
															}
														},
														failure: function(fp, o) {
															//console.log('FAILURE');

															gridPanel.setLoading(false);
															var message = "";
															if (o.result.data !== undefined || o.result.data !== null)
															{
																var convertedSize = convertSize(o.result.data.size);
																if (o.result.data.error == "size")
																{
																	var convetedMaxSize = convertSize(o.result.data.maxsize);
																	message = 'The file <b>' + o.result.data.name + '</b> is <b>' + convertedSize + '</b><br>';
																	message += 'Max file size is <b>'+ convetedMaxSize +'</b>';
																}
																else if (o.result.data.error == "file")
																{
																	message = o.result.data.errormsg;
																}

																Ext.Msg.alert(o.result.msg, message);
															}
														}
													});
												}


												function convertSize(size) {
													if (size >= (1024*1024)) // 1 MB
													{
														value = size / (1024 * 1024);
														return value.toFixed(1) + " MB";
													}
													else if (size >= 1024) // 1 KB
													{
														value = size / 1024;
														return value.toFixed(1) + " KB";
													}
													else
													{
														return size + " B";
													}
												}
											},
											itemId: 'uploadButton',
											icon: '../gfx/add.png',
											scale: 'medium',
											text: 'Save'
										}
									]
								}
							]
						}
					]
				}
			]
		});

		me.callParent(arguments);
	}

});