/*
 * File: app/view/LicenseCategoryWindow.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.view.LicenseCategoryWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.LicenseCategoryWindow',

	requires: [
		'Ext.form.Panel',
		'Ext.form.field.Number',
		'Ext.form.field.ComboBox',
		'Ext.form.field.Checkbox',
		'Ext.button.Button'
	],

	itemId: 'LicenseCategoryWindow',
	width: 400,
	layout: 'fit',
	title: 'Consolidated license category',
	modal: true,

	initComponent: function() {
		var me = this;

		Ext.applyIf(me, {
			items: [
				{
					xtype: 'form',
					itemId: 'licenseCategoryForm',
					bodyPadding: 10,
					header: false,
					title: 'My Form',
					items: [
						{
							xtype: 'numberfield',
							anchor: '100%',
							hidden: true,
							fieldLabel: 'Label',
							name: 'id'
						},
						{
							xtype: 'textfield',
							anchor: '100%',
							fieldLabel: 'Category',
							labelSeparator: ' ',
							name: 'category',
							allowBlank: false,
							allowOnlyWhitespace: false,
							enforceMaxLength: true,
							maxLength: 120,
							listeners: {
								change: {
									fn: me.onTextfieldChange,
									scope: me
								}
							}
						},
						{
							xtype: 'combobox',
							anchor: '100%',
							fieldLabel: 'Type',
							labelSeparator: ' ',
							name: 'type',
							allowBlank: false,
							allowOnlyWhitespace: false,
							selectOnFocus: true,
							editable: false,
							displayField: 'type',
							forceSelection: true,
							queryMode: 'local',
							store: 'LicenseType',
							valueField: 'id'
						},
						{
							xtype: 'textfield',
							anchor: '100%',
							fieldLabel: 'Quantity',
							labelSeparator: ' ',
							name: 'quantity',
							allowBlank: false,
							allowOnlyWhitespace: false,
							maskRe: /^[0-9]*$/,
							regex: /^[0-9]*$/
						},
						{
							xtype: 'textfield',
							anchor: '100%',
							fieldLabel: 'Cost',
							labelSeparator: ' ',
							name: 'cost',
							allowBlank: false,
							allowOnlyWhitespace: false,
							maskRe: /^[0-9]*$/,
							regex: /^[0-9]*$/
						},
						{
							xtype: 'textfield',
							anchor: '100%',
							fieldLabel: 'Dashboard name',
							labelSeparator: ' ',
							name: 'dash_abbr',
							allowBlank: false,
							allowOnlyWhitespace: false,
							enforceMaxLength: true,
							maxLength: 12
						},
						{
							xtype: 'checkboxfield',
							anchor: '100%',
							fieldLabel: 'Dashboard incl.',
							labelSeparator: ' ',
							name: 'dash_incl',
							checked: true,
							inputValue: 'true',
							uncheckedValue: 'false'
						},
						{
							xtype: 'container',
							layout: {
								type: 'hbox',
								align: 'stretch',
								pack: 'end'
							},
							items: [
								{
									xtype: 'button',
									disabled: true,
									itemId: 'btnLicenseCategoryCreate',
									icon: '../gfx/save.png',
									scale: 'medium',
									text: 'Save'
								},
								{
									xtype: 'button',
									disabled: true,
									hidden: true,
									itemId: 'btnLicenseCategoryEdit',
									icon: '../gfx/save.png',
									scale: 'medium',
									text: 'Save'
								}
							]
						}
					]
				}
			]
		});

		me.callParent(arguments);
	},

	onTextfieldChange: function(field, newValue, oldValue, eOpts) {
		if(newValue.length <= 12) {
			field.up('form').getForm().findField('dash_abbr').setValue(newValue);
		}
	}

});