/*
 * File: app/controller/LicenseMapping.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.controller.LicenseMapping', {
	extend: 'Ext.app.Controller',

	refs: [
		{
			ref: 'licenseMap',
			selector: '#licenseMap'
		},
		{
			autoCreate: true,
			ref: 'mappingWindow',
			selector: '#MappingWindow',
			xtype: 'MappingWindow'
		},
		{
			ref: 'btnMapExistingSave',
			selector: '#btnMapExistingSave'
		},
		{
			ref: 'btnMapSU01Save',
			selector: '#btnMapSU01Save'
		},
		{
			autoCreate: true,
			ref: 'localLicenseWindow',
			selector: '#LocalLicenseWindow',
			xtype: 'LocalLicenseWindow'
		},
		{
			ref: 'btnLocalLicenseCreate',
			selector: '#btnLocalLicenseCreate'
		},
		{
			ref: 'btnLocalLicenseEdit',
			selector: '#btnLocalLicenseEdit'
		},
		{
			ref: 'btnDeleteLocal',
			selector: '#btnDeleteLocal'
		},
		{
			ref: 'btnUnmap',
			selector: '#btnUnmap'
		}
	],

	init: function(application) {
		this.control({
			'#btnCreate': {
				click: function(btn) {
					var record = this.getLicenseMap().getSelectionModel().getSelection()[0];
					this.createOpenWindow(btn, record);
				}
			},
			'#btnLocalLicenseCreate': {
				click: function(btn) {
					btn.disable();
					this.create();
				}
			},
			'#btnLocalLicenseEdit': {
				click: function(btn) {
					btn.disable();
					this.edit();
				}
			},
			'#btnMapExisting': {
				click: function(btn) {
					var record = this.getLicenseMap().getSelectionModel().getSelection()[0];
					this.mapExistingOpenWindow(btn, record);
				}
			},
			'#btnMapExistingSave': {
				click: function(btn) {
					btn.disable();
					this.mapExisting();
				}
			},
			'#btnMapSap': {
				click: function(btn) {
					var record = this.getLicenseMap().getSelectionModel().getSelection()[0];
					this.mapSU01OpenWindow(btn, record);
				}
			},
			'#btnMapSU01Save': {
				click: function(btn) {
					btn.disable();
					this.mapSU01();
				}
			},
			'#btnEdit': {
				click: function(btn) {
					var record = this.getLicenseMap().getSelectionModel().getSelection()[0];
					this.createOpenWindow(btn, record);
				}
			},
			'#btnDeleteLocal': {
				click: function(btn) {
					this.deleteCategory();
				}
			},
			'#btnUnmap': {
				click: function(btn) {
					this.unMapCategory();
				}
			}
		});

	},

	mapExistingOpenWindow: function(button, record) {
		var syscli = record.get('syscli');

		var unassignedCategory = this.getLicenseMap().getStore().getById(0);

		//if there are no unmapped categories
		if(Ext.isEmpty(unassignedCategory)) {
			Ext.MessageBox.alert(CCS.Translator.getText('Error'), CCS.Translator.getText('No categories to map to.'), function() {
				//action to complete when user clicks ok.
			});
			return false;
		}

		var unassigned = [];
		for(var key in unassignedCategory.childNodes) {
			if(unassignedCategory.childNodes[key].get('syscli') == syscli)
				unassigned.push(unassignedCategory.childNodes[key]);
		}

		//if there is nothing to map to on that system / client
		if(unassigned.length === 0) {
			Ext.MessageBox.alert(CCS.Translator.getText('Error'), CCS.Translator.getText('No categories to map to.'), function() {
				//action to complete when user clicks ok.
			});
			return false;
		}

		//create store for combo
		var model = this.getLicenseMap().getStore().model;
		var store = Ext.create('Ext.data.ArrayStore', {
			model:	model,
			data:	unassigned
		});

		this.getMappingWindow().animateTarget = button;
		this.getMappingWindow().show();
		var form = this.getMappingWindow().down('form');
		var combo = form.getForm().findField('mappingTarget');
		combo.bindStore(store);

		//focus needs to happen after window has fully opened
		var task = new Ext.util.DelayedTask(function(){
			combo.focus();
			combo.expand();
		}, this);

		task.delay(350);
	},

	mapExisting: function(target) {
		var combo = this.getMappingWindow().down('form').getForm().findField('mappingTarget');
		var myRecordId = combo.getValue();
		var target = combo.getStore().findRecord('localId', myRecordId);

		var consolidated = this.getLicenseMap().getSelectionModel().getSelection()[0].parentNode;

		//set properties
		target.set('license_category_consolidated_id', consolidated.get('id'));
		target.set('cost', consolidated.get('cost'));
		target.set('command', 'mapExisting');

		//add to consolidate and update to store (service)
		consolidated.appendChild(target);

		this.updateLicenseGrid();
		this.getMappingWindow().close();
	},

	mapSU01OpenWindow: function(button, record) {
		this.getMappingWindow().animateTarget = button;
		this.getMappingWindow().show();
		this.getBtnMapExistingSave().hide();
		this.getBtnMapSU01Save().show();
		this.getMappingWindow().disable();

		//get local SU01 license categories
		var store = MyApp.app.getStore('SU01License');
		store.getProxy().extraParams.system = record.get('system');
		store.getProxy().extraParams.client = record.get('client');
		store.getProxy().extraParams.language = Ext.Object.fromQueryString(document.location.search).language;
		store.load({
			callback: function(records, eOpts, success) {
				if (records.length > 0) {
					//create store for combo
					var model = this.getLicenseMap().getStore().model;
					var store = Ext.create('Ext.data.ArrayStore', {
						model:	model,
						data:	records
					});

					var form = this.getMappingWindow().down('form');
					var combo = form.getForm().findField('mappingTarget');
					combo.bindStore(store);

					this.getMappingWindow().enable();

					var chosen = Ext.isEmpty(record.get('license_map_su01'))?
						combo.getStore().first() : combo.getStore().findRecord('localId',record.get('license_map_su01'));

					//focus needs to happen after window has fully opened
					var task = new Ext.util.DelayedTask(function(){
						combo.select(chosen);
						combo.focus();
						combo.expand();
					}, this);

					task.delay(350);
				}
				else {
					//if there are no SU01 categories
					var me = this;
					Ext.MessageBox.alert(CCS.Translator.getText('Error'), CCS.Translator.getText('No categories to map to.'), function() {
						//action to complete when user clicks ok.
						me.getMappingWindow().close();
					});
					return false;
				}
			},
			scope: this
		});
	},

	mapSU01: function() {
		var su01_id = this.getMappingWindow().down('form').getForm().getValues().mappingTarget;
		var name = this.getMappingWindow().down('form').getForm().findField('mappingTarget').getStore().findRecord('localId', su01_id).get('category');
		var record = this.getLicenseMap().getSelectionModel().getSelection()[0];

		//set properties
		record.set('license_map_su01', su01_id);
		record.set('sapLicense', name);
		record.set('command', 'mapSU01');

		this.updateLicenseGrid();
		this.getMappingWindow().close();
	},

	createOpenWindow: function(button, record) {
		this.getLocalLicenseWindow().animateTarget = button;
		this.getLocalLicenseWindow().show();

		if (button.itemId == 'btnCreate') {
			this.getLocalLicenseWindow().down('form').getForm().loadRecord(record.parentNode);

			this.getBtnLocalLicenseCreate().enable();
			this.getBtnLocalLicenseCreate().setVisible(true);
			this.getBtnLocalLicenseEdit().disable();
			this.getBtnLocalLicenseEdit().setVisible(false);
		}
		else if (button.itemId == 'btnEdit') {
			this.getLocalLicenseWindow().down('form').getForm().loadRecord(record);

			this.getBtnLocalLicenseCreate().disable();
			this.getBtnLocalLicenseCreate().setVisible(false);
			this.getBtnLocalLicenseEdit().enable();
			this.getBtnLocalLicenseEdit().setVisible(true);
		}

		var store = MyApp.app.getStore('SU01License');
		store.getProxy().extraParams.system = record.get('system');
		store.getProxy().extraParams.client = record.get('client');
		store.getProxy().extraParams.language = Ext.Object.fromQueryString(document.location.search).language;

		store.load({
			callback: function(records, eOpts, success) {
				//focus needs to happen after window has fully opened
				var task = new Ext.util.DelayedTask(function(){
					//this.getLocalLicenseWindow().down('form').getForm().findField('license_map_su01').expand();
					this.getLocalLicenseWindow().down('form').getForm().findField('category').focus();
					this.getLocalLicenseWindow().down('form').getForm().loadRecord(record);
				}, this);

				task.delay(350);
			},
			scope: this
		});
	},

	create: function() {
		var record = this.getLicenseMap().getSelectionModel().getSelection()[0];

		var consolidated = record.parentNode;
		var form = this.getLocalLicenseWindow().down('form').getForm();
		var data = form.getValues();

		var sapLicenseRecord = form.findField('license_map_su01').getStore().findRecord('license_map_su01', data.license_map_su01);
		var sapLicense = (Ext.isEmpty(sapLicenseRecord))? '' : sapLicenseRecord.get('sapLicense');

		//set properties
		record.set('category', data.category);
		record.set('dash_abbr', data.dash_abbr);
		record.set('license_map_su01', data.license_map_su01);
		record.set('sapLicense', sapLicense);

		record.set('dash_incl', consolidated.get('dash_incl'));
		record.set('cost', consolidated.get('cost'));
		record.set('license_category_consolidated_id', consolidated.get('id'));

		record.set('command', 'createLocal');

		this.updateLicenseGrid();
		this.getLocalLicenseWindow().close();
	},

	updateLicenseGrid: function() {
		//update to store (service)
		this.getLicenseMap().getStore().sync({
			callback: function() {
				this.getLicenseMap().getStore().load();
			},
			scope: this
		});

	},

	edit: function() {
		var record = this.getLicenseMap().getSelectionModel().getSelection()[0];

		var consolidated = record.parentNode;
		var form = this.getLocalLicenseWindow().down('form').getForm();
		var data = form.getValues();

		var sapLicenseRecord = form.findField('license_map_su01').getStore().findRecord('license_map_su01', data.license_map_su01);
		var sapLicense = (Ext.isEmpty(sapLicenseRecord))? '' : sapLicenseRecord.get('sapLicense');

		record.set('category', data.category);
		record.set('dash_abbr', data.dash_abbr);
		record.set('license_map_su01', data.license_map_su01);
		record.set('sapLicense', sapLicense);

		record.set('dash_incl', consolidated.get('dash_incl'));
		record.set('cost', consolidated.get('cost'));
		record.set('license_category_consolidated_id', consolidated.get('id'));

		record.set('command', 'editLocal');

		console.log(record);

		this.updateLicenseGrid();
		this.getLocalLicenseWindow().close();
	},

	deleteCategory: function() {
		var me = this;
		var record = this.getLicenseMap().getSelectionModel().getSelection()[0];
		record.set('command', 'deleteLocal');

		Ext.MessageBox.confirm('Delete', 'Are you sure?', function(btn){
			if (btn == 'yes') {
				confirm();
			}
		});



		function confirm() {
			me.updateLicenseGrid();
		}
	},

	unMapCategory: function() {
		var me = this;
		var record = this.getLicenseMap().getSelectionModel().getSelection()[0];
		record.set('command', 'unMapLocal');

		Ext.MessageBox.confirm('Delete', 'Are you sure?', function(btn){
			if (btn == 'yes') {
				confirm();
			}
		});



		function confirm() {
			me.updateLicenseGrid();
		}
	}

});
