/*
 * File: app/controller/LicenseGUI.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.controller.LicenseGUI', {
	extend: 'Ext.app.Controller',

	refs: [
		{
			ref: 'licenseMap',
			selector: '#licenseMap'
		},
		{
			ref: 'btnEditCategory',
			selector: '#btnEditCategory'
		},
		{
			ref: 'btnDeleteCategory',
			selector: '#btnDeleteCategory'
		},
		{
			ref: 'btnCreate',
			selector: '#btnCreate'
		},
		{
			ref: 'btnEdit',
			selector: '#btnEdit'
		},
		{
			ref: 'btnMapSap',
			selector: '#btnMapSap'
		},
		{
			ref: 'btnMapExisting',
			selector: '#btnMapExisting'
		},
		{
			ref: 'btnUnmap',
			selector: '#btnUnmap'
		},
		{
			ref: 'btnDeleteLocal',
			selector: '#btnDeleteLocal'
		}
	],

	init: function(application) {
		this.control({
			'#licenseMap': {
				selectionchange: function(component, selection) {
					this.selectionChanged(selection[0]);
					//console.log(selection[0].data);
				}
			},
			'#btnDeleteCategory': {
				click: function(btn) {
					this.deleteConsolidated();
				}
			},
			'#btnMapExisting': {
				click: function(btn) {
					console.log("map existing");
				}
			}
		});
	},

	selectionChanged: function(newRecord) {
		this.selectedItem = newRecord;
		//disable all btns then enable the ones that needs it
		this.getBtnEditCategory().disable();
		this.getBtnDeleteCategory().disable();

		this.getBtnCreate().disable();
		this.getBtnEdit().disable();
		this.getBtnMapExisting().disable();
		this.getBtnMapSap().disable();
		this.getBtnUnmap().disable();
		this.getBtnDeleteLocal().disable();

		if(newRecord !== undefined) { //if store is cleared no buttons should be enabled
			if(newRecord.parentNode == this.getLicenseMap().getStore().getRootNode()) {
				if(newRecord.getId() !== 0) { //user cannot edit nor delete unassigned
					this.getBtnEditCategory().enable();
					this.getBtnDeleteCategory().enable();
				}
			}
			else {
				if(newRecord.parentNode.getId() !== 0) { //user cannot edit nor delete in unassigned
					if(newRecord.get('localId') == 'X') { // non-existing categories can be mapped to unassigned or created as new
						this.getBtnMapExisting().enable();
						this.getBtnCreate().enable();
					}

					if(newRecord.get('localId') != 'X') { //user cannot su01-map, edit, unmap nor delete a non-existing category
						this.getBtnEdit().enable();
						this.getBtnMapSap().enable();
						this.getBtnUnmap().enable();
						this.getBtnDeleteLocal().enable();
					}
				}
			}
		}
	},

	deleteConsolidated: function() {
		console.log(this.selectedItem.data);
		var me = this;
		this.selectedItem.data.command = 'delete';

		Ext.MessageBox.confirm('Delete', 'Are you sure?', function(btn){
			if (btn == 'yes') {
				confirm();
			}
		});


		function confirm() {
			//me.updateLicenseGrid();
			Ext.Ajax.request({
				url: '../../service/licenseManagement_mapping.php',
				method: 'POST',
				jsonData: Ext.encode(me.selectedItem.data),
				success: function(response, object){
					this.getLicenseMap().getStore().load();
				},
				failure: function(response, object){

				},
				scope: me
			});
		}
	},

	updateLicenseGrid: function() {
		//update to store (service)
		this.getLicenseMap().getStore().sync({
			callback: function() {
				this.getLicenseMap().getStore().load();
			},
			scope: this
		});

	}

});
