/*
 * File: app/controller/LicenseController.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.controller.LicenseController', {
	extend: 'Ext.app.Controller',

	refs: [
		{
			ref: 'newLicBtn',
			selector: '#newLicBtn'
		},
		{
			ref: 'editLicBtn',
			selector: '#editLicBtn'
		},
		{
			ref: 'deleteLicBtn',
			selector: '#deleteLicBtn'
		},
		{
			ref: 'gridPanel',
			selector: '#GridPanel'
		},
		{
			ref: 'uploadForm1',
			selector: '#uploadForm1'
		},
		{
			autoCreate: true,
			ref: 'licenseWindow',
			selector: '#LicenseWindow',
			xtype: 'LicenseWindow'
		},
		{
			ref: 'fileUploadField',
			selector: '#fileUploadField'
		},
		{
			ref: 'invoiceDateField',
			selector: '#invoiceDateField'
		},
		{
			ref: 'amountField',
			selector: '#amountField'
		},
		{
			ref: 'uploadButton',
			selector: '#uploadButton'
		},
		{
			ref: 'commentField',
			selector: '#commentField'
		}
	],

	createLicenseWindow: function(button) {
		this.getLicenseWindow().show();
		if (button.itemId === 'newLicBtn')
		{
			this.getLicenseWindow().setTitle('Add License');


			/*

			this.getUploadButton().setText('Add');
			I cant even change the text of the button???


			this.getUploadEditBtn().hide(); // THIS WORKS IT HIDES THE BUTTON
			// NONE OF THIS WORKS?
			//this.getUploadButton().setVisible(true);
			//this.getUploadButton().show();
			//this.getUploadEditBtn().hide();
			*/
		}
		else if (button.itemId === 'editLicBtn')
		{
			this.getLicenseWindow().setTitle('Edit License');

			console.log(this.selectedLic.data);

			//this.getFileUploadField().allowBlank = true;
			//this.getFileUploadField().validateValue(this.getFileUploadField().getValue()); //force update
			//this.getInvoiceDateField().setValue(this.selectedLic.data.purchaseDate);
			//this.getAmountField().setValue(this.selectedLic.data.amount);

			//this.getUploadButton().hide(); // THIS DOES NOT WORK!? WHY DOES IT NOT HIDE BUTTON?!

		}
	},

	init: function(application) {
		this.control({
			'#newLicBtn': {
				click: function(btn) {
					this.createLicenseWindow(btn);
				}
			},
			'#editLicBtn': {
				click: function(btn) {
					this.createLicenseWindow(btn);
				}
			},
			'#deleteLicBtn': {
				click: function(btn) {
					this.deleteLicense(this.selectedLic);
				}
			},
			'#GridPanel': {
				selectionchange: function(component, selection) {
					if (selection.length >= 0) {
						//console.log(selection[0]);
						this.selectedLic = selection[0];
						this.getEditLicBtn().enable();
						this.getDeleteLicBtn().enable();
					}
				}
			}
		});
	},

	deleteLicense: function(lic) {
		var orgParams = Ext.Object.fromQueryString(document.location.search);
		var FID = lic.data.FID;
		var params = {
			deleteLic: 'true',
			FID: FID,
			user: orgParams.user
		};

		var tempurl = '../../service/archive_um_data.php?deleteLic=true&user=' + orgParams.user + '&FID=' + FID;
		console.log(tempurl);

		var gridPanel = this.getGridPanel();
		gridPanel.setLoading(CCS.Translator.getText('Loading...'));
		Ext.Ajax.request({
			url: tempurl,
			method: 'POST',
			params: params,
			success: function(response, object){
				//console.log(response);
				gridPanel.setLoading(false);
				gridPanel.getStore().load();
				this.selectedLic = null;
			},
			failure: function(response, object){
				//console.log(response);
				gridPanel.setLoading(false);
				gridPanel.getStore().load();
				this.selectedLic = null;
			},
			scope: this
		});

	}

});
