/*
 * File: app/controller/Consolidated_CUD.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.controller.Consolidated_CUD', {
	extend: 'Ext.app.Controller',

	refs: [
		{
			ref: 'licenseMap',
			selector: '#licenseMap'
		},
		{
			autoCreate: true,
			ref: 'licenseCategoryWindow',
			selector: '#LicenseCategoryWindow',
			xtype: 'LicenseCategoryWindow'
		},
		{
			ref: 'licenseCategoryForm',
			selector: '#licenseCategoryForm'
		},
		{
			ref: 'btnLicenseCategoryCreate',
			selector: '#btnLicenseCategoryCreate'
		},
		{
			ref: 'btnLicenseCategoryEdit',
			selector: '#btnLicenseCategoryEdit'
		}
	],

	init: function(application) {
		this.control({
			'#btnCreateCategory': {
				click: function(btn) {
					this.createCategoryOpenWindow(btn);
				}
			},
			'#licenseCategoryForm': {
				validitychange: function(component, isValid) {
					if(isValid) {
						//this.getBtnLicenseCategoryCreate().enable();
						//this.getBtnLicenseCategoryEdit().enable();
					}
					else {
						//this.getBtnLicenseCategoryCreate().disable();
						//this.getBtnLicenseCategoryEdit().disable();
					}
				}
			},
			'#btnEditCategory': {
				click: function(btn) {
					this.createCategoryOpenWindow(btn);
					var record = this.getLicenseMap().getSelectionModel().getSelection()[0];
					this.getLicenseCategoryForm().getForm().loadRecord(record);
					this.getBtnLicenseCategoryCreate().hide();
					this.getBtnLicenseCategoryEdit().show();
				}
			},
			'#btnLicenseCategoryCreate': {
				click: function(btn) {
					btn.disable();
					var data = this.getLicenseCategoryForm().getForm().getValues();
					this.createCategory(data);
					this.getLicenseCategoryWindow().close();
				}
			},
			'#btnLicenseCategoryEdit': {
				click: function(btn) {
					btn.disable();
					var data = this.getLicenseCategoryForm().getForm().getValues();
					this.editCategory(data);
					this.getLicenseCategoryWindow().close();
				}
			}

		});
	},

	createCategoryOpenWindow: function(button) {
		this.getLicenseCategoryWindow().animateTarget = button;
		this.getLicenseCategoryWindow().show();
		var userLicense = this.getLicenseCategoryForm().getForm().findField('type').getStore().getAt(0);
		this.getLicenseCategoryForm().getForm().findField('type').setValue(userLicense);

		//focus needs to happen after window has fully opened
		var task = new Ext.util.DelayedTask(function(){
			this.getLicenseCategoryForm().getForm().findField('category').focus();
		}, this);

		task.delay(350);
	},

	createCategory: function(data) {
		//adding a few extra properties
		data.icon = '../gfx/create.gif';
		data.leaf = true;
		data.license_type = MyApp.app.getStore('LicenseType').getById(data.type).get('type');
		data.license_type_id = data.type;
		data.command = 'create';

		//creating new record and adding it
		var model = this.getLicenseMap().getStore().model;
		var newCat = new model(data);
		this.getLicenseMap().getStore().getRootNode().appendChild(newCat);
		this.getLicenseMap().getStore().sync({
			callback: function() {
				this.getLicenseMap().getStore().load();
			},
			scope: this
		});
	},

	editCategory: function(data) {
		var record = this.getLicenseMap().getStore().getById(data.id);

		//setting properties
		record.set('category', data.category);
		record.set('quantity', data.quantity);
		record.set('cost', data.cost);
		record.set('dash_abbr', data.dash_abbr);
		record.set('dash_incl', data.dash_incl);
		record.set('license_type', MyApp.app.getStore('LicenseType').getById(data.type).get('type'));
		record.set('license_type_id', data.type);
		record.set('command', 'edit');

		//creating new record and adding it
		this.getLicenseMap().getStore().sync({
			callback: function() {
				this.getLicenseMap().getStore().load();
			},
			scope: this
		});
	},

	deleteCategory: function() {
		//Are you totally sure ?
		// Really?
	}

});
