Ext.define("MyApp.view.LicenseCategoryGridPanel",{extend:Ext.grid.Panel,alias:"widget.lic_cat_grid",border:false,itemId:"LicenseCategoryGrid",autoScroll:true,frameHeader:false,header:false,title:"Categories",store:"LicCatJsonStore",initComponent:function(){var a=this;Ext.applyIf(a,{columns:[{xtype:"gridcolumn",renderer:function(g,d,c,h,f,e,b){if(g){return'<img src="../gfx/sap_star.png" title="'+CCS.Translator.getText("Sap Star category")+'" />'}else{if(c.get("id")===0){return'<img src="../gfx/cn_cat.png" title="'+CCS.Translator.getText("Default")+'" />'}else{return'<img src="../gfx/cn_cat.png" title="'+CCS.Translator.getText("User defined")+'" />'}}},width:26,align:"center",dataIndex:"sap_star"},{xtype:"numbercolumn",hidden:true,width:30,dataIndex:"id",text:"ID",format:"0"},{xtype:"gridcolumn",dataIndex:"category",renderer:"htmlEncode",text:"Category",tooltip:"Name of license category",flex:10,editor:{xtype:"textfield",itemId:"categoryName",allowBlank:false,allowOnlyWhitespace:false,enforceMaxLength:true,maxLength:120,minLength:1}},a.processCost({xtype:"numbercolumn",cls:"setLeft",width:75,align:"right",dataIndex:"cost",text:"Cost",tooltip:"Cost of each license. May be actual cost or simple rank value.",format:"0,000",editor:{xtype:"numberfield",allowDecimals:false,allowExponential:false,autoStripChars:true}}),{xtype:"numbercolumn",cls:"setLeft",width:50,align:"right",dataIndex:"step",text:"Step",format:"0"},{xtype:"gridcolumn",renderer:function(g,d,c,h,f,e,b){if(c.get("sap_star")){return""}return CCS.Translator.getText(g?"Show":"Hide")},width:75,dataIndex:"dash_incl",text:"Dashboard",tooltip:"Show or hide category in license dashboard.",editor:{xtype:"combobox",store:[[false,CCS.Translator.getText("Hide")],[true,CCS.Translator.getText("Show")]]}},{xtype:"gridcolumn",width:60,dataIndex:"dash_abbr",renderer:"htmlEncode",text:"Abbr.",tooltip:"Abbreviation for use in dashboard",editor:{xtype:"textfield",allowOnlyWhitespace:false,maxLength:12}},{xtype:"gridcolumn",renderer:function(g,d,c,h,f,e,b){return MyApp.app.getLicenseCategoryControllerController().getSU01LicenseCategory(g)},dataIndex:"license_map_su01",text:"SU01 License",tooltip:"Corresponding SU01 license type",flex:16,editor:{xtype:"combobox",allowBlank:false,allowOnlyWhitespace:false,matchFieldWidth:false,anyMatch:true,displayField:"presentation",forceSelection:true,queryMode:"local",store:"SU01LicCatJsonStore",typeAhead:true,typeAheadDelay:5,valueField:"type"}}],plugins:[Ext.create("Ext.grid.plugin.CellEditing",{pluginId:"editing",listeners:{beforeedit:{fn:a.onCellEditingBeforeEdit,scope:a},validateedit:{fn:a.onCellEditingValidateedit,scope:a}}})],selModel:Ext.create("Ext.selection.RowModel",{mode:"SINGLE"}),dockedItems:[{xtype:"toolbar",dock:"bottom",items:[{xtype:"button",icon:"../gfx/create.gif",text:"Add",tooltip:"Add a new license category",listeners:{click:{fn:a.onButtonClickAdd,scope:a}}},{xtype:"tbspacer",width:25},{xtype:"button",icon:"../gfx/trash.gif",text:"Remove",tooltip:"Remove selected license category",listeners:{click:{fn:a.onButtonClickRemove,scope:a}}}]}]});a.callParent(arguments)},processCost:function(a){a.renderer=function(d,c,b){return b.get("id")==0?"":d};return a},onCellEditingBeforeEdit:function(b,c,a){if(c.record.get("sap_star")){return false}else{if(c.record.get("id")===0){return c.field=="dash_abbr"}else{return true}}},onCellEditingValidateedit:function(g,h,d){if(h.field=="license_map_su01"){var a=h.grid.getStore();var c=h.record.getId();var b=h.value;if(b.length>0){var f=false;a.each(function(e){if(e.getId()!=c&&e.get("license_map_su01")==b){f=true}});if(f){h.cancel=f;Ext.Msg.show({title:"Invalid mapping",msg:"The chosen SU01 license category has already been mapped to another UM license category.",buttons:Ext.Msg.CANCEL,icon:Ext.Msg.ERROR})}}}},onButtonClickAdd:function(d,f,c){var a=new MyApp.model.LicenseCategory({category:"new"});var b=this.getStore();b.insert(0,a);var g=b.indexOf(a);this.getPlugin("editing").startEditByPosition({row:g,column:0})},onButtonClickRemove:function(c,f,b){var d=this.getSelectionModel().getSelection();if(d&&d.length==1){var a=d[0];if(a.get("id")=="0"||a.get("sap_star")){Ext.Msg.show({title:CCS.Translator.getText('Category "{1}"',[a.get("category")]),msg:CCS.Translator.getText("This category cannot be removed."),buttons:Ext.Msg.OK,icon:Ext.Msg.INFO})}else{Ext.Msg.show({title:CCS.Translator.getText('Remove category "{1}"?',[a.get("category")]),msg:CCS.Translator.getText("All roles assigned to this category will revert to Unassigned.<br/><br/>Would you like to remove this category?"),buttons:Ext.Msg.YESNO,icon:Ext.Msg.QUESTION,fn:function(e){if(e=="yes"){this.getStore().remove(a)}},scope:this})}}}});Ext.define("MyApp.view.AssignedRolesGrid",{extend:Ext.grid.Panel,alias:"widget.mygridpanel11",border:false,itemId:"assignedRolesGrid",autoScroll:true,frameHeader:false,header:false,title:"Assigned Roles",store:"LicCatRoleAssignmentJsonStore",initComponent:function(){var a=this;Ext.applyIf(a,{dockedItems:[{xtype:"toolbar",dock:"top",hidden:true,items:[{xtype:"tbspacer",flex:1}]},{xtype:"pagingtoolbar",dock:"bottom",displayInfo:true,store:"LicCatRoleAssignmentJsonStore",items:[{xtype:"combobox",disabled:true,itemId:"assignedRolesPageSizeCombo",width:50,labelAlign:"right",labelSeparator:" ",labelWidth:75,value:50,store:[50,100,250,500,1000,5000],listeners:{change:{fn:a.onComboboxChange1,scope:a}}},{xtype:"tbspacer",width:3},{xtype:"label",text:"per page"},{xtype:"triggerfield",onTriggerClick:function(b){a.doSearch()},flex:100,disabled:true,itemId:"searchField",fieldLabel:"Search",labelAlign:"right",labelSeparator:" ",labelWidth:35,triggerCls:"x-form-search-trigger",listeners:{specialkey:{fn:a.onSearchFieldSpecialkey,scope:a}}}]}],columns:[{xtype:"gridcolumn",dataIndex:"role",renderer:"htmlEncode",text:"Role",flex:3},{xtype:"gridcolumn",dataIndex:"description",renderer:"htmlEncode",text:"Description",flex:4},{xtype:"gridcolumn",dataIndex:"parent_role",renderer:"htmlEncode",text:"Parent",flex:3}],selModel:Ext.create("Ext.selection.RowModel",{mode:"MULTI"})});a.callParent(arguments)},onComboboxChange1:function(d,c,a,b){},onSearchFieldSpecialkey:function(c,b,a){if(b.getKey()==b.ENTER){c.up("grid").doSearch()}},doSearch:function(){this.getStore().filter({id:"search",property:"*",value:this.down("#searchField").getValue()})},changeCategory:function(a){this.getStore().clearFilter(true);this.setCategoryName(a.get("category"));if(a.get("sap_star")){var b=a.get("id");this.getStore().filter({property:"sapStar",value:b})}else{if(a.phantom){this.getStore().filter({property:"catId",value:-1})}else{var b=a.get("id");this.getStore().filter({property:"catId",value:b})}}},setCategoryName:function(a){this.up("#assignedRolesContainer").setTitle(CCS.Translator.getText("Assigned Roles - {1}",[a]))}});Ext.define("MyApp.view.RoleFinderGridPanel1",{extend:Ext.grid.Panel,alias:"widget.mygridpanel13",border:false,itemId:"mygridpanel",autoScroll:true,frameHeader:false,header:false,title:"Role finder",store:"RoleFinderJsonStore",initComponent:function(){var a=this;Ext.applyIf(a,{columns:[{xtype:"gridcolumn",dataIndex:"role",renderer:"htmlEncode",text:"Role",flex:3},{xtype:"gridcolumn",dataIndex:"description",renderer:"htmlEncode",text:"Description",flex:4},{xtype:"gridcolumn",dataIndex:"parent_role",renderer:"htmlEncode",text:"Parent Role",flex:3},{xtype:"gridcolumn",renderer:function(i,b,e,g,k,j,h){var l=MyApp.app.getLicCatJsonStoreStore();var d=l.getById(e.get("category_id"));var f=d.get("category");return Ext.String.htmlEncode(f)},dataIndex:"category_id",text:"Category",flex:2},{xtype:"gridcolumn",dataIndex:"sap_star",text:"SAP Star",flex:2}],selModel:Ext.create("Ext.selection.RowModel",{mode:"MULTI"}),dockedItems:[{xtype:"toolbar",dock:"top",hidden:true,items:[{xtype:"tbspacer",flex:1}]},{xtype:"pagingtoolbar",dock:"bottom",displayInfo:true,store:"RoleFinderJsonStore",items:[{xtype:"combobox",disabled:true,itemId:"roleFinderPageSizeCombo",width:50,labelAlign:"right",labelSeparator:" ",labelWidth:75,value:50,store:[50,100,250,500,1000,5000],listeners:{change:{fn:a.onComboboxChange,scope:a}}},{xtype:"tbspacer",width:3},{xtype:"label",text:"per page"},{xtype:"tbspacer",width:10},{xtype:"triggerfield",onTriggerClick:function(b){a.doSearch()},flex:1,disabled:true,hidden:true,itemId:"searchField",fieldLabel:"Search",labelAlign:"right",labelSeparator:" ",labelWidth:35,triggerCls:"x-form-search-trigger",listeners:{specialkey:{fn:a.onSearchFieldSpecialkey,scope:a}}},{xtype:"textareafield",flex:500,itemId:"searchArea",margin:"3 0 0 0",enterIsSpecial:true},{xtype:"tbspacer",width:1},{xtype:"container",layout:{type:"hbox",align:"stretch"},items:[{xtype:"button",itemId:"searchButton",margin:"-2 0 0 0",icon:"../gfx/search_small.png"},{xtype:"tbspacer",width:1},{xtype:"button",itemId:"searchClearButton",margin:"-2 0 0 0",icon:"../gfx/clear.png"}]}]}]});a.callParent(arguments)},onComboboxChange:function(d,c,a,b){},onSearchFieldSpecialkey:function(c,b,a){if(b.getKey()==b.ENTER){c.up("grid").doSearch()}},doSearch:function(){var c=this.down("#searchField");var b=c.getValue();var a=this.getStore();a.clearFilter(true);a.filter("*",b)}});Ext.define("MyApp.model.SingleRole",{extend:Ext.data.Model,idProperty:"role",fields:[{name:"role"},{name:"description"},{name:"parent_role"},{name:"category_id",type:"int"},{name:"num_children",type:"int"},{name:"sap_star"}]});Ext.define("MyApp.store.LicCatRoleAssignmentJsonStore",{extend:Ext.data.Store,constructor:function(a){var b=this;a=a||{};b.callParent([Ext.apply({autoLoad:false,model:"MyApp.model.SingleRole",remoteFilter:true,remoteSort:true,storeId:"MyJsonStore",pageSize:50,proxy:{type:"ajax",url:"../../service/role_finder.php",reader:{type:"json",root:"result"}},listeners:{beforeload:{fn:b.onJsonstoreBeforeLoad,scope:b}}},a)])},onJsonstoreBeforeLoad:function(b,a,c){params=Ext.Object.fromQueryString(document.location.search);b.proxy.extraParams=params}});Ext.define("MyApp.store.RoleFinderJsonStore",{extend:Ext.data.Store,constructor:function(a){var b=this;a=a||{};b.callParent([Ext.apply({autoLoad:false,model:"MyApp.model.SingleRole",remoteFilter:true,remoteSort:true,storeId:"RoleFinderJsonStore",pageSize:50,proxy:{type:"ajax",url:"../../service/role_finder.php",reader:{type:"json",root:"result"}},listeners:{beforeload:{fn:b.onJsonstoreBeforeLoad,scope:b}}},a)])},onJsonstoreBeforeLoad:function(b,a,c){params=Ext.Object.fromQueryString(document.location.search);b.proxy.extraParams=params}});Ext.define("MyApp.model.LicenseCategory",{extend:Ext.data.Model,fields:[{name:"id",type:"int"},{name:"category",type:"string"},{name:"cost"},{name:"dash_incl",type:"boolean"},{name:"dash_abbr",type:"string"},{name:"license_map_su01",type:"string"},{name:"sap_star",type:"boolean"},{name:"step"}],hasOne:{associationKey:"su01",model:"MyApp.model.SU01LicenseCategory",primaryKey:"type",foreignKey:"license_map_su01",getterName:"getSU01Category"}});Ext.define("MyApp.store.LicCatJsonStore",{extend:Ext.data.Store,constructor:function(a){var b=this;a=a||{};b.callParent([Ext.apply({autoLoad:false,autoSync:true,model:"MyApp.model.LicenseCategory",storeId:"LicCatJsonStore",proxy:{type:"rest",url:"../../service/license_category.php",reader:{type:"json",root:"result"},listeners:{exception:{fn:b.onAjaxException,scope:b}}},listeners:{beforeload:{fn:b.onJsonstoreBeforeLoad,scope:b},write:{fn:b.onJsonstoreWrite,scope:b}}},a)])},onAjaxException:function(e,b,a,d){var g=Ext.JSON.decode(b.responseText);var f="Error communicating with web server: ";if(g){for(var c=0;c<g.errors.length;c++){f=f+"<br>Category "+g.errors[c].id+": "+g.errors[c].msg}}else{f=f+b.responseText}Ext.Msg.alert("Warning",f)},onJsonstoreBeforeLoad:function(b,a,c){params=Ext.Object.fromQueryString(document.location.search);b.proxy.extraParams=params},onJsonstoreWrite:function(b,a,c){MyApp.app.getController("LicenseCategoryController").reloadRoleFinder()}});Ext.define("MyApp.model.SU01LicenseCategory",{extend:Ext.data.Model,idProperty:"type",fields:[{name:"type",type:"string"},{name:"text",type:"string"},{name:"presentation"}]});Ext.define("MyApp.store.SU01LicCatJsonStore",{extend:Ext.data.Store,constructor:function(a){var b=this;a=a||{};b.callParent([Ext.apply({autoLoad:true,model:"MyApp.model.SU01LicenseCategory",storeId:"SU01LicCatJsonStore",proxy:{type:"ajax",url:"../../service/su01_license_category.php",reader:{type:"json",root:"result"}},listeners:{beforeload:{fn:b.onJsonstoreBeforeLoad,scope:b}}},a)])},onJsonstoreBeforeLoad:function(b,a,c){params=Ext.Object.fromQueryString(document.location.search);b.proxy.extraParams=params}});Ext.define("MyApp.controller.LicenseCategoryController",{extend:Ext.app.Controller,stores:["LicCatRoleAssignmentJsonStore","RoleFinderJsonStore","LicCatJsonStore","SU01LicCatJsonStore"],views:["LicenseCategoryGridPanel","AssignedRolesGrid","RoleFinderGridPanel1"],refs:[{ref:"assignedRoles",selector:"#assignedRolesGrid"},{ref:"roleFinderGrid",selector:"#roleFinderGrid"},{ref:"assignedRolesGrid",selector:"#assignedRolesGrid"},{ref:"licCatPanel",selector:"#licCatPanel"},{ref:"licenseCategoryGrid",selector:"#licenseCategoryGrid"},{ref:"assignedRolesPageSizeCombo",selector:"#assignedRolesPageSizeCombo"},{ref:"roleFinderPageSizeCombo",selector:"#roleFinderPageSizeCombo"},{ref:"btnAssign",selector:"#btnAssign"},{ref:"btnUnassign",selector:"#btnUnassign"},{ref:"searchArea",selector:"#searchArea"},{ref:"searchButton",selector:"#searchButton"}],init:function(a){var b=this;this.getSU01LicCatJsonStoreStore().on("load",function(){this.getLicCatPanel().setLoading(false);this.getLicCatJsonStoreStore().load({callback:function(){this.getRoleFinderJsonStoreStore().load()},scope:this})},this);this.getLicCatJsonStoreStore().on("remove",function(f,d,g,e,h){var c=this.getLicCatJsonStoreStore().getById(0);var i=this.getLicenseCategoryGrid().getSelectionModel();i.select([c])},this);this.getLicCatRoleAssignmentJsonStoreStore().on("load",function(){this.getAssignedRolesPageSizeCombo().enable();var d=this.getAssignedRolesGrid();d.down("#searchField").enable();var c=this.getLicenseCategoryGrid().getSelectionModel().getSelection()[0];if(c.get("id")==0||c.get("sap_star")){this.getBtnUnassign().disable()}else{this.getBtnUnassign().enable()}},this);this.getRoleFinderJsonStoreStore().on("load",function(){this.getRoleFinderPageSizeCombo().enable();var c=this.getRoleFinderGrid();c.down("#searchField").enable();this.getBtnAssign().enable()},this);this.control({"#licenseCategoryGrid":{select:function(f,c,d,e){this.selectedCategory=c.get("id");this.getAssignedRoles().changeCategory(c);if(c.get("id")==0||c.get("sap_star")){this.getBtnUnassign().disable();this.getBtnAssign().disable()}else{this.getBtnAssign().enable()}}},"#categoryName":{change:function(f,e,c,d){this.getAssignedRoles().setCategoryName(e)}},"#btnAssign":{click:function(f,h,g){var d=this.getRoleFinderGrid();var i=d.getSelectionModel();var c=i.getSelection();if(c.length>0){i.deselectAll(true);this.assignRoles(c)}}},"#btnUnassign":{click:function(f,h,g){var d=this.getAssignedRolesGrid();var i=d.getSelectionModel();var c=i.getSelection();if(c.length>0){this.unassignRoles(c);i.deselectAll(true)}}},"#roleFinderPageSizeCombo":{change:function(g,f,d,e){var c=this.getRoleFinderJsonStoreStore();c.pageSize=f;c.load()}},"#assignedRolesPageSizeCombo":{change:function(g,f,d,e){var c=this.getLicCatRoleAssignmentJsonStoreStore();c.pageSize=f;c.load()}},"#searchField":{change:function(d,c){console.log(c)}},"#searchArea":{change:function(e,d,c){console.log(d);e.setRawValue(d.replace("\n"," ").trim())},specialkey:function(f,d,c){if(d.getKey()==d.ENTER){this.doSearch()}}},"#searchButton":{click:this.doSearch},"#searchClearButton":{click:function(c){c.blur();this.getSearchArea().setRawValue("");this.getSearchArea().focus()}}})},reloadAssignments:function(){if(this.selectedCategory){this.getLicCatRoleAssignmentJsonStoreStore().reload()}},reloadRoleFinder:function(){this.getRoleFinderJsonStoreStore().reload()},doAssignment:function(b,c,e){this.getLicCatPanel().setLoading("Working...",true);var d=Ext.Array.map(b,function(f,g,h){return f.get("role")});var a=Ext.JSON.encode({roles:d,related:e,category:c});Ext.Ajax.request({url:"../../service/role_assign.php",method:"POST",params:Ext.Object.fromQueryString(document.location.search),jsonData:a,success:function(h,i){var k=h.responseText;var j=Ext.JSON.decode(k).result;var g=this.getRoleFinderJsonStoreStore();g.load();var f=this.getLicCatRoleAssignmentJsonStoreStore();f.load();this.getLicCatPanel().setLoading(false)},failure:function(f,g){var h=f.responseText;Ext.Error.raise({msg:"Failed to assign roles",option:h,object:g})},scope:this})},assign:function(b,d,a){var c=0;Ext.Array.forEach(b,function(e,f,g){if(e.get("parent_role")!==null||e.get("num_children")>0){c=c+1}});if(c>0){Ext.Msg.show({title:"Include related roles?",msg:CCS.Translator.getText("Related roles include the parent role, any derived roles, and all siblings.<br/>Would you like to also change the assignment of related roles?"),buttons:Ext.Msg.YESNOCANCEL,icon:Ext.Msg.QUESTION,fn:function(e){if(e!="cancel"){this.doAssignment(b,d,e=="yes")}},scope:this})}else{this.doAssignment(b,d,false)}return},unassignRoles:function(a){this.assign(a,0)},assignRoles:function(a){if(this.selectedCategory){return this.assign(a,this.selectedCategory)}else{Ext.Msg.alert("No category selected","Select a license category before making assignments.");return false}},onLaunch:function(){this.getLicCatPanel().setLoading(true,true)},getSU01LicenseCategory:function(c){if(c&&(c.length>0)){var b=this.getSU01LicCatJsonStoreStore();if(!b){return"nostore"}var a=b.getById(c);if(a){return Ext.String.htmlEncode(a.get("text"))}else{return c+" | "+CCS.Translator.getText("Not available")}}return""},doSearch:function(){this.getSearchButton().blur();var b=this.getSearchArea().getValue();var a=this.getRoleFinderGrid().getStore();a.clearFilter(true);a.filter("*",b)}});Ext.define("MyApp.view.LicenseCategories",{extend:Ext.panel.Panel,itemId:"licCatPanel",padding:"3 10 10 10",resizable:false,title:"License Categories",layout:{type:"hbox",align:"stretch"},initComponent:function(){var a=this;Ext.applyIf(a,{items:[{xtype:"container",flex:1,layout:{type:"vbox",align:"stretch"},items:[{xtype:"fieldset",flex:1,margin:0,layout:"fit",title:"Categories",items:[{xtype:"lic_cat_grid",itemId:"licenseCategoryGrid"}]},{xtype:"splitter",overCls:"mySplitterHorizontal",size:10},{xtype:"fieldset",flex:1,itemId:"assignedRolesContainer",margin:0,layout:"fit",title:"Assigned Roles - no category selected",items:[{xtype:"mygridpanel11"}]}]},{xtype:"splitter",overCls:"mySplitter",size:10},{xtype:"container",flex:1,layout:{type:"vbox",align:"stretch"},items:[{xtype:"fieldset",flex:60,margin:0,padding:"3 10 10 10",layout:"fit",title:"Role finder",items:[{xtype:"mygridpanel13",itemId:"roleFinderGrid"}]},{xtype:"fieldset",margin:0,padding:"3 10 10 10",title:"Actions",layout:{type:"hbox",align:"stretch"},items:[{xtype:"button",disabled:true,itemId:"btnAssign",padding:5,icon:"../gfx/add.png",scale:"medium",text:"Assign",textAlign:"left",tooltip:"Assign selected role(s) to selected category"},{xtype:"tbspacer",width:10},{xtype:"button",disabled:true,itemId:"btnUnassign",padding:5,icon:"../gfx/remove.png",text:"Unassign",tooltip:"Unassign selected role(s) from this category"}]}]}]});a.callParent(arguments)}});