/*
 * File: app.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

// @require @packageOverrides
Ext.Loader.setConfig({
	enabled: true
});


Ext.application({
	models: [
		'Frequency',
		'User',
		'UserSelect',
		'Tcode',
		'RoleSelect',
		'Role',
		'UserGroup',
		'IdTextUsage',
		'Enum',
		'RuleSelect',
		'Rule',
		'TcodeSelect',
		'ReportHistory',
		'OrgLevel'
	],
	stores: [
		'Frequencies',
		'User',
		'UserSelect',
		'Favorites',
		'Tcode',
		'TcodeSelect',
		'Role',
		'RoleSelect',
		'UserGroup',
		'PossibleApproversStore',
		'PossibleSystemReactionStore',
		'PossibleRiskLevelStore',
		'PossibleMessageStore',
		'LanguageStore',
		'PossibleRiskGroupsStore',
		'ReportHistoryStore',
		'ScheduleStore',
		'UserType',
		'PossibleOrgLevels'
	],
	views: [
		'UMReportsPanel',
		'StatusWindow',
		'SelectionPanel',
		'ScheduleWindow'
	],
	controllers: [
		'ReportsController',
		'FavoriteHistorySync',
		'BackgroundStatus',
		'Scheduler',
		'GUI'
	],
	name: 'MyApp',

	getParams: function() {
		return Ext.Object.fromQueryString(document.location.search);
	},

	launch: function() {
		Ext.create('MyApp.view.UMReportsPanel', {renderTo: Ext.getBody()});
		this.msgCt = Ext.DomHelper.insertFirst(document.body, {id:'msg-div'}, true);
	},

	message: function(title, message) {
		var s = Ext.String.format.apply(String, Array.prototype.slice.call(arguments, 1));
		var m = Ext.DomHelper.append(this.msgCt, '<div class="msg"><h3>' + title + '</h3><p>' + s + '</p></div>', true);
		m.hide();
		m.slideIn('t').ghost("t", { delay: 2000, remove: true});
	}

});
