/*
 * File: app/view/selectMultiApproversWindow.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.view.selectMultiApproversWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.selectMultiApproversWindow',

	requires: [
		'Ext.grid.Panel',
		'Ext.grid.column.Column',
		'Ext.grid.View',
		'Ext.selection.CheckboxModel',
		'Ext.form.field.Number',
		'Ext.toolbar.Spacer',
		'Ext.button.Button'
	],

	itemId: 'selectMultiApproversWindow',
	width: 596,
	layout: 'fit',
	icon: '../gfx/sod_warn_4-0.png',
	title: 'Select approvers',
	modal: true,

	initComponent: function() {
		var me = this;

		Ext.applyIf(me, {
			items: [
				{
					xtype: 'container',
					autoRender: true,
					layout: 'fit',
					items: [
						me.processSelectMultiApproversGrid({
							xtype: 'gridpanel',
							height: 250,
							itemId: 'selectMultiApproversGrid',
							autoScroll: true,
							header: false,
							title: 'My Grid Panel',
							enableColumnHide: false,
							enableColumnMove: false,
							enableColumnResize: false,
							scroll: 'vertical',
							store: 'SelectApproverStore',
							columns: [
								{
									xtype: 'gridcolumn',
									sortable: true,
									dataIndex: 'text',
									text: 'Approver',
									flex: 1.5
								},
								{
									xtype: 'gridcolumn',
									sortable: true,
									dataIndex: 'user',
									text: 'Username',
									flex: 1
								},
								{
									xtype: 'gridcolumn',
									sortable: true,
									dataIndex: 'substitute',
									text: 'Substitute',
									flex: 1
								}
							],
							selModel: Ext.create('Ext.selection.CheckboxModel', {
								checkOnly: true
							})
						})
					]
				}
			],
			dockedItems: [
				{
					xtype: 'container',
					dock: 'bottom',
					layout: {
						type: 'hbox',
						align: 'stretch'
					},
					items: [
						{
							xtype: 'container',
							layout: {
								type: 'vbox',
								align: 'stretch',
								pack: 'center'
							},
							items: [
								{
									xtype: 'numberfield',
									flex: 0,
									itemId: 'selectMultiApproversMinimumNumber',
									maxHeight: 22,
									width: 245,
									fieldLabel: 'Minimum number of approvers',
									labelAlign: 'right',
									labelSeparator: ' ',
									labelWidth: 200,
									value: 1,
									fieldCls: 'x-form-field, numberField',
									minValue: 1
								}
							]
						},
						{
							xtype: 'tbspacer',
							flex: 1
						},
						{
							xtype: 'button',
							flex: 0.6,
							margins: '10 10 10 10',
							itemId: 'selectMultiApproversDoneButton',
							padding: '5 10 5 10',
							icon: '../gfx/save.png',
							scale: 'medium',
							text: 'Save changes'
						}
					]
				}
			]
		});

		me.callParent(arguments);
	},

	processSelectMultiApproversGrid: function(config) {
		config.viewConfig = {
		    getRowClass: function(record, index) {
		        if (record.get('id') === '0' || Ext.isEmpty(record.get('user'))) {
		            return 'display-false';
		        }
		    }
		};
		return config;
	}

});