/*
 * File: app/view/editRuleWindowClass.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.view.editRuleWindowClass', {
	extend: 'Ext.window.Window',
	alias: 'widget.editRuleWindowAlias',

	requires: [
		'Ext.container.Container',
		'Ext.form.field.ComboBox',
		'Ext.button.Button',
		'Ext.toolbar.Spacer',
		'Ext.form.field.TextArea',
		'Ext.form.field.Checkbox'
	],

	saveDelay: 50,
	itemId: 'editRuleWindow',
	width: 596,
	shadow: 'drop',
	icon: '../gfx/rule.png',
	title: 'Define risk',
	modal: true,

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	initComponent: function() {
		var me = this;

		Ext.applyIf(me, {
			items: [
				{
					xtype: 'container',
					flex: 1,
					padding: '10 10 0 10',
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					items: [
						{
							xtype: 'container',
							margin: '0 0 5 0',
							layout: {
								type: 'hbox',
								align: 'stretch'
							},
							items: [
								{
									xtype: 'combobox',
									flex: 1,
									itemId: 'editRuleGroup',
									fieldLabel: 'Group',
									labelSeparator: ' ',
									labelWidth: 120,
									size: 64,
									editable: false,
									forceSelection: true,
									growToLongestValue: false,
									queryCaching: false,
									store: 'SelectGroupStore',
									valueField: 'id'
								},
								{
									xtype: 'button',
									margins: '0 0 0 10',
									itemId: 'editRuleNewGroupButton',
									padding: '2 2 2 5',
									width: 140,
									icon: '../gfx/group.png',
									text: 'Create group',
									textAlign: 'left'
								}
							]
						},
						{
							xtype: 'container',
							layout: {
								type: 'hbox',
								align: 'stretch'
							},
							items: [
								{
									xtype: 'textfield',
									flex: 1,
									itemId: 'editRuleName',
									focusOnToFront: false,
									fieldLabel: 'Name of risk',
									labelSeparator: ' ',
									labelWidth: 120,
									enforceMaxLength: true,
									maskRe: /[a-zA-Z0-9 _-]/,
									maxLength: 64,
									selectOnFocus: true,
									size: 64
								},
								{
									xtype: 'textfield',
									itemId: 'editSignature',
									width: 150,
									focusOnToFront: false,
									fieldLabel: 'Signature',
									labelAlign: 'right',
									labelPad: 10,
									labelSeparator: ' ',
									labelWidth: 70,
									enforceMaxLength: true,
									maskRe: /[a-zA-Z0-9]/,
									maxLength: 8,
									selectOnFocus: true
								}
							]
						},
						{
							xtype: 'tbspacer',
							height: 5
						},
						{
							xtype: 'container',
							layout: {
								type: 'hbox',
								align: 'stretch'
							},
							items: [
								{
									xtype: 'combobox',
									flex: 1,
									itemId: 'editRuleWarning',
									fieldLabel: 'System reaction',
									labelSeparator: ' ',
									labelWidth: 120,
									size: 64,
									editable: false,
									forceSelection: true,
									growToLongestValue: false,
									queryMode: 'local',
									store: 'SelectWarningTypeStore',
									valueField: 'id'
								},
								{
									xtype: 'combobox',
									itemId: 'editRuleRisk',
									width: 150,
									fieldLabel: 'Risk Level',
									labelAlign: 'right',
									labelPad: 10,
									labelSeparator: ' ',
									labelWidth: 70,
									size: 64,
									editable: false,
									forceSelection: true,
									growToLongestValue: false,
									queryMode: 'local',
									store: 'SelectRiskStore',
									valueField: 'id'
								}
							]
						},
						{
							xtype: 'tbspacer',
							height: 5
						},
						{
							xtype: 'textareafield',
							flex: 1,
							height: 65,
							itemId: 'editRuleDescription',
							width: 541,
							fieldLabel: 'Risk description',
							labelSeparator: ' ',
							labelWidth: 120,
							enforceMaxLength: true,
							maxLength: 65536,
							size: 450
						},
						{
							xtype: 'combobox',
							itemId: 'editRuleMessage',
							fieldLabel: 'Message',
							labelSeparator: ' ',
							labelWidth: 120,
							emptyText: 'please select',
							size: 64,
							editable: false,
							forceSelection: true,
							growToLongestValue: false,
							queryCaching: false,
							store: 'SelectMessageStore',
							valueField: 'id',
							listeners: {
								change: {
									fn: me.onEditRuleMessageChange,
									scope: me
								}
							}
						},
						{
							xtype: 'container',
							margins: '0 0 5 0',
							layout: {
								type: 'hbox',
								align: 'stretch',
								pack: 'end'
							},
							items: [
								{
									xtype: 'combobox',
									flex: 1,
									itemId: 'editRuleApprover',
									fieldLabel: 'Approver',
									labelSeparator: ' ',
									labelWidth: 120,
									emptyText: 'please select',
									size: 64,
									editable: false,
									forceSelection: true,
									growToLongestValue: false,
									queryCaching: false,
									store: 'SelectApproverStore',
									valueField: 'id',
									listeners: {
										change: {
											fn: me.onEditRuleApproverChange,
											scope: me
										}
									}
								},
								{
									xtype: 'button',
									margins: '0 0 0 10',
									itemId: 'editRuleAddApproverButton',
									padding: '2 2 2 5',
									width: 140,
									icon: '../gfx/sod_warn_4-0.png',
									text: 'Select approvers',
									textAlign: 'left'
								}
							]
						},
						{
							xtype: 'container',
							layout: {
								type: 'hbox',
								align: 'stretch'
							},
							items: [
								{
									xtype: 'combobox',
									flex: 1,
									disabled: true,
									itemId: 'editRuleFrequency',
									fieldLabel: 'Approval expires',
									labelSeparator: ' ',
									labelWidth: 120,
									value: 9,
									allowBlank: false,
									allowOnlyWhitespace: false,
									editable: false,
									forceSelection: true,
									queryMode: 'local',
									store: 'Frequency',
									valueField: 'id'
								},
								{
									xtype: 'tbspacer',
									width: 10
								},
								{
									xtype: 'checkboxfield',
									disabled: true,
									itemId: 'editRuleAutoRenewal',
									width: 140,
									fieldLabel: 'Auto renewal',
									labelAlign: 'right',
									labelPad: 10,
									labelSeparator: ' ',
									labelWidth: 115,
									value: '0',
									readOnly: true,
									inputValue: '1',
									uncheckedValue: '0'
								}
							]
						},
						{
							xtype: 'tbspacer',
							height: 5
						},
						{
							xtype: 'textareafield',
							flex: 1,
							height: 65,
							itemId: 'editRuleMitigation',
							width: 541,
							fieldLabel: 'Mitigation description',
							labelSeparator: ' ',
							labelWidth: 120,
							enforceMaxLength: true,
							maxLength: 65535
						},
						{
							xtype: 'textfield',
							itemId: 'editRuleOrigin',
							focusOnToFront: false,
							fieldLabel: 'Origin',
							labelSeparator: ' ',
							labelWidth: 120,
							emptyText: 'Local',
							selectOnFocus: true,
							size: 64
						},
						{
							xtype: 'container',
							layout: {
								type: 'hbox',
								align: 'stretch',
								pack: 'end'
							},
							items: [
								{
									xtype: 'checkboxfield',
									itemId: 'editRuleActive',
									labelAlign: 'right',
									value: 'Active',
									boxLabel: 'Active',
									boxLabelAlign: 'before',
									uncheckedValue: 'Inactive'
								}
							]
						}
					]
				},
				{
					xtype: 'container',
					padding: 10,
					layout: {
						type: 'hbox',
						align: 'stretch'
					},
					items: [
						{
							xtype: 'button',
							disabled: true,
							itemId: 'editRuleConfirmButton',
							padding: 5,
							icon: '../gfx/save.png',
							scale: 'medium',
							text: 'Create'
						},
						{
							xtype: 'button',
							hidden: true,
							itemId: 'editRuleSaveButton',
							padding: 5,
							icon: '../gfx/save.png',
							scale: 'medium',
							text: 'Update'
						},
						{
							xtype: 'tbspacer',
							flex: 1
						},
						{
							xtype: 'button',
							itemId: 'editRuleCancelButton',
							padding: 5,
							icon: '../gfx/red_x.png',
							scale: 'medium',
							text: 'Cancel'
						}
					]
				}
			]
		});

		me.callParent(arguments);
	},

	onEditRuleMessageChange: function(field, newValue, oldValue, eOpts) {
		if (newValue === 0) {
			field.reset();
		}
	},

	onEditRuleApproverChange: function(field, newValue, oldValue, eOpts) {
		if (newValue === 0) {
			field.reset();
		}
	}

});