/*
 * File: app/view/MainPanel.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.view.MainPanel', {
	extend: 'Ext.panel.Panel',

	requires: [
		'Ext.form.FieldSet',
		'Ext.tree.Panel',
		'Ext.tree.View',
		'Ext.tree.Column',
		'Ext.grid.column.Template',
		'Ext.XTemplate',
		'Ext.toolbar.Spacer',
		'Ext.button.Button'
	],

	itemId: 'mainPanel',
	bodyPadding: '3 10 10 10',
	header: false,
	title: 'Critical Roles',

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	initComponent: function() {
		var me = this;

		Ext.applyIf(me, {
			items: [
				{
					xtype: 'fieldset',
					flex: 3,
					margin: 0,
					layout: 'fit',
					title: 'Current groups of critical roles',
					items: [
						{
							xtype: 'treepanel',
							border: false,
							height: 250,
							itemId: 'treegrid',
							width: 400,
							header: false,
							title: 'My Tree Grid Panel',
							store: 'CurrentRuleTreeStore',
							rootVisible: false,
							useArrows: true,
							viewConfig: {
								itemId: 'mytreeview',
								overflowY: 'scroll',
								loadMask: true
							},
							columns: [
								{
									xtype: 'treecolumn',
									dataIndex: 'name',
									text: 'Groups and defined risks',
									flex: 1
								},
								{
									xtype: 'gridcolumn',
									draggable: false,
									detachOnRemove: false,
									enableColumnHide: false,
									sortable: false,
									dataIndex: 'description',
									hideable: false,
									text: 'Description',
									flex: 2,
									layout: {
										type: 'vbox',
										align: 'stretch'
									}
								},
								{
									xtype: 'gridcolumn',
									cls: 'gridNumber',
									draggable: false,
									width: 75,
									detachOnRemove: false,
									enableColumnHide: false,
									sortable: false,
									align: 'right',
									dataIndex: 'signature',
									hideable: false,
									text: 'Signature'
								},
								{
									xtype: 'gridcolumn',
									draggable: false,
									width: 50,
									detachOnRemove: false,
									sortable: false,
									dataIndex: 'level',
									hideable: false,
									text: 'Level'
								},
								{
									xtype: 'gridcolumn',
									draggable: false,
									width: 150,
									detachOnRemove: false,
									sortable: false,
									dataIndex: 'warningText',
									hideable: false,
									text: 'System reaction'
								},
								{
									xtype: 'gridcolumn',
									renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
										if(value != 9) {
											return record.get('frequencyText');
										}
										return '';
									},
									draggable: false,
									width: 75,
									detachOnRemove: false,
									sortable: false,
									dataIndex: 'workflow_frequency',
									hideable: false,
									text: 'Renewal'
								},
								{
									xtype: 'templatecolumn',
									cls: 'gridMitigation',
									tpl: Ext.create('Ext.XTemplate', 
										'<img src="{mitigation:this.findM}" alt="Mitigation Icon" title="{mitigation:this.findMText}" />',
										{
											findM: function(item) {
												var pic = '';
												if(item !== "" && item !== null && item !== undefined) {
													pic = "../gfx/m.png";
												} else {
													pic = '../gfx/blank.png';
												}
												return pic;
											},
											findMText: function(item) {
												var text = "";
												if(item !== "" && item !== null && item !== undefined) {
													text = CCS.Translator.getText("Mitigation description")+":\n"+item;
												}
												return text;
											}
										}
									),
									width: 115,
									enableColumnHide: false,
									sortable: false,
									align: 'center',
									dataIndex: 'mitigation',
									hideable: false,
									text: 'Mitigation description'
								},
								{
									xtype: 'gridcolumn',
									renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
										if(value=='Active')
										return '<img src="../gfx/approve.png" title="'+record.get('status')+'" />';
										else if(value=='Inactive')
										return '<img src="../gfx/icon_red_minus_small.png" title="'+record.get('status')+'" />';
										else
										return '';
									},
									cls: 'setLeft',
									draggable: false,
									width: 50,
									detachOnRemove: false,
									enableColumnHide: false,
									sortable: false,
									align: 'center',
									dataIndex: 'statusId',
									hideable: false,
									text: 'Status'
								},
								{
									xtype: 'gridcolumn',
									draggable: false,
									detachOnRemove: false,
									enableColumnHide: false,
									sortable: false,
									dataIndex: 'origin',
									hideable: false,
									text: 'Origin'
								}
							],
							listeners: {
								beforeselect: {
									fn: me.onTreegridBeforeSelect,
									scope: me
								}
							}
						}
					]
				},
				{
					xtype: 'tbspacer',
					height: 5
				},
				{
					xtype: 'fieldset',
					itemId: 'actionsPanel',
					margin: 0,
					padding: '3 10 10 10',
					title: 'Actions',
					layout: {
						type: 'hbox',
						align: 'stretch'
					},
					items: [
						{
							xtype: 'button',
							itemId: 'createnewruleButton',
							padding: 5,
							icon: '../gfx/rule.png',
							scale: 'medium',
							text: 'Define risk'
						},
						{
							xtype: 'tbspacer',
							width: 10
						},
						{
							xtype: 'button',
							disabled: true,
							itemId: 'editRuleButton',
							padding: 5,
							icon: '../gfx/rule_edit.png',
							scale: 'medium',
							text: 'Edit'
						},
						{
							xtype: 'tbspacer',
							width: 10
						},
						{
							xtype: 'button',
							disabled: true,
							itemId: 'copyRuleButton',
							padding: 5,
							icon: '../gfx/rule_copy.png',
							scale: 'medium',
							text: 'Duplicate'
						},
						{
							xtype: 'tbspacer',
							width: 10
						},
						{
							xtype: 'button',
							disabled: true,
							itemId: 'deleteRuleButton',
							padding: 5,
							icon: '../gfx/rule_delete.png',
							scale: 'medium',
							text: 'Delete'
						},
						{
							xtype: 'tbspacer',
							width: 10
						},
						{
							xtype: 'button',
							disabled: true,
							itemId: 'addRoleButton',
							padding: 5,
							icon: '../gfx/add.png',
							scale: 'medium',
							text: 'Add roles'
						},
						{
							xtype: 'tbspacer',
							width: 10
						},
						{
							xtype: 'button',
							disabled: true,
							itemId: 'removeRoleButton',
							padding: 5,
							icon: '../gfx/remove.png',
							scale: 'medium',
							text: 'Remove role'
						},
						{
							xtype: 'tbspacer',
							width: 10
						},
						{
							xtype: 'button',
							disabled: true,
							itemId: 'viewRuleHistoryButton',
							padding: 5,
							icon: '../gfx/history.png',
							scale: 'medium',
							text: 'History'
						},
						{
							xtype: 'tbspacer',
							flex: 1
						},
						{
							xtype: 'button',
							disabled: true,
							itemId: 'riskDetailsPDF',
							padding: 5,
							icon: '../../../common/gfx/filetypes/pdf.png',
							scale: 'medium',
							text: 'Risk Details'
						},
						{
							xtype: 'tbspacer',
							width: 10
						},
						{
							xtype: 'button',
							itemId: 'riskDetailsActivePDF',
							padding: 5,
							icon: '../../../common/gfx/filetypes/zip.png',
							scale: 'medium',
							text: 'Active Risk Details'
						}
					]
				},
				{
					xtype: 'tbspacer',
					height: 5
				},
				{
					xtype: 'fieldset',
					itemId: 'miscPanel',
					margin: 0,
					title: 'Group',
					layout: {
						type: 'hbox',
						align: 'stretch'
					},
					items: [
						{
							xtype: 'button',
							margins: '2 10 10 0',
							itemId: 'newGroupButton',
							padding: 5,
							icon: '../gfx/group.png',
							scale: 'medium',
							text: 'Create group'
						},
						{
							xtype: 'button',
							margins: '2 10 10 0',
							itemId: 'editGroupButton',
							padding: 5,
							icon: '../gfx/group_edit.png',
							scale: 'medium',
							text: 'Edit group'
						},
						{
							xtype: 'button',
							margins: '2 10 10 0',
							disabled: true,
							itemId: 'deleteGroupButton',
							padding: 5,
							icon: '../gfx/group_delete.png',
							scale: 'medium',
							text: 'Delete group'
						},
						{
							xtype: 'button',
							margins: '2 10 10 0',
							disabled: true,
							itemId: 'activateGroupButton',
							padding: 5,
							icon: '../gfx/approve.png',
							scale: 'medium',
							text: 'Activate group'
						},
						{
							xtype: 'button',
							margins: '2 10 10 0',
							disabled: true,
							itemId: 'deactivateGroupButton',
							padding: 5,
							icon: '../gfx/red_minus.png',
							scale: 'medium',
							text: 'Deactivate group'
						},
						{
							xtype: 'button',
							margins: '2 10 10 10',
							disabled: true,
							hidden: true,
							itemId: 'clearselection',
							padding: '5 10 5 10',
							icon: '../gfx/clear.png',
							scale: 'medium',
							text: 'Clear selection'
						}
					]
				}
			]
		});

		me.callParent(arguments);
	},

	onTreegridBeforeSelect: function(rowmodel, record, index, eOpts) {
		MyApp.app.getController('GUIController').getTreegrid().getSelectionModel().deselectAll();
	}

});