/*
 * File: app/view/CritRoles.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.view.CritRoles', {
	extend: 'Ext.panel.Panel',

	requires: [
		'Ext.form.FieldSet',
		'Ext.tree.Panel',
		'Ext.tree.View',
		'Ext.tree.Column',
		'Ext.grid.column.Template',
		'Ext.XTemplate',
		'Ext.button.Button'
	],

	height: 537,
	itemId: 'mypanel',
	width: 1132,
	header: false,
	title: 'Critical Roles',

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	initComponent: function() {
		var me = this;

		Ext.applyIf(me, {
			items: [
				{
					xtype: 'fieldset',
					flex: 5,
					margin: '5 12 15 12',
					layout: 'fit',
					title: 'Current groups of critical roles',
					items: [
						{
							xtype: 'treepanel',
							border: false,
							height: 250,
							itemId: 'treegrid',
							width: 400,
							header: false,
							title: 'My Tree Grid Panel',
							store: 'CurrentRuleTreeStore',
							rootVisible: false,
							useArrows: true,
							viewConfig: {
								itemId: 'mytreeview',
								overflowY: 'scroll',
								loadMask: true
							},
							columns: [
								{
									xtype: 'treecolumn',
									dataIndex: 'name',
									text: 'Groups and defined risks',
									flex: 1
								},
								{
									xtype: 'gridcolumn',
									draggable: false,
									detachOnRemove: false,
									enableColumnHide: false,
									sortable: false,
									dataIndex: 'description',
									hideable: false,
									text: 'Description',
									flex: 2,
									layout: {
										type: 'vbox',
										align: 'stretch'
									}
								},
								{
									xtype: 'gridcolumn',
									cls: 'gridNumber',
									draggable: false,
									width: 75,
									detachOnRemove: false,
									enableColumnHide: false,
									sortable: false,
									align: 'right',
									dataIndex: 'ruleId',
									hideable: false,
									text: 'Risk ID'
								},
								{
									xtype: 'gridcolumn',
									draggable: false,
									width: 50,
									detachOnRemove: false,
									sortable: false,
									dataIndex: 'level',
									hideable: false,
									text: 'Level'
								},
								{
									xtype: 'gridcolumn',
									draggable: false,
									width: 150,
									detachOnRemove: false,
									sortable: false,
									dataIndex: 'warningText',
									hideable: false,
									text: 'System reaction'
								},
								{
									xtype: 'templatecolumn',
									cls: 'gridMitigation',
									tpl: Ext.create('Ext.XTemplate', 
										'<img src="{mitigation:this.findM}" alt="Mitigation Icon" title="{mitigation:this.findMText}" />',
										{
											findM: function(item) {
												var pic = '';
												if(item !== "" && item !== null && item !== undefined) {
													pic = "../gfx/m.png";
												} else {
													pic = '../gfx/blank.png';
												}
												return pic;
											},
											findMText: function(item) {
												var text = "";
												if(item !== "" && item !== null && item !== undefined) {
													text = CCS.Translator.getText("Mitigation description")+":\n"+item;
												}
												return text;
											}
										}
									),
									width: 115,
									enableColumnHide: false,
									sortable: false,
									align: 'center',
									dataIndex: 'mitigation',
									hideable: false,
									text: 'Mitigation description'
								},
								{
									xtype: 'gridcolumn',
									renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
										if(value=='Active')
										return '<img src="../gfx/approve.png" title="'+record.get('status')+'" />';
										else if(value=='Inactive')
										return '<img src="../gfx/icon_red_minus_small.png" title="'+record.get('status')+'" />';
										else
										return '';
									},
									cls: 'setLeft',
									draggable: false,
									width: 50,
									detachOnRemove: false,
									enableColumnHide: false,
									sortable: false,
									align: 'center',
									dataIndex: 'statusId',
									hideable: false,
									text: 'Status'
								},
								{
									xtype: 'gridcolumn',
									draggable: false,
									detachOnRemove: false,
									enableColumnHide: false,
									sortable: false,
									dataIndex: 'origin',
									hideable: false,
									text: 'Origin'
								}
							]
						}
					]
				},
				{
					xtype: 'fieldset',
					itemId: 'actionsPanel',
					margin: '5 12 5 12',
					title: 'Actions',
					layout: {
						type: 'hbox',
						align: 'stretch'
					},
					items: [
						{
							xtype: 'button',
							margins: '2 10 10 0',
							itemId: 'createnewruleButton',
							padding: '5 10 5 10',
							icon: '../gfx/rule.png',
							scale: 'medium',
							text: 'Define risk'
						},
						{
							xtype: 'button',
							margins: '2 10 10 0',
							disabled: true,
							itemId: 'editRuleButton',
							padding: '5 10 5 10',
							icon: '../gfx/rule_edit.png',
							scale: 'medium',
							text: 'Edit'
						},
						{
							xtype: 'button',
							margins: '2 10 10 0',
							disabled: true,
							itemId: 'copyRuleButton',
							padding: '5 10 5 10',
							icon: '../gfx/rule_copy.png',
							scale: 'medium',
							text: 'Duplicate'
						},
						{
							xtype: 'button',
							margins: '2 10 10 0',
							disabled: true,
							itemId: 'deleteRuleButton',
							padding: '5 10 5 10',
							icon: '../gfx/rule_delete.png',
							scale: 'medium',
							text: 'Delete'
						},
						{
							xtype: 'button',
							margins: '2 10 10 0',
							disabled: true,
							itemId: 'addRoleButton',
							padding: '5 10 5 10',
							icon: '../gfx/add.png',
							scale: 'medium',
							text: 'Add roles'
						},
						{
							xtype: 'button',
							margins: '2 10 10 0',
							disabled: true,
							itemId: 'removeRoleButton',
							padding: '5 10 5 10',
							icon: '../gfx/remove.png',
							scale: 'medium',
							text: 'Remove role'
						},
						{
							xtype: 'button',
							margins: '2 10 10 0',
							disabled: true,
							itemId: 'viewRuleHistoryButton',
							padding: '5 10 5 10',
							icon: '../gfx/history.png',
							scale: 'medium',
							text: 'History'
						}
					]
				},
				{
					xtype: 'fieldset',
					itemId: 'miscPanel',
					margin: '5 12 15 12',
					title: 'Group',
					layout: {
						type: 'hbox',
						align: 'stretch'
					},
					items: [
						{
							xtype: 'button',
							margins: '2 10 10 0',
							itemId: 'newGroupButton',
							padding: '5 10 5 10',
							icon: '../gfx/group.png',
							scale: 'medium',
							text: 'Create group'
						},
						{
							xtype: 'button',
							margins: '2 10 10 0',
							itemId: 'editGroupButton',
							padding: '5 10 5 10',
							icon: '../gfx/group_edit.png',
							scale: 'medium',
							text: 'Edit group'
						},
						{
							xtype: 'button',
							margins: '2 10 10 0',
							disabled: true,
							itemId: 'deleteGroupButton',
							padding: '5 10 5 10',
							icon: '../gfx/group_delete.png',
							scale: 'medium',
							text: 'Delete group'
						},
						{
							xtype: 'button',
							margins: '2 10 10 0',
							disabled: true,
							itemId: 'activateGroupButton',
							padding: '5 10 5 10',
							icon: '../gfx/approve.png',
							scale: 'medium',
							text: 'Activate group'
						},
						{
							xtype: 'button',
							margins: '2 10 10 0',
							disabled: true,
							itemId: 'deactivateGroupButton',
							padding: '5 10 5 10',
							icon: '../gfx/red_minus.png',
							scale: 'medium',
							text: 'Deactivate group'
						},
						{
							xtype: 'button',
							margins: '2 10 10 10',
							disabled: true,
							hidden: true,
							itemId: 'clearselection',
							padding: '5 10 5 10',
							icon: '../gfx/clear.png',
							scale: 'medium',
							text: 'Clear selection'
						}
					]
				}
			]
		});

		me.callParent(arguments);
	}

});