/*
 * File: app/store/CurrentRuleTreeStore.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.store.CurrentRuleTreeStore', {
	extend: 'Ext.data.TreeStore',

	requires: [
		'MyApp.model.CurrentRuleTreeModel',
		'Ext.data.proxy.Ajax',
		'Ext.data.reader.Json'
	],

	constructor: function(cfg) {
		var me = this;
		cfg = cfg || {};
		me.callParent([Ext.apply({
			autoLoad: true,
			autoSync: true,
			model: 'MyApp.model.CurrentRuleTreeModel',
			storeId: 'IdCurrentRuleTreeStore',
			proxy: {
				type: 'ajax',
				url: '../../service/common_risk_treestore.php',
				reader: {
					type: 'json',
					idProperty: 'tree_id'
				}
			},
			listeners: {
				beforeload: {
					fn: me.onTreeStoreBeforeLoad,
					scope: me
				},
				load: {
					fn: me.onTreeStoreLoad,
					scope: me
				},
				write: {
					fn: me.onTreeStoreWrite,
					scope: me
				},
				beforesync: {
					fn: me.onTreeStoreBeforeSync,
					scope: me
				}
			}
		}, cfg)]);
	},

	onTreeStoreBeforeLoad: function(store, operation, eOpts) {
		var params = Ext.Object.fromQueryString(document.location.search);
		params.risktype = "crit_role";
		var extra = store.proxy.extraParams;
		var newParams = Ext.Object.merge(params, extra);
		store.proxy.extraParams = newParams;
	},

	onTreeStoreLoad: function(treestore, node, records, successful, eOpts) {
		var urlParams = Ext.Object.fromQueryString(document.location.search);

		//expand last selected (in order to expand after add)
		var grid = Ext.ComponentQuery.query('#treegrid')[0];
		var model = grid.getSelectionModel();
		var lastSelected = model.getLastSelected();
		if(lastSelected !== undefined && lastSelected !== null) {
			var record;
			if(lastSelected.data.groupId === "") {
				record = treestore.getRootNode().findChild('id', lastSelected.data.id, true);
			} else {
				record = treestore.getRootNode().findChild('ruleId', lastSelected.data.ruleId, true);
				var group = treestore.getRootNode().findChild('id', record.data.groupId, true);
				grid.expand(group);
				group.expand();
			}

			model.doSelect(record);
			grid.expand(record);
			record.expand();
		}
		else if(urlParams.risk_id) { //find risk with the id transferred from another page (lagecy)
			var groups = treestore.getRootNode().childNodes;
			Ext.Array.each(groups, function(group) {
				var record = group.findChild('id', urlParams.risk_id);
				if(!Ext.isEmpty(record)) {
					group.expand();
					record.expand();
					model.doSelect(record);
				}
			});
			//cleanup url
			delete urlParams.risk_id;
			window.history.pushState(urlParams, document.title, location.protocol + '//' + location.host +
									location.pathname +"?"+ Ext.urlEncode(urlParams) );
		}
		treestore.proxy.extraParams = Ext.Object.fromQueryString(document.location.search);
		MyApp.app.getController('GUIController').selectionHasChanged();
	},

	onTreeStoreWrite: function(store, operation, eOpts) {
		var record = operation.records[0];
		//select rule or group record
		if(!record.isLeaf() && operation.action == "create") {
			var grid  = Ext.ComponentQuery.query('#treegrid')[0];
			var model = grid.getSelectionModel();
			model.doSelect(record);
			grid.expand(record);
		}
	},

	onTreeStoreBeforeSync: function(options, eOpts) {
		var store = eOpts.scope;
		var params = Ext.Object.fromQueryString(document.location.search);
		params.risktype = "crit_role";
		store.proxy.extraParams = params;
	}

});