/*
 * File: app/controller/GUIController.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.controller.GUIController', {
	extend: 'Ext.app.Controller',

	refs: [
		{
			ref: 'treegrid',
			selector: '#treegrid'
		},
		{
			ref: 'deleterule',
			selector: '#deleteRuleButton'
		},
		{
			ref: 'addrole',
			selector: '#addRoleButton'
		},
		{
			ref: 'deleterole',
			selector: '#removeRoleButton'
		},
		{
			ref: 'copyRuleButton',
			selector: '#copyRuleButton'
		},
		{
			ref: 'editRuleButton',
			selector: '#editRuleButton'
		},
		{
			ref: 'deleteGroupButton',
			selector: '#deleteGroupButton'
		},
		{
			ref: 'clearselection',
			selector: '#clearselection'
		},
		{
			ref: 'viewRuleHistoryButton',
			selector: '#viewRuleHistoryButton'
		},
		{
			ref: 'activateGroupButton',
			selector: '#activateGroupButton'
		},
		{
			ref: 'deactivateGroupButton',
			selector: '#deactivateGroupButton'
		},
		{
			ref: 'editGroupButton',
			selector: '#editGroupButton'
		},
		{
			ref: 'riskDetailsPDF',
			selector: '#riskDetailsPDF'
		}
	],

	init: function(application) {
		//add listener to treegrid
		this.control({
		    '#treegrid': {
		        selectionchange: function(model, selected, eOpts) {
					this.selectionHasChanged(model, selected, eOpts);
				}
		    }
		});

		//clear selection button
		this.control({
		    '#clearselection': {
		        click: function() {
		            this.getTreegrid().getSelectionModel().deselectAll();
		            this.getClearselection().blur();
		        }
		    }
		});

	},

	onLaunch: function() {
		/*
		var task = new Ext.util.DelayedTask(function(args){
		    var mygrid = args.grid;
		    mygrid.getStore().load();
		    mygrid.expandAll();
		});
		var mygrid = this.getTreegrid();
		task.delay(3000, null, null, [{grid: mygrid}]);
		*/
	},

	selectionHasChanged: function(model, selected, eOpts) {
		this.disableAll();
		/*
		this.getEditGroupButton().disable();
		this.getDeleteGroupButton().disable();
		this.getActivateGroupButton().disable();
		this.getDeactivateGroupButton().disable();
		*/
		//console.log(selected);

		if(!Ext.isEmpty(selected)) {
		    this.getClearselection().enable();

			var selNode = selected.length > 1? selected[selected.length-1] : selected[0];

			if(selNode.isLeaf()) {
				//role
				this.getDeleterole().enable();
			}
			else if (selNode.data.ruleId !== null && selNode.data.ruleId !== undefined && selNode.data.ruleId !== "") {
				//rule
				this.getAddrole().enable();
				this.getEditRuleButton().enable();
				this.getCopyRuleButton().enable();
				this.getViewRuleHistoryButton().enable();
				this.getRiskDetailsPDF().enable();

				if(selNode.get('statusId') != "Active") {
					this.getDeleterule().enable();
				}

			}
			else {
				//group
				if(selNode.childNodes.length < 1 && selNode.get('id') !== 0) {
					this.getDeleteGroupButton().enable();
				}
				else {
					this.getActivateGroupButton().enable();
					this.getDeactivateGroupButton().enable();
				}
				if (selNode.get('id') !== 0) {
					this.getEditGroupButton().enable();
				}
				else {
					this.getEditGroupButton().disable();
				}
			}
			//selNode.expand(); //creates problems with double click expansion of the tree
		}
		else {
			this.getClearselection().disable();
		}
	},

	disableAll: function() {
		if(this.getEditRuleButton() !== undefined) {
			this.getEditRuleButton().disable();
			this.getCopyRuleButton().disable();
			this.getDeleterule().disable();

			this.getAddrole().disable();
			this.getDeleterole().disable();

			this.getRiskDetailsPDF().disable();

			this.getEditGroupButton().disable();
			this.getDeleteGroupButton().disable();
			this.getActivateGroupButton().disable();
			this.getDeactivateGroupButton().disable();

			this.getViewRuleHistoryButton().disable();

		}
	}

});
