/*
 * File: app/controller/Download.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.controller.Download', {
	extend: 'Ext.app.Controller',

	refs: [
		{
			ref: 'treegrid',
			selector: '#treegrid'
		}
	],

	init: function(application) {
		this.control({
		    '#riskDetailsPDF': {
				click: this.getDetailsPDF
		    },
			'#riskDetailsActivePDF': {
				click: this.getDetailsActivePDF
			}
		});

	},

	getDetailsPDF: function(btn) {
		btn.disable();

		var risk = this.getTreegrid().getSelectionModel().getSelection()[0];

		var iframe = document.getElementById("hiddenIFrameCurrent");
		if(iframe === null) {
		    iframe = document.createElement('iframe');
		    iframe.id = "hiddenIFrameCurrent";
		    iframe.style.display = 'none';
		    document.body.appendChild(iframe);
		}
		iframe.src = '../../service/download_pdf.php' + document.location.search + '&type=risk_details_pdf&risk_id='+risk.get('id');

		btn.blur();
		setTimeout(function(){
			btn.enable();
		}, 2500);
	},

	getDetailsActivePDF: function(btn) {
		btn.disable();

		var risk = this.getTreegrid().getSelectionModel().getSelection()[0];

		var iframe = document.getElementById("hiddenIFrameCurrent");
		if(iframe === null) {
		    iframe = document.createElement('iframe');
		    iframe.id = "hiddenIFrameCurrent";
		    iframe.style.display = 'none';
		    document.body.appendChild(iframe);
		}
		iframe.src = '../../service/download_pdf.php' + document.location.search + '&type=risk_details_active_pdf&rule_type=crit_role';

		btn.blur();
		setTimeout(function(){
			btn.enable();
		}, 2500);
	}

});
