/*
 * File: app/controller/CreateEditDeleteRuleController.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.controller.CreateEditDeleteRuleController', {
	extend: 'Ext.app.Controller',

	refs: [
		{
			ref: 'mainTreeGrid',
			selector: '#treegrid'
		},
		{
			ref: 'deleteRuleButton',
			selector: '#deleteRuleButton'
		},
		{
			ref: 'copyRuleButton',
			selector: '#copyRuleButton'
		},
		{
			ref: 'createnewruleButton',
			selector: '#createnewruleButton'
		},
		{
			ref: 'editRuleButton',
			selector: '#editRuleButton'
		},
		{
			autoCreate: true,
			ref: 'editRuleWindow',
			selector: '#editRuleWindow',
			xtype: 'editRuleWindowAlias'
		},
		{
			ref: 'editRuleNumberLabel',
			selector: '#editRuleNumberLabel'
		},
		{
			ref: 'editRuleSettingsPanel',
			selector: '#editRuleSettingsPanel'
		},
		{
			ref: 'editRuleName',
			selector: '#editRuleName'
		},
		{
			ref: 'editRuleWarning',
			selector: '#editRuleWarning'
		},
		{
			ref: 'editRuleApprover',
			selector: '#editRuleApprover'
		},
		{
			ref: 'editRuleMessage',
			selector: '#editRuleMessage'
		},
		{
			ref: 'editRuleRisk',
			selector: '#editRuleRisk'
		},
		{
			ref: 'editRuleMitigation',
			selector: '#editRuleMitigation'
		},
		{
			ref: 'editRuleDescription',
			selector: '#editRuleDescription'
		},
		{
			ref: 'editRuleGroup',
			selector: '#editRuleGroup'
		},
		{
			ref: 'editRuleOrigin',
			selector: '#editRuleOrigin'
		},
		{
			ref: 'editRuleActive',
			selector: '#editRuleActive'
		},
		{
			ref: 'editRuleConfirmButton',
			selector: '#editRuleConfirmButton'
		},
		{
			ref: 'editRuleSaveButton',
			selector: '#editRuleSaveButton'
		},
		{
			ref: 'editRuleCancelButton',
			selector: '#editRuleCancelButton'
		},
		{
			ref: 'actionsPanel',
			selector: '#actionsPanel'
		},
		{
			autoCreate: true,
			ref: 'selectMultiApproversWindow',
			selector: '#selectMultiApproversWindow',
			xtype: 'selectMultiApproversWindow'
		},
		{
			ref: 'selectMultiApproversGrid',
			selector: '#selectMultiApproversGrid'
		},
		{
			ref: 'selectMultiApproversDoneButton',
			selector: '#selectMultiApproversDoneButton'
		},
		{
			ref: 'selectMultiApproversMinimumNumber',
			selector: '#selectMultiApproversMinimumNumber'
		},
		{
			ref: 'editRuleAddApproverButton',
			selector: '#editRuleAddApproverButton'
		},
		{
			ref: 'editRuleFrequency',
			selector: '#editRuleFrequency'
		},
		{
			ref: 'editRuleAutoRenewal',
			selector: '#editRuleAutoRenewal'
		},
		{
			ref: 'editSignature',
			selector: '#editSignature'
		}
	],

	init: function(application) {
		this.control({
		    '#deleteRuleButton': {
		        click: function() {
		            this.deleteRule();
		        }
		    },
		    '#copyRuleButton': {
		        click: function() {
		            this.copyRule();
		        }
		    },
		    '#editRuleButton': {
		        click: function() {
					this.edit = true;
		            this.getDefaultSettings();
		        }
		    },
		    '#createnewruleButton': {
		        click: function() {
					this.edit = false;
					this.getDefaultSettings();
		        }
		    },
		//close window on cancel
		    '#editRuleCancelButton': {
		        click: function() {
		            this.getEditRuleWindow().destroy();
		        }
		    },
		//do stuff on confirm
		    '#editRuleConfirmButton': {
		        click: function() {
					this.createRule();
					this.getEditRuleWindow().destroy(); //close popup window
		        }
		    },
		//save on edit
		    '#editRuleSaveButton': {
		        click: function() {
		            this.editRule();
					this.getEditRuleWindow().destroy(); //close popup window
		        }
		    },
		//active / inactive check box
		    '#editRuleActive': {
		        change: function() {

				}
		    },
		//check comboboxes for change
		    '#editRuleWarning': {
		        change: function() {
					this.warningTypeChanged();
		        }
		    },
			'#editRuleApprover': {
		        change: function() {
		            this.checkFieldStates();
		        }
		    },
			'#editRuleMessage': {
		        change: function() {
		            this.checkFieldStates();
		        }
		    },
			'#editRuleRisk': {
		        select: function() {
		            this.checkFieldStates();
		        }
		    },
		    '#editRuleGroup': {
		        change: function() {
		            this.checkFieldStates();
		        }
		    },
			'#editRuleFrequency': {
				change: function(component, newValue) {
					if(newValue == 9) {
						this.getEditRuleAutoRenewal().setValue(false);
					}
					else {
						this.getEditRuleAutoRenewal().setValue(true);
					}
				}
			},
		//check fields for changes
		    '#editRuleName': {
		        change: function() {
		            this.checkFieldStates();
		        }
		    },
		    '#editRuleMitigation': {
		        change: function() {
		            this.checkFieldStates();
		        }
		    },
		    '#editRuleDescription': {
		        change: function() {
		            this.checkFieldStates();
		        }
		    },
			'#selectMultiApproversMinimumNumber': {
				change: function() {
					this.checkFieldStates();
				}
			},
		    '#editSignature': {
		        change: this.checkUniqueSignature
		    },
		//multiapprover buttons
		    '#editRuleAddApproverButton': {
		        click: function() {
					this.multiApproversStart();
		        }
		    },
		    '#selectMultiApproversDoneButton': {
		        click: function() {
		            this.multiApproversDone();
		        }
		    }
		});
	},

	createSetUpWindow: function() {
		var groupId = '0';
		var selNode = this.getMainTreeGrid().getSelectionModel().selected.getAt(0);
		if(!Ext.isEmpty(selNode)) {
			if(selNode.isLeaf()) {
				//function
				groupId = selNode.parentNode.parentNode.data.id;
			} else if (selNode.data.ruleId !== null && selNode.data.ruleId !== undefined && selNode.data.ruleId !== "") {
				//rule
				groupId = selNode.parentNode.data.id;
			} else {
				//group
				groupId = selNode.data.id;
			}
		}
		groupId = ""+groupId;
		this.getEditRuleGroup().setValue(groupId);
		//set defaults
		this.multiApprovers = [];
		this.getEditRuleRisk().setValue('Low');
		this.getEditRuleOrigin().setValue('Local');
		this.getEditRuleMessage().setValue("0");

		//reduce system reaction store if settings requires it
		var me = this;
		var myData = [];
		this.RSstore = this.getEditRuleWarning().getStore();
		this.RSstore.each(function(rec) {
			if(me.defaults["defaultsSR"+rec.data.id]) {
				myData.push(rec);
			}
		});
		var myNewStore = new Ext.data.ArrayStore( {
			fields:	['id', 'text]'],
			data:	myData
		});

		this.getEditRuleWarning().bindStore(myNewStore);
		this.getEditRuleWarning().getStore().load();

		this.multiApproversMin = this.defaults.approver_minimum;
		this.getEditRuleWarning().setValue(this.defaults.system_reaction);
		//if lock reaction setting is set then lock
		if(this.defaults.system_reaction_locked)
			this.getEditRuleWarning().disable();

		//focus on name
		this.getEditRuleWindow().setLoading(false);
		this.getEditRuleName().focus();
	},

	createRule: function() {
		var myStore = this.getMainTreeGrid().getStore();
		var rootNode = this.getMainTreeGrid().getRootNode();
		var groupNode = rootNode.findChild('id', this.getEditRuleGroup().getValue(), false);
		if(this.getEditRuleOrigin().getValue().length === 0) {
			this.getEditRuleOrigin().setValue('Local');
		}

		//rule creation stuff
		var myModel = myStore.model;
		var newRecord = new myModel({
		    ruleId:		"New rule",
		    name:		this.getEditRuleName().getValue(),
		    warning:	this.getEditRuleWarning().getValue(),
		    responseId: this.getEditRuleMessage().getValue(),
		    levelId:	this.getEditRuleRisk().getValue(),
		    mitigation:	this.getEditRuleMitigation().getValue(),
		    description:this.getEditRuleDescription().getValue(),
		    groupId:	this.getEditRuleGroup().getValue(),
		    origin:		this.getEditRuleOrigin().getValue(),
		    statusId:	(this.getEditRuleActive().getValue())? 'Active' : 'Inactive',
			approverId: (this.getEditRuleWarning().getValue() == 2)? this.getEditRuleApprover().getValue() : 0,
			approver:	this.getEditRuleApprover().getRawValue(),
			workflow_autostart: this.getEditRuleAutoRenewal().getValue(),
			workflow_frequency: this.getEditRuleFrequency().getValue(),
			signature:	this.getEditSignature().getValue(),

			multiApprovers: this.multiApprovers,
			multiApproversMin : this.multiApproversMin,
			icon:		'../gfx/rule.png'
		});

		groupNode.appendChild(newRecord);
		newRecord.expand();
		this.getMainTreeGrid().getSelectionModel().deselectAll(true);
		this.getMainTreeGrid().getSelectionModel().doSelect(newRecord);
	},

	editSetUpWindow: function() {
		var record = this.getMainTreeGrid().getSelectionModel().selected.getAt(0);

		this.getEditRuleWindow().setTitle(CCS.Translator.getText('Edit risk ID {1} for critical roles',[record.data.ruleId]));
		this.getEditRuleConfirmButton().hide();
		this.getEditRuleSaveButton().show();

		this.multiApprovers = record.get('multiApprovers');
		this.multiApproversMin = record.get('multiApproversMin');
		this.getEditRuleName().setValue(record.get('name'));

		//reduce system reaction store if settings requires it
		var me = this;
		var myData = [];
		this.RSstore = this.getEditRuleWarning().getStore();
		this.RSstore.each(function(rec) {
			if(me.defaults["defaultsSR"+rec.data.id]) {
				myData.push(rec);
			}
		});
		var myNewStore = new Ext.data.ArrayStore( {
			fields:	['id', 'text]'],
			data:	myData
		});

		this.getEditRuleWarning().bindStore(myNewStore);
		this.getEditRuleWarning().getStore().load();
		this.getEditRuleWarning().setValue(record.get('warning'));

		if(this.multiApprovers.length > 0)
			this.multiApproversOutput();
		else
			this.getEditRuleApprover().setValue(record.get('approverId'));

		this.getEditSignature().setValue(record.get('signature'));
		this.getEditRuleMessage().setValue(record.get('responseId'));
		this.getEditRuleRisk().setValue(record.get('levelId'));
		this.getEditRuleMitigation().setValue(record.get('mitigation'));
		this.getEditRuleDescription().setValue(record.get('description'));
		this.getEditRuleGroup().setValue(record.get('groupId'));
		this.getEditRuleOrigin().setValue(record.get('origin'));
		this.getEditRuleActive().setValue((record.get('statusId') == "Active"));
		this.getEditRuleFrequency().setValue(record.get('workflow_frequency'));

		this.getEditRuleWindow().setLoading(false);

		//reduced system reaction store may need to be messaged to the user
		if(this.getEditRuleWarning().getValue() === null) {
			if(this.defaults.system_reaction != record.get('warning')) {
				MyApp.app.message(	CCS.Translator.getText('System reaction no longer available due to system settings!'),
									CCS.Translator.getText('You must choose an available option to edit this risk definition.'));
			}
		}
	},

	editRule: function() {
		var store = this.getMainTreeGrid().getStore();
		store.suspendAutoSync();

		var record = this.getMainTreeGrid().getSelectionModel().selected.getAt(0);

		//No empty origin
		if(this.getEditRuleOrigin().getValue().length === 0) {
			this.getEditRuleOrigin().setValue(record.data.origin);
		}

		//if the group is changed
		if(record.data.groupId != this.getEditRuleGroup().getValue()) {
			var newGroup = this.getMainTreeGrid().getRootNode().findChild('id', this.getEditRuleGroup().getValue(), false);

			record.remove(false);

			newGroup.appendChild(record);
			record.expand();
		}

		record.set("name", this.getEditRuleName().getValue());
		record.set("warning", this.getEditRuleWarning().getValue());
		record.set("warningText", this.getEditRuleWarning().getRawValue());
		record.set("approverId", (this.getEditRuleWarning().getValue() == 2)? this.getEditRuleApprover().getValue() : 0);
		record.set("approver", this.getEditRuleApprover().getRawValue());
		record.set("responseId", this.getEditRuleMessage().getValue());
		record.set("response", this.getEditRuleMessage().getRawValue());
		record.set("levelId", this.getEditRuleRisk().getValue());
		record.set("mitigation", this.getEditRuleMitigation().getValue());
		record.set("description", this.getEditRuleDescription().getValue());
		record.set("groupId", this.getEditRuleGroup().getValue());
		record.set("origin", this.getEditRuleOrigin().getValue());
		record.set("statusId", (this.getEditRuleActive().getValue())? 'Active' : 'Inactive');
		record.set("multiApprovers", this.multiApprovers);
		record.set("multiApproversMin", this.multiApproversMin);
		record.set("workflow_autostart", this.getEditRuleAutoRenewal().getValue());
		record.set("workflow_frequency", this.getEditRuleFrequency().getValue());
		record.set("signature", this.getEditSignature().getValue());

		record.set("ruleId", "Update rule");

		var model = this.getMainTreeGrid().getSelectionModel();
		store.resumeAutoSync();
		store.sync({callback:
			function(){
				model.deselectAll();
				record.commit();
				model.doSelect(record);
			}
		});
	},

	copyRule: function() {
		//suspend grid
		MyApp.app.getController('GUIController').disableAll();
		this.getMainTreeGrid().setLoading({border: false}, true);

		var record = this.getMainTreeGrid().getSelectionModel().selected.getAt(0); //there is no multiselect
		var myStore = this.getMainTreeGrid().getStore();
		var groupId = record.data.groupId;

		//rule creation stuff
		var myModel = myStore.model;
		var newRecord = new myModel({
			id:			record.data.id,
			name:		"Copy of "+record.data.name,
			groupId:	groupId,
		//	children:	record.data.children,
			ruleId:		"Copying rule",
			icon:		'../gfx/rule.png'

		});

		var groupNode = this.getMainTreeGrid().getRootNode().findChild('id', groupId, false);
		myStore.suspendAutoSync();
		myStore.autoSync = false;
		groupNode.appendChild(newRecord);
		newRecord.expand();

		myStore.sync({
			success: function(operationdata, operation) {
				var rule = operationdata.operations[0].records[0]; //find return risk with new id
				var selection = rule.data.children; //find children in received data
				for (var i = 0; i < selection.length; i++) { //add children to rule
					var newRecord = new myModel({
						id: selection[i].id,
						name: selection[i].name,
						description: selection[i].description,
						leaf: true,
						icon: selection[i].icon
					});

					rule.appendChild(newRecord);
				}
				operation.scope.getMainTreeGrid().setLoading(false);
			},
			failure: function() {	alert("Error on copying rule. Please press F5.");	},
			callback: function(){	myStore.autoSync = true; myStore.resumeAutoSync();	},
			scope: this
		}, record);
	},

	deleteRule: function() {
		var node = this.getMainTreeGrid().getSelectionModel().selected.getAt(0);
		var rule = node.get('name');
		var groupNode = this.getMainTreeGrid().getRootNode().findChild('id', node.get('groupId'), false);
		var group = groupNode.get('name');

		var scope = this;
		var question = CCS.Translator.getText('Are you sure you want to remove {1} from {2}?', [rule, group]);
		Ext.MessageBox.confirm(CCS.Translator.getText('Delete risk definition'), question, function(btn){
		    if(btn === 'yes'){
		        node.data.ruleId = "Delete rule";
		        node.remove();
				scope.getMainTreeGrid().getStore().sync();
		    }
		});
	},

	warningTypeChanged: function() {
		var warning = this.getEditRuleWarning().getValue();
		var record = this.getMainTreeGrid().getSelectionModel().selected.getAt(0);

		this.getEditRuleApprover().disable(); //single approver select
		this.getEditRuleAddApproverButton().disable(); //btn for multi approver select
		this.getEditRuleAutoRenewal().disable();
		this.getEditRuleFrequency().disable();
		this.getEditRuleFrequency().setValue(9);

		if(warning != '0') {
			this.getEditRuleMessage().enable();

			if(record !== undefined && record !== null && this.edit) {
				this.getEditRuleMessage().setValue(record.data.responseId);
			}
			switch(warning) {
				case '2':
					this.getEditRuleApprover().setValue(0);
					if(record !== undefined && record !== null && this.edit) {
						this.getEditRuleApprover().setValue(record.data.approverId);
					}
					this.getEditRuleApprover().enable();
					this.multiApprovers = [];
					this.multiApproversMin = 0;
				break;
				case '4':
					this.getEditRuleAddApproverButton().enable();
					this.getEditRuleAutoRenewal().enable();
					this.getEditRuleFrequency().enable();

					if(record !== undefined && record !== null && this.edit)
						if(!Ext.isEmpty(record.get('multiApprovers')))
							this.multiApprovers = record.get('multiApprovers');
						else {
							this.multiApprovers = [];
							this.multiApproversMin = (record.get('multiApproversMin') > this.defaults.approver_minimum)? record.get('multiApproversMin') : this.defaults.approver_minimum;
						}
					this.multiApproversOutput();
				break;
				default:
					this.getEditRuleApprover().setValue(0);
					this.multiApprovers = [];
					this.multiApproversMin = 0;
			}
		} else {
			this.getEditRuleMessage().setValue(0);
			this.getEditRuleMessage().disable();
		}
		this.checkFieldStates();
	},

	checkFieldStates: function(uniqueSignature) {
		if(this.getSelectMultiApproversMinimumNumber() !== undefined && this.getSelectMultiApproversMinimumNumber().getValue() < this.defaults.approver_minimum)
			this.getSelectMultiApproversMinimumNumber().setValue(this.defaults.approver_minimum);

		this.getEditRuleConfirmButton().disable();
		this.getEditRuleSaveButton().disable();

		this.getEditRuleName().addCls('formFieldNotReady');
		this.getEditRuleMessage().removeCls('formFieldNotReady');
		this.getEditRuleApprover().removeCls('formFieldNotReady');
		this.getEditRuleAddApproverButton().removeCls('formButtonNotReady');

		//avoid null on comboboxes
		if(	this.getEditRuleWarning().getValue() !== null && uniqueSignature === undefined) {

			//name field
			if(	Ext.String.trim(this.getEditRuleName().getValue()).length > 0) {
				//enable create / save button
				this.getEditRuleName().removeCls('formFieldNotReady');
				this.getEditRuleConfirmButton().enable();
				this.getEditRuleSaveButton().enable();
			}
			//common for message check
			if(this.getEditRuleWarning().getValue() > 0 && this.getEditRuleMessage().getValue() === null) {
				this.getEditRuleConfirmButton().disable();
				this.getEditRuleSaveButton().disable();
				this.getEditRuleMessage().addCls('formFieldNotReady');
			}

			//do checks according to warning type (system reaction)
			this.getEditRuleWarning().removeCls('formFieldNotReady');
			switch(this.getEditRuleWarning().getValue()) {
				case '0': break; //don't do nothing
				case '2':
					//check approver
					if(this.getEditRuleApprover().getValue() === null) {
						this.getEditRuleConfirmButton().disable();
						this.getEditRuleSaveButton().disable();
						this.getEditRuleApprover().addCls('formFieldNotReady');
					}
					break;
				case '4':
					if(this.multiApprovers.length < this.multiApproversMin) {
						this.getEditRuleConfirmButton().disable();
						this.getEditRuleSaveButton().disable();
						this.getEditRuleAddApproverButton().addCls('formButtonNotReady');
					}
					break;
				default: //case '1' & '3'
			}

		}
		//reduced warning types / sytem reactions can result in null value
		else {
			if(	Ext.String.trim(this.getEditRuleName().getValue()).length > 0)
				this.getEditRuleName().removeCls('formFieldNotReady');
		}

		if (uniqueSignature === true) {
			this.getEditRuleConfirmButton().enable();
			this.getEditRuleSaveButton().enable();
		}

	},

	multiApproversStart: function() {
		this.getSelectMultiApproversWindow().show();

		var currentMultiApproversMin = (this.multiApproversMin > this.defaults.approver_minimum)? this.multiApproversMin : this.defaults.approver_minimum;

		this.getSelectMultiApproversMinimumNumber().setValue(Number(currentMultiApproversMin));
		this.getSelectMultiApproversMinimumNumber().minValue = Number(this.defaults.approver_minimum);

		if(Ext.isArray(this.multiApprovers) && this.multiApprovers.length > 0) {
			for(i = 0; i < this.multiApprovers.length; i++) {
				var record = this.getSelectMultiApproversGrid().getStore().findRecord('id', this.multiApprovers[i]);
				this.getSelectMultiApproversGrid().getSelectionModel().select(record, true);
			}
		}
	},

	multiApproversDone: function() {
		var mySelection = this.getSelectMultiApproversGrid().getSelectionModel().getSelection();
		var selectedApproverIds = [];
		if (mySelection.length > 0) {
			for(i = 0; i < mySelection.length; i++) {
				selectedApproverIds.push( mySelection[i].get('id') );
			}
		}
		this.multiApprovers = selectedApproverIds;
		this.multiApproversMin = this.getSelectMultiApproversMinimumNumber().getValue();
		this.multiApproversOutput();
		this.getSelectMultiApproversWindow().destroy();
		this.checkFieldStates();
	},

	multiApproversOutput: function() {
		var selectedOutput = "";
		if (this.multiApprovers.length > 0) {
			for(i = 0; i < this.multiApprovers.length; i++) {
				selectedOutput += this.getEditRuleApprover().getStore().getById(this.multiApprovers[i]).get('text');
				if(i < this.multiApprovers.length-1)
					selectedOutput += ", ";
			}
			this.getEditRuleApprover().setRawValue(selectedOutput);
		} else {
			this.getEditRuleApprover().setValue(0);
		}
	},

	getDefaultSettings: function(mode) {
		this.getEditRuleWindow().show();
		this.getEditRuleWindow().setLoading(CCS.Translator.getText('Loading...'));

		//load all data needed to set up window
		this.numLoaded = 0;
		this.getEditRuleMessage().getStore().load({callback: function() { this.onLoad(); }, scope: this});
		this.getEditRuleApprover().getStore().load({callback: function() { this.onLoad(); }, scope: this});
		this.getEditRuleWarning().getStore().load({callback: function() { this.onLoad(); }, scope: this});
		this.getEditRuleRisk().getStore().load({callback: function() { this.onLoad(); }, scope: this});
		this.getEditRuleGroup().getStore().load({callback: function() { this.onLoad(); }, scope: this});

		//get data from service and call the right method afterwards
		Ext.Ajax.request({
			url: '../../service/default_settings.php',
			method: 'GET',
			params: Ext.Object.fromQueryString(document.location.search),
			success: function(response, object){
				this.defaults = Ext.JSON.decode(response.responseText);
				this.onLoad();
			},
			failure: function(response, object){
				var text = response.responseText;
				Ext.Error.raise({
					msg: 'Failed to get report parameters',
					option: text,   // whatever was passed into the method
					'object': object // other arbitrary info
				});
			},
			scope: this
		});
	},

	onLoad: function() {
		this.numLoaded++;
		if (this.numLoaded == 6) {
			if(this.edit)
				this.editSetUpWindow();
			else
				this.createSetUpWindow();
		}
	},

	checkUniqueSignature: function(field, newValue, oldValue, eOpts) {
		field.removeCls('formFieldNotReady');
		var record = this.getMainTreeGrid().getSelectionModel().selected.getAt(0);

		var notSame = false;
		if(record !== null) {
			notSame = record.get('signature') != newValue;
		}
		else {
			notSame = true;
		}

		if(newValue.length > 0 && notSame) {
			params = Ext.Object.fromQueryString(document.location.search);
			params.signature = newValue;
			Ext.Ajax.request({ //manual AJAX
				url: '../../service/is_unique_signature.php',
				method: 'GET',
				params: params,
				success: function(response, object){
					var data = Ext.JSON.decode(response.responseText);
					if(!data.result)
						field.addCls('formFieldNotReady');

					this.checkFieldStates(data.result);
				},
				failure: function(response, object){
					field.setValue(oldValue);

					var text = response.responseText;
					Ext.Error.raise({
						msg: 'Ajax Get systems and clients failed',
						option: text,   // whatever was passed into the method
						'object': object // other arbitrary info
					});
				},
				scope: this
			});
		}
		else {
			this.checkFieldStates(true);
		}
	}

});
