/*
 * File: app/controller/Authorization.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.controller.Authorization', {
	extend: 'Ext.app.Controller',

	refs: [
		{
			ref: 'mainPanel',
			selector: '#mainPanel'
		}
	],

	onLaunch: function() {
		/*this.authorizations = {
			'01': false,
			'02': false,
			'03': false
		};

		var actvt_checks = ['03', '02', '01'];
		Ext.Array.each(actvt_checks, function(actvt) {
			this.checkAuthorization(actvt);
		}, this);*/


		/** ACTIVATE MAIN PANEL UNTILL THIS SHOULD BE IMPLEMENTED **/
		this.getMainPanel().enable();

	},

	checkAuthorization: function(value) {
		/* Check SAP authorizations */
		var authorization = {
		    object: 'ZAPM_SOD',
		    obj_values: [
		        {
		            name: 'ACTVT',
		            value: value
		        }
		    ]
		};

		Ext.Ajax.request({
		    url: '../../../../../auth_check',
		    method: 'POST',
		    jsonData: Ext.encode(authorization),
		    success: function(response, object){
		        var text = response.responseText;
		        var result = Ext.JSON.decode(text);
		        if (Ext.String.trim(result) == '0') {
		            this.authorizations[value] = true;
		        }
				this.reactToAuthorization(value);
		    },
		    failure: function(response, object){
		        var text = response.responseText;
		        Ext.Error.raise({
		            msg: 'Could not perform authorization check',
		            option: text,   // whatever was passed into the method
		            'object': object // other arbitrary info
		        });
		    },
		    scope: this
		});
	},

	reactToAuthorization: function(actvt_value) {
		switch(actvt_value) {
			case '01':
				if(this.authorizations['01']) {

				}
			break;
			case '02':
				if(this.authorizations['02']) {

				}
			break;
			case '03':
				if(this.authorizations['03'])
					this.getMainPanel().enable();
				else
					Ext.MessageBox.alert(
						CCS.Translator.getText('Authorization Error'),
						CCS.Translator.getText('It seems you are not allowed to see this page.'),
						function() {
							//actions to complete when user clicks ok.
							window.history.back();
						}
					);
			break;

		}
	}

});
