/*
 * File: app/controller/RiskSearchController.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.controller.RiskSearchController', {
    extend: 'Ext.app.Controller',
    alias: 'controller.RiskSearchController',

    refs: [
        {
            ref: 'treegrid',
            selector: '#treegrid'
        },
        {
            ref: 'searchGroupCombo',
            selector: '#searchGroupCombo'
        },
        {
            ref: 'searchRiskIdTrigger',
            selector: '#searchRiskIdTrigger'
        },
        {
            ref: 'searchNameTrigger',
            selector: '#searchNameTrigger'
        },
        {
            ref: 'searchContentTrigger',
            selector: '#searchContentTrigger'
        }
    ],

    init: function(application) {
        //add listener to treegrid
        this.control({
        	'#searchGroupCombo': {
        		specialkey: function(field, e) {
        			if (e.getKey() == e.ENTER) {
        				this.prepareSearch();
        			}
        		}
        	},
            '#searchRiskIdTrigger': {
        		specialkey: function(field, e) {
        			if (e.getKey() == e.ENTER) {
        				this.prepareSearch();
        			}
        		}
            },
        	'#searchNameTrigger': {
        		specialkey: function(field, e) {
        			if (e.getKey() == e.ENTER) {
        				this.prepareSearch();
        			}
        		}
        	},
        	'#searchContentTrigger': {
        		specialkey: function(field, e) {
        			if (e.getKey() == e.ENTER) {
        				this.prepareSearch();
        			}
        		}
        	}
        });

    },

    onLaunch: function() {
        this.getTreegrid().addDocked({
            xtype: 'RiskSearchToolBar',
            dock: 'bottom'
        });
        var me = this;
        this.getSearchRiskIdTrigger().onTriggerClick = function(event) {
        	me.prepareSearch();
        };
        this.getSearchNameTrigger().onTriggerClick = function(event) {
        	me.prepareSearch();
        };
        this.getSearchContentTrigger().onTriggerClick = function(event) {
        	me.prepareSearch();
        };
        this.getSearchRiskIdTrigger().focus();
    },

    prepareSearch: function() {
        this.getSearchGroupCombo().disable();
        this.getSearchRiskIdTrigger().disable();
        this.getSearchNameTrigger().disable();
        this.getSearchContentTrigger().disable();
        this.getTreegrid().setLoading(CCS.Translator.getText('Loading...'));
        this.getTreegrid().collapseAll();

        //delay actual search so tree has time to both collapse and setLoading
        var me = this;
        setTimeout(function() {
            me.search();
        }, 400);
    },

    search: function() {
        this.getTreegrid().suspendLayout = true;
        var grpsearch = this.getSearchGroupCombo().getValue();
        var intsearch = parseInt(this.getSearchRiskIdTrigger().getValue(), 10);
        var chrsearch = this.getSearchRiskIdTrigger().getValue();
        var namesearch= this.getSearchNameTrigger().getValue().toUpperCase();
        var contsearch= this.getSearchContentTrigger().getValue().toUpperCase();

        var root = this.getTreegrid().getStore().getRootNode();

        var groups = [];
        var risks = [];
        Ext.Array.each(root.childNodes, function(group) {
        	if(Ext.isEmpty(grpsearch) || group.get('id') == grpsearch) {
        		Ext.Array.each(group.childNodes, function(risk) {
        			if(risk.get('id') == intsearch ||
                       (risk.get('ruleId').indexOf(chrsearch) >= 0 && chrsearch.length > 0)||
                       (risk.get('name').toUpperCase().indexOf(namesearch) >= 0 && namesearch.length > 0)
                      ) {
                        if(contsearch.length > 0) { //if risk hasn't been selected by id or name try children
                            //sod_role2 has different children than other rules (risks)
                            if(risk.get('rule_type') == 'sod_role2') {
                                Ext.Array.each(risk.childNodes, function(child) {
                                    if(child.get('description').toUpperCase().indexOf(contsearch) >= 0) {
                                        groups.push(group);
                                        risks.push(risk);
                                    }
                                });
                            }
                            else {
                                Ext.Array.each(risk.childNodes, function(child) {
                                    if(child.get('name').toUpperCase().indexOf(contsearch) >= 0) {
                                        groups.push(group);
                                        risks.push(risk);
                                    }
                                });
                            }
                        }
                        else {
                            groups.push(group);
                            risks.push(risk);
                        }
        			}
                    //search on role/tcode/func only
                    else if(chrsearch.length === 0 && namesearch.length === 0 && contsearch.length > 0) {
                        //sod_role2 has different children than other rules (risks)
                         console.log(risk);
                        if(risk.get('rule_type') == 'sod_role2') {
                            Ext.Array.each(risk.childNodes, function(child) {
                                if(child.get('description').toUpperCase().indexOf(contsearch) >= 0) {
                                    groups.push(group);
                                    risks.push(risk);
                                }
                            });
                        }
                        else {
                            Ext.Array.each(risk.childNodes, function(child) {
                                if(child.get('name').toUpperCase().indexOf(contsearch) >= 0) {
                                    groups.push(group);
                                    risks.push(risk);
                                }
                            });
                        }
                    }
        		});
        	}
        });

        this.expandGroups(Ext.Array.unique(groups));

        //delay expansion to give grid time to update the group nodes
        var me = this;
        setTimeout(function() {
            me.expandRisks(risks);
            setTimeout(function() {
                me.afterSearch();
            }, 50*risks.length);
        }, 50*groups.length);

    },

    expandGroups: function(groups) {
        Ext.Array.each(groups, function(group) {
        	group.expand();
        });
    },

    expandRisks: function(risks) {
        Ext.Array.each(risks, function(risk) {
        	risk.expand();
        	if(risks.length == 1) //only one result do select
        		this.getTreegrid().getSelectionModel().doSelect(risk);
        }, this);

    },

    afterSearch: function() {
        this.getTreegrid().suspendLayout = false;
        this.getTreegrid().doLayout();
        this.getTreegrid().setLoading(false);

        this.getSearchGroupCombo().enable();
        this.getSearchNameTrigger().enable();
        this.getSearchContentTrigger().enable();

        this.getSearchRiskIdTrigger().enable();
        this.getSearchRiskIdTrigger().focus();
    }

});
