/*
 * File: app/view/MCReportsPanel.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.view.MCReportsPanel', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.mcreppanel',

	requires: [
		'Ext.form.FieldSet',
		'Ext.grid.Panel',
		'Ext.grid.View',
		'Ext.grid.column.Column',
		'Ext.toolbar.Toolbar',
		'Ext.toolbar.Spacer',
		'Ext.form.field.Trigger',
		'Ext.button.Button',
		'Ext.resizer.Splitter'
	],

	autoRender: true,
	border: false,
	height: 632,
	itemId: 'umReportsPanel',
	minHeight: 450,
	layout: 'fit',
	bodyBorder: false,
	title: 'Reports',

	initComponent: function() {
		var me = this;

		Ext.applyIf(me, {
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						align: 'stretch',
						padding: '3 10 0 10'
					},
					items: [
						{
							xtype: 'container',
							flex: 3,
							margin: '0 5',
							layout: {
								type: 'vbox',
								align: 'stretch'
							},
							items: [
								{
									xtype: 'fieldset',
									flex: 1,
									title: 'Controls',
									layout: {
										type: 'vbox',
										align: 'stretch'
									},
									items: [
										{
											xtype: 'gridpanel',
											flex: 1,
											border: false,
											itemId: 'controlGrid',
											autoScroll: true,
											bodyBorder: false,
											store: 'control',
											viewConfig: {
												itemId: 'controlsGridView'
											},
											columns: [
												{
													xtype: 'gridcolumn',
													cls: 'setLeft',
													width: 50,
													align: 'right',
													dataIndex: 'id',
													text: 'ID'
												},
												{
													xtype: 'gridcolumn',
													dataIndex: 'name',
													text: 'Name',
													flex: 2
												},
												{
													xtype: 'gridcolumn',
													dataIndex: 'group_name',
													text: 'Group',
													flex: 1
												},
												{
													xtype: 'gridcolumn',
													dataIndex: 'executer',
													text: 'Executer'
												},
												{
													xtype: 'gridcolumn',
													dataIndex: 'owner',
													text: 'Approver'
												},
												{
													xtype: 'gridcolumn',
													dataIndex: 'created_by',
													text: 'Created by'
												},
												{
													xtype: 'gridcolumn',
													renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
														Image = '';
														if(value==1){
															var Image = '<a><img src="../../gfx/check.png" data-qtip="Active" border="0"/></a>';
														}
														return Image;
													},
													cls: 'setLeft',
													width: 50,
													align: 'center',
													dataIndex: 'active',
													text: 'Active'
												},
												{
													xtype: 'gridcolumn',
													cls: 'setLeft',
													width: 50,
													align: 'right',
													dataIndex: 'controls',
													text: 'Controls'
												},
												{
													xtype: 'gridcolumn',
													cls: 'setLeft',
													width: 50,
													align: 'right',
													dataIndex: 'done',
													text: 'Done'
												}
											]
										},
										{
											xtype: 'toolbar',
											border: false,
											items: [
												{
													xtype: 'tbspacer',
													flex: 1,
													width: 10
												},
												{
													xtype: 'triggerfield',
													flex: 2,
													itemId: 'controlSearchTriggerField',
													fieldLabel: 'Search',
													labelAlign: 'right',
													labelSeparator: ' ',
													labelWidth: 50,
													triggerCls: 'x-form-search-trigger'
												},
												{
													xtype: 'tbspacer',
													flex: 1,
													width: 10
												}
											]
										}
									]
								},
								{
									xtype: 'fieldset',
									title: 'Actions',
									layout: {
										type: 'hbox',
										align: 'stretch',
										padding: '0 0 5 0'
									},
									items: [
										{
											xtype: 'button',
											disabled: true,
											itemId: 'downloadDefinitionBtn',
											icon: '../../gfx/filetypes/pdf.png',
											scale: 'medium',
											text: 'Download definition as PDF'
										},
										{
											xtype: 'tbspacer',
											width: 10
										},
										{
											xtype: 'button',
											disabled: true,
											itemId: 'downloadControlBtn',
											icon: '../../gfx/filetypes/pdf.png',
											scale: 'medium',
											text: 'Download controls as PDF'
										},
										{
											xtype: 'tbspacer',
											width: 10
										},
										{
											xtype: 'button',
											itemId: 'downloadControlxlsxBtn',
											icon: '../../gfx/filetypes/xlsx.png',
											scale: 'medium',
											text: 'Download all as excel'
										}
									]
								}
							]
						},
						{
							xtype: 'splitter'
						},
						{
							xtype: 'fieldset',
							flex: 1,
							height: 500,
							itemId: 'detailsContainer',
							padding: '0 0 0 10',
							layout: 'fit',
							title: 'Details'
						}
					]
				}
			]
		});

		me.callParent(arguments);
	}

});