/*
 * File: app/controller/control.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.controller.control', {
	extend: 'Ext.app.Controller',

	refs: [
		{
			ref: 'controlSearchTriggerField',
			selector: '#controlSearchTriggerField'
		},
		{
			ref: 'controlGrid',
			selector: '#controlGrid'
		},
		{
			ref: 'downloadDefinitionBtn',
			selector: '#downloadDefinitionBtn'
		},
		{
			ref: 'downloadControlBtn',
			selector: '#downloadControlBtn'
		},
		{
			ref: 'downloadControlxlsxBtn',
			selector: '#downloadControlxlsxBtn'
		},
		{
			ref: 'detailsContainer',
			selector: '#detailsContainer'
		}
	],

	init: function(application) {
		this.control({
			'#controlSearchTriggerField' : {
				specialkey: function(field, e) {
					if (e.getKey() == e.ENTER)
						this.filterControlSearch();
				}
			},
			'#controlGrid':{
				selectionchange:function(component, selection){
					if(selection.length > 0)
						this.selectionChanged(selection[0]);
				}
			},
			'#downloadControlBtn':{
				click: function(btn){
					this.download('control_pdf');
				}
			},
			'#downloadDefinitionBtn':{
				click: function(btn){
					this.download('definition_pdf');
				}
			},
			'#downloadControlxlsxBtn':{
				click: function(btn){
					this.download('control_with_check');
				}
			}
		});
	},

	filterControlSearch: function() {
		var filter = Ext.util.Format.trim(this.getControlSearchTriggerField().getValue());
		this.getControlGrid().getStore().proxy.extraParams.query = filter;
		this.getControlGrid().getStore().load({
			callback: function() {
				this.getControlSearchTriggerField().focus();
			},
			scope: this
		});
	},

	selectionChanged: function(selected) {
		this.showDetails(selected);

		this.getDownloadDefinitionBtn().enable();
		this.getDownloadControlBtn().enable();

	},

	download: function(type) {
		var controlid = 0;
		if(this.getControlGrid().getSelectionModel().selected.getAt(0)){
		var controlid = this.getControlGrid().getSelectionModel().selected.getAt(0).get('id');
		}

		var iframe = document.getElementById("hiddenIFrameCurrent"+controlid);
		if(iframe === null) {
		    iframe = document.createElement('iframe');
		    iframe.id = "hiddenIFrameCurrent"+controlid;
		    iframe.style.display = 'none';
		    document.body.appendChild(iframe);
		}
		iframe.src = '../../service/download.php' + document.location.search + '&type='+type+'&controlid='+controlid;
	},

	showDetails: function(record) {
		var url = "../display_details/display_details.php";

		var params = Ext.Object.fromQueryString(document.location.search);
		params.id = record.get('id');
		params.type = 'control';

		var par = Ext.Object.toQueryString(params);

		this.getDetailsContainer().update('<iframe src="'+url+"?"+par+'" width="100%" height="100%" frameborder="0" style="border-color: white;"></iframe>');

	}

});
