/*
 * File: app/view/MyPanel.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.view.MyPanel', {
	extend: 'Ext.panel.Panel',

	requires: [
		'Ext.grid.Panel',
		'Ext.grid.column.Column',
		'Ext.grid.View',
		'Ext.toolbar.Toolbar',
		'Ext.toolbar.Spacer',
		'Ext.button.Button',
		'Ext.form.field.Checkbox'
	],

	autoRender: true,
	border: false,
	itemId: 'myPanel',
	margin: 0,
	resizable: false,
	bodyBorder: false,
	frameHeader: false,
	header: false,
	title: 'Reports',

	layout: {
		type: 'hbox',
		align: 'stretch'
	},

	initComponent: function() {
		var me = this;

		Ext.applyIf(me, {
			items: [
				{
					xtype: 'gridpanel',
					flex: 1,
					itemId: 'grid',
					overflowY: 'auto',
					header: false,
					title: 'My Grid Panel',
					store: 'restrictions',
					columns: [
						{
							xtype: 'gridcolumn',
							width: 50,
							dataIndex: 'id',
							text: 'ID'
						},
						{
							xtype: 'gridcolumn',
							width: 50,
							dataIndex: 'system',
							text: 'System'
						},
						{
							xtype: 'gridcolumn',
							width: 50,
							dataIndex: 'client',
							text: 'Client'
						},
						{
							xtype: 'gridcolumn',
							dataIndex: 'project',
							text: 'Project'
						},
						{
							xtype: 'gridcolumn',
							dataIndex: 'object_class',
							text: 'Object Class'
						},
						{
							xtype: 'gridcolumn',
							dataIndex: 'object',
							text: 'Object'
						},
						{
							xtype: 'gridcolumn',
							dataIndex: 'field',
							text: 'Field'
						},
						{
							xtype: 'gridcolumn',
							dataIndex: 'value',
							text: 'Value'
						},
						{
							xtype: 'gridcolumn',
							dataIndex: 'comment',
							text: 'Comment',
							flex: 1
						},
						{
							xtype: 'gridcolumn',
							renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
								return '<p style="padding:0;margin:0;line-height:1em;"'+
								' title="'+ record.get('audit_user')+
								' ('+ record.get('audit_system')+'/'+record.get('audit_client')  +')">'+value+'</p>';
							},
							width: 120,
							dataIndex: 'audit_timestamp',
							text: 'Last change'
						},
						{
							xtype: 'gridcolumn',
							renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
								var icon = "light_grey.png";
								var text = CCS.Translator.getText("Unknown");

								switch(value) {
									case 'A':
									icon = "light_green.png";
									text = CCS.Translator.getText("Active");
									break;
									case 'I':
									icon = "light_yellow.png";
									text = CCS.Translator.getText("Inactive");
									break;
									case 'D':
									icon = "light_red.png";
									text = CCS.Translator.getText("Deleted");
									break;
								}

								return '<img src="../../../common/ui/gfx/'+icon+'" title="'+text+'" alt="'+text+'" />';
							},
							cls: 'setLeft',
							width: 50,
							align: 'center',
							dataIndex: 'status',
							text: 'Status'
						}
					],
					dockedItems: [
						{
							xtype: 'toolbar',
							dock: 'bottom',
							items: [
								{
									xtype: 'tbspacer',
									width: 10
								},
								{
									xtype: 'container',
									layout: {
										type: 'hbox',
										align: 'stretch'
									},
									items: [
										{
											xtype: 'button',
											itemId: 'btnCreate',
											padding: 5,
											icon: '../gfx/container_add.png',
											scale: 'medium',
											text: 'Create'
										},
										{
											xtype: 'tbspacer',
											flex: 0.25,
											minWidth: 10
										},
										{
											xtype: 'button',
											disabled: true,
											itemId: 'btnActive',
											padding: 5,
											icon: '../gfx/add.png',
											text: 'Activate'
										},
										{
											xtype: 'tbspacer',
											minWidth: 10
										},
										{
											xtype: 'button',
											disabled: true,
											itemId: 'btnInactive',
											padding: 5,
											icon: '../gfx/remove.png',
											text: 'Deactivate'
										}
									]
								},
								{
									xtype: 'tbspacer',
									flex: 1
								},
								{
									xtype: 'checkboxfield',
									itemId: 'global',
									boxLabel: 'Global'
								},
								{
									xtype: 'tbspacer',
									flex: 0.25
								},
								{
									xtype: 'checkboxfield',
									itemId: 'local',
									boxLabel: 'Client'
								},
								{
									xtype: 'tbspacer',
									flex: 0.25
								},
								{
									xtype: 'checkboxfield',
									itemId: 'project',
									boxLabel: 'Project'
								},
								{
									xtype: 'tbspacer',
									flex: 0.25
								},
								{
									xtype: 'checkboxfield',
									itemId: 'active',
									boxLabel: 'Active',
									checked: true
								},
								{
									xtype: 'tbspacer',
									width: 10
								}
							]
						}
					]
				}
			]
		});

		me.callParent(arguments);
	}

});