/*
 * File: app/controller/Data.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.controller.Data', {
	extend: 'Ext.app.Controller',

	refs: [
		{
			ref: 'grid',
			selector: '#grid'
		},
		{
			ref: 'btnActive',
			selector: '#btnActive'
		},
		{
			ref: 'btnInactive',
			selector: '#btnInactive'
		}
	],

	init: function(application) {
		this.control({
			'#grid':{
				selectionchange: this.selectionchanged
			},
			'#btnActive': {
				click: this.setActive
			},
			'#btnInactive': {
				click: this.setInactive
			}

		});
	},

	selectionchanged: function(component, selection) {
		this.getBtnActive().disable();
		this.getBtnInactive().disable();

		if(selection.length > 0) {
			var selected = selection[0];
			if(selected.get('status') == 'A') {
				this.getBtnInactive().enable();
			}
			else {
				this.getBtnActive().enable();
			}
		}
	},

	setActive: function(btn) {
		btn.blur();
		var selection = this.getGrid().getSelectionModel().getSelection();
		if(selection.length > 0) {
			var record = selection[0];
			record.set('status', 'A');
		}
	},

	setInactive: function(btn) {
		btn.blur();
		var selection = this.getGrid().getSelectionModel().getSelection();

		if(!Ext.isEmpty(selection)) {
			if(selection.length > 0) {
				var record = selection[0];
				record.set('status', 'I');
			}
		}
	}

});
