/*
 * File: app/controller/Content.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('MyApp.controller.Content', {
	extend: 'Ext.app.Controller',

	refs: [
		{
			ref: 'switchGlobal',
			selector: '#global'
		},
		{
			ref: 'switchLocal',
			selector: '#local'
		},
		{
			ref: 'switchProject',
			selector: '#project'
		},
		{
			ref: 'switchActive',
			selector: '#active'
		},
		{
			ref: 'myPanel',
			selector: '#myPanel'
		}
	],

	init: function(application) {
		this.control({
			'#global': {
				change: this.updateData
			},
			'#local': {
				change: this.updateData
			},
			'#project': {
				change: this.updateData
			},
			'#active': {
				change: this.updateData
			}


		});
	},

	onLaunch: function() {
		this.getMyPanel().doLayout();

		this.params = Ext.Object.fromQueryString(document.location.search);
		this.params.active = true; //always start with only active restrictions

		if(Ext.isEmpty(this.params.projectName)) {
			this.getSwitchProject().hide();
			var store = Ext.StoreManager.lookup('Scopes');
			store.remove(store.getById(3));
		}

		this.getSwitchGlobal().setValue(this.params.global);
		this.getSwitchLocal().setValue(this.params.local);
		this.getSwitchProject().setValue(this.params.project);


	},

	updateData: function(component, newValue, oldValue) {
		this.params[component.itemId] = newValue;

		MyApp.app.getStore('restrictions').load();

	}

});
