Ext.define("MyApp.Application",{name:"MyApp",extend:Ext.app.Application,views:[],controllers:[],stores:[]});Ext.define("MyApp.view.StatusWindow",{extend:Ext.window.Window,alias:"widget.StatusWindow",height:402,itemId:"statusWindow",width:300,resizable:false,layout:"fit",title:"Background processing status",initComponent:function(){var a=this;a.callParent(arguments)}});Ext.define("MyApp.controller.BackgroundStatus",{extend:Ext.app.Controller,refs:[{ref:"grid",selector:"#reportHistoryGridPanel"},{ref:"status",selector:"#btnStatus"},{autoCreate:true,ref:"statusWindow",selector:"#statusWindow",xtype:"StatusWindow"}],init:function(a){this.control({"#btnStatus":{click:function(b,d,c){this.showStatusWindow(b)}},"#btnRefresh":{click:function(b,d,c){this.getGrid().getStore().reload()}}})},showStatusWindow:function(b){this.getStatusWindow().animateTarget=b;this.getStatusWindow().showBy(b,"c-c?");var a="../../../common/ui/reportStatus/reportStatus.php";var c=Ext.Object.fromQueryString(document.location.search);this.getStatusWindow().update('<iframe src="'+a+"?"+Ext.Object.toQueryString(c)+'" width="100%" height="100%" frameborder="0" style="border-color: white;"></iframe>')}});Ext.define("MyApp.model.ReportHistory",{extend:Ext.data.Model,fields:[{name:"id",type:"int"},{name:"created"},{name:"status"},{name:"duration",type:"int"},{name:"available",type:"int"},{name:"taskStatus",type:"int"},{name:"free",type:"int"},{name:"fav"},{name:"name"},{convert:function(a,b){return Ext.util.Format.htmlEncode(b.get("name"))},name:"nameEnc",persist:false},{name:"filetype"},{name:"time"},{name:"filesize"}]});Ext.define("MyApp.store.ReportHistoryStore",{extend:Ext.data.Store,constructor:function(a){var b=this;a=a||{};b.callParent([Ext.apply({model:"MyApp.model.ReportHistory",storeId:"ReportHistoryStore",pageSize:50,proxy:{type:"rest",url:"../../../common/service/report_history.php",reader:{type:"json",root:"result"}},listeners:{beforeload:{fn:b.onJsonstoreBeforeLoad,scope:b},update:{fn:b.onJsonstoreUpdate,scope:b},load:{fn:b.onJsonstoreLoad,scope:b}}},a)])},onJsonstoreBeforeLoad:function(b,a,c){if(b.proxy.extraParams.method!=="advanced"){b.proxy.extraParams.method="simple"}var e=MyApp.getApplication().getParams();e.reportType=13;var d=b.proxy.extraParams;b.proxy.extraParams=Ext.Object.merge(e,d)},onJsonstoreUpdate:function(c,a,b,e,d){if(e){Ext.Array.forEach(e,function(h,f,g){if(h=="name"||h=="fav"){if(h=="name"&&a.get("fav")=="T"){if(a.get("name")!==""){c.sync()}else{a.set("name",a.get("nameEnc"));Ext.Msg.alert("Warning!","You can not change favourite name to empty.",Ext.emptyFn)}}else{c.sync()}}},this)}},onJsonstoreLoad:function(b,a,e,d){for(var c=0;c<a.length;c++){if(a[c].get("taskStatus")<=1){MyApp.app.getController("ReportsController").getReportWatcher().addReport(a[c].get("id"))}}},updateRecord:function(a){var b=[];var c=this.getById(a.id);if(c&&c.getId()==a.id){Ext.Array.forEach(c.fields.keys,function(e,d,f){if(c.get(e)!=a[e]){c.set(e,a[e]);b.push(e)}},this)}c.commit(false,b)},toggleReportFav:function(c){var d=this.getById(c);if(d&&d.getId()==c&&d.get("name")!==""){var a=d.get("fav");var b=a=="F"?"T":"F";d.set("fav",b)}},deleteReport:function(a){var b=this.getById(a);if(b.get("fav")!=="T"){this.remove(b);this.sync()}}});Ext.define("MyApp.store.Favorites",{extend:Ext.data.Store,constructor:function(a){var b=this;a=a||{};b.callParent([Ext.apply({sortRoot:"name",model:"MyApp.model.ReportHistory",storeId:"Favorites",proxy:{type:"memory"}},a)])}});Ext.define("MyApp.controller.FavoriteHistorySync",{extend:Ext.app.Controller,models:["ReportHistory"],stores:["ReportHistoryStore","Favorites"],init:function(a){var c=this.getReportHistoryStoreStore();var b=this.getFavoritesStore();c.on("add",function(e,d,f,g){this.addRecords(d)},this);c.on("load",function(e,d,g,f){b.removeAll();this.addRecords(d)},this);c.on("bulkremove",function(f,e,g,d,h){b.remove(e)});c.on("update",function(f,d,e,h,g){if(Ext.Array.contains(h,"fav")){if(d.get("fav")=="T"){this.addRecords([d])}else{b.remove([d])}}else{if(Ext.Array.contains(h,"name")){}}},this)},addRecords:function(a){var b=this.getFavoritesStore();Ext.Array.forEach(a,function(c){if(c.get("fav")=="T"){b.add(c)}},this);b.sort()}});Ext.define("MyApp.controller.GUI",{extend:Ext.app.Controller,refs:[{ref:"availableReports",selector:"#availableReports"},{ref:"availableReportsOptions",selector:"#availableReportsOptions"},{ref:"projectGrid",selector:"#projectGrid"},{ref:"exportToExcelBtn",selector:"#exportToExcelBtn"},{ref:"form",selector:"#form"},{ref:"myPanel",selector:"#umReportsPanel"},{ref:"outputFormat",selector:"#outputFormat"},{ref:"languageCombo",selector:"#languageCombo"},{ref:"triggerSearch",selector:"#triggerSearch"},{ref:"projectListLocalCheckBox",selector:"#projectListLocalCheckBox"},{ref:"projectListOpenCheckBox",selector:"#projectListOpenCheckBox"},{ref:"projectGridPaging",selector:"#projectGridPaging"},{ref:"reportHistoryGridPaging",selector:"#reportHistoryGridPaging"},{ref:"reportHistoryGridPanel",selector:"#reportHistoryGridPanel"}],onLaunch:function(){Ext.getStore("AvailableReports").load({callback:this.setupAvailableReports,scope:this})},setStartOptions:function(){var c=Ext.Object.fromQueryString(document.location.search);var d=c.language.toLowerCase();if(this.getLanguageCombo().getStore().getById(d)===null){d="en"}var b={language:d,outputFormat:1};this.getForm().getForm().setValues(b);var a=this;this.getTriggerSearch().onTriggerClick=function(e){a.search()};this.search();this.getTriggerSearch().focus()},init:function(a){this.control({"#availableReports":{change:function(f,d,b,c){this.changeAvailableReports(d.availableReport);this.selectionHasChanged()}},"#projectGrid":{selectionchange:function(b,d,c){this.selectionHasChanged()}},"#reportOnScreenBtn":{click:this.clickOnScreen},"#exportToExcelBtn":{click:function(){}},"#triggerSearch":{specialkey:function(c,b){if(b.getKey()==b.ENTER){this.search()}}},"#projectListOpenCheckBox":{change:function(d,c,b){if(c){this.getProjectGrid().getStore().getProxy().extraParams.openOnly=c}else{delete this.getProjectGrid().getStore().getProxy().extraParams.openOnly}this.search()}},"#projectListLocalCheckBox":{change:function(d,c,b){this.search()}},"#projectGridPaging":{specialkey:function(c,b){if(b.getKey()==b.ENTER){this.search()}},select:function(){this.search()}},"#reportHistoryGridPaging":{specialkey:function(c,b){},select:function(){console.log(this.getReportHistoryGridPaging().getValue());this.getReportHistoryGridPanel().getStore().pageSize=this.getReportHistoryGridPaging().getValue();this.getReportHistoryGridPanel().getStore().load()}}})},setupAvailableReports:function(){var c=Ext.getStore("AvailableReports").data.items;var a=[];for(i=0;i<c.length;i++){var b=Ext.create("Ext.form.field.Radio",{name:"availableReport",boxLabel:c[i].raw.name,inputValue:c[i].raw.id,margins:"0 0 0 10"});a.push(b)}var b=Ext.create("Ext.form.field.Radio",{name:"availableReport",boxLabel:"hidden for reset",inputValue:c.length,hidden:true});a.push(b);this.getAvailableReports().add(a);this.getMyPanel().doLayout()},changeAvailableReports:function(c){this.clearExtraOptions();var a=Ext.getStore("AvailableReports").getById(c);if(!Ext.isEmpty(a)){var b=a.raw.selections;if(!Ext.isEmpty(b)){for(i=0;i<b.length;i++){switch(b[i].type){case"checkbox":this.addCheckBoxAvailableReports(b[i]);break;default:}}}}},addCheckBoxAvailableReports:function(a){var b=Ext.create("Ext.form.field.Checkbox",{fieldLabel:a.name,name:a.name,boxLabel:a.description,formBind:true,inputValue:"X",margins:"0 0 0 10",labelSeparator:" "});this.getAvailableReportsOptions().add(b)},clearExtraOptions:function(){var a=this.getAvailableReportsOptions();a.items.each(function(d,c,b){this.remove(d,true)},a)},selectionHasChanged:function(){this.getExportToExcelBtn().disable();var b=this.getAvailableReports().getValue();var a=this.getProjectGrid().getSelectionModel().selected;if(b.availableReport!==undefined&&b.availableReport==7){if(a.length>0){this.getProjectGrid().getSelectionModel().deselectAll()}this.getProjectGrid().disable();this.getExportToExcelBtn().enable()}else{this.getProjectGrid().enable()}if(b.availableReport!==undefined&&a.length>0&&b.availableReport!=7){this.getExportToExcelBtn().enable()}},clickOnScreen:function(){var h="On screen report";this.win=Ext.create("Ext.panel.Panel",{title:h,height:this.getMyPanel().getHeight()*0.9,width:this.getMyPanel().getWidth()*0.9,layout:"fit",modal:false,constrain:true,floating:true,closable:true,draggable:true,resizable:true}).showBy(this.getMyPanel(),"c-c?");this.win.setLoading(CCS.Translator.getText("Loading..."));var f=this.getForm().getForm();var b=f.getValues();var d=[];var e=this.getProjectGrid().getSelectionModel().selected.items;for(i=0;i<e.length;i++){d.push(e[i].raw.proj_name)}var a="Project[]";b[a]=d;b.id=b.availableReport;delete b.availableReport;b.format="JSON";var g=MyApp.app.getApplication().getParams();b.system=g.system;b.client=g.client;b.onScreen=true;var c=Ext.JSON.encode(b);Ext.Ajax.request({url:"../../service/report_submit.php",method:"POST",params:g,jsonData:c,success:function(l,m){var n=l.responseText;if(n.length>0){var k=Ext.JSON.decode(n);var j=k.id;this.watchOnScreenReport(j)}else{this.win.setLoading(false)}},failure:function(j,k){this.win.setLoading(false);var l=j.responseText;Ext.Error.raise({msg:"Failed to initiate report generation",option:l,object:k})},scope:this})},setupOnScreen:function(g){var e=[];var d=[];var c=[];for(var f in g.fields){e.push({xtype:"gridcolumn",dataIndex:f,text:g.fields[f],sortable:false,flex:1,minWidth:100,renderer:function(l,k,j,h){if(!isNaN(l)){k.align="right"}if(k.record.get("summary")){k.style="color: white; background-color: #001426; font-weight: bold; "}return l}});d.push(f);c.push({name:f,type:"string"})}c.push({name:"summary",type:"boolean"});Ext.define("ReportData",{extend:Ext.data.Model,fields:c});var b=Ext.create("Ext.data.JsonStore",{model:"ReportData",fields:d,data:g.rows});var a=Ext.create("Ext.grid.Panel",{background:false,border:false,theme:"Browser",scroll:"both",itemId:"reportGrid",margin:2,frameHeader:false,titleAlign:"center",titleCollapse:false,disableSelection:true,store:b,columns:e,viewConfig:{disableSelection:true}});this.win.add(a);this.win.doLayout();this.win.setLoading(false)},getOnScreenReport:function(b){var a={id:b};Ext.Ajax.request({url:"../../service/reports_content.php",method:"POST",params:a,success:function(c,d){var e=Ext.decode(c.responseText);this.setupOnScreen(e)},failure:function(c,d){this.win.setLoading(false);var e=c.responseText;Ext.Error.raise({msg:"Failed to get a reponse",option:e,object:d})},scope:this})},watchOnScreenReport:function(b){var a=b;var c=Ext.JSON.encode(a);var d=MyApp.app.getApplication().getParams();d.reportType=13;Ext.Ajax.request({url:"../../../common/service/report_watch.php",method:"POST",params:d,jsonData:c,success:function(g,h){var k=g.responseText;var f=Ext.JSON.decode(k);var e=f[0];if(e.taskStatus>1){this.getOnScreenReport(e.id)}else{var j=this;setTimeout(function(){j.watchOnScreenReport(b)},750)}},failure:function(e,f){var g=e.responseText;Ext.Error.raise({msg:"Failed watching reports",option:g,object:f})},scope:this})},getProjectSearchParams:function(){var a=MyApp.app.getApplication().getParams();a.searchString=this.getTriggerSearch().getValue();return a},search:function(){this.getTriggerSearch().disable();var b=this.getProjectGrid().getStore();var a=parseInt(this.getProjectGridPaging().getValue(),10);b.pageSize=a;b.getProxy().extraParams.method="simple";b.getProxy().extraParams.filter=this.getTriggerSearch().getValue();b.getProxy().extraParams.local=this.getProjectListLocalCheckBox().getValue();b.load({callback:function(){this.getTriggerSearch().enable();this.getTriggerSearch().focus()},scope:this})},getDownloadtext:function(a){if(a.filetype=="xlsx"){if(a.taskStatus==2){return CCS.Translator.getText("Download as Excel")+"<br/>"+a.filesize}if(a.taskStatus==3){return CCS.Translator.getText("Download as Excel (partial)")+"<br/>"+a.filesize}}if(a.filetype=="csv"){if(a.taskStatus==2){return CCS.Translator.getText("Download as CSV")+"<br/>"+a.filesize}if(a.taskStatus==3){return CCS.Translator.getText("Download as CSV (partial)")+"<br/>"+a.filesize}}if(a.filetype=="zip"){if(a.taskStatus==2){return CCS.Translator.getText("Download CSV as zip")+"<br/>"+a.filesize}if(a.taskStatus==3){return CCS.Translator.getText("Download CSV as zip (partial)")+"<br/>"+a.filesize}}}});Ext.define("MyApp.controller.Main",{extend:Ext.app.Controller});Ext.define("MyApp.controller.ReportWatcher",{extend:Ext.Base,init:function(a){this._store=a;this.watchList=[]},getStore:function(){return this._store},getTask:function(){if(!this._task){this._task=new Ext.util.DelayedTask(this.checkReports,this)}return this._task},checkReports:function(){var a=this.watchList.join(",");var b=Ext.JSON.encode(a);var c=MyApp.app.getApplication().getParams();c.reportType=13;Ext.Ajax.request({url:"../../../common/service/report_watch.php",method:"POST",params:c,jsonData:b,success:function(f,g){var h=f.responseText;var e=Ext.JSON.decode(h);var d=MyApp.app.getApplication().getReportHistoryStoreStore();Ext.Array.forEach(e,function(j,k,l){d.updateRecord(j);if(j.taskStatus>1){this.removeReport(j.id)}},this);this.trigger(5000)},failure:function(d,e){var f=d.responseText;Ext.Error.raise({msg:"Failed watching reports",option:f,object:e})},scope:this})},addReport:function(a){this.watchList.push(a);this.trigger(3000)},removeReport:function(c){var b=[];for(var a=0;a<this.watchList.length;a++){if(this.watchList[a]!=c){b.push(this.watchList[a])}}this.watchList=b},trigger:function(a){if(this.watchList.length>0){this.getTask().delay(a)}}});Ext.define("MyApp.controller.ReportsController",{extend:Ext.app.Controller,stores:["ReportHistoryStore"],refs:[{ref:"form",selector:"#form"},{ref:"projectGrid",selector:"#projectGrid"},{ref:"reportHistoryGridPanel",selector:"#reportHistoryGridPanel"}],init:function(a){this.control({"#umReportsPanel":{afterrender:this.onUMReportsPanelRendered,generateReport:this.onGenerateReport},"#copyFavCombo":{select:function(d,b,c){if(b&&b[0]){this.getReportParameters(b[0].get("id"));d.clearValue()}}},"#exportToExcelBtn":{click:this.onGenerateReport}})},onUMReportsPanelRendered:function(){this.getReportHistoryStoreStore().load()},onGenerateReport:function(){var e=this.getForm().getForm();var b=e.getValues();b.projects=[];var d=this.getProjectGrid().getSelectionModel().selected.items;for(i=0;i<d.length;i++){b.projects.push(d[i].raw.proj_name)}var a="Project[]";b[a]=b.projects;if(b.Description===undefined){b.Description=""}if(b.Comments===undefined){b.Comments=""}b.id=b.availableReport;delete b.availableReport;b.format="JSON";var g=MyApp.app.getApplication().getParams();b.system=g.system;b.client=g.client;b=Ext.Object.merge(g,b);var c=Ext.JSON.encode(b);var f=this.getForm();f.setLoading(CCS.Translator.getText("Submitting report..."));Ext.Ajax.request({url:"../../service/report_submit.php",method:"POST",params:g,jsonData:c,success:function(k,l){var m=k.responseText;var j=Ext.JSON.decode(m);var h=MyApp.app.getApplication().getReportHistoryStoreStore();h.insert(0,j);f.setLoading(false);this.getReportWatcher().addReport(j.id);MyApp.app.message(CCS.Translator.getText("Report submitted"),CCS.Translator.getText("Result is displayed in report history list"))},failure:function(h,j){f.setLoading(false);var k=h.responseText;Ext.Error.raise({msg:"Failed to initiate report generation",option:k,object:j})},scope:this})},getReportWatcher:function(){if(!this.reportWatcher){this.reportWatcher=MyApp.controller.ReportWatcher.create();this.reportWatcher.init(this.getReportHistoryStoreStore())}return this.reportWatcher},getReportParameters:function(a){this.getForm().setLoading(CCS.Translator.getText("Getting parameters..."));var b=MyApp.app.getApplication().getParams();MyApp.app.getController("GUI").clearExtraOptions();this.getForm().getForm().findField("availableReport").setValue(Ext.getStore("AvailableReports").data.items.length);this.getProjectGrid().getSelectionModel().deselectAll();Ext.Ajax.request({url:"../../service/report_params.php?id="+a,method:"GET",params:b,success:function(d,e){var f=d.responseText;var c=Ext.JSON.decode(f);c.availableReport=c.id;delete c.id;this.getForm().getForm().findField("availableReport").setValue(c.availableReport);this.checkProjectsArePresent(c["Project[]"]);this.getForm().getForm().setValues(c)},failure:function(c,d){var e=c.responseText;Ext.Error.raise({msg:"Failed to get report parameters",option:e,object:d})},scope:this})},checkProjectsArePresent:function(b){var d=true;var a=[];for(i=0;i<b.length;i++){var c=false;this.getProjectGrid().getStore().data.each(function(e){if(b[i]==e.get("proj_name")){c=true}},this);if(!c){d=false;a.push(b[i])}}if(d){this.setProjectSelection(b)}else{this.getMissingProjects(a,b)}},getMissingProjects:function(b,a){var c=MyApp.app.getApplication().getParams();c.projects=Ext.JSON.encode(b);Ext.Ajax.request({url:"../../service/reports_projects.php",method:"GET",params:c,success:function(e,f){var h=e.responseText;var d=Ext.JSON.decode(h);var g=d.result;Ext.Array.each(g,function(j){this.getProjectGrid().getStore().add(j)},this);this.setProjectSelection(a)},failure:function(d,e){var f=d.responseText;Ext.Error.raise({msg:"Failed to get report parameters",option:f,object:e})},scope:this})},setProjectSelection:function(a){this.getProjectGrid().getStore().data.each(function(b){for(i=0;i<a.length;i++){if(a[i]==b.get("proj_name")){this.getProjectGrid().getSelectionModel().doSelect(b,true)}}},this);this.getForm().setLoading(false);MyApp.app.message(CCS.Translator.getText("Report parameters copied"),CCS.Translator.getText("Adjust selections as required before generating a new report"))},restartReport:function(a){var b=MyApp.app.getApplication().getParams();Ext.Ajax.request({url:"../../service/report_submit.php?force="+a,method:"GET",params:b,success:function(e,f){if(a>0){this.getReportWatcher().addReport(a);var g=e.responseText;var c=Ext.JSON.decode(g);var d=MyApp.app.getApplication().getReportHistoryStoreStore();MyApp.app.message("Report restarted","Result is displayed in report history list");d.updateRecord(c)}},failure:function(c,d){var e=c.responseText;Ext.Error.raise({msg:"Failed to restart report generation",option:e,object:d})},scope:this})},showHelperPanel:function(c,g,k,h,d){if(this.popupWindow&&this.popupWindow.getEl()){this.closeHelperPanel();return}var b={floating:true,width:g.getBox().width-g.labelWidth-5,x_idProperty:k.idProperty};this.popupWindow=Ext.create("MyApp.view.SelectionPanel",b);var a=this.popupWindow.down("#grid");a.reconfigure(k.store,k.columns);this.popupWindow.down("#selectGrid").reconfigure(k.selectStore,k.selectColumns);var e=this.popupWindow.down("#numRows");var f=function(){e.setValue(h.getTotalCount())};h.on("load",f,this);f();this.popupWindow.showBy(g,"tl-bl?",[g.labelWidth+g.labelPad,-1]);c.setIcon("../gfx/tool-up.gif");this.firstClickTarget=d;this.activeButton=c;Ext.getBody().on("click",this.onBodyClick,this);if(h.count()===0){h.load()}var j=this.popupWindow.down("#searchField");if(h.mySearch){j.setValue(h.mySearch)}},onBodyClick:function(d,a){if(this.firstClickTarget==a){return}else{if(this.popupWindow){var c=this.popupWindow.getEl();var b=this.activeButton.getEl();if(c&&!(c.dom===a||c.contains(a))){this.closeHelperPanel()}}Ext.getBody().un("click",this.closeWindow)}},closeHelperPanel:function(){if(this.popupWindow&&this.popupWindow.getEl()){this.popupWindow.close();this.activeButton.setIcon("../gfx/tool-down.gif");delete this.popupWindow}},updateSelectionFieldFromStore:function(d,a,c){var b=[];Ext.Array.forEach(a.getRange(),function(e){b.push(e.get(c))});d.setValue(b.join(", "))},updateStoreFromSelectionField:function(a,e,b){var d=e.getValue().toUpperCase();var c=d.replace(","," ").split(/[\s,]+/);a.suspendEvents(false);a.removeAll();Ext.Array.forEach(c,function(f){f=Ext.String.trim(f);if(f.length>0){var h={};h[b]=f;var g=a.model.create(h);a.add(g)}});a.resumeEvents();this.updateSelectionFieldFromStore(e,a,b)},shutdown:function(){this.closeHelperPanel()},pasteClipboard:function(){var c=window.clipboardData.getData("Text");if(c){var a=c.split(/\r\n|\r|\n/g).reverse();var b=this.getSelectGrid().getStore();Ext.Array.forEach(a,function(d){var f=d.replace(/^\s+|\s+$/g,"").toUpperCase();if(f.length>0&&!b.getById(f)){var e=b.model.create();e.setId(f);b.insert(0,e)}});b.commitChanges()}},cancelReport:function(c){if(c>0){var a=MyApp.app.getApplication().getParams();var b={command:"cancel",taskId:c};Ext.Object.merge(a,b);this.getReportHistoryGridPanel().setLoading(CCS.Translator.getText("Loading..."));MyApp.app.message(CCS.Translator.getText("Cancel report"),CCS.Translator.getText("Report is being cancelled!"));Ext.Ajax.request({url:"../../service/report_background_status.php",method:"GET",params:a,success:function(d,e){this.getReportHistoryGridPanel().setLoading(false);this.getReportWatcher().removeReport(c);this.getReportHistoryGridPanel().getStore().load()},failure:function(d,e){this.getStatusFormPanel().setLoading(false);var f=d.responseText;Ext.Error.raise({msg:"Failed to refresh background processing status",option:f,object:e})},scope:this})}}});Ext.define("MyApp.controller.ReportsHistory",{extend:Ext.app.Controller,refs:[{ref:"historyToolbar",selector:"#historyToolbar"},{ref:"reportHistoryGridPanel",selector:"#reportHistoryGridPanel"}],onLaunch:function(){var a=Ext.create("Ext.panel.Tool",{itemId:"btnStatus",tooltip:"Background processing status",type:"gear"});this.getHistoryToolbar().add(a)}});Ext.define("MyApp.controller.SearchController",{extend:Ext.app.Controller,refs:[{ref:"advSearchFieldset",selector:"#advSearchFieldset"},{ref:"resetAdvBtn",selector:"#resetAdvBtn"},{ref:"searchAdvBtn",selector:"#searchAdvBtn"},{ref:"advProjectField",selector:"#advProjectField"},{ref:"advCreateByField",selector:"#advCreateByField"},{ref:"advStatusField",selector:"#advStatusField"},{ref:"advSystemField",selector:"#advSystemField"},{ref:"advClientField",selector:"#advClientField"},{ref:"simpleSearchContainer",selector:"#simpleSearchContainer"},{ref:"projectGridPaging",selector:"#projectGridPaging"},{ref:"projectGrid",selector:"#projectGrid"},{ref:"triggerSearch",selector:"#triggerSearch"}],init:function(a){this.control({"#advSearchFieldset":{collapse:function(){this.toggleAdvancedPanel(false)},expand:function(){this.toggleAdvancedPanel(true)}},"#resetAdvBtn":{click:function(){this.resetAdvFields()}},"#searchAdvBtn":{click:function(){this.advSearch()}}});this.control({"#advProjectField":{change:function(b,d,c){this.checkAdvFields()},specialkey:function(c,b){if(b.getKey()==b.ENTER){if(this.checkAdvFields()){this.advSearch()}}}},"#advCreateByField":{change:function(b,d,c){this.checkAdvFields()},specialkey:function(c,b){if(b.getKey()==b.ENTER){if(this.checkAdvFields()){this.advSearch()}}}},"#advStatusField":{change:function(b,d,c){this.checkAdvFields()},specialkey:function(c,b){if(b.getKey()==b.ENTER){if(this.checkAdvFields()){this.advSearch()}}}},"#advSystemField":{change:function(b,d,c){this.checkAdvFields()},specialkey:function(c,b){if(b.getKey()==b.ENTER){if(this.checkAdvFields()){this.advSearch()}}}},"#advClientField":{change:function(b,d,c){this.checkAdvFields()},specialkey:function(c,b){if(b.getKey()==b.ENTER){if(this.checkAdvFields()){this.advSearch()}}}}})},toggleAdvancedPanel:function(a){if(a){this.getSimpleSearchContainer().disable();this.checkAdvFields();this.getAdvProjectField().focus()}else{this.getSimpleSearchContainer().enable();this.getTriggerSearch().focus()}},checkAdvFields:function(){var c=false;var d=this.getAdvProjectField().getValue();var b=this.getAdvCreateByField().getValue();var a=this.getAdvStatusField().getValue();var e=this.getAdvSystemField().getValue();var f=this.getAdvClientField().getValue();if(!Ext.isEmpty(d)||!Ext.isEmpty(b)||!Ext.isEmpty(e)||!Ext.isEmpty(f)||(a===CCS.Translator.getText("Open")||a===CCS.Translator.getText("Closed")||a===CCS.Translator.getText("Overdue")||a===CCS.Translator.getText("Any"))){this.getResetAdvBtn().enable();this.getSearchAdvBtn().enable();c=true}else{this.getResetAdvBtn().disable();this.getSearchAdvBtn().disable()}return c},resetAdvFields:function(){this.getAdvProjectField().setValue("");this.getAdvCreateByField().setValue("");this.getAdvStatusField().setValue(CCS.Translator.getText("Any"));this.getAdvSystemField().setValue("");this.getAdvClientField().setValue("");this.getResetAdvBtn().disable();this.getSearchAdvBtn().disable();MyApp.app.getController("GUI").search()},advSearch:function(){var e=this;this.getAdvSearchFieldset().disable();var f=parseInt(this.getProjectGridPaging().getValue(),10);var a=this.getProjectGrid().getStore();a.pageSize=f;a.proxy.extraParams.method="advanced";var d=this.getAdvProjectField().getValue();var g=this.getAdvCreateByField().getValue();var b=c();var j=this.getAdvSystemField().getValue();var h=this.getAdvClientField().getValue();a.proxy.extraParams.project=d;a.proxy.extraParams.createdBy=g;a.proxy.extraParams.status=b;a.proxy.extraParams.sys=j;a.proxy.extraParams.cli=h;a.load({callback:function(){this.getAdvSearchFieldset().enable()},scope:this});function c(){var k;switch(e.getAdvStatusField().getValue()){case CCS.Translator.getText("Any"):break;case CCS.Translator.getText("Open"):k=0;break;case CCS.Translator.getText("Closed"):k=1;break;case CCS.Translator.getText("Overdue"):k=2;break;default:break}return k}}});Ext.define("MyApp.controller.SearchController2",{extend:Ext.app.Controller,refs:[{ref:"reportHistoryGridPanel",selector:"#reportHistoryGridPanel"},{ref:"adv2NameField",selector:"#adv2NameField"},{ref:"adv2DateField",selector:"#adv2DateField"},{ref:"adv2StatusField",selector:"#adv2StatusField"},{ref:"resetAdv2Btn",selector:"#resetAdv2Btn"},{ref:"searchAdv2Btn",selector:"#searchAdv2Btn"},{ref:"reportHistoryGridPaging",selector:"#reportHistoryGridPaging"},{ref:"advanced2Fieldset",selector:"#advanced2Fieldset"}],init:function(a){this.control({"#advanced2Fieldset":{collapse:function(){this.toggleAdvanced2Panel(false)},expand:function(){this.toggleAdvanced2Panel(true)}},"#resetAdv2Btn":{click:function(){this.resetAdv2Fields()}},"#searchAdv2Btn":{click:function(){this.adv2Search()}}});this.control({"#adv2NameField":{change:function(b,d,c){this.checkAdv2Fields()},specialkey:function(c,b){if(b.getKey()==b.ENTER){}}},"#adv2DateField":{change:function(b,d,c){this.checkAdv2Fields()},specialkey:function(c,b){if(b.getKey()==b.ENTER){}}},"#adv2StatusField":{change:function(b,d,c){this.checkAdv2Fields()},specialkey:function(c,b){if(b.getKey()==b.ENTER){}}}})},toggleAdvanced2Panel:function(a){if(a){this.getResetAdv2Btn().disable();this.getSearchAdv2Btn().disable()}else{}},checkAdv2Fields:function(){var c=true;var d=this.getAdv2NameField().getValue();var a=this.getAdv2DateField().getValue();var b=this.getAdv2StatusField().getValue();if(!Ext.isEmpty(d)||!Ext.isEmpty(a)||!Ext.isEmpty(b)){this.getResetAdv2Btn().enable();this.getSearchAdv2Btn().enable();c=false}else{this.getResetAdv2Btn().disable();this.getSearchAdv2Btn().disable();c=true}return c},resetAdv2Fields:function(){this.getAdv2NameField().setValue("");this.getAdv2DateField().setValue("");this.getAdv2StatusField().setValue("");this.getResetAdv2Btn().disable();this.getSearchAdv2Btn().disable()},adv2Search:function(){var e=this;this.getAdvanced2Fieldset().disable();var a=parseInt(this.getReportHistoryGridPaging().getValue(),10);var d=this.getReportHistoryGridPanel().getStore();d.pageSize=a;d.proxy.extraParams.method="advanced";var g=this.getAdv2NameField().getValue();var b=this.getAdv2DateField().getValue();var c=this.getAdv2StatusField().getValue();d.proxy.extraParams.advName=g;d.proxy.extraParams.advDate=b;d.proxy.extraParams.advStatus=c;d.load({callback:function(){this.getAdvanced2Fieldset().enable()},scope:this});function f(){var h;switch(e.getAdv2StatusField().getValue()){case CCS.Translator.getText("Any"):break;case CCS.Translator.getText("Open"):h=2;break;case CCS.Translator.getText("Closed"):h=1;break;case CCS.Translator.getText("Overdue"):h=0;break;default:break}return h}}});Ext.define("MyApp.model.AvailableReport",{extend:Ext.data.Model,fields:[{name:"id"},{name:"name"},{name:"description"},{name:"group"},{name:"type"},{name:"selections"},{name:"query"},{name:"groupQuery"}]});Ext.define("MyApp.model.IdTextUsage",{extend:Ext.data.Model,fields:[{name:"id"},{name:"text"},{name:"usage"}]});Ext.define("MyApp.model.Language",{extend:Ext.data.Model,idProperty:"code",fields:[{name:"code"},{name:"title"},{name:"icon"}]});Ext.define("MyApp.model.ProjectsModel",{extend:Ext.data.Model,idProperty:"proj_name",fields:[{name:"auth_group"},{name:"client"},{name:"create_date"},{name:"create_user"},{name:"end_date"},{name:"fast"},{name:"proj_name"},{name:"start_date"},{name:"status"},{name:"system"},{name:"task"},{name:"text"},{name:"objects"},{name:"new_project",type:"boolean"},{name:"end_date_expired"}]});Ext.define("MyApp.store.AvailableReports",{extend:Ext.data.Store,constructor:function(a){var b=this;a=a||{};b.callParent([Ext.apply({model:"MyApp.model.AvailableReport",storeId:"AvailableReports",proxy:{type:"ajax",url:"../../service/reports_available_reports.php",reader:{type:"array",root:"result"}}},a)])}});Ext.define("MyApp.store.LanguageStore",{extend:Ext.data.Store,constructor:function(a){var b=this;a=a||{};b.callParent([Ext.apply({autoLoad:true,model:"MyApp.model.Language",storeId:"LanguageStore",proxy:{type:"ajax",url:"../../../common/service/languages_get_available.php",reader:{type:"json"}},listeners:{load:{fn:b.onArraystoreLoad,scope:b}}},a)])},onArraystoreLoad:function(b,a,d,c){MyApp.app.getController("GUI").setStartOptions()}});Ext.define("MyApp.store.ProjectsJsonStore",{extend:Ext.data.Store,constructor:function(a){var b=this;a=a||{};b.callParent([Ext.apply({autoLoad:false,model:"MyApp.model.ProjectsModel",remoteFilter:true,storeId:"ProjectsJsonStore",leadingBufferZone:50,pageSize:50,proxy:{type:"ajax",url:"../../service/Projects_projectlist.php",reader:{type:"json",root:"result"}},listeners:{beforeload:{fn:b.onJsonstoreBeforeLoad,scope:b}}},a)])},onJsonstoreBeforeLoad:function(b,a,c){var e=Ext.Object.fromQueryString(document.location.search);var d=b.proxy.extraParams;b.proxy.extraParams=Ext.Object.merge(e,d)}});Ext.define("MyApp.view.Main",{extend:Ext.container.Container,xtype:"app-main",layout:{type:"border"},items:[{region:"west",xtype:"panel",title:"west",width:150},{region:"center",xtype:"tabpanel",items:[{title:"Center Tab 1"}]}]});Ext.define("MyApp.view.MyPanel",{extend:Ext.panel.Panel,autoRender:true,border:false,itemId:"umReportsPanel",resizable:false,bodyBorder:false,frameHeader:false,header:false,title:"Reports",layout:{type:"hbox",align:"stretch"},initComponent:function(){var a=this;Ext.applyIf(a,{items:[{xtype:"container",flex:1,width:400,layout:"fit",items:[{xtype:"form",border:false,itemId:"form",margin:0,layout:"fit",bodyPadding:"5 0 7 12",header:false,title:"Report Selections",items:[{xtype:"fieldset",margin:"0 0 5 0",padding:"3 10 10 10",overflowY:"auto",title:"Report criteria",layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",layout:{type:"hbox",align:"stretch",padding:"0 0 5 0"},items:[{xtype:"textfield",flex:1,fieldLabel:"Name",labelSeparator:" ",name:"name"},{xtype:"tbspacer",flex:0.2},{xtype:"combobox",itemId:"copyFavCombo",fieldLabel:'<img src="../../../common/gfx/fav_yes.png" height="15" width="15"  />',labelAlign:"right",labelSeparator:" ",labelWidth:20,submitValue:false,emptyText:"copy a favorite",autoSelect:false,displayField:"nameEnc",forceSelection:true,queryMode:"local",store:"Favorites",valueField:"id"}]},{xtype:"radiogroup",itemId:"availableReports",margin:"0 0 10 -5",fieldLabel:"Report type",labelAlign:"top",labelSeparator:" ",layout:{type:"vbox",align:"stretch"}},{xtype:"label",margin:"0 0 10 0",text:"Selections"},{xtype:"gridpanel",flex:1,border:false,itemId:"projectGrid",margin:"0 0 10 10",minHeight:180,bodyBorder:false,scroll:"vertical",store:"ProjectsJsonStore",columns:[{xtype:"gridcolumn",dataIndex:"proj_name",text:"Project",flex:0.75},{xtype:"gridcolumn",width:75,dataIndex:"create_user",text:"Created by"},{xtype:"gridcolumn",dataIndex:"text",text:"Description",flex:1},{xtype:"gridcolumn",width:50,dataIndex:"system",text:"System"},{xtype:"gridcolumn",width:50,dataIndex:"client",text:"Client"},{xtype:"gridcolumn",width:75,dataIndex:"start_date",text:"Start date"},{xtype:"gridcolumn",width:75,dataIndex:"end_date",text:"End date"},{xtype:"gridcolumn",renderer:function(h,b,c,d,l,j,f){var e="../gfx/open.png";var g=CCS.Translator.getText("Open");if(h>0){e="../gfx/closed.png";g=CCS.Translator.getText("Closed")}else{var k=new Date(c.get("end_date"));k.setHours(23,59,59,999);var m=new Date(Date.now());if(k.getTime()<m.getTime()){e="../gfx/overdue.png";g=CCS.Translator.getText("End date is overdue and project is still open")}}return'<img src="'+e+'" title="'+g+'" alt="'+g+'" />'},cls:"setLeft",width:50,align:"center",dataIndex:"status",text:"Status"}],selModel:Ext.create("Ext.selection.CheckboxModel",{}),dockedItems:[{xtype:"pagingtoolbar",dock:"bottom",width:360,displayInfo:true,store:"ProjectsJsonStore",items:[{xtype:"container",flex:100,itemId:"simpleSearchContainer",layout:{type:"hbox",align:"middle"},items:[{xtype:"combobox",itemId:"projectGridPaging",width:50,labelSeparator:" ",name:"projectGridPaging",value:50,store:[50,100,250,500,1000,5000]},{xtype:"tbspacer",width:3},{xtype:"label",text:"per page"},{xtype:"triggerfield",flex:50,itemId:"triggerSearch",fieldLabel:"Search",labelAlign:"right",labelSeparator:" ",labelWidth:35,name:"triggerSearch",triggerCls:"x-form-search-trigger"},{xtype:"tbspacer",width:10},{xtype:"container",layout:{type:"hbox",align:"stretch",pack:"end"},items:[{xtype:"checkboxfield",itemId:"projectListLocalCheckBox",margin:"0 5",name:"projectListLocalCheckBox",boxLabel:"Local system/client",checked:true},{xtype:"checkboxfield",itemId:"projectListOpenCheckBox",margin:"0 5",name:"projectListOpenCheckBox",boxLabel:"Open only"}]}]}]},{xtype:"toolbar",dock:"bottom",itemId:"advancedToolbar",padding:0,items:[{xtype:"form",flex:1,border:false,layout:"fit",bodyBorder:false,header:false,title:"My Form",items:[{xtype:"fieldset",itemId:"advSearchFieldset",margin:0,padding:"3 10 5 10",collapsed:true,collapsible:true,title:"Advanced search",layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",itemId:"hboxContainer",layout:{type:"hbox",align:"stretch"},items:[{xtype:"textfield",flex:1,itemId:"advProjectField",fieldLabel:"Project",labelSeparator:" ",labelWidth:75,name:"advProjectField"},{xtype:"tbspacer",width:10},{xtype:"textfield",flex:1,itemId:"advCreateByField",fieldLabel:"Created by",labelSeparator:" ",labelWidth:75,name:"advCreateByField"},{xtype:"tbspacer",width:10},{xtype:"combobox",flex:1,itemId:"advStatusField",fieldLabel:"Status",labelSeparator:" ",labelWidth:75,name:"advStatusField",store:[CCS.Translator.getText("Any"),CCS.Translator.getText("Open"),CCS.Translator.getText("Closed"),CCS.Translator.getText("Overdue")]}]},{xtype:"tbspacer",flex:1,height:5},{xtype:"container",itemId:"hboxContainer1",layout:{type:"hbox",align:"stretch"},items:[{xtype:"textfield",flex:1,itemId:"advSystemField",fieldLabel:"System",labelSeparator:" ",labelWidth:75,name:"advSystemField"},{xtype:"tbspacer",width:10},{xtype:"textfield",flex:1,itemId:"advClientField",fieldLabel:"Client",labelSeparator:" ",labelWidth:75,name:"advClientField"},{xtype:"tbspacer",width:10},{xtype:"tbspacer",flex:1,width:10}]},{xtype:"tbspacer",flex:1,height:5},{xtype:"container",itemId:"hboxContainer2",layout:{type:"hbox",align:"stretch"},items:[{xtype:"tbspacer",flex:3},{xtype:"button",itemId:"resetAdvBtn",padding:5,icon:"../gfx/clear.png",text:"Reset search criteria",textAlign:"left"},{xtype:"tbspacer",width:10},{xtype:"button",itemId:"searchAdvBtn",padding:5,icon:"../gfx/search_small.png",text:"Advanced search",textAlign:"left"}]}]}]}]}]},{xtype:"container",itemId:"availableReportsOptions",layout:{type:"vbox",align:"stretch"}},{xtype:"container",margin:"0 0 10 0",layout:{type:"hbox",align:"stretch"},items:[{xtype:"combobox",itemId:"languageCombo",width:220,fieldLabel:"Language",labelSeparator:" ",name:"language",allowBlank:false,allowOnlyWhitespace:false,editable:false,displayField:"title",forceSelection:true,store:"LanguageStore",valueField:"code"},{xtype:"tbspacer",flex:1},{xtype:"combobox",itemId:"outputFormat",width:100,fieldLabel:'<img src="../../../common/gfx/filetypes/xlsx.png" />',labelAlign:"right",labelSeparator:" ",labelWidth:16,name:"outputFormat",allowBlank:false,allowOnlyWhitespace:false,editable:false,forceSelection:true,queryMode:"local",store:[[0,"CSV"],[1,"Excel"]],valueField:"id"}]},{xtype:"container",items:[{xtype:"button",disabled:true,itemId:"exportToExcelBtn",padding:5,icon:"../../../common/gfx/running.png",scale:"medium",text:"Generate report"}]}]}]}]},{xtype:"splitter",width:10},{xtype:"fieldset",flex:1,margin:"5 12 12 0",layout:"fit",title:"Report history",items:[{xtype:"gridpanel",border:false,itemId:"reportHistoryGridPanel",margin:"3 0 0 0",autoScroll:true,collapseDirection:"right",collapseFirst:false,header:false,title:"Reports",titleCollapse:true,scroll:"vertical",store:"ReportHistoryStore",columns:[{xtype:"templatecolumn",tpl:['<a href="#" onclick="MyApp.app.getStore(\'ReportHistoryStore\').toggleReportFav({id});">',"\t<tpl if=\"fav == 'T'\">","\t\t<img src=\"../../../common/gfx/fav_yes.png\" data-qtip=\"{[CCS.Translator.getText('Favourite')]}<br>{[CCS.Translator.getText('Click to toggle')]}<br>{[CCS.Translator.getText('Need name to toggle')]}\" border=\"0\"/>","\t<tpl else>","\t\t<img src=\"../../../common/gfx/fav_no.png\" data-qtip=\"{[CCS.Translator.getText('Favourite')]}<br>{[CCS.Translator.getText('Click to toggle')]}<br>{[CCS.Translator.getText('Need name to toggle')]}\" border=\"0\"/>","\t</tpl>","</a>",""],width:40,align:"center",dataIndex:"fav",text:"Fav."},{xtype:"gridcolumn",dataIndex:"name",renderer:"htmlEncode",text:"Name",tooltip:"Double-click to edit",flex:1,editor:{xtype:"textfield",validateOnChange:false}},{xtype:"gridcolumn",width:120,dataIndex:"created",text:"Date"},{xtype:"gridcolumn",width:60,dataIndex:"time",text:"Duration"},{xtype:"gridcolumn",dataIndex:"status",text:"Status",flex:1},{xtype:"templatecolumn",tpl:['<tpl if="taskStatus == 2">','\t<tpl if="available == 1">',"\t\t<tpl if=\"filetype == 'xlsx'\">",'\t\t\t<a href="../../../common/service/report_download.php?id={id}"><img src="../../../common/gfx/filetypes/xlsx.png" data-qtip="{[MyApp.app.getController(\'GUI\').getDownloadtext(values)]}" border="0"/></a>',"\t\t<tpl elseif=\"filetype == 'csv'\">",'\t\t\t<a href="../../../common/service/report_download.php?id={id}"><img src="../../../common/gfx/filetypes/csv.png" data-qtip="{[MyApp.app.getController(\'GUI\').getDownloadtext(values)]}" border="0"/></a>',"\t\t<tpl elseif=\"filetype == 'zip'\">",'\t\t\t<a href="../../../common/service/report_download.php?id={id}"><img src="../../../common/gfx/filetypes/zip_csv.png" data-qtip="{[MyApp.app.getController(\'GUI\').getDownloadtext(values)]}" border="0"/></a>',"\t\t</tpl>","\t<tpl else>","\t\t<tpl if=\"filetype == 'xlsx'\">",'\t\t\t<img src="../../../common/gfx/filetypes/xlsx_removed.png" data-qtip="{[CCS.Translator.getText(\'Removed due to space limitations\')]}" border="0"/>',"\t\t<tpl else>",'\t\t\t<img src="../../../common/gfx/filetypes/csv_removed.png" data-qtip="{[CCS.Translator.getText(\'Removed due to space limitations\')]}" border="0"/>',"\t\t</tpl>","\t</tpl>",'<tpl elseif="taskStatus == 3">','\t<tpl if="available == 1">',"\t\t<tpl if=\"filetype == 'xlsx'\">",'\t\t\t<a href="../../../common/service/report_download.php?id={id}"><img src="../../../common/gfx/filetypes/xlsx_partial.png" data-qtip="{[MyApp.app.getController(\'GUI\').getDownloadtext(values)]}" border="0"/></a>',"\t\t<tpl elseif=\"filetype == 'csv'\">",'\t\t\t<a href="../../../common/service/report_download.php?id={id}"><img src="../../../common/gfx/filetypes/csv_partial.png" data-qtip="{[MyApp.app.getController(\'GUI\').getDownloadtext(values)]}" border="0"/></a>',"\t\t<tpl elseif=\"filetype == 'zip'\">",'\t\t\t<a href="../../../common/service/report_download.php?id={id}"><img src="../../../common/gfx/filetypes/zip_csv.png" data-qtip="{[MyApp.app.getController(\'GUI\').getDownloadtext(values)]}" border="0"/></a>',"\t\t</tpl>","\t<tpl else>","\t\t<tpl if=\"filetype == 'xlsx'\">",'\t\t\t<img src="../../../common/gfx/filetypes/xlsx_removed.png" data-qtip="{[CCS.Translator.getText(\'Removed due to space limitations\')]}" border="0"/>',"\t\t<tpl else>",'\t\t\t<img src="../../../common/gfx/filetypes/csv_removed.png" data-qtip="{[CCS.Translator.getText(\'Removed due to space limitations\')]}" border="0"/>',"\t\t</tpl>","\t</tpl>",'<tpl elseif="taskStatus == 5">','\t<tpl if="available == 1">',"\t\t<tpl if=\"filetype == 'xlsx'\">",'\t\t\t<a href="../../../common/service/report_download.php?id={id}"><img src="../../../common/gfx/filetypes/xlsx_partial.png" data-qtip="{[MyApp.app.getController(\'GUI\').getDownloadtext(values)]}" border="0"/></a>',"\t\t<tpl else>",'\t\t\t<a href="../../../common/service/report_download.php?id={id}"><img src="../../../common/gfx/filetypes/csv_partial.png" data-qtip="{[MyApp.app.getController(\'GUI\').getDownloadtext(values)]}" border="0"/></a>',"\t\t</tpl>","\t</tpl>",'<tpl elseif="taskStatus == 0">','\t<tpl if="free == 1">','\t\t<a href="#" onclick="MyApp.app.getController(\'ReportsController\').restartReport(0);"><img src="../../../common/gfx/restart.png" data-qtip="{[CCS.Translator.getText(\'Start\')]}" border="0"/></a>',"\t</tpl>",'<tpl elseif="taskStatus == 4">','\t<a href="#" onclick="MyApp.app.getController(\'ReportsController\').restartReport({id});"><img src="../../../common/gfx/critical.png" data-qtip="{[CCS.Translator.getText(\'Force start\')]}" border="0"/></a>','<tpl elseif="taskStatus == 1">','\t<tpl if="free == 0">','\t\t<img src="../../../common/gfx/running.png" data-qtip="{[CCS.Translator.getText(\'Running\')]}" border="0"/>',"\t</tpl>","</tpl>"],width:40,align:"center",text:"Link"},{xtype:"templatecolumn",tpl:['<a href="#" onclick="MyApp.app.getController(\'ReportsController\').getReportParameters({id});"><img src="../gfx/copy_params.png" data-qtip="{[CCS.Translator.getText(\'Copy to report selections\')]}" border="0"/></a>'],width:40,align:"center",text:"Copy"},{xtype:"templatecolumn",tpl:["<!--",'<tpl if="taskStatus &gt; 1">','\t<a href="#" onclick="MyApp.app.getStore(\'ReportHistoryStore\').deleteReport({id});">','\t\t<img src="../gfx/delete.png" data-qtip="{[CCS.Translator.getText(\'Delete report\')]}" border="0"/>',"\t</a>","</tpl>","",'<tpl if="taskStatus == 0">','\t<a href="#" onclick="MyApp.app.getController(\'ReportsController\').cancelReport({id});">','\t\t<img src="../gfx/clear.png" data-qtip="{[CCS.Translator.getText(\'Cancel report\')]}" border="0"/>',"\t</a>","</tpl>","-->","<tpl if=\"taskStatus &gt; 1 && fav == 'F'\">",'\t<a href="#" onclick="MyApp.app.getStore(\'ReportHistoryStore\').deleteReport({id});">','\t\t<img src="../gfx/delete.png" data-qtip="{[CCS.Translator.getText(\'Delete report\')]}" border="0"/>',"\t</a>","</tpl>","<tpl if=\"taskStatus &gt; 1 && fav == 'T'\">",'\t<a href="#" onclick="">','\t\t<img src="../gfx/delete_grey.png" data-qtip="{[CCS.Translator.getText(\'Delete report\')]}<br>{[CCS.Translator.getText(\'Can not be favourite\')]}" border="0"/>',"\t</a>","</tpl>","","",'<tpl if="taskStatus == 0">','\t<a href="#" onclick="MyApp.app.getController(\'ReportsController\').cancelReport({id});">','\t\t<img src="../gfx/clear.png" data-qtip="{[CCS.Translator.getText(\'Cancel report\')]}" border="0"/>',"\t</a>","</tpl>",""],width:60,align:"center",text:"Action"},{xtype:"gridcolumn",cls:"setLeft",width:60,align:"right",dataIndex:"id",text:"ID"}],plugins:[Ext.create("Ext.grid.plugin.CellEditing",{})],dockedItems:[{xtype:"toolbar",dock:"bottom",hidden:true,itemId:"advancedToolbar2",items:[{xtype:"fieldset",flex:1,border:"none",itemId:"advanced2Fieldset",collapsible:true,title:"Advanced search",items:[{xtype:"container",itemId:"vboxContainer",layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",flex:1,itemId:"hboxContainer",margin:"3 0 3 0",layout:{type:"hbox",align:"stretch"},items:[{xtype:"textfield",flex:10,itemId:"adv2NameField",fieldLabel:"Name",labelSeparator:" ",labelWidth:50,name:"adv2NameField"},{xtype:"tbspacer",flex:1},{xtype:"textfield",flex:10,itemId:"adv2DateField",fieldLabel:"Date",labelSeparator:" ",labelWidth:50,name:"adv2DateField"},{xtype:"tbspacer",flex:1},{xtype:"textfield",flex:10,itemId:"adv2StatusField",fieldLabel:"Status",labelSeparator:" ",labelWidth:50,name:"adv2StatusField"}]},{xtype:"container",flex:1,itemId:"hboxContainer1",margin:"3 0 3 0",layout:{type:"hbox",align:"stretch"},items:[{xtype:"tbspacer",flex:2},{xtype:"button",flex:1,itemId:"resetAdv2Btn",icon:"../gfx/clear.png",scale:"medium",text:"Reset search criteria",textAlign:"left"},{xtype:"tbspacer",width:10},{xtype:"button",flex:1,itemId:"searchAdv2Btn",icon:"../gfx/search.png",scale:"medium",text:"Advanced search",textAlign:"left"}]}]}]}]},{xtype:"pagingtoolbar",dock:"bottom",itemId:"historyToolbar",width:360,displayInfo:true,store:"ReportHistoryStore",layout:{type:"hbox",align:"middle"},items:[{xtype:"combobox",itemId:"reportHistoryGridPaging",width:50,labelSeparator:" ",name:"reportHistoryPageSize",value:50,store:[50,100,250,500,1000,5000]},{xtype:"tbspacer",width:3},{xtype:"label",text:"per page"}]}]}]}]});a.callParent(arguments)}});Ext.define("MyApp.view.Viewport",{extend:Ext.container.Viewport,layout:{type:"fit"},items:[{xtype:"app-main"}]});