/*
 * File: app.js
 *
 * This file was generated by Sencha Architect version 3.0.2.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

// @require @packageOverrides
Ext.Loader.setConfig({
	enabled: true
});


Ext.application({
	models: [
		'TestUser',
		'TestRole',
		'RoleTcodes'
	],
	stores: [
		'TestUsers',
		'TestRoles',
		'SapUsers',
		'TestTcodes',
		'SapRoles',
		'TestTcodesFlat'
	],
	views: [
		'MyPanel',
		'WindowProgress',
		'WindowAddUsersPasted',
		'WindowCreateUsersSetup',
		'WindowTcodeComment',
		'WindowAddUsers',
		'WindowRoleManagement',
		'WindowTcodeManagement'
	],
	controllers: [
		'TestUsers',
		'AddRemoveRolesToFromUsers',
		'AddUsersPasted',
		'CreateUsers',
		'RemoveUser',
		'SendMails',
		'AddUsers',
		'TcodeManagement',
		'RoleManagement',
		'SyncData'
	],
	name: 'MyApp',

	launch: function() {
		Ext.create('MyApp.view.MyPanel', {renderTo: Ext.getBody()});
		this.msgCt = Ext.DomHelper.insertFirst(document.body, {id:'msg-div'}, true);

		/* GET FALLBACK LANGUAGE FOR DESCRIPTIONS AND WHAT NOT */
		this.fallbackLanguage = 'en';
		Ext.Ajax.request({ //manual AJAX
			url: '../../../common/service/getFallbackLanguage.php',
			method: 'get',
			params: Ext.Object.fromQueryString(document.location.search),
			success: function(response, object){
				var data = Ext.JSON.decode(response.responseText);
				this.fallbackLanguage = data.result;
			},
			failure: function(response, object){
				var userMessage = CCS.Translator.getText("Error code")+': '+ response.status +"<br />"+
					"url: "+ object.url +"<br />"+
					"text: "+ response.statusText +"<br />"+
					"scope: "+ response.request.options.scope.id +"<br />"+
					"timeout: ";
				userMessage += response.timedout === true? CCS.Translator.getText("Yes") : CCS.Translator.getText("No");
				userMessage += "<br /><br />"+CCS.Translator.getText("Are you sure you want to continue?");

				Ext.MessageBox.show({
					icon: Ext.MessageBox.WARNING,
					title: CCS.Translator.getText("Some errors occurred"),
					msg: userMessage,
					buttons: Ext.MessageBox.OKCANCEL,
					animateTarget: me.getEmptyContainer(),

					fn: function(response) {
						if(response == 'ok') {
							document.location.reload();
						}
						else {
							document.location.reload();
						}
					}
				});
			},
			scope: this
		});
	},

	message: function(title, message) {
		var s = Ext.String.format.apply(String, Array.prototype.slice.call(arguments, 1));
		var m = Ext.DomHelper.append(this.msgCt, '<div class="msg"><h3>' + title + '</h3><p>' + s + '</p></div>', true);
		m.hide();
		m.slideIn('t').ghost("t", { delay: 2500, remove: true});
	}

});
