-- -----------------------------------------------
-- APM-3414 - AC, combine crit_role and sod_role2
-- -----------------------------------------------
ALTER TABLE `sod_sod_role2` 
ADD COLUMN `list` TINYINT NULL DEFAULT NULL AFTER `rule_id`;

SET SQL_SAFE_UPDATES = 0;

UPDATE `sod_sod_role2`
SET `list` = CASE
	 WHEN `side` = 'A' THEN 0
	 WHEN `side` = 'B' THEN 1
	 ELSE NULL
   END
WHERE `list` IS NULL;

UPDATE `sod_rule`
SET `rule_type` = CASE
	WHEN `rule_type` = 'crit_role' THEN 'sod_role2'
	WHEN `rule_type` = 'sod_role' THEN 'sod_role2'
	ELSE `rule_type`
END;

UPDATE `sod_group`
SET `rule_type` = CASE
	WHEN `rule_type` = 'crit_role' THEN 'sod_role2'
	WHEN `rule_type` = 'sod_role' THEN 'sod_role2'
	ELSE `rule_type`
END;

INSERT INTO sod_sod_role2
(`role_id`, `rule_id`, `list`)
SELECT `role_id`, `rule_id`, 0 AS `list`
FROM sod_crit_role;

ALTER TABLE `sod_sod_role2` DROP COLUMN `side`;
DROP TABLE IF EXISTS sod_sod_role;
DROP TABLE IF EXISTS sod_crit_role;
DROP TABLE IF EXISTS sod_role;
RENAME TABLE `sod_sod_role2` TO `sod_role`;

SET SQL_SAFE_UPDATES = 1;
