-- -----------------------------------------------------
-- New table to capture the history of star roles and users
-- -----------------------------------------------------

CREATE TABLE IF NOT EXISTS  `um_dash_star_role_history` (
  `system` char(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client` char(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` date NOT NULL,
  `step` int NOT NULL,
  `count` int DEFAULT NULL,
  PRIMARY KEY (`date`,`step`,`system`,`client`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS  `um_dash_star_user_history` (
  `system` char(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client` char(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` date NOT NULL,
  `step` int NOT NULL,
  `count` int DEFAULT NULL,
  PRIMARY KEY (`date`,`step`,`system`,`client`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `um_dash_star_user` (
  `system` char(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `client` char(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int unsigned NOT NULL,
  `step` int DEFAULT NULL,
  PRIMARY KEY (`system`,`client`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
