-- -----------------------
-- Mitigator additions  --
--------------------------
CREATE TABLE IF NOT EXISTS `ic_control_approver` (
  `control_id` INT NOT NULL,
  `approver_id` INT NOT NULL,
  `area_id` INT NOT NULL DEFAULT '0',
  PRIMARY KEY (`control_id`,`approver_id`,`area_id`)
)
SELECT `control_id`, `approver_id`, `area_id` FROM `ic_control_approvers`;
DROP TABLE IF EXISTS `ic_control_approvers`;

CREATE TABLE IF NOT EXISTS `ic_control_executer` (
  `control_id` INT NOT NULL,
  `approver_id` INT NOT NULL,
  `area_id` INT NOT NULL DEFAULT '0',
  PRIMARY KEY (`control_id`,`approver_id`,`area_id`)
)
SELECT `control_id`, `executer_id` AS `approver_id`, `area_id` FROM `ic_control_executers`;
DROP TABLE IF EXISTS `ic_control_executers`;

CREATE TABLE IF NOT EXISTS `ic_control_mitigator` (
  `control_id` INT NOT NULL,
  `approver_id` INT NOT NULL,
  `area_id` INT NOT NULL DEFAULT '0',
  PRIMARY KEY (`control_id`,`approver_id`,`area_id`)
);

CREATE TABLE IF NOT EXISTS `ic_check_mitigator` (
  `check_id` int(11) NOT NULL,
  `approver_id` int(11) NOT NULL,
  PRIMARY KEY (`check_id`,`approver_id`)
);

ALTER TABLE `ic_check_executers` 
CHANGE COLUMN `executer_id` `approver_id` INT NOT NULL ;

