-- ------------------------------------------- --
-- Explanations for authorization field values 
-- ------------------------------------------- --
CREATE TABLE IF NOT EXISTS `sod_field_value_description_sap` (
	`field` VARCHAR(20) NOT NULL,
	`value` VARCHAR(20) NOT NULL,
	`language` CHAR(2) NOT NULL,
	`system` VARCHAR(8) NOT NULL,
	`description` TEXT NULL,
	`timestamp` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
PRIMARY KEY (`field`, `value`, `language`, `system`));

CREATE TABLE IF NOT EXISTS `sod_field_value_description_user` (
	`field` VARCHAR(20) NOT NULL,
	`value` VARCHAR(20) NOT NULL,
	`language` CHAR(2) NOT NULL,
	`system` VARCHAR(8) NOT NULL,
	`user_id` INT NOT NULL,
	`description` TEXT NULL,
	`timestamp` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
PRIMARY KEY (`field`, `value`, `language`, `system`));
 
CREATE TABLE IF NOT EXISTS `sod_field_value_description_delivered` (
	`field` VARCHAR(20) NOT NULL,
	`value` VARCHAR(20) NOT NULL,
	`description` TEXT NULL,
PRIMARY KEY (`field`, `value`));
 
INSERT INTO `sod_field_value_description_delivered` 
		(`field`, `value`, `description`)
	VALUES
		('ACTVT','07','Activate, Generate'),
		('ACTVT','24','Archive'),
		('ACTVT','78','Assign'),
		('ACTVT','79','Assign Role to Composite Role'),
		('ACTVT','02','Change'),
		('ACTVT','11','Change number range status'),
		('ACTVT','42','Convert to DB'),
		('ACTVT','90','Copy'),
		('ACTVT','40','Create in DB'),
		('ACTVT','01','Create or generate'),
		('ACTVT','06','Delete'),
		('ACTVT','41','Delete in DB'),
		('ACTVT','C4','Develope Payment Card'),
		('ACTVT','03','Display'),
		('ACTVT','08','Display change documents'),
		('ACTVT','59','Distribute'),
		('ACTVT','76','Enter'),
		('ACTVT','22','Enter, Include, Assign'),
		('ACTVT','16','Execute'),
		('ACTVT','36','Extended maintenance'),
		('ACTVT','64','Generate'),
		('ACTVT','60','Import'),
		('ACTVT','13','Initialize number levels'),
		('ACTVT','19','Invoices from coll. Proc'),
		('ACTVT','05','Lock'),
		('ACTVT','23','Maintain'),
		('ACTVT','17','Maintain number range object'),
		('ACTVT','10','Post'),
		('ACTVT','77','Pre-enter'),
		('ACTVT','A6','Read with filter'),
		('ACTVT','43','Release'),
		('ACTVT','25','Reload'),
		('ACTVT','75','Remove'),
		('ACTVT','84','Settle'),
		('ACTVT','21','Transport'),
		('ACTVT','UL','Upload'),
		('ACTVT','34','Write'),
		('ACTVT','A7','Write with filter'),
		('AKTPR','01','Allow posting to previous period'),
		('AKTPR','50','Close periods'),
		('AKTPR','02','Close periods [obsolete]'),
		('AKTPR','51','Initialization for period closing program'),
		('AKTPR','03','Initialization for period closing program [obsolete]'),
		('APPKZ','F','Financial Accounting'),
		('AUTHC','*','[all operations]. * includes all authorization levels simultaneously'),
		('AUTHC','D','[Dequeue] for write access using the Asymmetrical Double Verification Principle. D also enables you to change the lock indicator.'),
		('AUTHC','E','[Enqueue] for write access using the Asymmetrical Double Verification Principle. E also enables you to create and change locked records'),
		('AUTHC','M','[Matchcode] for read access to entry helps'),
		('AUTHC','R','[Read] for read access'),
		('AUTHC','S','[Symmetric] for write access using the Symmetric Double Verification Principle/Write data to internal buffer but not to database [simulation]'),
		('AUTHC','W','[Write] for write access'),
		('AUTHC','U','Write [update] – this includes the authorizations of authorization level S but not authorization level R'),
		('BTCADMIN','Y','[No Field Value Found]'),
		('BWART','617','Cre. Str. Mat. Cons.'),
		('BWART','317','Create struct. mat.'),
		('BWART','601','GD goods issue:delvy'),
		('BWART','651','GD ret.del.  returns'),
		('BWART','652','GD ret.del. retn rev'),
		('BWART','658','GD returns blk. rev.'),
		('BWART','657','GD returns blocked'),
		('BWART','655','GD returns QI'),
		('BWART','656','GD returns QI  rev.'),
		('BWART','654','GD returns unr. rev.'),
		('BWART','653','GD returns unrestr.'),
		('BWART','557','GI adjust. transit'),
		('BWART','558','GI adjust. transit'),
		('BWART','291','GI all acc. assigmts'),
		('BWART','525','GI blkd w/o prod.or.'),
		('BWART','581','GI by-prod. network'),
		('BWART','531','GI by-product'),
		('BWART','533','GI by-product'),
		('BWART','631','GI consgmt: lending'),
		('BWART','632','GI consgmt:ret.delvy'),
		('BWART','511','GI deliv. w/o charge'),
		('BWART','565','GI EntrStBals: blckd'),
		('BWART','563','GI EntrStBals: QI'),
		('BWART','561','GI entry of st. bals'),
		('BWART','241','GI for asset'),
		('BWART','201','GI for cost center'),
		('BWART','281','GI for network'),
		('BWART','261','GI for order'),
		('BWART','221','GI for project'),
		('BWART','251','GI for sales'),
		('BWART','231','GI for sales order'),
		('BWART','901','GI internal c.center'),
		('BWART','717','GI InvDiff.: blocked'),
		('BWART','715','GI InvDiff.:returns'),
		('BWART','711','GI InvDiff.:whouse'),
		('BWART','713','GI InvDiff: QI'),
		('BWART','633','GI iss: cust.consgmt'),
		('BWART','623','GI iss:cust.ret.pack'),
		('BWART','546','GI issue SC by-prod.'),
		('BWART','543','GI issue sls.ord.st.'),
		('BWART','702','GI phys.inv.: whse'),
		('BWART','708','GI phys.inv.:blocked'),
		('BWART','704','GI phys.inv: QI'),
		('BWART','523','GI quality w/o PrOrd'),
		('BWART','575','GI rcpt blkd assmbly'),
		('BWART','573','GI rcpt QI assembly'),
		('BWART','545','GI rcpt SC by-prod.'),
		('BWART','634','GI rcpt:cust.consgmt'),
		('BWART','624','GI rcpt:cust.re.pack'),
		('BWART','571','GI receipt assembly'),
		('BWART','544','GI receipt sls.or.st'),
		('BWART','505','GI receipt to blockd'),
		('BWART','503','GI receipt to qual.'),
		('BWART','501','GI receipt w/o PO'),
		('BWART','521','GI receipt w/o PrOrd'),
		('BWART','621','GI ret.pack.:lending'),
		('BWART','622','GI ret.pack:ret.del.'),
		('BWART','451','GI returns'),
		('BWART','661','GI returns to vendor'),
		('BWART','551','GI scrapping'),
		('BWART','555','GI scrapping blocked'),
		('BWART','553','GI scrapping QI'),
		('BWART','862','GI TF SD/MM'),
		('BWART','863','GI TF SD/MM return'),
		('BWART','335','GI to sampl. blocked'),
		('BWART','331','GI to sampling QI'),
		('BWART','333','GI to sampling unre.'),
		('BWART','541','GI whse to subc.stck'),
		('BWART','131','Goods receipt'),
		('BWART','132','Goods receipt'),
		('BWART','801','GR adv. inv. + tax'),
		('BWART','803','GR AI ICMS/IPI'),
		('BWART','815','GR B TP dely w. tax'),
		('BWART','825','GR B val. VS w. tax'),
		('BWART','805','GR bl. AI w. tax'),
		('BWART','535','GR by-prod. sls.ord.'),
		('BWART','536','GR by-prod. sls.ord.'),
		('BWART','110','GR fr. Val. Bl. Rev.'),
		('BWART','109','GR fr. Val. Bl. St.'),
		('BWART','105','GR from blocked stck'),
		('BWART','141','GR G subseq. adjustm'),
		('BWART','142','GR G subseq. adjustm'),
		('BWART','101','GR goods receipt'),
		('BWART','103','GR into blocked stck'),
		('BWART','718','GR InvDiff.: blocked'),
		('BWART','716','GR InvDiff.:returns'),
		('BWART','712','GR InvDiff.:wrhouse'),
		('BWART','714','GR InvDiff: QI'),
		('BWART','701','GR phys.inv.: whse'),
		('BWART','707','GR phys.inv.:blocked'),
		('BWART','703','GR phys.inv: QI'),
		('BWART','161','GR returns'),
		('BWART','125','GR rtn blkd stck rev'),
		('BWART','841','GR RTP'),
		('BWART','843','GR RTP w. tax'),
		('BWART','124','GR rtrn blocked stck'),
		('BWART','162','GR rtrns reversal'),
		('BWART','121','GR subseq. adjustm.'),
		('BWART','861','GR TF SD/MM'),
		('BWART','864','GR TF SD/MM return'),
		('BWART','108','GR to Val. Bl. Rev.'),
		('BWART','107','GR to Val. Bl. Stock'),
		('BWART','811','GR TP dely w. tax'),
		('BWART','821','GR val. VS w. tax'),
		('BWART','834','R reval. iss. w tax'),
		('BWART','836','R reval. rec. w tax'),
		('BWART','292','RE all acct assigmts'),
		('BWART','526','RE blocked w/o PrOrd'),
		('BWART','582','RE by-prod. network'),
		('BWART','532','RE by-product'),
		('BWART','534','RE by-product'),
		('BWART','618','RE Cr. Str. Mat. Con'),
		('BWART','318','RE create struc. mat'),
		('BWART','512','RE deliv. w/o charge'),
		('BWART','566','RE EntrStBals: blckd'),
		('BWART','564','RE EntrStBals: QI'),
		('BWART','562','RE entry of st.bals.'),
		('BWART','242','RE for asset'),
		('BWART','202','RE for cost center'),
		('BWART','282','RE for network'),
		('BWART','262','RE for order'),
		('BWART','222','RE for project'),
		('BWART','252','RE for sales'),
		('BWART','232','RE for sales order'),
		('BWART','602','RE goods deliv. rev.'),
		('BWART','524','RE quality w/o PrOrd'),
		('BWART','576','RE rcpt blkd assmbly'),
		('BWART','574','RE rcpt QI assembly'),
		('BWART','572','RE receipt assembly'),
		('BWART','506','RE receipt to blockd'),
		('BWART','504','RE receipt to qual.'),
		('BWART','502','RE receipt w/o PO'),
		('BWART','522','RE receipt w/o PrOrd'),
		('BWART','620','RE Rem. Str Mat Cons'),
		('BWART','662','RE ret. to vdr revrs'),
		('BWART','122','RE return to vendor'),
		('BWART','922','RE return to vendor'),
		('BWART','452','RE returns [rev.]'),
		('BWART','123','RE rtrn vendor rev.'),
		('BWART','552','RE scrapping'),
		('BWART','556','RE scrapping blocked'),
		('BWART','554','RE scrapping QI'),
		('BWART','320','RE split struct.mat.'),
		('BWART','542','RE subctrStck toWhse'),
		('BWART','336','RE to sampling blkd'),
		('BWART','332','RE to sampling QI'),
		('BWART','334','RE to sampling unre.'),
		('BWART','619','Rem. Str. Mat. Cons.'),
		('BWART','104','Rev. GR to blocked'),
		('BWART','416','Rev. SLoc to proj.'),
		('BWART','414','Rev. SLoc to sls ord'),
		('BWART','106','Rev.GR from blocked'),
		('BWART','833','Reval. iss. w. tax'),
		('BWART','835','Reval. rec. w. tax'),
		('BWART','102','Reversal of GR'),
		('BWART','412','Reversal own to own'),
		('BWART','802','RGR ad. inv. + tax'),
		('BWART','804','RGR AI ICMS/IPI'),
		('BWART','816','RGR B TP dely w. tax'),
		('BWART','826','RGR B val. VS w. tax'),
		('BWART','806','RGR bl. AI w. tax'),
		('BWART','842','RGR RTP'),
		('BWART','844','RGR RTP w. tax'),
		('BWART','812','RGR TP dely w tax'),
		('BWART','822','RGR val. VS w. tax'),
		('BWART','732','SlsVal.iss. afftgMgs'),
		('BWART','722','SlsVal.iss.n.afftMgs'),
		('BWART','731','SlsVal.rec. afftgMgs'),
		('BWART','721','SlsVal.rec.n.afftMgs'),
		('BWART','319','Split structured mat'),
		('BWART','340','TF bch revaluation'),
		('BWART','325','TF blocked in plant'),
		('BWART','349','TF blocked to qual.'),
		('BWART','343','TF blocked to unre.'),
		('BWART','635','TF consgmt lending'),
		('BWART','645','TF cross company'),
		('BWART','676','TF cross company'),
		('BWART','305','TF pl.in stor.in pl.'),
		('BWART','605','TF pl.in stor.in pl.'),
		('BWART','315','TF pl.in str.in SLoc'),
		('BWART','323','TF quality in plant'),
		('BWART','321','TF quality to unrest'),
		('BWART','303','TF rem.fm.stor.to pl'),
		('BWART','603','TF rem.fm.stor.to pl'),
		('BWART','313','TF rem.fm.str.toSLoc'),
		('BWART','455','TF st.tfr. returns'),
		('BWART','311','TF tfr. within plant'),
		('BWART','301','TF tfr.plnt.to plnt.'),
		('BWART','309','TF tfr.ps.mat.to mat'),
		('BWART','643','TF to cross company'),
		('BWART','673','TF to cross company'),
		('BWART','351','TF to stck in trans.'),
		('BWART','641','TF to stck in trans.'),
		('BWART','647','TF to stck in trans.'),
		('BWART','672','TF to stck in trans.'),
		('BWART','678','TF to stck in trans.'),
		('BWART','342','TF unr. to rstricted'),
		('BWART','341','TF unrestr.to restr.'),
		('BWART','460','TP Own blckt to ret.'),
		('BWART','403','TP own from consgt.'),
		('BWART','405','TP own from project'),
		('BWART','401','TP own from sls.ord.'),
		('BWART','458','TP Own QIS to ret.'),
		('BWART','404','TP own to consgt.'),
		('BWART','411','TP own to own'),
		('BWART','406','TP own to project'),
		('BWART','454','TP own to returns'),
		('BWART','402','TP own to sales ord.'),
		('BWART','459','TP Ret.to own blckd'),
		('BWART','457','TP Ret.to own QIS'),
		('BWART','453','TP returns to own'),
		('BWART','415','TP SLoc to project'),
		('BWART','413','TP SLoc to sls order'),
		('BWART','442','TP tiedEmp.to unrstr'),
		('BWART','441','TP unrstr.to tiedEmp'),
		('BWART','326','TR blocked in plant'),
		('BWART','350','TR blocked to qual.'),
		('BWART','344','TR blocked to unre.'),
		('BWART','636','TR consgmt ret. del.'),
		('BWART','646','TR cross company'),
		('BWART','675','TR cross company'),
		('BWART','306','TR pl.in stor.in pl.'),
		('BWART','606','TR pl.in stor.in pl.'),
		('BWART','316','TR pl.in stor.inSLoc'),
		('BWART','324','TR quality in plant'),
		('BWART','322','TR quality to unrest'),
		('BWART','304','TR rem.fm.stor.to pl'),
		('BWART','604','TR rem.fm.stor.to pl'),
		('BWART','314','TR rem.fm.str.toSLoc'),
		('BWART','456','TR St.tfr. returns'),
		('BWART','302','TR tfr.plnt.to plnt.'),
		('BWART','310','TR tfr.ps.mat.to mat'),
		('BWART','644','TR to cross company'),
		('BWART','674','TR to cross company'),
		('BWART','352','TR to stck in trans.'),
		('BWART','642','TR to stck in trans.'),
		('BWART','648','TR to stck in trans.'),
		('BWART','671','TR to stck in trans.'),
		('BWART','677','TR to stck in trans.'),
		('BWART','312','TR transfer in plant'),
		('COARS','1','Infotype authorization independent of org. assignment'),
		('COARS','2','Report must be run executed without being checked'),
		('CTS_LANFKT','ADMI','Administration'),
		('CTS_LANFKT','SHOW','Display'),
		('CTS_LANFKT','INST','Installation'),
		('CTS_LANFKT','SUPL','Supplementation'),
		('DICBERCLS','ACED','ACE: Distr. Server'),
		('DICBERCLS','ACE','ACE: General'),
		('DICBERCLS','ACEP','ACE: Posting Server'),
		('DICBERCLS','BAST','Activity: Tables'),
		('DICBERCLS','WXP9','Add. key figures'),
		('DICBERCLS','DM01','Admin / Developer'),
		('DICBERCLS','AIF','AIF Customizing'),
		('DICBERCLS','ALE1','ALE: Serialization'),
		('DICBERCLS','ALE0','ALE: Table Maint.'),
		('DICBERCLS','SALT','Alert Management'),
		('DICBERCLS','BALV','ALV Extensions'),
		('DICBERCLS','SEQV','ALV Grid Variants'),
		('DICBERCLS','AA','AM: Application Tab.'),
		('DICBERCLS','AS','AM: SAP Control'),
		('DICBERCLS','AC','AM: User Control'),
		('DICBERCLS','FDKU','AP/AR: User action'),
		('DICBERCLS','CTM','APO Capable To Match'),
		('DICBERCLS','AMON','APO: Alert Monitor'),
		('DICBERCLS','PPDS','APO: PPDS'),
		('DICBERCLS','SCC','APO: SCC and SCE'),
		('DICBERCLS','SCDA','Applic. Table DAS'),
		('DICBERCLS','IMCA','AppropriationRequest'),
		('DICBERCLS','SARC','Archiving'),
		('DICBERCLS','ARBE','Ariba Integr. ERP'),
		('DICBERCLS','ARBF','Ariba Integr. Found.'),
		('DICBERCLS','ARUN_CUST','ARun: Authorization group'),
		('DICBERCLS','WXPD','Assign. period/seas.'),
		('DICBERCLS','WXPC','Assignments'),
		('DICBERCLS','/ASU','ASU Toolbox'),
		('DICBERCLS','ATPC','ATP: Cust. - Genl.'),
		('DICBERCLS','ATPR','ATP: Cust. - RBA'),
		('DICBERCLS','ATPT','ATP: Cust. - Tools'),
		('DICBERCLS','ATPQ','ATP: Cust.- Acct.Asg'),
		('DICBERCLS','SAUT','Audit Trail [ILM]'),
		('DICBERCLS','AUT','Audit Trail [Part11]'),
		('DICBERCLS','PSSR','Aut. Settlement Rule'),
		('DICBERCLS','SU2X_ADMIN','Authorization Default Values - Admin.'),
		('DICBERCLS','WXPA','Automatic planning'),
		('DICBERCLS','WXPE','Avg. retail param.'),
		('DICBERCLS','FKGB','BA Consolidation'),
		('DICBERCLS','BPAA','BA: Application'),
		('DICBERCLS','BPAS','BA: Control'),
		('DICBERCLS','BPAC','BA: Customizing'),
		('DICBERCLS','BAF4','BA: Market Data'),
		('DICBERCLS','DNO','Basis Message'),
		('DICBERCLS','BTCH','Batches'),
		('DICBERCLS','SCUS','BC Customizing'),
		('DICBERCLS','SBCA','BC Set Admin'),
		('DICBERCLS','SZ02','BC: Address Admin.'),
		('DICBERCLS','STRA','BC: Basis Training'),
		('DICBERCLS','SUNI','BC: DDIC Training'),
		('DICBERCLS','SIMG','BC: IMG Attributes'),
		('DICBERCLS','SZ01','BC: Maintain Objects'),
		('DICBERCLS','STUN','BC: Performance'),
		('DICBERCLS','SPFL','BC: System Param.'),
		('DICBERCLS','STRW','BC: Transport System'),
		('DICBERCLS','SRZL','BC:Comp.Ctr.Mgt.Sys.'),
		('DICBERCLS','BDC_CUS','BDC Customizing'),
		('DICBERCLS','SBDC','BDC Customizing'),
		('DICBERCLS','SBDC_CUS','BDC Customizing'),
		('DICBERCLS','BIWH','BI Warehouse'),
		('DICBERCLS','PSFP','Billing Plan in WBS'),
		('DICBERCLS','BVIC','Bonus Customizing'),
		('DICBERCLS','BPCB','BPCA: Basis'),
		('DICBERCLS','FIFM','BUDGET'),
		('DICBERCLS','BUPS','BUPA: Control'),
		('DICBERCLS','BUPC','BUPA: Customizing'),
		('DICBERCLS','A2G1','Bus. Config. GL'),
		('DICBERCLS','SBM','Business Navigator'),
		('DICBERCLS','BWC','BW Customizing Table'),
		('DICBERCLS','BWAA','BW Data Retraction'),
		('DICBERCLS','BWG','BW Generated Table'),
		('DICBERCLS','BWA','BW Standard Table'),
		('DICBERCLS','GVAR','BW: Global Variable'),
		('DICBERCLS','CA0C','CAD Interface'),
		('DICBERCLS','SCMG','Case Management'),
		('DICBERCLS','CTLG','Catalog maintenance'),
		('DICBERCLS','CMMFDCO','CDOTE Common Authorization Group'),
		('DICBERCLS','SCDO','Central Change Documents'),
		('DICBERCLS','JBMA','CFM/Bank Market Data'),
		('DICBERCLS','SCRM','Check Res.Management'),
		('DICBERCLS','XXXX','Cl.-Indep. Cust.tab.'),
		('DICBERCLS','CLEA','Clearing Tool'),
		('DICBERCLS','CMS1','CMS: Control'),
		('DICBERCLS','CMS0','CMS: Core'),
		('DICBERCLS','CMS2','CMS: Objects'),
		('DICBERCLS','CNS2','CNS Control'),
		('DICBERCLS','CNS1','CNS Customizing'),
		('DICBERCLS','KA','CO: Application Tab.'),
		('DICBERCLS','KCS','CO: Cost Ctr Acctg'),
		('DICBERCLS','K001','CO: Master Data'),
		('DICBERCLS','KCA','CO: Orders'),
		('DICBERCLS','KCOR','CO: Org. units'),
		('DICBERCLS','KS','CO: SAP Control'),
		('DICBERCLS','KCB','CO: Settlement'),
		('DICBERCLS','KC','CO: User Control'),
		('DICBERCLS','KFPR','CO-Fixed Price'),
		('DICBERCLS','COMS','COM Control'),
		('DICBERCLS','COMC','COM Customizing'),
		('DICBERCLS','CACS','Commissions'),
		('DICBERCLS','CMMFDOR','Commodity Derivative Order'),
		('DICBERCLS','CMMFDOF','Commodity Derivative Order Fill'),
		('DICBERCLS','CMMFDAI','Commodity Order AIF Group'),
		('DICBERCLS','CMMFSA','Commodity Subaccount Authorization Group'),
		('DICBERCLS','CKOM','Communication'),
		('DICBERCLS','ECOP','Con. ECOP'),
		('DICBERCLS','X500','Config. Table'),
		('DICBERCLS','KEC','CO-PA: Customizing'),
		('DICBERCLS','KES','CO-PA: SAP Control'),
		('DICBERCLS','KEA','CO-PA: User Table'),
		('DICBERCLS','KKU','CO-PC: Comprehensive'),
		('DICBERCLS','KKH','CO-PC: Cost Comp.'),
		('DICBERCLS','KKP','CO-PC: Cost Objects'),
		('DICBERCLS','KKK','CO-PC: Costing'),
		('DICBERCLS','KKZ','CO-PC: Other'),
		('DICBERCLS','KKB2','CO-PC: Report Layout'),
		('DICBERCLS','KKB1','CO-PC: Report List'),
		('DICBERCLS','KKA','CO-PC: Results Anlys'),
		('DICBERCLS','KKR','CO-PC: Summarization'),
		('DICBERCLS','KKSY','CO-PC: System Tables'),
		('DICBERCLS','KKV','CO-PC: Variances'),
		('DICBERCLS','KE1C','CO-PCA: Customizing'),
		('DICBERCLS','COR1','Corresp.:Customizing'),
		('DICBERCLS','CPEC','CPE: General Custom.'),
		('DICBERCLS','CPEQ','CPE: Quotation Cust.'),
		('DICBERCLS','CRMS','CRM Control'),
		('DICBERCLS','CRMC','CRM Customizing'),
		('DICBERCLS','ICMC','CRM-ICM Customizing'),
		('DICBERCLS','SCSL','Cross System Lock'),
		('DICBERCLS','FLBP','Cust./Vend. Integr.'),
		('DICBERCLS','CY2C','Cust.graph.Cap.Pl.Tb'),
		('DICBERCLS','SYCM','Custom Code Migration'),
		('DICBERCLS','WRMA','Customizing RMA'),
		('DICBERCLS','DGBH','Dang.Goods Mast.Data'),
		('DICBERCLS','DGBG','Danger.Goods Custom.'),
		('DICBERCLS','TXXC','DARTX'),
		('DICBERCLS','SCDS','DAS Customizing'),
		('DICBERCLS','DA','DASS: Appl. Tables'),
		('DICBERCLS','DS','DASS: SAP Control'),
		('DICBERCLS','DC','DASS: User Control'),
		('DICBERCLS','DAAG','Data Aging'),
		('DICBERCLS','DHCDC','Data Hub: Change Data Capture'),
		('DICBERCLS','DHBAS_CDS','DataHub Integration Authorization Group'),
		('DICBERCLS','SU2X','Default Authorization Values'),
		('DICBERCLS','SCDL','Delivery Customizing'),
		('DICBERCLS','YRAD','Development tools'),
		('DICBERCLS','SDIC','Dictionary Verific.'),
		('DICBERCLS','DM04','Display All'),
		('DICBERCLS','GSPL','Document breakdown'),
		('DICBERCLS','CV','Document Management'),
		('DICBERCLS','SDOC','Documentation'),
		('DICBERCLS','KR','Drilldown reporting'),
		('DICBERCLS','DSDM','DSD Connector'),
		('DICBERCLS','DSDP','DSD Pricing Engine'),
		('DICBERCLS','DSDC','DSD Route Accounting'),
		('DICBERCLS','DSDR','DSD Transp. Planning'),
		('DICBERCLS','DSDV','DSD Visit Control'),
		('DICBERCLS','DXAD','DX Administration'),
		('DICBERCLS','ECCU','eCATT Customizing'),
		('DICBERCLS','CSS2','EC-CS: CG/CU Master'),
		('DICBERCLS','CSS1','EC-CS: Chart/Accts'),
		('DICBERCLS','CSS6','EC-CS: Cons.of Inv.'),
		('DICBERCLS','CSS8','EC-CS: Consolidation'),
		('DICBERCLS','CSS5','EC-CS: Control C5'),
		('DICBERCLS','CSS0','EC-CS: Crit. Tables'),
		('DICBERCLS','CSS4','EC-CS: Data Entry'),
		('DICBERCLS','CSSI','EC-CS: Integration'),
		('DICBERCLS','CSMD','EC-CS: Master data'),
		('DICBERCLS','CSS9','EC-CS: Other'),
		('DICBERCLS','CSS7','EC-CS: Tasks'),
		('DICBERCLS','CSS3','EC-CS: Versions'),
		('DICBERCLS','ECH','ECH Customizing'),
		('DICBERCLS','EDI0','EDI: IDOC Tables'),
		('DICBERCLS','UA','EDM: Appl. Table'),
		('DICBERCLS','US','EDM: SAP Control'),
		('DICBERCLS','UC','EDM: User Control'),
		('DICBERCLS','EGF','EGF Authorizations'),
		('DICBERCLS','CSHE','EH&S Customizing'),
		('DICBERCLS','CSHF','EH&S Master Data'),
		('DICBERCLS','EHS','EH&S Objects'),
		('DICBERCLS','EHWA','EH&S Waste Mgmt'),
		('DICBERCLS','EHSI','EH&S: IHS'),
		('DICBERCLS','EHSJ','EH&S: OH'),
		('DICBERCLS','EHSH','EH&S: OH Cust.'),
		('DICBERCLS','EHGL','EHS: Label Mgmt'),
		('DICBERCLS','EHPC','EHSM PRC Customizing'),
		('DICBERCLS','EHPD','EHSM PRC Mater Data'),
		('DICBERCLS','EHPP','EHSM PRC Password'),
		('DICBERCLS','EHME','EHSM: Emisstion Mgmt'),
		('DICBERCLS','EHMF','EHSM: Foundation'),
		('DICBERCLS','EHMI','EHSM: Incident'),
		('DICBERCLS','EHMR','EHSM: Risk Assessmt'),
		('DICBERCLS','EIS1','EIS Aspects'),
		('DICBERCLS','BVEC','Empties Cust.'),
		('DICBERCLS','OBSOLETE','Empty Tables No Longer Required'),
		('DICBERCLS','KEO','Enterprise org.'),
		('DICBERCLS','RE','Enterprise: RE'),
		('DICBERCLS','UJ','EPM BPC'),
		('DICBERCLS','UJG','EPM BPC Generated'),
		('DICBERCLS','SMW0','Error handler'),
		('DICBERCLS','J3GC','ETM - Customizing'),
		('DICBERCLS','EA','Euro - Application'),
		('DICBERCLS','EC','Euro - Customizing'),
		('DICBERCLS','ES','Euro - Systemcontrol'),
		('DICBERCLS','SWE','Event Linking'),
		('DICBERCLS','TRXA','Event Manager AI'),
		('DICBERCLS','TRXB','Event Manager Basis'),
		('DICBERCLS','TRXT','Event Manager Server'),
		('DICBERCLS','SWEC','Events Change Doc.'),
		('DICBERCLS','SWES','Events Status Mgt.'),
		('DICBERCLS','BV2C','Excise Duty Custom.'),
		('DICBERCLS','BV2D','Excse Duty Cstr Mstr'),
		('DICBERCLS','BV2M','Excse Duty Mat. Mstr'),
		('DICBERCLS','BV2K','Excse Duty Vndr Mstr'),
		('DICBERCLS','FDU','Ext. Data Transfer'),
		('DICBERCLS','SVIM','Ext. Table Maint.'),
		('DICBERCLS','FLE','Extend Fld Length'),
		('DICBERCLS','FDU7','External data tr. 7'),
		('DICBERCLS','BVWC','Extra Charge Cust.'),
		('DICBERCLS','ACIN','FI/CO Interface'),
		('DICBERCLS','FS','FI/CO: SAP Control'),
		('DICBERCLS','FC34','FI: Antic. Amnt Payt'),
		('DICBERCLS','FC03','FI: Authorizations'),
		('DICBERCLS','FC13','FI: Balance Sheet'),
		('DICBERCLS','FC23','FI: Banks'),
		('DICBERCLS','FC02','FI: Basis Tables'),
		('DICBERCLS','FC17','FI: Bill of Ex. Mgt'),
		('DICBERCLS','FC15','FI: Correspondence'),
		('DICBERCLS','FC33','FI: Countries'),
		('DICBERCLS','FC24','FI: Credit Mgt'),
		('DICBERCLS','FC00','FI: Currencies'),
		('DICBERCLS','FC22','FI: Display Variants'),
		('DICBERCLS','FC11','FI: Dunning'),
		('DICBERCLS','FC32','FI: Exchange Rates'),
		('DICBERCLS','FC25','FI: Fin. Info System'),
		('DICBERCLS','FC19','FI: FinCal'),
		('DICBERCLS','FC16','FI: Interest Calc.'),
		('DICBERCLS','FC01','FI: Org. Units'),
		('DICBERCLS','FC39','FI: Other'),
		('DICBERCLS','FC12','FI: Payment Program'),
		('DICBERCLS','FC31','FI: Posting Periods'),
		('DICBERCLS','FC14','FI: Reorganization'),
		('DICBERCLS','FS00','FI: SAP Control'),
		('DICBERCLS','FB00','FI: System'),
		('DICBERCLS','FC21','FI: Taxes'),
		('DICBERCLS','FC90','FI: User Control'),
		('DICBERCLS','FC28','FI: Workflow'),
		('DICBERCLS','FC35','FI:Antic.Amt.B.Exch.'),
		('DICBERCLS','FC41','FI:Cash Mgt.& Forcst'),
		('DICBERCLS','FCOR','FI:CashMgt&FcstOrgUn'),
		('DICBERCLS','FC27','FI:EDI Incoming Inv.'),
		('DICBERCLS','FC26','FI:Ext.Data Transfer'),
		('DICBERCLS','FC18','FI:Payment Adv.Proc.'),
		('DICBERCLS','FC04','FI:Posting Interface'),
		('DICBERCLS','FB10','FI-BA: Acct Mgmt'),
		('DICBERCLS','FB03','FI-BA: Acct/Prod.'),
		('DICBERCLS','FB16','FI-BA: Amt Authoriz.'),
		('DICBERCLS','FB15','FI-BA: Archiving'),
		('DICBERCLS','FB02','FI-BA: B.Partner'),
		('DICBERCLS','FB05','FI-BA: Central'),
		('DICBERCLS','FB07','FI-BA: Closing'),
		('DICBERCLS','FB12','FI-BA: Cnt. Settings'),
		('DICBERCLS','FB01','FI-BA: Conditions'),
		('DICBERCLS','FB08','FI-BA: Control'),
		('DICBERCLS','FB06','FI-BA: Gen.Ledger'),
		('DICBERCLS','FB14','FI-BA: In-House Bank'),
		('DICBERCLS','FB13','FI-BA: Limit Cats'),
		('DICBERCLS','FB11','FI-BA: Parall. Proc'),
		('DICBERCLS','FB04','FI-BA:Acct hierarchy'),
		('DICBERCLS','FB09','FI-BA:Means Payt Mgt'),
		('DICBERCLS','FBL1','FIBL: Control'),
		('DICBERCLS','FLOG','Field Logistics: Customizing'),
		('DICBERCLS','GA','FI-GLX: App. Table'),
		('DICBERCLS','GCOR','FI-GLX: Org. units'),
		('DICBERCLS','GS','FI-GLX: SAP Control'),
		('DICBERCLS','FKS1','FI-LC: Control K1'),
		('DICBERCLS','FKS2','FI-LC: Control K2'),
		('DICBERCLS','FKS3','FI-LC: Control K3'),
		('DICBERCLS','FKRD','FI-LC: Fin.Rpt.Tabls'),
		('DICBERCLS','FKMD','FI-LC: Master Tables'),
		('DICBERCLS','FITR','FINB: Transport'),
		('DICBERCLS','FSIF','FINS: Insrt Ldgr Aft'),
		('DICBERCLS','SMW1','Flow maintenance'),
		('DICBERCLS','FOMB','FOM: Control [SAP]'),
		('DICBERCLS','FOMA','FOM: Customizing'),
		('DICBERCLS','STSM','FP Table Maintenance'),
		('DICBERCLS','YRAE','Framew. enhancements'),
		('DICBERCLS','BPOA','FSBP: Application'),
		('DICBERCLS','BPOS','FSBP: Control'),
		('DICBERCLS','BPOC','FSBP: Customizing'),
		('DICBERCLS','U1DM','FSCM-DM: Disp.Mgmt'),
		('DICBERCLS','FSPM','FS-PM: Authorization'),
		('DICBERCLS','FTPR','FT: Basic data'),
		('DICBERCLS','FTGR','FT: Basic data - App'),
		('DICBERCLS','FTCT','FT: Con.: SLS: App.'),
		('DICBERCLS','FTCS','FT: Con.: SLS: cont.'),
		('DICBERCLS','FTDP','FT: Document print'),
		('DICBERCLS','FTEV','FT: Elect. procedure'),
		('DICBERCLS','FTCO','FT: Export Control'),
		('DICBERCLS','FTEX','FT: ExtraStat - app.'),
		('DICBERCLS','FTFD','FT: Financial doc.'),
		('DICBERCLS','FTCI','FT: Import Control'),
		('DICBERCLS','FTIM','FT: Import processng'),
		('DICBERCLS','FTIN','FT: IntraStat - app.'),
		('DICBERCLS','FTMO','FT: Market'),
		('DICBERCLS','FTDC','FT: Messages'),
		('DICBERCLS','FTPF','FT: Preference Proc.'),
		('DICBERCLS','FTUS','FT: User-Dep. Sett.'),
		('DICBERCLS','WXPH','Function Modules'),
		('DICBERCLS','KGC','Gen. Cost Collector'),
		('DICBERCLS','SHIE','Gen. Hierarchy Tool'),
		('DICBERCLS','CAGD','Ger. Tax Reduc. Law'),
		('DICBERCLS','PEGP','GPD Pegging Run Prof'),
		('DICBERCLS','SEGR','Graphics:Basis Sett.'),
		('DICBERCLS','SEGC','Graphics:Customizing'),
		('DICBERCLS','WXP7','GUI Function Codes'),
		('DICBERCLS','WXP6','GUI status'),
		('DICBERCLS','SHC','Help Center'),
		('DICBERCLS','SHOT','Hot Package Exceptn'),
		('DICBERCLS','PA','HR: Application Tab.'),
		('DICBERCLS','PCAE','HR: Argentina'),
		('DICBERCLS','PCAR','HR: Argentina'),
		('DICBERCLS','PCSA','HR: Argentina'),
		('DICBERCLS','PCAU','HR: Australia'),
		('DICBERCLS','PCAT','HR: Austria'),
		('DICBERCLS','PCBE','HR: Belgium'),
		('DICBERCLS','PCBR','HR: Brazil'),
		('DICBERCLS','PCCA','HR: Canada'),
		('DICBERCLS','PCCL','HR: Chile'),
		('DICBERCLS','PS01','HR: Compensation'),
		('DICBERCLS','PCDK','HR: Denmark'),
		('DICBERCLS','PCEG','HR: Egypt'),
		('DICBERCLS','PAXF','HR: Expert Finder'),
		('DICBERCLS','PCFI','HR: Finland'),
		('DICBERCLS','PCFR','HR: France'),
		('DICBERCLS','PCDE','HR: Germany'),
		('DICBERCLS','PSDE','HR: Germany'),
		('DICBERCLS','PCHK','HR: Hong Kong'),
		('DICBERCLS','PCIT','HR: Italy'),
		('DICBERCLS','PCJP','HR: Japan'),
		('DICBERCLS','PC06','HR: Master data'),
		('DICBERCLS','PCMX','HR: Mexico'),
		('DICBERCLS','PCNZ','HR: New Zealand'),
		('DICBERCLS','PCNO','HR: Norway'),
		('DICBERCLS','PCPT','HR: Portugal'),
		('DICBERCLS','PFDE','HR: Retir. Pension'),
		('DICBERCLS','PCRU','HR: Russia'),
		('DICBERCLS','PS','HR: SAP Control'),
		('DICBERCLS','PCSG','HR: Singapore'),
		('DICBERCLS','PC02','HR: Social Benefits'),
		('DICBERCLS','PCZA','HR: South Africa'),
		('DICBERCLS','PCES','HR: Spain'),
		('DICBERCLS','PCSE','HR: Sweden'),
		('DICBERCLS','PCCH','HR: Switzerland'),
		('DICBERCLS','PCTW','HR: Taiwan'),
		('DICBERCLS','PC04','HR: Time management'),
		('DICBERCLS','PS04','HR: Time management'),
		('DICBERCLS','PC03','HR: Travel mgmt'),
		('DICBERCLS','PCUS','HR: USA'),
		('DICBERCLS','PC','HR: User Control'),
		('DICBERCLS','PCVE','HR: Venezuela'),
		('DICBERCLS','PC01','HR:Compensation Mgmt'),
		('DICBERCLS','PC99','HR:Country-dependent'),
		('DICBERCLS','PS99','HR:Country-dependent'),
		('DICBERCLS','PADE','HR-DE: Applic. Tab'),
		('DICBERCLS','BWHL','HTTP Whitelist'),
		('DICBERCLS','BURL','Httpurlloc maintenance view editing'),
		('DICBERCLS','ADMC','ICH Data Management'),
		('DICBERCLS','IMCP','IM-FA: Customizing'),
		('DICBERCLS','IMCS','IM-FA: SAP control'),
		('DICBERCLS','IMCC','IM-FA: Summarization'),
		('DICBERCLS','SIWB','Info Workbench'),
		('DICBERCLS','IVIS','Integr. visibilility'),
		('DICBERCLS','UISS','Internal Self Srv.'),
		('DICBERCLS','JA','IS - Application'),
		('DICBERCLS','JC','IS - Customizing'),
		('DICBERCLS','JS','IS - System Control'),
		('DICBERCLS','AD05','IS-A&D view maint.'),
		('DICBERCLS','JBCO','IS-B STC costing'),
		('DICBERCLS','JBCU','IS-B STC Customizing'),
		('DICBERCLS','JBED','IS-B STC EDT'),
		('DICBERCLS','JBBA','IS-B STC non-int.pos'),
		('DICBERCLS','ISIS','IS-IS central'),
		('DICBERCLS','DARL','IS-IS: Loan'),
		('DICBERCLS','WERT','IS-IS: Securities'),
		('DICBERCLS','IAM','Issue & Acty Mgmt'),
		('DICBERCLS','JPCL','Japanese Calendar'),
		('DICBERCLS','YRAJ','Jobs'),
		('DICBERCLS','WXP8','Key figure parameter'),
		('DICBERCLS','WXPB','Key figure texts'),
		('DICBERCLS','SDOK','Knowledge Provider'),
		('DICBERCLS','SRM','LCC'),
		('DICBERCLS','LDAP','LDAP Authorization'),
		('DICBERCLS','LEC','LEFIO: Customizing'),
		('DICBERCLS','SLL','Legal Services'),
		('DICBERCLS','MCPL','LIS: Planning'),
		('DICBERCLS','MCS','LIS: Stat. Database'),
		('DICBERCLS','HTML','Maintain HTML Tags'),
		('DICBERCLS','MAPC','MAP Customizing 1'),
		('DICBERCLS','UPAR','MAP Customizing 2'),
		('DICBERCLS','TRMR','Market risk managemt'),
		('DICBERCLS','WXP5','MasterDataCheckFlds'),
		('DICBERCLS','MCMC','MC: Log. Controlling'),
		('DICBERCLS','USMD','MDG Gen. Authoriz.'),
		('DICBERCLS','MDG0','MDG: Generation'),
		('DICBERCLS','MDG1','MDG: Transport'),
		('DICBERCLS','USMA','MDGAF Authorizations'),
		('DICBERCLS','VN','Message control'),
		('DICBERCLS','WA','ML: Appl. Table'),
		('DICBERCLS','WFFP','ML: FM Parameter'),
		('DICBERCLS','LS','ML: SAP Control'),
		('DICBERCLS','WS','ML: SAP Control'),
		('DICBERCLS','LC','ML: User Control'),
		('DICBERCLS','WC','ML: User Control'),
		('DICBERCLS','LA','ML:Application Table'),
		('DICBERCLS','LB','ML:Internal appl.tab'),
		('DICBERCLS','MCOR','MM:'),
		('DICBERCLS','MA','MM: Appl. Table'),
		('DICBERCLS','MPN1','MM: Interchangeable'),
		('DICBERCLS','MPN2','MM: MPN display'),
		('DICBERCLS','MS','MM: SAP Control'),
		('DICBERCLS','MC','MM: User Control'),
		('DICBERCLS','MCMD','MM: User Dept. MRP'),
		('DICBERCLS','MCMB','MM: User Dept. Stock'),
		('DICBERCLS','MCME','MM: UserDept. Purch.'),
		('DICBERCLS','MCMR','MM: UserDept.Inv.Ver'),
		('DICBERCLS','MCMG','MM:UserDept.BasicDat'),
		('DICBERCLS','WCUS','MMS company struct.'),
		('DICBERCLS','WCGE','MMS glob. settings'),
		('DICBERCLS','SNTE','Notes on Appl. Obj.'),
		('DICBERCLS','NWBC','NW Business Client'),
		('DICBERCLS','EPM','NW EPM: Fiori Ref Apps'),
		('DICBERCLS','ODMC','ODM: Doc.Management'),
		('DICBERCLS','OA','Oil - Application'),
		('DICBERCLS','OC','Oil - Customizing'),
		('DICBERCLS','OS','Oil - System Control'),
		('DICBERCLS','SAOP','Optical Archiving'),
		('DICBERCLS','PASA','PA-AS:Cust.Authoriz.'),
		('DICBERCLS','PASC','PA-AS:Customizing'),
		('DICBERCLS','PAI1','PAi  task scheduling tables'),
		('DICBERCLS','FPP','Parallel Processing'),
		('DICBERCLS','WXPF','Param. enhancement'),
		('DICBERCLS','YRAP','Parameter tables'),
		('DICBERCLS','SPWD','Password Hash Values'),
		('DICBERCLS','BVV1','PendulLst/ContrHndlg'),
		('DICBERCLS','DSIG','PI:Digital signature'),
		('DICBERCLS','SPZ','Pizza Project'),
		('DICBERCLS','WXP4','Plan.Hierarchy Vers.'),
		('DICBERCLS','RSPL','Planning'),
		('DICBERCLS','WXP1','Planning scenario'),
		('DICBERCLS','WXP2','Planning step'),
		('DICBERCLS','WXP3','Planning Version'),
		('DICBERCLS','PWAC','PLM WUI ACC&RT Cust.'),
		('DICBERCLS','PWAS','PLM WUI ACC&RT Syst.'),
		('DICBERCLS','PW-C','PLM WUI Gen. Cust.'),
		('DICBERCLS','PW-S','PLM WUI Gen. Syst.'),
		('DICBERCLS','PMC','PM: Appl. Table'),
		('DICBERCLS','IA','PM: Application Tab.'),
		('DICBERCLS','PMO','PM: Org. Units'),
		('DICBERCLS','PMD','PM: Print Papers'),
		('DICBERCLS','PMTD','PM: Print Papers'),
		('DICBERCLS','IS','PM: SAP Control'),
		('DICBERCLS','PSC','PM: Serial No. Cust.'),
		('DICBERCLS','PSS','PM: Serial No. Syst.'),
		('DICBERCLS','PMTS','PM: System Tables'),
		('DICBERCLS','PMTC','PM: Tables Appl.'),
		('DICBERCLS','PMTO','PM: Tables Org.'),
		('DICBERCLS','IC','PM: User Control'),
		('DICBERCLS','PMS','PM: User Control'),
		('DICBERCLS','PMM0','PMMO - Customizing for MM Interface'),
		('DICBERCLS','NA','PP: Appl. Table'),
		('DICBERCLS','CL','PP: Control Data'),
		('DICBERCLS','MRP','PP: Mat.Req.Planning'),
		('DICBERCLS','CS','PP: SAP Control'),
		('DICBERCLS','NS','PP: SAP Control'),
		('DICBERCLS','NC','PP: User Control'),
		('DICBERCLS','PPFC','PPF: Customizing'),
		('DICBERCLS','PPO2','PPO: Applications'),
		('DICBERCLS','PPO1','PPO: Customizing'),
		('DICBERCLS','CCPI','PP-PI: User Control'),
		('DICBERCLS','CA','PPS: Applicatn Table'),
		('DICBERCLS','CC','PPS: User Control'),
		('DICBERCLS','WXPG','Preliminary article'),
		('DICBERCLS','POBJ','Proc.Obj.Customizing'),
		('DICBERCLS','POCM','Proc.Observer Models'),
		('DICBERCLS','HP','Process Hierarchy'),
		('DICBERCLS','POC','Process Observer'),
		('DICBERCLS','PRC','Product Customizing'),
		('DICBERCLS','PFCG_ADMIN','Profile Generator - Administration'),
		('DICBERCLS','PFCG','Profile Generator - Role Data'),
		('DICBERCLS','ACPM','Profit.Management'),
		('DICBERCLS','CNIS','Project info system'),
		('DICBERCLS','DM02','Project Master'),
		('DICBERCLS','DM03','Project User'),
		('DICBERCLS','PSSC','PS Social Services'),
		('DICBERCLS','PSIC','PS: Customizing Int.'),
		('DICBERCLS','PSR1','PS: Reporting'),
		('DICBERCLS','PSC0','PSC: Customizing'),
		('DICBERCLS','SPSE','PSE Files'),
		('DICBERCLS','GC','PY: User Control'),
		('DICBERCLS','QM-M','QM/PM: Notifications'),
		('DICBERCLS','QA','QM: Application Tab.'),
		('DICBERCLS','QM-Z','QM: Certificates'),
		('DICBERCLS','QM-U','QM: Environment'),
		('DICBERCLS','Q','QM: Other'),
		('DICBERCLS','QM-F','QM: Process-related'),
		('DICBERCLS','QM-I','QM: Quality Control'),
		('DICBERCLS','QM-L','QM: Quality Inspec.'),
		('DICBERCLS','QM-P','QM: Quality Planning'),
		('DICBERCLS','QS','QM: SAP Control'),
		('DICBERCLS','QC','QM: User Control'),
		('DICBERCLS','QAM','Quality Issue Mgmt'),
		('DICBERCLS','AQPR','Query Log'),
		('DICBERCLS','WCSD','R/3 Retail:Mstr data'),
		('DICBERCLS','IMMO','Real Estate Mgt'),
		('DICBERCLS','RLMF','Release Management'),
		('DICBERCLS','REL2','RelTool Control'),
		('DICBERCLS','REL1','RelTool Customizing'),
		('DICBERCLS','DM05','Reserved - SLO'),
		('DICBERCLS','DM06','Reserved - SLO'),
		('DICBERCLS','RTF','Retail Foundation'),
		('DICBERCLS','FA','RF: Appl. Table'),
		('DICBERCLS','FC','RF: User Control'),
		('DICBERCLS','JBR0','RM: Application'),
		('DICBERCLS','RMSB','RM: BB Stab. Study'),
		('DICBERCLS','RMCV','RM: Charac. Attr.'),
		('DICBERCLS','JBR1','RM: Current Settings'),
		('DICBERCLS','JBR2','RM: Customizing'),
		('DICBERCLS','JBRS','RM: System Tables'),
		('DICBERCLS','SAGRDIST','Role Distribution: Customizing'),
		('DICBERCLS','SA','RS: Appl. Table'),
		('DICBERCLS','SS','RS: SAP Control'),
		('DICBERCLS','SC','RS: User Control'),
		('DICBERCLS','BS','SAP control'),
		('DICBERCLS','RKC1','SAP EIS: Ctrl. Tab.'),
		('DICBERCLS','RKC3','SAP EIS: Field Catlg'),
		('DICBERCLS','RKC6','SAP EIS: Info system'),
		('DICBERCLS','RKC4','SAP EIS: Master Data'),
		('DICBERCLS','RKC2','SAP EIS:Data Transf.'),
		('DICBERCLS','SWU7','SAP Forms Proxy Add.'),
		('DICBERCLS','GT','SAP Global Trade Svs'),
		('DICBERCLS','SOBJ','SAP objects'),
		('DICBERCLS','SCOM','SAPcomm Customizing'),
		('DICBERCLS','RKC5','SAP-EIS: Key Figures'),
		('DICBERCLS','RKC7','SAP-EIS: Planning'),
		('DICBERCLS','SOAD','SAPoffice Admin'),
		('DICBERCLS','SPHO','SAPphone: Terminal'),
		('DICBERCLS','SPHA','SAPphone:System-Wide'),
		('DICBERCLS','STAC','SAPscript Tables'),
		('DICBERCLS','PRSF','SAWE: Enh. Planning'),
		('DICBERCLS','LIME','SCM: LIME Customiz.'),
		('DICBERCLS','LIMG','SCM: LIME Generat.'),
		('DICBERCLS','BDMC','SCMB Data Management'),
		('DICBERCLS','SCMS','SCMB Schedul.Custom.'),
		('DICBERCLS','SCMB','SCM-FC PMC Business'),
		('DICBERCLS','SCMP','SCM-FC PMC Business'),
		('DICBERCLS','SCMT','SCM-FC PMC Technical'),
		('DICBERCLS','CSCP','SCP Model Maint.'),
		('DICBERCLS','VA','SD: Appl. Table'),
		('DICBERCLS','VS','SD: SAP Control'),
		('DICBERCLS','VC','SD: User Control'),
		('DICBERCLS','SES','Search Eng. Service'),
		('DICBERCLS','SAL_CTEMP','Security Audit Log - Compressed Buffer'),
		('DICBERCLS','SAL_DATA','Security Audit Log - Raw Data [Critical]'),
		('DICBERCLS','SAL_TEMP','Security Audit Log - Temporary Buffer'),
		('DICBERCLS','SGT_SETUP','Segmentation Setup Authorization Group'),
		('DICBERCLS','UI','SEM-BIC'),
		('DICBERCLS','RBSC','SEM-CPM: BSC'),
		('DICBERCLS','RMB','SEM-CPM: MB'),
		('DICBERCLS','DSV','Service Assistant'),
		('DICBERCLS','/SPE','Service Parts Mgmt'),
		('DICBERCLS','0SBC','Set Country Version'),
		('DICBERCLS','FGL0','SetUp General Ledger'),
		('DICBERCLS','STSF','Smart Forms Tables'),
		('DICBERCLS','REWO','SNC Work Order'),
		('DICBERCLS','SRMC','SRM Customizing'),
		('DICBERCLS','MCAD','Statistics database'),
		('DICBERCLS','BCSV','Status Profile Maint'),
		('DICBERCLS','BSV','Status Profile Maint'),
		('DICBERCLS','BBPS','Status tracking'),
		('DICBERCLS','STAT','StatusMaint.IMG/CATT'),
		('DICBERCLS','SACF','Switchable Authorization Checks'),
		('DICBERCLS','B0SD','System Data Maint.'),
		('DICBERCLS','FITS','System travel plan.'),
		('DICBERCLS','BCTA','TabAnalys. Administr'),
		('DICBERCLS','SWHL','Tabular Positive Lists [Whitelists]'),
		('DICBERCLS','TXWC','Tax Whse Customizing'),
		('DICBERCLS','A1G1','Techn. Config. GL'),
		('DICBERCLS','BVOC','Telesales Cust.'),
		('DICBERCLS','TEMP','Temporary'),
		('DICBERCLS','ATES','Test'),
		('DICBERCLS','TTTT','Test'),
		('DICBERCLS','TGS','testgs'),
		('DICBERCLS','TFWC','TFW: Customizing'),
		('DICBERCLS','CATS','Time recording'),
		('DICBERCLS','TSDC','Time Series Data Mgt'),
		('DICBERCLS','TMOI','TM Order Integration'),
		('DICBERCLS','TMRE','TM Resource Settings'),
		('DICBERCLS','TMBF','TM: Basic Functions'),
		('DICBERCLS','TMDG','TM: Dangerous Goods'),
		('DICBERCLS','TMCF','TM: Forward. Settlmt'),
		('DICBERCLS','TMFW','TM: Forwarding Order'),
		('DICBERCLS','TMFO','TM: Freight Order'),
		('DICBERCLS','TMSF','TM: Freight Settlmnt'),
		('DICBERCLS','TMGT','TM: GTS'),
		('DICBERCLS','TMLI','TM: Logistics Integ.'),
		('DICBERCLS','TMPL','TM: Planning'),
		('DICBERCLS','TMES','TM-ERP: Settlement'),
		('DICBERCLS','TRBA','TR: Basis Functions'),
		('DICBERCLS','TRBP','TR: Business Partner'),
		('DICBERCLS','TRZ','TR: Central functns'),
		('DICBERCLS','TRDE','TR: Derivatives'),
		('DICBERCLS','TRFX','TR: Foreign exchange'),
		('DICBERCLS','TRMM','TR: Money market'),
		('DICBERCLS','TRTF','TR: Trade Finance'),
		('DICBERCLS','TRMK','TR: Volatilities'),
		('DICBERCLS','VTRX','Tracking control'),
		('DICBERCLS','STRN','Translation'),
		('DICBERCLS','FITP','Travel planning'),
		('DICBERCLS','TTRL','Trust Relationships'),
		('DICBERCLS','TXMG','TTE Tax Manager'),
		('DICBERCLS','UI2','UI Technologies'),
		('DICBERCLS','USGREP','Usage reporting'),
		('DICBERCLS','SUSR','User Master'),
		('DICBERCLS','YRAU','Utilities'),
		('DICBERCLS','BVQC','Valtd Del.Note Cust.'),
		('DICBERCLS','CNVL','Variable Lists'),
		('DICBERCLS','VSOC','Veh.Sp. Optim. Cust.'),
		('DICBERCLS','USRVETO','Veto Check During Deletion of Users'),
		('DICBERCLS','SVIR','Virus Scan'),
		('DICBERCLS','&NC&','w/o auth. group'),
		('DICBERCLS','SWN1','WF: E-Mail Notif.'),
		('DICBERCLS','SWP','WFM: Customizing'),
		('DICBERCLS','SWLC','WLC: Administration'),
		('DICBERCLS','SWLR','WLC: Remote Inbox'),
		('DICBERCLS','WMA','WM: Appl. Table'),
		('DICBERCLS','WMC1','WM: Appl. Texts'),
		('DICBERCLS','WMS','WM: SAP Control'),
		('DICBERCLS','WMC','WM: User Control'),
		('DICBERCLS','SCEA','WME Applic. Table'),
		('DICBERCLS','SCE','WME Customizing'),
		('DICBERCLS','SWS','Work Item Views'),
		('DICBERCLS','SWW','Work items'),
		('DICBERCLS','SWBRF','Workflow BRF Plus'),
		('DICBERCLS','SWFC','Workflow Customizing'),
		('DICBERCLS','SWF','Workflow Wizards'),
		('DICBERCLS','WFRL','Workflow: Roles'),
		('DICBERCLS','WCZK','WWS centr.coord.'),
		('DICBERCLS','WCKO','WWS Communication'),
		('DICBERCLS','WCDA','WWS Decentr.Proc.'),
		('DICBERCLS','WCRT','WWS General Retail'),
		('DICBERCLS','WCRS','WWS Retail Store'),
		('DICBERCLS','XIAD','XI Administration'),
		('DICBERCLS','XICO','XI: Configuration'),
		('DICBERCLS','XIPE','XI: Persist. Layer'),
		('DICBERCLS','XITR','XI: Tech. Routing'),
		('DICBERCLS','XOTA','XO: Application'),
		('DICBERCLS','XOTS','XO: Control'),
		('DICBERCLS','XOTC','XO: Customizing'),
		('FBTCH','25','Create payment media of paymen'),
		('FBTCH','15','Create payment medium proposal'),
		('FBTCH','26','Delete payment orders of payme'),
		('FBTCH','24','Delete payment run payment dat'),
		('FBTCH','14','Delete proposal'),
		('FBTCH','03','Display parameters'),
		('FBTCH','23','Display payment run'),
		('FBTCH','13','Display proposal'),
		('FBTCH','02','Edit parameters'),
		('FBTCH','12','Edit proposal'),
		('FBTCH','21','Execute payment run'),
		('FBTCH','11','Execute proposal'),
		('FBTCH','31','Print payment medium manually'),
		('GLCENTACTY','03','Archiving'),
		('GLCENTACTY','14','Clear differences'),
		('GLCENTACTY','06','Conversion'),
		('GLCENTACTY','13','Data transfer'),
		('GLCENTACTY','04','Delete transaction data'),
		('GLCENTACTY','11','Display code combinations'),
		('GLCENTACTY','09','Display integrated master data'),
		('GLCENTACTY','07','Ledger statistics'),
		('GLCENTACTY','12','Maintain code combinations'),
		('GLCENTACTY','10','Maintain integrated master data'),
		('GLCENTACTY','01','Preparation for system configuration'),
		('GLCENTACTY','02','Table installation'),
		('GLCENTACTY','05','Tools'),
		('GLCENTACTY','08','Transport'),
		('INFTY','9640','Abrechnungsergebn./Payroll Results'),
		('INFTY','0613','Absence Donation Administration  US'),
		('INFTY','0405','Absence Event'),
		('INFTY','0573','Absence for Australia PS'),
		('INFTY','0601','Absence History'),
		('INFTY','0338','Absence payment clearing PT'),
		('INFTY','0696','Absence Pools'),
		('INFTY','2006','Absence Quotas'),
		('INFTY','0572','Absence Scheme Override'),
		('INFTY','2001','Absences'),
		('INFTY','0407','Absences [Additional information]'),
		('INFTY','3229','Absences: Additional Data AR'),
		('INFTY','0618','Academic Qualification'),
		('INFTY','0000','Actions'),
		('INFTY','0707','Activation Information'),
		('INFTY','0509','Activity with Higher Rate of Pay'),
		('INFTY','0039','Add. Org. Assignment  CH'),
		('INFTY','0292','Add. Social Insurance Data [CIS]'),
		('INFTY','0234','Add. Withh. Info.  US'),
		('INFTY','0482','Addit. data family/related person'),
		('INFTY','0516','Addit. SI Data PL'),
		('INFTY','0082','Additional Abs. Data'),
		('INFTY','0302','Additional Actions'),
		('INFTY','0155','Additional administrative data [IT]'),
		('INFTY','0873','Additional Amount - Garnishment FR'),
		('INFTY','0304','Additional Basic Pay Information'),
		('INFTY','0902','Additional Data for Correspondence'),
		('INFTY','0428','Additional data on beneficiary'),
		('INFTY','0344','Additional Family      HK'),
		('INFTY','0213','additional family info'),
		('INFTY','0528','Additional family information [CN]'),
		('INFTY','0352','Additional Family Information [TW]'),
		('INFTY','0181','Additional Funds  SG'),
		('INFTY','0090','Additional Income  E'),
		('INFTY','0267','Additional Off-Cycle Payments'),
		('INFTY','0015','Additional Payments'),
		('INFTY','0829','Additional Payments'),
		('INFTY','0830','Additional Payments'),
		('INFTY','0831','Additional Payments'),
		('INFTY','0832','Additional Payments'),
		('INFTY','0833','Additional Payments'),
		('INFTY','0834','Additional Payments'),
		('INFTY','0835','Additional Payments'),
		('INFTY','0836','Additional Payments'),
		('INFTY','0837','Additional Payments'),
		('INFTY','0838','Additional Payments'),
		('INFTY','0839','Additional Payments'),
		('INFTY','0569','Additional Pension Payments [BE]'),
		('INFTY','0077','Additional Personal Data'),
		('INFTY','0557','Additional personal data'),
		('INFTY','0529','Additional Personal Data for [CN]'),
		('INFTY','3207','Additional Tax Amounts [BE]'),
		('INFTY','0464','Additional Tax Data CA'),
		('INFTY','0419','Additional tax statement info [NO]'),
		('INFTY','3210','Additional Terms of Employment [NL]'),
		('INFTY','0467','Add\'l SI Notif.Data f.Comp.Agts  A'),
		('INFTY','0199','Addl. tax deduction'),
		('INFTY','0006','Addresses'),
		('INFTY','0801','Addresses'),
		('INFTY','3202','Addresses'),
		('INFTY','0879','Adjustment Calculations [NL]'),
		('INFTY','0378','Adjustment Reasons'),
		('INFTY','0536','Administration Information [CN]'),
		('INFTY','0738','Alimony Adjustment Brazil'),
		('INFTY','0736','Alimony Brazil'),
		('INFTY','0737','Alimony Debt Brazil'),
		('INFTY','3293','Alternative Financing Requirement'),
		('INFTY','3294','Alternative Financing Requirement'),
		('INFTY','3298','Alternative Financing Requirement'),
		('INFTY','0182','Alternative Names Asia'),
		('INFTY','0158','Amounts paid by Third Parties [IT]'),
		('INFTY','0568','Anniversary Date History'),
		('INFTY','2050','Annual Calendar'),
		('INFTY','0460','Annual Cumulations'),
		('INFTY','0658','Annual remuneration PL'),
		('INFTY','0438','Annual Tax additions - SE'),
		('INFTY','4000','Applicant Actions'),
		('INFTY','4003','Applicant Activities'),
		('INFTY','4004','Applicant Activity Status'),
		('INFTY','4005','Applicant\'s Personnel Number'),
		('INFTY','4001','Applications'),
		('INFTY','0348','Appraisal & Bonus      HK'),
		('INFTY','0025','Appraisals'),
		('INFTY','0283','Archiving/Data Destruction'),
		('INFTY','0051','ASB/SPI Data'),
		('INFTY','0075','ATP Pension  DK'),
		('INFTY','2007','Attendance Quotas'),
		('INFTY','2002','Attendances'),
		('INFTY','2004','Availability'),
		('INFTY','0382','Award'),
		('INFTY','0861','Award/Decorations'),
		('INFTY','0183','Awards'),
		('INFTY','0650','BA Statements'),
		('INFTY','0009','Bank Details'),
		('INFTY','0648','Bar Point Information'),
		('INFTY','0278','Basic Data Pension Fund'),
		('INFTY','0008','Basic Pay'),
		('INFTY','0201','Basic Pension Payments CPS'),
		('INFTY','0717','Benefit point account'),
		('INFTY','0890','Benefit Point System Management JP'),
		('INFTY','0893','Benefit Point System Management JP'),
		('INFTY','0894','Benefit Point System Management JP'),
		('INFTY','0895','Benefit Point System Management JP'),
		('INFTY','0718','Benefit request'),
		('INFTY','0376','Benefits Medical Information'),
		('INFTY','0547','BIK[TAX] Infotype for Malaysia'),
		('INFTY','0233','Bilan social [Social survey]'),
		('INFTY','0744','Blacklist'),
		('INFTY','0104','Bond Denominations'),
		('INFTY','0103','Bond Purchases'),
		('INFTY','0789','Bonus Periods for Child Rear./Care'),
		('INFTY','0790','Bonuses for Child Rearing/Care'),
		('INFTY','0848','Bursary Payments SA'),
		('INFTY','0483','CAAF data clearing [IT]'),
		('INFTY','0553','Calculation of Service'),
		('INFTY','0224','Canadian Taxation'),
		('INFTY','0010','Capital Formation'),
		('INFTY','0942','Capital Payment'),
		('INFTY','0583','Car & Conveyance'),
		('INFTY','0623','Career History [Publ.Sector BE]'),
		('INFTY','0193','Carry over tax data H'),
		('INFTY','0408','CBS NL'),
		('INFTY','3231','Certific@2'),
		('INFTY','0652','Certificates of Training'),
		('INFTY','0653','Certificates to Local Authorities'),
		('INFTY','0654','Certificates to Local Authorities'),
		('INFTY','0795','Certification and Licensing'),
		('INFTY','0004','Challenge'),
		('INFTY','3225','Check Results/Training Results'),
		('INFTY','0118','Child Allowance'),
		('INFTY','0232','Child Allowance  D'),
		('INFTY','0525','Child Care'),
		('INFTY','0747','Child Data for ZfA Bonus Applicatn'),
		('INFTY','0617','Clinical Details'),
		('INFTY','0671','COBRA Flexible Spending Accounts'),
		('INFTY','0212','COBRA Health Plans'),
		('INFTY','0270','COBRA Payments'),
		('INFTY','0211','COBRA-Qualified Beneficiary'),
		('INFTY','0748','Command and Delegation'),
		('INFTY','0750','Command and Delegation'),
		('INFTY','0105','Communication'),
		('INFTY','0058','Commuter Rate  A'),
		('INFTY','0127','Commuter Traffic  NL'),
		('INFTY','0559','Commuting allowance Info JP'),
		('INFTY','0442','Company Car'),
		('INFTY','0225','Company Car Unavail. GB'),
		('INFTY','0222','Company Cars      GB'),
		('INFTY','0035','Company Instructions'),
		('INFTY','0026','Company Insurance'),
		('INFTY','0268','Company Loans     JP'),
		('INFTY','0053','Company Pension'),
		('INFTY','0046','Company Pension Fund CH'),
		('INFTY','0120','Company pension fund transaction CH'),
		('INFTY','0751','Company Pension Plan AT'),
		('INFTY','0380','Compensation Adjustment'),
		('INFTY','0383','Compensation Component'),
		('INFTY','0381','Compensation Eligibility'),
		('INFTY','0760','Compensation Eligibility Override'),
		('INFTY','0384','Compensation Package'),
		('INFTY','0706','Compensation Package Offer'),
		('INFTY','0759','Compensation Process'),
		('INFTY','0758','Compensation Program'),
		('INFTY','0243','Completive Data Absence'),
		('INFTY','0255','Completive Data Absence  SK'),
		('INFTY','0192','Construction Pay: Assignment'),
		('INFTY','0191','Construction Pay: Expenses'),
		('INFTY','0189','Construction Pay: Funds Procedure'),
		('INFTY','0190','Construction Pay: Previous ER'),
		('INFTY','0349','Cont/Ent Eligibility   HK'),
		('INFTY','0016','Contract Elements'),
		('INFTY','0343','Contract Elements      HK'),
		('INFTY','0109','Contract Elements [BE]'),
		('INFTY','0935','Contract Elements [BG]'),
		('INFTY','3211','Contract Elements [CN]'),
		('INFTY','0622','Contract Elements [Publ. Sector BE]'),
		('INFTY','0574','Contract Elements Austria PS'),
		('INFTY','3224','Contract Termination [CN]'),
		('INFTY','0859','Contracts for tempolary workers PL'),
		('INFTY','0657','Contracts of order  PL'),
		('INFTY','0398','Contractual Elements             BR'),
		('INFTY','0346','Contribution Plan      HK'),
		('INFTY','0164','Contributions H'),
		('INFTY','0034','Corporate Function'),
		('INFTY','3533','Corporate Pension Mgmt [CN]'),
		('INFTY','0441','Corrections for reports H'),
		('INFTY','0027','Cost Distribution'),
		('INFTY','0511','Cost-of-living allowance/amount'),
		('INFTY','0351','Country Information'),
		('INFTY','0806','Course Data'),
		('INFTY','0070','Court Orders  GB'),
		('INFTY','0215','CP: Transaction Data'),
		('INFTY','0186','CPF'),
		('INFTY','0236','Credit Plans'),
		('INFTY','0475','Customer Program'),
		('INFTY','0204','DA/DS Statistics  DK'),
		('INFTY','0567','Data Container'),
		('INFTY','0439','Data Transfer Information'),
		('INFTY','0041','Date Specifications'),
		('INFTY','0393','Datos familia: Ayuda escolar     AR'),
		('INFTY','0394','Datos familia: información adic. AR'),
		('INFTY','0889','DB & EPF Plan Data Management JP'),
		('INFTY','0754','Declaration of Interest in Business'),
		('INFTY','0752','Declaration of Land/Houses/Property'),
		('INFTY','0755','Declaration of Non-Indebtedness'),
		('INFTY','0756','Declaration of Non-Indebtedness'),
		('INFTY','0757','Declaration of Non-Indebtedness'),
		('INFTY','0753','Declaration of Shares'),
		('INFTY','3223','Deduction [TW]'),
		('INFTY','0165','Deduction Limits'),
		('INFTY','0166','Deduction Limits'),
		('INFTY','0119','Definition of child allow.[pre1996]'),
		('INFTY','0968','Delt@'),
		('INFTY','0974','Delt@'),
		('INFTY','0397','Dependents                       BR'),
		('INFTY','0710','Details on Global Assignment'),
		('INFTY','0708','Details on Global Commuting'),
		('INFTY','0427','Deudas por órden jurídica México'),
		('INFTY','0020','DEUEV'),
		('INFTY','0341','DEUEV Start'),
		('INFTY','0735','Dimona Declaration [BE]'),
		('INFTY','0333','Disability PT'),
		('INFTY','0604','Disability SI'),
		('INFTY','0545','Disciplinary measure'),
		('INFTY','0743','Discipline'),
		('INFTY','0124','Disruptive Factor D'),
		('INFTY','0465','Documents'),
		('INFTY','0702','Documents'),
		('INFTY','0290','Documents and Certificates [CIS]'),
		('INFTY','0703','Documents on Dependants'),
		('INFTY','0858','Donation Expense'),
		('INFTY','0697','Drug Screening'),
		('INFTY','0796','Duty Assignments'),
		('INFTY','0022','Education'),
		('INFTY','0936','Education [BG]'),
		('INFTY','0493','Education [PS-SG]'),
		('INFTY','0980','Education and Training Costs CH'),
		('INFTY','0998','Education and Training Costs CH'),
		('INFTY','0866','Education PL'),
		('INFTY','0607','Education SI'),
		('INFTY','0358','EE Welfare Fund [TW]'),
		('INFTY','0633','EEO/Grievance Case Management'),
		('INFTY','0139','EE\'s Applicant No.'),
		('INFTY','0816','EIC Authentication'),
		('INFTY','0700','Electronic Data Exchange'),
		('INFTY','0850','Eligible Termination Payment - AU'),
		('INFTY','0356','Empl. Stab. Fund [TW]'),
		('INFTY','0321','Employee Accommodations'),
		('INFTY','9222','Employee Approval'),
		('INFTY','3226','Employee Dependents Assoc. [CL]'),
		('INFTY','2010','Employee Remuneration Info'),
		('INFTY','2501','Employee Time and Labor Data'),
		('INFTY','0196','Employees Provident Fund'),
		('INFTY','0197','Employees\' Social Security'),
		('INFTY','0711','Employer number'),
		('INFTY','0600','Employer Statement'),
		('INFTY','0294','Employment Book [CIS]'),
		('INFTY','0217','Employment contract: addit. data'),
		('INFTY','0480','Enhancement: Contracts Processing'),
		('INFTY','0323','Entitlement Group Type CPS'),
		('INFTY','0883','Entitlement Periods'),
		('INFTY','0347','Entitlement Plan       HK'),
		('INFTY','0202','Entitlements CPS'),
		('INFTY','0619','Equity and Diversity'),
		('INFTY','0655','ESS Settings Remuneration Statement'),
		('INFTY','0875','Events - My Simplification'),
		('INFTY','0876','Events - My Simplification'),
		('INFTY','0277','Exceptions - SE'),
		('INFTY','0941','Exclude Contract from Chargeback'),
		('INFTY','0409','Execution of Employee Insurances'),
		('INFTY','0410','Execution of Employee Insurances'),
		('INFTY','0512','Exemption Cert. Part-Time Employee'),
		('INFTY','0582','Exemptions'),
		('INFTY','0396','Expatriation'),
		('INFTY','0881','Expense Information'),
		('INFTY','0415','Export Status'),
		('INFTY','0151','External Insurance  SA'),
		('INFTY','0395','External Organizational Assignment'),
		('INFTY','0219','External Organizations'),
		('INFTY','0665','External Pension Rights'),
		('INFTY','0011','External Transfers'),
		('INFTY','0579','External Wage Components'),
		('INFTY','3894','Factoring Information BPO'),
		('INFTY','0430','Fam. Allowance for Processing'),
		('INFTY','0148','Family  JP'),
		('INFTY','0264','Family  NL'),
		('INFTY','0540','Family / Related Person'),
		('INFTY','0306','Family add.'),
		('INFTY','0187','Family Add. [TH]'),
		('INFTY','0043','Family Allowance  A'),
		('INFTY','0160','Family allowance [IT]'),
		('INFTY','0288','Family CH'),
		('INFTY','0563','Family Data Croatia'),
		('INFTY','0021','Family Member/Dependents'),
		('INFTY','0318','Family view Indonesia'),
		('INFTY','0138','Family/Rel. Person [BE]'),
		('INFTY','0106','Family/Related Person'),
		('INFTY','0595','Family-Related Bonuses'),
		('INFTY','0463','Federal Tax CA'),
		('INFTY','0724','Financing Status'),
		('INFTY','0042','Fiscal Data  A'),
		('INFTY','0038','Fiscal Data  CH'),
		('INFTY','0012','Fiscal Data  D'),
		('INFTY','0072','Fiscal Data  DK'),
		('INFTY','0060','Fiscal Data  NL'),
		('INFTY','0062','Fiscal Data  S'),
		('INFTY','0101','Fiscal Data [BE]'),
		('INFTY','0518','Fiscal statement [RO]'),
		('INFTY','0897','Flexible Benefits [NL]'),
		('INFTY','0172','Flexible Spending Account Claims'),
		('INFTY','0170','Flexible Spending Accounts'),
		('INFTY','0471','Flight Preference'),
		('INFTY','0672','FMLA Event'),
		('INFTY','0725','Foreign Income SA'),
		('INFTY','0729','Foreign Income SA'),
		('INFTY','0730','Foreign Income SA'),
		('INFTY','0731','Foreign Income SA'),
		('INFTY','0646','FVP'),
		('INFTY','0137','Garn. Compensation  A'),
		('INFTY','0117','Garn. Compensation  D'),
		('INFTY','0133','Garn. Interest  A'),
		('INFTY','0136','Garn. Transfer  A'),
		('INFTY','0116','Garn. Transfer  D'),
		('INFTY','0216','Garnish. Adjustment'),
		('INFTY','0113','Garnish. Interest  D'),
		('INFTY','0125','Garnishment [BE]'),
		('INFTY','3235','Garnishment [CL]'),
		('INFTY','3236','Garnishment [CL]'),
		('INFTY','0272','Garnishment [F]'),
		('INFTY','0134','Garnishment Amount A'),
		('INFTY','0114','Garnishment Amount D'),
		('INFTY','0132','Garnishment Claim  A'),
		('INFTY','0112','Garnishment Claim  D'),
		('INFTY','0308','Garnishment correction H'),
		('INFTY','0194','Garnishment Document'),
		('INFTY','0296','Garnishment Documents [CIS]'),
		('INFTY','0195','Garnishment Order'),
		('INFTY','0295','Garnishment Orders [CIS]'),
		('INFTY','0115','Garnishment Wages  D'),
		('INFTY','0131','Garnishment/Cession'),
		('INFTY','0111','Garnishment/Cession  D'),
		('INFTY','0066','Garnishment/Cession CA'),
		('INFTY','0067','Garnishment: Claim CA'),
		('INFTY','0068','Garnishment: Compensation CA'),
		('INFTY','0200','Garnishments  DK'),
		('INFTY','0275','Garnishments - SE'),
		('INFTY','0276','Garnishments - SE'),
		('INFTY','0887','Garnishments [ES]'),
		('INFTY','0228','Garnishments Finland'),
		('INFTY','0226','Garnishments H'),
		('INFTY','0478','Garnishments: Adjustment'),
		('INFTY','0477','Garnishments: Debt'),
		('INFTY','0612','Garnishments: Interest'),
		('INFTY','0611','Garnishments: Management Data'),
		('INFTY','0476','Garnishments: Order'),
		('INFTY','0433','GB View for Bank Details'),
		('INFTY','0281','GB View for Beneficial Loans'),
		('INFTY','0280','GB View for Contractual Elements'),
		('INFTY','0434','GB view for External Transfers'),
		('INFTY','0647','GBA'),
		('INFTY','0171','General Benefits Information'),
		('INFTY','0787','General Data Child Rearing/Care'),
		('INFTY','0374','General Eligibility'),
		('INFTY','0345','General Tax            HK'),
		('INFTY','0123','Germany only'),
		('INFTY','0537','Going Abroad Information [CN]'),
		('INFTY','0102','Grievances NA'),
		('INFTY','0514','Hand out materials [WC record] H'),
		('INFTY','0375','HCE Information'),
		('INFTY','0742','HDB Concession'),
		('INFTY','0423','HDMF Philippines'),
		('INFTY','0615','HE Contract Data'),
		('INFTY','0624','HE Professional Qualifications'),
		('INFTY','0625','HE Professional Qualifications'),
		('INFTY','0386','Health Insurance Ireland'),
		('INFTY','0167','Health Plans'),
		('INFTY','3205','Heavy Labor Position A'),
		('INFTY','3206','Heavy Labor Position A'),
		('INFTY','0614','HESA Master Data'),
		('INFTY','0616','HESA Submitted Data'),
		('INFTY','0813','Historical Additional Fees A'),
		('INFTY','0814','Historical Additional Fees A'),
		('INFTY','0505','Holiday Certificate [BE]'),
		('INFTY','9500','Home work center'),
		('INFTY','0805','Honors'),
		('INFTY','0472','Hotel Preference'),
		('INFTY','0554','Hourly Rate per Assignment'),
		('INFTY','0581','Housing[HRA / CLA / COA]'),
		('INFTY','0425','IJSS Summary [F]'),
		('INFTY','3248','Illess Reporting from ELDA A'),
		('INFTY','3249','Illness Reporting: Conditions [NL]'),
		('INFTY','3250','Illness Reporting: Details [NL]'),
		('INFTY','3260','Illness Reporting: Details [NL]'),
		('INFTY','3261','Illness Reporting: Details [NL]'),
		('INFTY','3262','Illness Reporting: Details [NL]'),
		('INFTY','3263','Illness Reporting: Details [NL]'),
		('INFTY','3264','Illness Reporting: Details [NL]'),
		('INFTY','3265','Illness Reporting: Details [NL]'),
		('INFTY','0390','Impto.Ganancias: Deducciones     AR'),
		('INFTY','0391','Impto.Ganancias: Otro empleador  AR'),
		('INFTY','0389','Impuesto a las Ganancias         AR'),
		('INFTY','0782','Imputation of Add. Pension Payments'),
		('INFTY','0326','Imputation of Pension'),
		('INFTY','0659','INAIL Management'),
		('INFTY','0660','INAIL Management'),
		('INFTY','0661','INAIL Management'),
		('INFTY','0584','Income From Other Sources'),
		('INFTY','0938','Income from previous/others ER [BG]'),
		('INFTY','0781','Income from Wages Amount'),
		('INFTY','0780','Income from Wages Employer'),
		('INFTY','0399','Income Tax'),
		('INFTY','0531','Income Tax [CN]'),
		('INFTY','0353','Income Tax [TW]'),
		('INFTY','0817','Income Tax Withholding Variation-AU'),
		('INFTY','0818','Income Tax Withholding Variation-AU'),
		('INFTY','0827','Income Tax Withholding Variation-AU'),
		('INFTY','0906','Increase in Basic Salary'),
		('INFTY','3270','Indemnity Definition [BE]'),
		('INFTY','3271','Indemnity Payment [BE]'),
		('INFTY','0513','Indiv. data [working clothes] H'),
		('INFTY','0589','Individual Reimbursements'),
		('INFTY','0279','Individual Values Pension Fund'),
		('INFTY','0908','Info. about Annual Income Check'),
		('INFTY','0370','INFONAVIT Loan'),
		('INFTY','0705','Information on Checklists'),
		('INFTY','0704','Information on Dependants'),
		('INFTY','0784','Inquiry Family Court'),
		('INFTY','0162','Ins. Y.E.T.A. Data  JP'),
		('INFTY','0882','Insurability Basic Data'),
		('INFTY','0884','Insurability Calculation'),
		('INFTY','0037','Insurance'),
		('INFTY','0519','Insurance and Tax data [RO]'),
		('INFTY','0168','Insurance Plans'),
		('INFTY','0253','Insurance premium       SK'),
		('INFTY','0153','Insurance premium CZ'),
		('INFTY','0372','Integrated daily wage'),
		('INFTY','0032','Internal Data'),
		('INFTY','0028','Internal Medical Service'),
		('INFTY','0309','IRD Nbr New Zealand'),
		('INFTY','0161','IRS Limits USA'),
		('INFTY','0435','ITF ADP 309 Free Format'),
		('INFTY','0436','ITF ADP 409 Free Format'),
		('INFTY','0242','Jamsostek Insurance Indonesia'),
		('INFTY','0783','Job Index'),
		('INFTY','0354','Labor Insurance [TW]'),
		('INFTY','0311','Leave Balance Adj'),
		('INFTY','0005','Leave Entitlement'),
		('INFTY','0083','Leave Entitlement Compensation'),
		('INFTY','0312','Leave History Adj'),
		('INFTY','0074','Leave Processing  DK'),
		('INFTY','0488','Leave Scheme'),
		('INFTY','3203','Leaving'),
		('INFTY','3246','Legal Hold'),
		('INFTY','0502','Letter of appointment'),
		('INFTY','0143','Life/General Ins. JP'),
		('INFTY','0261','Loading Leave Aust.'),
		('INFTY','0698','Loan master to supplement for KR'),
		('INFTY','0078','Loan Payments'),
		('INFTY','0373','Loan Repayment JP'),
		('INFTY','0214','Loan Supplement Denmark'),
		('INFTY','0045','Loans'),
		('INFTY','0590','Long term reimbursements'),
		('INFTY','0762','LTI Exercising'),
		('INFTY','0761','LTI Granting'),
		('INFTY','0763','LTI Participant Data'),
		('INFTY','0712','Main Personnel Assignment'),
		('INFTY','9223','Manager Approval'),
		('INFTY','0800','Material Assignment'),
		('INFTY','3003','Materials Management'),
		('INFTY','3140','Materials Management'),
		('INFTY','0977','Maternity Pay'),
		('INFTY','0080','Maternity Protection/Parental Leave'),
		('INFTY','0862','Medical Check'),
		('INFTY','0812','Medical Expense for DME'),
		('INFTY','0057','Membership Fees'),
		('INFTY','0218','Membership to insurance'),
		('INFTY','0362','Membership view Indonesia'),
		('INFTY','0081','Military Service'),
		('INFTY','0555','Military service'),
		('INFTY','0486','Military Service [PS-SG]'),
		('INFTY','0404','Military Service [TW]'),
		('INFTY','0377','Miscellaneous Plans'),
		('INFTY','0899','Mobility'),
		('INFTY','0019','Monitoring of Tasks'),
		('INFTY','2051','Monthly Calendar'),
		('INFTY','0458','Monthly Cumulations'),
		('INFTY','0815','Multiple Checks in One Cycle'),
		('INFTY','0797','Municipal Tax A'),
		('INFTY','0799','Municipal Tax A'),
		('INFTY','0976','Municipal Tax per Person'),
		('INFTY','0355','National Health Insurance [TW]'),
		('INFTY','0069','National Ins.  GB'),
		('INFTY','0656','Nature of Actions'),
		('INFTY','0368','No longer used'),
		('INFTY','0591','Nominations'),
		('INFTY','0330','Non-Monetary Remuneration'),
		('INFTY','3230','Non-Recurring Payments PA-PF-CH'),
		('INFTY','0269','Not used at present'),
		('INFTY','0128','Notifications'),
		('INFTY','0958','NPO Additional Contract Elements'),
		('INFTY','0959','NPO Additional Family Data'),
		('INFTY','0963','NPO Agency for Loan or Secondment'),
		('INFTY','3244','NPO City of Residence'),
		('INFTY','0965','NPO Education Grant'),
		('INFTY','0960','NPO Mobility and Hardship Allowance'),
		('INFTY','0961','NPO Pension Funds'),
		('INFTY','0964','NPO Personal Numbers'),
		('INFTY','0962','NPO Rental Subsidy'),
		('INFTY','0040','Objects on Loan'),
		('INFTY','0320','Official Housing'),
		('INFTY','0571','Offshore Social Security   GB'),
		('INFTY','0570','Offshore Tax   GB'),
		('INFTY','3228','Online Selection'),
		('INFTY','0426','Orden jurídica México'),
		('INFTY','0792','Organizational Additional Data'),
		('INFTY','0001','Organizational Assignment'),
		('INFTY','0880','Organizational Assignment'),
		('INFTY','0293','Other and Previous Employers [CIS]'),
		('INFTY','0501','Other Social Insurance Data'),
		('INFTY','0588','Other Statutory Deductions'),
		('INFTY','0235','Other Taxes  US'),
		('INFTY','0575','Other/Prev. ERs Croatia'),
		('INFTY','0023','Other/Previous Employers'),
		('INFTY','0634','Other/Previous Employers'),
		('INFTY','0635','Other/Previous Employers'),
		('INFTY','0636','Other/Previous Employers'),
		('INFTY','0637','Other/Previous Employers'),
		('INFTY','0638','Other/Previous Employers'),
		('INFTY','0639','Other/Previous Employers'),
		('INFTY','0640','Other/Previous Employers'),
		('INFTY','0641','Other/Previous Employers'),
		('INFTY','0642','Other/Previous Employers'),
		('INFTY','0643','Other/Previous Employers'),
		('INFTY','0644','Other/Previous Employers'),
		('INFTY','0645','Other/Previous Employers'),
		('INFTY','0885','Other/Previous Employers'),
		('INFTY','0904','Override Garnishable Amount D'),
		('INFTY','0905','Override Garnishable Amount D'),
		('INFTY','0560','Overseas pay  JP'),
		('INFTY','2005','Overtime'),
		('INFTY','0630','PAISY: Other Information'),
		('INFTY','0629','PAISY: P5 [Payroll Acct Carried]'),
		('INFTY','0631','PAISY: USA 15 [Garnishment]'),
		('INFTY','0628','PAISY: USA 21 [Spec. Date Function]'),
		('INFTY','0597','Part-Time Work/Alternative Task'),
		('INFTY','0598','Part-Time Work/Alternative Task'),
		('INFTY','0534','Party Information [CN]'),
		('INFTY','0178','Paying office H'),
		('INFTY','3238','Payment After Leaving A'),
		('INFTY','0793','Payment Made in Error GB'),
		('INFTY','0303','Payment Reductions [NL]'),
		('INFTY','0626','Payment Summary'),
		('INFTY','0849','Payment Summary Australia'),
		('INFTY','3348','Payment Summary FE Australia'),
		('INFTY','3359','Payment Summary FE Australia'),
		('INFTY','0527','Payment Upon Leaving A'),
		('INFTY','0723','Payroll for GE: Retro. Accounting'),
		('INFTY','0722','Payroll for Global Employees'),
		('INFTY','3239','Payroll Infotype for Japan'),
		('INFTY','3243','Payroll Infotype for Japan'),
		('INFTY','0491','Payroll Outsourcing'),
		('INFTY','0402','Payroll Results'),
		('INFTY','9220','Payroll Results'),
		('INFTY','9390','Payroll Results'),
		('INFTY','9402','Payroll Results'),
		('INFTY','9901','Payroll Results'),
		('INFTY','0403','Payroll Results 2'),
		('INFTY','0221','Payroll Results Adjustment'),
		('INFTY','0003','Payroll Status'),
		('INFTY','0496','Payroll US Benefits data'),
		('INFTY','0497','Payroll US Benefits data MTD'),
		('INFTY','0498','Payroll US Benefits data QTD'),
		('INFTY','0499','Payroll US Benefits data YTD'),
		('INFTY','0446','Payroll US Fed Taxes'),
		('INFTY','0447','Payroll US Fed Taxes MTD'),
		('INFTY','0448','Payroll US Fed Taxes QTD'),
		('INFTY','0449','Payroll US Fed Taxes YTD'),
		('INFTY','0454','Payroll US Local Taxes'),
		('INFTY','0455','Payroll US Local Taxes MTD'),
		('INFTY','0456','Payroll US Local Taxes QTD'),
		('INFTY','0457','Payroll US Local Taxes YTD'),
		('INFTY','0450','Payroll US State Taxes'),
		('INFTY','0451','Payroll US State Taxes MTD'),
		('INFTY','0452','Payroll US State Taxes QTD'),
		('INFTY','0453','Payroll US State Taxes YTD'),
		('INFTY','0578','PBS Accumulator Correction'),
		('INFTY','0979','Pension A'),
		('INFTY','0504','Pension Advantage [BE]'),
		('INFTY','0978','Pension Contribution A'),
		('INFTY','0785','Pension Equalization Payment'),
		('INFTY','0071','Pension Funds  GB'),
		('INFTY','0406','Pension Information'),
		('INFTY','0322','Pension Payments'),
		('INFTY','0699','Pension Provision Act'),
		('INFTY','0811','Pension references [UA]'),
		('INFTY','3274','Pension Return APG [NL]'),
		('INFTY','3275','Pension Return APG [NL]'),
		('INFTY','0621','Pension/handicap'),
		('INFTY','0203','Pension/Valuation Status BAV'),
		('INFTY','0503','Pensioner Definition [BE]'),
		('INFTY','0794','Pensioner Message A'),
		('INFTY','3213','Pensions'),
		('INFTY','3214','Pensions'),
		('INFTY','0110','Pensions  NL'),
		('INFTY','0361','Pensions Ireland'),
		('INFTY','0620','Pensions/Challenged pers.CZ'),
		('INFTY','0788','Periods for Child Rearing/Care'),
		('INFTY','0764','Permanent Disability Benefit Act NL'),
		('INFTY','0768','Permanent Disability Benefit Act NL'),
		('INFTY','0769','Permanent Disability Benefit Act NL'),
		('INFTY','0770','Permanent Disability Benefit Act NL'),
		('INFTY','0771','Permanent Disability Benefit Act NL'),
		('INFTY','0772','Permanent Disability Benefit Act NL'),
		('INFTY','0773','Permanent Disability Benefit Act NL'),
		('INFTY','0774','Permanent Disability Benefit Act NL'),
		('INFTY','0775','Permanent Disability Benefit Act NL'),
		('INFTY','0776','Permanent Disability Benefit Act NL'),
		('INFTY','0147','Pers. Appraisals  JP'),
		('INFTY','0709','Person ID'),
		('INFTY','0002','Personal Data'),
		('INFTY','0539','Personal Data'),
		('INFTY','0342','Personal Data          HK'),
		('INFTY','0108','Personal Data [BE]'),
		('INFTY','0562','Personal Data Croatia'),
		('INFTY','0804','Personal Features'),
		('INFTY','0533','Personal File Management [CN]'),
		('INFTY','0185','Personal IDs'),
		('INFTY','3208','Personal IDs JP'),
		('INFTY','2500','Personal Work Schedule Times'),
		('INFTY','0298','Personnel Orders [CIS]'),
		('INFTY','0541','Personnel tax status'),
		('INFTY','0145','Personnel Tax Status JP'),
		('INFTY','0596','PhilHealth Philippines'),
		('INFTY','3200','Plan Flexible Benefit [NL]'),
		('INFTY','0007','Planned Working Time'),
		('INFTY','0666','Planning of Pers. Costs'),
		('INFTY','0429','Position in PS'),
		('INFTY','0030','Powers of Attorney'),
		('INFTY','0874','Predetermination PAYE and NIC Adjus'),
		('INFTY','0888','Pre-paid & DC Plan Management JP'),
		('INFTY','0401','Prestaciones/Antigüedad'),
		('INFTY','0055','Previous Employer  A'),
		('INFTY','0093','Previous Employers  D'),
		('INFTY','0937','Previous Employers [BG]'),
		('INFTY','0305','Previous Employers [IT]'),
		('INFTY','3542','Previous Employers KR'),
		('INFTY','3743','Previous Employers KR'),
		('INFTY','0694','Previous Employment Details'),
		('INFTY','0695','Previous Employment Details'),
		('INFTY','0363','Previous Employment Period'),
		('INFTY','0580','Previous Employment Tax Details'),
		('INFTY','0244','Previous ER           CZ'),
		('INFTY','0256','Previous ER           SK'),
		('INFTY','0508','Prior Service'),
		('INFTY','0319','Private Insurances Indonesia'),
		('INFTY','0073','Private Pension  DK'),
		('INFTY','0337','Prof.Classificat. PT'),
		('INFTY','0098','Profit Sharing  F'),
		('INFTY','0535','Project & Achievement [CN]'),
		('INFTY','0144','Property Accum. Sav. JP'),
		('INFTY','0366','Provident Fund   TH'),
		('INFTY','0587','Provident Fund Contribution'),
		('INFTY','0462','Provincial Tax CA'),
		('INFTY','0360','PRSI Ireland'),
		('INFTY','0530','Public Housing Fund [CN]'),
		('INFTY','0592','Public Sector - Foreign Service'),
		('INFTY','0901','Purchasing Data'),
		('INFTY','0024','Qualifications'),
		('INFTY','0459','Quarterly Cumulations'),
		('INFTY','3290','Query Court CPS'),
		('INFTY','2013','Quota Corrections'),
		('INFTY','2502','Quota Statuses'),
		('INFTY','0440','Receipts & Misc. Information  HK'),
		('INFTY','0014','Recurring Payments/Deductions'),
		('INFTY','0049','Red. Hrs/Seasonal Red. Hrs'),
		('INFTY','3232','Reduced Hours A'),
		('INFTY','0786','Reduction of Pension Equaliz. Paymt'),
		('INFTY','0031','Reference Personnel Numbers'),
		('INFTY','0121','RefPerNo Priority'),
		('INFTY','0177','Registration of Country of Birth'),
		('INFTY','0593','Rehabilitants'),
		('INFTY','0896','Reimbursement ADSE'),
		('INFTY','0909','Reimbursement of Overpayment [USA]'),
		('INFTY','0846','Reimbursements'),
		('INFTY','0847','Reimbursements'),
		('INFTY','0473','Rental Car Preference'),
		('INFTY','3233','Reserve Basis A'),
		('INFTY','3234','Reserve Basis A'),
		('INFTY','0412','Reserved PL'),
		('INFTY','0094','Residence Status'),
		('INFTY','0142','Residence Tax  JP'),
		('INFTY','0207','Residence Tax Area'),
		('INFTY','0184','Resume Texts'),
		('INFTY','0371','Retenciones en otros empleos'),
		('INFTY','3204','Retirement Allowance'),
		('INFTY','0903','Retirement Benefit Resource Mgmt JP'),
		('INFTY','0495','Retirement Benefits/Death Gratuity'),
		('INFTY','3538','Retirement Pension Plan Mgmt KR'),
		('INFTY','0602','Retirement Plan Cumulations'),
		('INFTY','0565','Retirement Plan Valuation Results'),
		('INFTY','0262','Retroactive accounting'),
		('INFTY','0263','Salary conversion'),
		('INFTY','0900','Sales Data'),
		('INFTY','0802','Sanctions / Offense'),
		('INFTY','0860','Sanctions / Offense'),
		('INFTY','0357','Saving Plan [TW]'),
		('INFTY','0169','Savings Plans'),
		('INFTY','0854','Savings Schemes'),
		('INFTY','0198','Schedular Deduction Tax'),
		('INFTY','0586','Section 80 C Deductions'),
		('INFTY','0585','Section 80 Deductions'),
		('INFTY','0487','Security/ Medical Clearance'),
		('INFTY','0392','Seguridad Social                 AR'),
		('INFTY','0632','Semiretirement A'),
		('INFTY','0662','Semiretirement A - Notif. Supplmnts'),
		('INFTY','0521','Semiretirement D'),
		('INFTY','0092','Seniority  E'),
		('INFTY','0777','Seniority & Notice Information'),
		('INFTY','0778','Seniority & Notice Information'),
		('INFTY','0159','Seniority [IT]'),
		('INFTY','0576','Seniority for Promotion'),
		('INFTY','0803','Seniority Ranked List'),
		('INFTY','0538','Separation payment'),
		('INFTY','0851','Shukko Cost Charging'),
		('INFTY','0852','Shukko Cost Charging Adjustment'),
		('INFTY','0853','Shukko External Org. Assignment'),
		('INFTY','0079','SI Additional Ins.  D'),
		('INFTY','0140','SI Basic Data  JP'),
		('INFTY','0651','SI Carrier Certificates'),
		('INFTY','0286','SI child additional data H'),
		('INFTY','0287','SI child contingent H'),
		('INFTY','0515','SI Data PL'),
		('INFTY','0367','SI Notification Supplements A'),
		('INFTY','0141','SI Premium Data  JP'),
		('INFTY','0056','Sickness Certificates  A'),
		('INFTY','0329','Sideline Job'),
		('INFTY','0284','SI-entitlement H'),
		('INFTY','0437','Simultaneous Jobs'),
		('INFTY','0285','SI-services accounting H'),
		('INFTY','0088','SMP/SAP/SPP GB'),
		('INFTY','0063','Social Ins. Funds  NL'),
		('INFTY','0400','Social Insurance'),
		('INFTY','0543','Social insurance'),
		('INFTY','0100','Social Insurance  [BE]'),
		('INFTY','0044','Social Insurance  A'),
		('INFTY','0013','Social Insurance  D'),
		('INFTY','0064','Social Insurance  F'),
		('INFTY','0059','Social Insurance  NL'),
		('INFTY','0061','Social Insurance  S'),
		('INFTY','0150','Social Insurance  SA'),
		('INFTY','0649','Social Insurance [Publ. Sector BE]'),
		('INFTY','0036','Social Insurance CH'),
		('INFTY','0206','Social Insurance Info. Finland'),
		('INFTY','0544','Social insurance premium'),
		('INFTY','0532','Social Insurance[CN]'),
		('INFTY','0365','Social Security  TH'),
		('INFTY','0369','Social Security Data'),
		('INFTY','0154','Social Security data [IT]'),
		('INFTY','0422','Social Security Philippines'),
		('INFTY','0332','Social Security PT'),
		('INFTY','0135','Spec. Garn. Cond.  A'),
		('INFTY','0317','Spec. Provisions NL'),
		('INFTY','3212','Special Payment [CN]'),
		('INFTY','0265','Special Regulations'),
		('INFTY','0421','Special remunerations [IT]'),
		('INFTY','0084','SSP Control  GB'),
		('INFTY','0086','SSP/SMP Exclusions GB'),
		('INFTY','0085','SSP1[L] Form Data GB'),
		('INFTY','0490','Staff Suggestion'),
		('INFTY','0494','Staff Suggestion Scheme - Evaluator'),
		('INFTY','0485','Stage'),
		('INFTY','0387','Starters Details Ireland'),
		('INFTY','3273','Statement: Rules for SI Payments-RU'),
		('INFTY','0500','Statistical Data'),
		('INFTY','0176','Statistical data H'),
		('INFTY','0033','Statistics'),
		('INFTY','0271','Statistics Public Sector Germany'),
		('INFTY','0715','Status of Global Assignment'),
		('INFTY','0716','Status of Global Assignment'),
		('INFTY','0739','Stock Option [Singapore]'),
		('INFTY','0741','Stock Option [Singapore]'),
		('INFTY','0379','Stock Purchase Plans'),
		('INFTY','2003','Substitutions'),
		('INFTY','0507','Superannuation'),
		('INFTY','0220','Superannuation Aust.'),
		('INFTY','0310','Superannuation NZ'),
		('INFTY','0558','Suppl. IT0002 [PL]'),
		('INFTY','0336','Suppl. it0002 [PT]'),
		('INFTY','0334','Suppl. it0016 [PT]'),
		('INFTY','0517','Suppl. IT0021 [PL]'),
		('INFTY','0335','Suppl. it0021 [PT]'),
		('INFTY','0414','Suppl. IT0023 [PL]'),
		('INFTY','0126','Supplem. Pension  D'),
		('INFTY','0231','Supplement to P0001  PSG'),
		('INFTY','0230','Supplement to P0008  PSG'),
		('INFTY','0266','Supplement to P0027  PSG'),
		('INFTY','0237','Supplement to P0052  PSG'),
		('INFTY','3532','Supplementary Insurance[CN]'),
		('INFTY','0548','Supplementary pension funds [IT]'),
		('INFTY','0175','Supplementary personal data H'),
		('INFTY','3216','SWF Contract Details'),
		('INFTY','3217','SWF Qualifications'),
		('INFTY','3218','SWF Qualifications'),
		('INFTY','3219','SWF Qualifications'),
		('INFTY','3220','SWF Qualifications'),
		('INFTY','3215','SWF Staff Details'),
		('INFTY','0179','Tax  SG'),
		('INFTY','0307','Tax additional data H'),
		('INFTY','0291','Tax and Social Ins. Payments [CIS]'),
		('INFTY','0461','Tax Assignment CA'),
		('INFTY','0188','Tax Australia'),
		('INFTY','0173','Tax card information [Norway]'),
		('INFTY','0205','Tax Card Information Finland'),
		('INFTY','0561','Tax Data'),
		('INFTY','0252','Tax data              SK'),
		('INFTY','0065','Tax Data  GB'),
		('INFTY','3227','Tax Data [CL]'),
		('INFTY','0095','Tax data CAN'),
		('INFTY','0564','Tax data Croatia'),
		('INFTY','0152','Tax data CZ'),
		('INFTY','0241','Tax Data Indonesia'),
		('INFTY','0359','Tax Data Ireland'),
		('INFTY','0413','Tax Data PL'),
		('INFTY','0603','Tax data SI'),
		('INFTY','0156','Tax Deductions [IT]'),
		('INFTY','0163','Tax H'),
		('INFTY','0313','Tax New Zealand'),
		('INFTY','0299','Tax Privileges [CIS]'),
		('INFTY','0939','Tax properties [BG]'),
		('INFTY','0331','Tax PT'),
		('INFTY','0364','Tax TH'),
		('INFTY','0556','Tax Treaty'),
		('INFTY','0484','Taxation [Enhancement]'),
		('INFTY','0411','Taxation Philippines'),
		('INFTY','0149','Taxes  SA'),
		('INFTY','0273','Taxes - SE'),
		('INFTY','0274','Taxes - SE'),
		('INFTY','0510','Tax-Sheltered Pension [US]'),
		('INFTY','0713','Termination'),
		('INFTY','0714','Termination'),
		('INFTY','0701','Termination Australia'),
		('INFTY','0546','Termination Data'),
		('INFTY','0551','Termination: General Data'),
		('INFTY','0130','Test Procedures'),
		('INFTY','0227','TFN Australia'),
		('INFTY','3893','Time Account Status'),
		('INFTY','2011','Time Events'),
		('INFTY','0416','Time Quota Compensation'),
		('INFTY','0050','Time Recording Info'),
		('INFTY','0315','Time Sheet Defaults'),
		('INFTY','0552','Time Specification/Employ. Period'),
		('INFTY','2012','Time Transfer Specifications'),
		('INFTY','0506','Tip Indicators'),
		('INFTY','0474','Train Preference'),
		('INFTY','0606','Transport and food SI'),
		('INFTY','0017','Travel Privileges'),
		('INFTY','0470','Travel Profile'),
		('INFTY','0468','Travel Profile [not specified]'),
		('INFTY','0469','Travel Profile [not specified]'),
		('INFTY','0209','Unemployment State'),
		('INFTY','0388','Union due Ded.  JP'),
		('INFTY','9995','US Deductions'),
		('INFTY','9996','US Deductions MTD'),
		('INFTY','9997','US Deductions QTD'),
		('INFTY','9998','US Deductions YTD'),
		('INFTY','9990','US Earnings'),
		('INFTY','9991','US Earnings MTD'),
		('INFTY','9992','US Earnings QTD'),
		('INFTY','9993','US Earnings YTD'),
		('INFTY','0566','US Pension Plan QDRO Information'),
		('INFTY','0157','User Administration Data [IT]'),
		('INFTY','4002','Vacancy Assignment'),
		('INFTY','0229','Value Types BAV'),
		('INFTY','0863','Verdict'),
		('INFTY','0864','Verdict'),
		('INFTY','0865','Verdict'),
		('INFTY','3291','Verdict Family Court CPS'),
		('INFTY','3292','Verdict Family Court CPS'),
		('INFTY','0431','View Basic Pay'),
		('INFTY','0734','View for IT Basic Pay - Brazil'),
		('INFTY','0432','View: Type of Employment'),
		('INFTY','0048','Visa Status'),
		('INFTY','0489','Voluntary Service/ ECA'),
		('INFTY','0052','Wage Maintenance'),
		('INFTY','0808','Wage Return'),
		('INFTY','0809','Wage Return'),
		('INFTY','2052','Weekly Entry w/Activity Allocation'),
		('INFTY','0087','WFTC/DPTC GB'),
		('INFTY','0210','Withholding Info W4/W5 US'),
		('INFTY','0526','Work & Remuneration Confirmation A'),
		('INFTY','0845','Work Relationships'),
		('INFTY','0424','Work Stopped [F]'),
		('INFTY','0208','Work Tax Area'),
		('INFTY','0076','Workers\' Comp.  NA'),
		('INFTY','0029','Workers\' Compensation'),
		('INFTY','0605','Working age SI'),
		('INFTY','0297','Working Conditions [CIS]'),
		('INFTY','0107','Working Time [BE]'),
		('INFTY','0054','Works Councils'),
		('INFTY','0146','Y.E.A. Data  JP'),
		('INFTY','0245','Year Clearan Tax Wage'),
		('INFTY','0257','Year Clearance Tax From Wage SK'),
		('INFTY','0542','Year End Adjustment Data'),
		('INFTY','0940','Year End Income Tax Adjustment [BG]'),
		('INFTY','0746','ZfA Bonus Application'),
		('INFTY','0745','ZfA Notifications in Public Sector'),
		('KAPPL','ST','[No Field Value Found]'),
		('KAPPL','VN','[No Field Value Found]'),
		('KAPPL','WR','Agency Business'),
		('KAPPL','W0','All. Table    Group'),
		('KAPPL','WA','Allocation Table'),
		('KAPPL','RS','Automotive'),
		('KAPPL','V3','Billing'),
		('KAPPL','VP','Bonus Buy'),
		('KAPPL','CM','Campus Management'),
		('KAPPL','VC','Cash Settlement'),
		('KAPPL','QC','Certificates'),
		('KAPPL','VA','CO-PA'),
		('KAPPL','CS','Cost Centers'),
		('KAPPL','VS','Cross Selling'),
		('KAPPL','CR','CRP Calculation'),
		('KAPPL','DB','Customers'),
		('KAPPL','RD','DBM Automotive'),
		('KAPPL','RE','DBM Putaway Manager'),
		('KAPPL','RW','DI - Warranty'),
		('KAPPL','MD','Direct Procurement'),
		('KAPPL','P1','Direct Production'),
		('KAPPL','CV','Document Management'),
		('KAPPL','ES','Entry Sheet'),
		('KAPPL','CF','Error Control'),
		('KAPPL','MS','Ext.Services Manag.'),
		('KAPPL','WS','Free Sett. Agreem.'),
		('KAPPL','WN','Free Sett. Rel. Del.'),
		('KAPPL','V5','Groups'),
		('KAPPL','VG','GTIN Mapping'),
		('KAPPL','V6','Handling Units'),
		('KAPPL','PC','ICM: Liability'),
		('KAPPL','P','ICM: Payment'),
		('KAPPL','PB','ICM: Valuation'),
		('KAPPL','E1','Inbound Delivery'),
		('KAPPL','ME','Inventory Management'),
		('KAPPL','MR','Invoice Verification'),
		('KAPPL','BA','IS Bank'),
		('KAPPL','J0','IS-P SD for Publish.'),
		('KAPPL','PA','JIT Call'),
		('KAPPL','WE','Labeling'),
		('KAPPL','W','Merchandise Mgmt'),
		('KAPPL','NF','Nota fiscal'),
		('KAPPL','KA','Orders'),
		('KAPPL','PO','Packing Object'),
		('KAPPL','VD','Payment cards'),
		('KAPPL','CO','Production Orders'),
		('KAPPL','TP','Profit Center'),
		('KAPPL','KE','Profitability Anal.'),
		('KAPPL','EL','Purch. SchAgrRelease'),
		('KAPPL','EV','Purch.Outline Agr.'),
		('KAPPL','EF','Purchase Order'),
		('KAPPL','M','Purchasing'),
		('KAPPL','EA','Purchasing RFQ'),
		('KAPPL','VB','Reconciliation Acct'),
		('KAPPL','CQ','Resource Prices'),
		('KAPPL','WB','Retail Promotion'),
		('KAPPL','M1','Rough Goods Receipt'),
		('KAPPL','V1','Sales'),
		('KAPPL','K1','Sales activities'),
		('KAPPL','W1','Sales Promo. Group'),
		('KAPPL','V','Sales/Distribution'),
		('KAPPL','VE','SD Services'),
		('KAPPL','DS','Sender'),
		('KAPPL','F','Shipment Costs'),
		('KAPPL','V2','Shipping'),
		('KAPPL','V4','Shipping [Spec.Case]'),
		('KAPPL','DR','Ship-to Party'),
		('KAPPL','TX','Taxes'),
		('KAPPL','WT','Trading Contract'),
		('KAPPL','V7','Transport'),
		('KAPPL','VL','Visit List'),
		('KAPPL','WM','Warehouse Management'),
		('KOART','A','Assets'),
		('KOART','D','Customers'),
		('KOART','S','G/L accounts'),
		('KOART','M','Material'),
		('KOART','K','Vendors'),
		('MASSOBJTYP','BUS3006','G/L Acconut'),
		('MASSOBJTYP','BUS1312','[No Field Value Found]'),
		('MASSOBJTYP','BUS1313','[No Field Value Found]'),
		('MASSOBJTYP','BUS1701','[No Field Value Found]'),
		('MASSOBJTYP','EMPLOYEEFR','[No Field Value Found]'),
		('MASSOBJTYP','FISCDATACA','[No Field Value Found]'),
		('MASSOBJTYP','PFBASICNL','[No Field Value Found]'),
		('MASSOBJTYP','PFVALSNL','[No Field Value Found]'),
		('MASSOBJTYP','SBFADXT','[No Field Value Found]'),
		('MASSOBJTYP','SOFMSEND','[No Field Value Found]'),
		('MASSOBJTYP','WFUNIT_WK','[No Field Value Found]'),
		('MASSOBJTYP','WFUNIT_WOK','[No Field Value Found]'),
		('MASSOBJTYP','Z_MARA','[No Field Value Found]'),
		('MASSOBJTYP','Z_PD1001','[No Field Value Found]'),
		('MASSOBJTYP','ZADR6','[No Field Value Found]'),
		('MASSOBJTYP','ZBESEG','[No Field Value Found]'),
		('MASSOBJTYP','ZBP_02','[No Field Value Found]'),
		('MASSOBJTYP','ZBUS1001','[No Field Value Found]'),
		('MASSOBJTYP','ZBUS1001A','[No Field Value Found]'),
		('MASSOBJTYP','ZBUS1176','[No Field Value Found]'),
		('MASSOBJTYP','ZBUS2089','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_00','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_01','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_02','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_03','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_04','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_05','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_06','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_07','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_08','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_09','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_10','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_11','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_12','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_13','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_14','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_15','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_16','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_17','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_18','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_19','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_20','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_21','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_22','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_23','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_24','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_25','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_26','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_27','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_28','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_29','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_30','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_31','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_32','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_33','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_34','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_35','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_36','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_37','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_38','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_39','[No Field Value Found]'),
		('MASSOBJTYP','ZKNA1_40','[No Field Value Found]'),
		('MASSOBJTYP','ZLFA1','[No Field Value Found]'),
		('MASSOBJTYP','ZPD_1001','[No Field Value Found]'),
		('MASSOBJTYP','ZPD1001','[No Field Value Found]'),
		('MASSOBJTYP','ZPDOTYPESH','[No Field Value Found]'),
		('MASSOBJTYP','ZQCYTEST','[No Field Value Found]'),
		('MASSOBJTYP','ZTRAVELREQ','[No Field Value Found]'),
		('MASSOBJTYP','ZZBUS2005','[No Field Value Found]'),
		('MASSOBJTYP','/OPT/V1001','/OPT/V1001'),
		('MASSOBJTYP','/XFT/EPA01','/XFT/EPA01'),
		('MASSOBJTYP','/XFT/EPA02','/XFT/EPA01'),
		('MASSOBJTYP','/XFT/EPA03','/XFT/EPA01'),
		('MASSOBJTYP','AM_AI','AA Worklist for Mass Processing'),
		('MASSOBJTYP','TRDIR','ABAP program'),
		('MASSOBJTYP','ABSQUOTTY','Absence Quota Type'),
		('MASSOBJTYP','ABSQUOTTYL','Absence quota type vacation'),
		('MASSOBJTYP','CCPROC','Abstract CIC process'),
		('MASSOBJTYP','BUS3014','Account'),
		('MASSOBJTYP','BUS2081C','Account Maintenance Document'),
		('MASSOBJTYP','BUS6010','Accounting Activity Allocation'),
		('MASSOBJTYP','BUS6018','Accounting Asset Acquisition'),
		('MASSOBJTYP','BUS6019','Accounting Asset Retirement'),
		('MASSOBJTYP','BUS6020','Accounting Asset Revaluation'),
		('MASSOBJTYP','BUS6017','Accounting asset transfer'),
		('MASSOBJTYP','BUS6007','Accounting Billing'),
		('MASSOBJTYP','PS_OBJACC','Accounting Data for Contract Object'),
		('MASSOBJTYP','BKPF','Accounting document'),
		('MASSOBJTYP','BUS6035','Accounting Document'),
		('MASSOBJTYP','/OPT/BKPF','Accounting Document - Extension'),
		('MASSOBJTYP','BSEG','Accounting Document Line Item'),
		('MASSOBJTYP','BUS6004','Accounting Employee Expenses'),
		('MASSOBJTYP','BUS6006','Accounting Employee Payables'),
		('MASSOBJTYP','BUS6005','Accounting Employee Receivables'),
		('MASSOBJTYP','/EACC/DOC','Accounting Engine Document'),
		('MASSOBJTYP','BUS6030','Accounting GL Posting'),
		('MASSOBJTYP','BUS6002','Accounting Goods Movement'),
		('MASSOBJTYP','BUS6003','Accounting Invoice Receipt'),
		('MASSOBJTYP','BUS6036','Accounting Manual Cost Allocation'),
		('MASSOBJTYP','BUS6014','Accounting Not/Indirect Alloc.Activities'),
		('MASSOBJTYP','BUS6011','Accounting Primary Costs'),
		('MASSOBJTYP','BUS6008','Accounting Purchase Order'),
		('MASSOBJTYP','BUS6009','Accounting Purchase Requisition'),
		('MASSOBJTYP','BUS6012','Accounting Revenues'),
		('MASSOBJTYP','BUS6021','Accounting sales order'),
		('MASSOBJTYP','BUS6022','Accounting sales quotation'),
		('MASSOBJTYP','BUS6001','Accounting Services'),
		('MASSOBJTYP','BUS2162','Accounting Share of Purchase Scheduling Agreement'),
		('MASSOBJTYP','BUS6013','Accounting Statistical Key Figures'),
		('MASSOBJTYP','BUS6023','Accounting travel expenses'),
		('MASSOBJTYP','ACCTGDOCMT','Accounting: Document from External System'),
		('MASSOBJTYP','BUS1055','Accounts payable ledger'),
		('MASSOBJTYP','BUS1054','Accounts receivable ledger'),
		('MASSOBJTYP','FIOACCSTAT','AccountStatement'),
		('MASSOBJTYP','PPFOUTPUT','Action'),
		('MASSOBJTYP','/KYK/FI','Actions for FI documents'),
		('MASSOBJTYP','ERC_ACTIV','Activities in E-Recruiting'),
		('MASSOBJTYP','BUS1179','Activity [Integrated Product and Process Engineering]'),
		('MASSOBJTYP','ISUCRM1O','Activity in CRM'),
		('MASSOBJTYP','HRACTV_NAV','Activity in SAP E-Recruiting'),
		('MASSOBJTYP','EPIGRAPHES','Activity indicator SI Spain'),
		('MASSOBJTYP','BUS1031','Activity Type'),
		('MASSOBJTYP','BUS1115','Activity type group'),
		('MASSOBJTYP','ADB2030','AD Customer Inquiry'),
		('MASSOBJTYP','AFACTORY','Ad Hoc Factory for Agents'),
		('MASSOBJTYP','/IPRO/AMDB','Ad Hoc Properties [Approval Manager]'),
		('MASSOBJTYP','/IPRO/MRFC','Ad Hoc Properties [Approval Manager]'),
		('MASSOBJTYP','AMANAGER','Ad Hoc Properties [Default Manager]'),
		('MASSOBJTYP','AMANAGER2','Ad Hoc Properties [Default manager]'),
		('MASSOBJTYP','AASSIGNMNT','Ad Hoc Task Selection'),
		('MASSOBJTYP','ADB2015','AD Inbound Delivery'),
		('MASSOBJTYP','ADB2081','AD Incoming Invoice'),
		('MASSOBJTYP','ADB2012','AD Purchase Order'),
		('MASSOBJTYP','ADB2032','AD Sales Order'),
		('MASSOBJTYP','ADB1001006','AD Standard Material'),
		('MASSOBJTYP','ADB2011','AD Vendor Quotation'),
		('MASSOBJTYP','ADB2010','AD Vendor Quotation Request'),
		('MASSOBJTYP','BUS1021','Additional Ledger'),
		('MASSOBJTYP','BUS2106','Additionals request'),
		('MASSOBJTYP','CLAIM_ADDR','Address'),
		('MASSOBJTYP','ADDRESS','Address for sending documents'),
		('MASSOBJTYP','BUS4003','Address of Person in company'),
		('MASSOBJTYP','BUS4002','Address of natural oerson'),
		('MASSOBJTYP','BUS4001','Addresses of companies and organizations'),
		('MASSOBJTYP','BUS1509','Adjustment Measure [RE-FX]'),
		('MASSOBJTYP','ADVERTSMNT','Advertisement'),
		('MASSOBJTYP','BUSISM028','Advertising Management Ad Spec'),
		('MASSOBJTYP','BUSISM024','Advertising Management Booking Unit'),
		('MASSOBJTYP','BUSISM025','Advertising Management Content Component'),
		('MASSOBJTYP','BUSISM020','Advertising Management Media-Mix Contract'),
		('MASSOBJTYP','BUSISM018','Advertising Management Sales Agent Contract'),
		('MASSOBJTYP','BUSISM008','Advertising Management Sales Document'),
		('MASSOBJTYP','BUSISM033','Advertising Management Schedule Line'),
		('MASSOBJTYP','AVIK','Advice Notes for Paymets and Credit Memos'),
		('MASSOBJTYP','BPR_AER','after-event recording'),
		('MASSOBJTYP','IUEEPLOTO1','Aggregated Payment: Reference'),
		('MASSOBJTYP','GRPC_CASED','Aggregation of Deficiency'),
		('MASSOBJTYP','AII000003','AII external observation'),
		('MASSOBJTYP','DRPLANE','Aircraft Type [Drag&Relate]'),
		('MASSOBJTYP','DRCARR','Airline Carrier [Drag&Relate]'),
		('MASSOBJTYP','DRAIRPORT','Airport [Drag&Relate]'),
		('MASSOBJTYP','/KYK/CO','Aktionen für CO-Belege'),
		('MASSOBJTYP','/XFT/EPA04','AL - Workflows'),
		('MASSOBJTYP','ALELINK','ALE connection'),
		('MASSOBJTYP','IDOCCONDA2','ALE Customizing Synchronization: IDoc Type CONDA2'),
		('MASSOBJTYP','ALEMODEL','ALE distribution model'),
		('MASSOBJTYP','/ISDFPS/T1','ALE Test Data Type 1'),
		('MASSOBJTYP','/ISDFPS/TR','ALE Test Data Type 1'),
		('MASSOBJTYP','BCALERTLCL','Alert in component system without persistence'),
		('MASSOBJTYP','AAGENT','All Ad Hoc Properties of a Step [Agents Etc.]'),
		('MASSOBJTYP','IDOCWALREQ','Allocation: Report requested quantities'),
		('MASSOBJTYP','ISUAMIEVNT','AMI Event'),
		('MASSOBJTYP','BUS1154','Annotation in the Costing Solutions Area'),
		('MASSOBJTYP','BEANSWER','Answer'),
		('MASSOBJTYP','APPLICANT','Applicant'),
		('MASSOBJTYP','ACTIVITY','Applicant activity'),
		('MASSOBJTYP','APPLICATIO','Applicant application'),
		('MASSOBJTYP','PAPL','Applicant document'),
		('MASSOBJTYP','VACASSIGN','Applicant vacancy assignment'),
		('MASSOBJTYP','HRAPPG_NAV','Application Group in SAP E-Recruiting'),
		('MASSOBJTYP','ERC_APPL','Application in E-Recruiting'),
		('MASSOBJTYP','HRAPPL_NAV','Application in SAP E-Recruiting'),
		('MASSOBJTYP','USMD_ALOG','Application Log'),
		('MASSOBJTYP','ISUIDOCLOG','Application log IS-U'),
		('MASSOBJTYP','APPOINTMNT','Appointment'),
		('MASSOBJTYP','BUS7026','Appraisal'),
		('MASSOBJTYP','PDRELA_050','Appraisal'),
		('MASSOBJTYP','APPR_DOC','Appraisal Document'),
		('MASSOBJTYP','ZZAPPR_DOC','Appraisal Document [ Custom / Delegated ]'),
		('MASSOBJTYP','BUS7027','Appraisal model'),
		('MASSOBJTYP','BUS2104','Appropriation request'),
		('MASSOBJTYP','BUS2204','Appropriation Request'),
		('MASSOBJTYP','WIRE_APP','Approval of wire payments after CashCon'),
		('MASSOBJTYP','ZLEAVOBJ','Approve / Reject leave request'),
		('MASSOBJTYP','BUS1151','Architectural Object'),
		('MASSOBJTYP','ARCHIVE','Archive files R/3 application data'),
		('MASSOBJTYP','SREPOTREE','Archive report list'),
		('MASSOBJTYP','IMAGE','ArchiveLink Archive Objects'),
		('MASSOBJTYP','TOAV0','ArchiveLink Document'),
		('MASSOBJTYP','BUS0817','ArchiveLink Test Object'),
		('MASSOBJTYP','SWOTOL','Area'),
		('MASSOBJTYP','BUS1235','Article Hierarchy'),
		('MASSOBJTYP','FOPC_CASEA','Assessment'),
		('MASSOBJTYP','GRPC_CASEA','Assessment for PC 2.5'),
		('MASSOBJTYP','BUSISB100','Asset'),
		('MASSOBJTYP','BUS2040','Asset Account'),
		('MASSOBJTYP','BUS6029','Asset Acquisition'),
		('MASSOBJTYP','BPR_ASSETD','asset detail'),
		('MASSOBJTYP','BUS2043','Asset document'),
		('MASSOBJTYP','BUS6037','Asset Document Reversal'),
		('MASSOBJTYP','BUS6027','Asset Post-Capitalization'),
		('MASSOBJTYP','BUS6028','Asset Retirement'),
		('MASSOBJTYP','TRLOAPPR_2','Assignment to Organizational Objects'),
		('MASSOBJTYP','BUS1070','Assortment'),
		('MASSOBJTYP','BUS3032','Assortment list'),
		('MASSOBJTYP','BUS1085','Assortment module'),
		('MASSOBJTYP','HRATCH_NAV','Attachment'),
		('MASSOBJTYP','PDRELA_025','Attendance'),
		('MASSOBJTYP','ZPDRELA','Attendance'),
		('MASSOBJTYP','ATTQUOTTY','Attendance Quota Type'),
		('MASSOBJTYP','ATTABSQTYP','Attendance/Absence Quota Type'),
		('MASSOBJTYP','BUS1049','Attendance/Absence Type'),
		('MASSOBJTYP','PDOTYPE_PT','Attendee'),
		('MASSOBJTYP','BUS20350','Audit'),
		('MASSOBJTYP','BUS20300','Audit Plan'),
		('MASSOBJTYP','BUS20360','Audit Question/Reply List'),
		('MASSOBJTYP','BILLDOCAUT','Automatic billing document'),
		('MASSOBJTYP','FOPC_BGREP','Background Report - Results'),
		('MASSOBJTYP','GRPC_BGREP','Background Report - Results'),
		('MASSOBJTYP','BUS1147','Balanced scorecard'),
		('MASSOBJTYP','BUS1011','Bank'),
		('MASSOBJTYP','BANKDETAIL','Bank details'),
		('MASSOBJTYP','BUS4499','Bank Statement'),
		('MASSOBJTYP','BUS4498','Bank Statement Line Items'),
		('MASSOBJTYP','BUS2038A','BAPIs Maintenance Notification'),
		('MASSOBJTYP','BUS2080A','BAPIs Service Notification'),
		('MASSOBJTYP','PFBASICCH','Basic Data of Pension Fund Member'),
		('MASSOBJTYP','IDOCBASIS','Basic IDoc Types'),
		('MASSOBJTYP','DPSPP_BSKT','Basket'),
		('MASSOBJTYP','/KYK/BAT','BATCH'),
		('MASSOBJTYP','BUS1001002','Batch'),
		('MASSOBJTYP','BUS3053','Batch record'),
		('MASSOBJTYP','BUS3050','Batch Record [Old]'),
		('MASSOBJTYP','BUS3053001','Batch Record Document'),
		('MASSOBJTYP','BUS3051','Batch Record Document [Old]'),
		('MASSOBJTYP','BUS1001003','Batch-specific material unit of measure'),
		('MASSOBJTYP','ZRGMARA','BC610: Extended Material'),
		('MASSOBJTYP','Z00MARA','BC610: Material'),
		('MASSOBJTYP','ZPLANT00','BC610: Production Plant'),
		('MASSOBJTYP','BUSISB001','BCA Release Tool: Release Process Instance'),
		('MASSOBJTYP','UBCINVOIC','Bill for EBPP'),
		('MASSOBJTYP','BUS1002','Bill of material structure'),
		('MASSOBJTYP','BPR_BILL','billing'),
		('MASSOBJTYP','FKKBILLACC','Billing Account'),
		('MASSOBJTYP','BILLINGCLS','Billing class'),
		('MASSOBJTYP','BILLINGDOC','Billing document'),
		('MASSOBJTYP','ADVBRK','Billing Document [AD]'),
		('MASSOBJTYP','BUS2109','Billing Document for Magazines and Newspapers'),
		('MASSOBJTYP','BUSISM010','Billing Document in Advertising Management'),
		('MASSOBJTYP','PORTION','Billing portion'),
		('MASSOBJTYP','/OPT/BIR','Block Invoice Resolution'),
		('MASSOBJTYP','BPR_FNDLOG','BO for OBN by Application Log'),
		('MASSOBJTYP','BPR_FNDWFF','BO for OBN of EHSM Workflow Foundation'),
		('MASSOBJTYP','/BOBF/DOBJ','BOBF Demo Object'),
		('MASSOBJTYP','HRTIM_ABS','BOR for arch obj HRTIM_ABS - legal holds'),
		('MASSOBJTYP','HRPA_LOAN','BOR for Arch. Obj. HRPA_LOAN - Legal Holds'),
		('MASSOBJTYP','HRPA_TASK','BOR for Arch. Obj. HRPA_TASK - Legal Holds'),
		('MASSOBJTYP','HRTIM_ATT','BOR for Arch. Obj. HRTIM_ATT - Legal Holds'),
		('MASSOBJTYP','HRTIM_AVAL','BOR for Arch. Obj. HRTIM_AVAL - Legal Holds'),
		('MASSOBJTYP','HRTIM_MAT','BOR for Arch. Obj. HRTIM_MAT - Legal Holds'),
		('MASSOBJTYP','HRTIM_MIL','BOR for Arch. Obj. HRTIM_MIL - Legal Holds'),
		('MASSOBJTYP','HRTIM_OVER','BOR for Arch. Obj. HRTIM_OVER - Legal Holds'),
		('MASSOBJTYP','HRTIM_QUOT','BOR for Arch. Obj. HRTIM_QUOT - Legal Holds'),
		('MASSOBJTYP','HRTIM_SUBS','BOR for Arch. Obj. HRTIM_SUBS - Legal Holds'),
		('MASSOBJTYP','PA_CALC','BOR for Arch. Obj. PA_CALC - Legal Hold'),
		('MASSOBJTYP','PA_LDOC','BOR for Arch. Obj. PA_LDOC - Legal Hold'),
		('MASSOBJTYP','PA_TIME','BOR for Arch. Obj. PA_TIME - Legal Hold'),
		('MASSOBJTYP','BPR_BS_MTR','BOR for bank statement monitor'),
		('MASSOBJTYP','HRECM_REV','BOR object for arch object HRECM_REV'),
		('MASSOBJTYP','HRHAP_DOC','BOR Object for Arch. Object HRHAP_DOC'),
		('MASSOBJTYP','BPR_PY_MTR','BOR object for payment monitor'),
		('MASSOBJTYP','HRADMIN_WL','BOR Object for Worklist Navigation for HRA'),
		('MASSOBJTYP','MSS_WL','BOR Object for Worklist Navigation for MSS'),
		('MASSOBJTYP','XML_DOC','BOR Representation of an XML Document'),
		('MASSOBJTYP','BPR_BCKORD','BPR backord_proc'),
		('MASSOBJTYP','BPR_INSPL','BPR inspection_lot'),
		('MASSOBJTYP','BPR_TEL','BPR telephony'),
		('MASSOBJTYP','BPR_VND','BPR vendor'),
		('MASSOBJTYP','PS_LEANTRC','BRFplus Trace for TRM'),
		('MASSOBJTYP','BUSISI002','Broker-Contract Relationship'),
		('MASSOBJTYP','BUDBILPLAN','Budget Billing Plan'),
		('MASSOBJTYP','BUDBILPLNH','Budget Billing Plan Using Budget Billing Plan Number'),
		('MASSOBJTYP','FMBU','Budget document'),
		('MASSOBJTYP','BUS0051','Budget Funds Management'),
		('MASSOBJTYP','BUS0042','Budget Period'),
		('MASSOBJTYP','BUS0052','BudgetHeldDocumentFM'),
		('MASSOBJTYP','BUS0050','Budgeting Entry Document Funds Manageme'),
		('MASSOBJTYP','BUS0037','Budgeting Entry Document Grants Management [Held]'),
		('MASSOBJTYP','BUS0036','Budgeting Entry Document Grants Management [Posted]'),
		('MASSOBJTYP','BUS1126','Building [Real Estate]'),
		('MASSOBJTYP','BUS1503','Building [RE-FX]'),
		('MASSOBJTYP','IDPKASSMOD','Bundles of IDocs with message type ASSMOD'),
		('MASSOBJTYP','IDPKLIKOND','Bundles of IDocs with message type LICOND'),
		('MASSOBJTYP','Z01MARA','BUS1001_Group_01'),
		('MASSOBJTYP','Z02MARA','BUS1001_Group_02'),
		('MASSOBJTYP','Z03MARA','BUS1001_Group_03'),
		('MASSOBJTYP','Z04MARA','BUS1001_Group_04'),
		('MASSOBJTYP','Z05MARA','BUS1001_Group_05'),
		('MASSOBJTYP','Z06MARA','BUS1001_Group_06'),
		('MASSOBJTYP','Z07MARA','BUS1001_Group_07'),
		('MASSOBJTYP','Z08MARA','BUS1001_Group_08'),
		('MASSOBJTYP','Z09MARA','BUS1001_Group_09'),
		('MASSOBJTYP','Z10MARA','BUS1001_Group_10'),
		('MASSOBJTYP','Z11MARA','BUS1001_Group_11'),
		('MASSOBJTYP','Z12MARA','BUS1001_Group_12'),
		('MASSOBJTYP','Z13MARA','BUS1001_Group_13'),
		('MASSOBJTYP','Z14MARA','BUS1001_Group_14'),
		('MASSOBJTYP','Z15MARA','BUS1001_Group_15'),
		('MASSOBJTYP','Z16MARA','BUS1001_Group_16'),
		('MASSOBJTYP','Z17MARA','BUS1001_Group_17'),
		('MASSOBJTYP','Z18MARA','BUS1001_Group_18'),
		('MASSOBJTYP','Z19MARA','BUS1001_Group_19'),
		('MASSOBJTYP','Z20MARA','BUS1001_Group_20'),
		('MASSOBJTYP','Z21MARA','BUS1001_Group_21'),
		('MASSOBJTYP','Z22MARA','BUS1001_Group_22'),
		('MASSOBJTYP','Z23MARA','BUS1001_Group_23'),
		('MASSOBJTYP','Z24MARA','BUS1001_Group_24'),
		('MASSOBJTYP','Z25MARA','BUS1001_Group_25'),
		('MASSOBJTYP','Z26MARA','BUS1001_Group_26'),
		('MASSOBJTYP','Z27MARA','BUS1001_Group_27'),
		('MASSOBJTYP','Z28MARA','BUS1001_Group_28'),
		('MASSOBJTYP','Z29MARA','BUS1001_Group_29'),
		('MASSOBJTYP','Z30MARA','BUS1001_Group_30'),
		('MASSOBJTYP','Z31MARA','BUS1001_Group_31'),
		('MASSOBJTYP','Y01MARA','BUS1001_Groupnr_01'),
		('MASSOBJTYP','Y02MARA','BUS1001_Groupnr_02'),
		('MASSOBJTYP','Y03MARA','BUS1001_Groupnr_03'),
		('MASSOBJTYP','Y04MARA','BUS1001_Groupnr_04'),
		('MASSOBJTYP','Y05MARA','BUS1001_Groupnr_05'),
		('MASSOBJTYP','Y06MARA','BUS1001_Groupnr_06'),
		('MASSOBJTYP','Y07MARA','BUS1001_Groupnr_07'),
		('MASSOBJTYP','Y08MARA','BUS1001_Groupnr_08'),
		('MASSOBJTYP','Y09MARA','BUS1001_Groupnr_09'),
		('MASSOBJTYP','Y10MARA','BUS1001_Groupnr_10'),
		('MASSOBJTYP','Y11MARA','BUS1001_Groupnr_11'),
		('MASSOBJTYP','Y12MARA','BUS1001_Groupnr_12'),
		('MASSOBJTYP','Y13MARA','BUS1001_Groupnr_13'),
		('MASSOBJTYP','Y14MARA','BUS1001_Groupnr_14'),
		('MASSOBJTYP','Y15MARA','BUS1001_Groupnr_15'),
		('MASSOBJTYP','Y16MARA','BUS1001_Groupnr_16'),
		('MASSOBJTYP','Y17MARA','BUS1001_Groupnr_17'),
		('MASSOBJTYP','Y18MARA','BUS1001_Groupnr_18'),
		('MASSOBJTYP','Y19MARA','BUS1001_Groupnr_19'),
		('MASSOBJTYP','Y20MARA','BUS1001_Groupnr_20'),
		('MASSOBJTYP','Y21MARA','BUS1001_Groupnr_21'),
		('MASSOBJTYP','Y22MARA','BUS1001_Groupnr_22'),
		('MASSOBJTYP','Y23MARA','BUS1001_Groupnr_23'),
		('MASSOBJTYP','Y24MARA','BUS1001_Groupnr_24'),
		('MASSOBJTYP','Y25MARA','BUS1001_Groupnr_25'),
		('MASSOBJTYP','Y26MARA','BUS1001_Groupnr_26'),
		('MASSOBJTYP','Y27MARA','BUS1001_Groupnr_27'),
		('MASSOBJTYP','Y28MARA','BUS1001_Groupnr_28'),
		('MASSOBJTYP','Y29MARA','BUS1001_Groupnr_29'),
		('MASSOBJTYP','Y30MARA','BUS1001_Groupnr_30'),
		('MASSOBJTYP','Y31MARA','BUS1001_Groupnr_31'),
		('MASSOBJTYP','BUS8000','BUS8000'),
		('MASSOBJTYP','BEBAC','Business Application Component'),
		('MASSOBJTYP','BUS0003','Business Area'),
		('MASSOBJTYP','BUS1123','Business entity [Real Estate]'),
		('MASSOBJTYP','PDOTYPE_E','Business event'),
		('MASSOBJTYP','PDRELA_024','Business event <-> location'),
		('MASSOBJTYP','PDOTYPE_L','Business event group'),
		('MASSOBJTYP','PDOTYPE_D','Business event type'),
		('MASSOBJTYP','BUS0031','Business Location'),
		('MASSOBJTYP','BUS3064','Business Location Material Price'),
		('MASSOBJTYP','BUS3063','Business Location Meter Reading'),
		('MASSOBJTYP','BUS6033','Business Location Payment Card Processing'),
		('MASSOBJTYP','BUS3062','Business Location Tank Dip Reading'),
		('MASSOBJTYP','ESDIDOC','Business Object Enhancements SD [DI 3.0]'),
		('MASSOBJTYP','BPR_FNDACT','Business Object for EHSM Action Workflows'),
		('MASSOBJTYP','BPR_FNDEXT','Business Object for External Notifications'),
		('MASSOBJTYP','UCSTATS','Business Object for SEM-BCS Sign-Off'),
		('MASSOBJTYP','HRTRM_NAV','Business Object for Talent Review Meeting'),
		('MASSOBJTYP','BUS1006','Business Partner'),
		('MASSOBJTYP','BUSISM007','Business Partner'),
		('MASSOBJTYP','ZBP_05','Business partner 05'),
		('MASSOBJTYP','BUS1006002','Business Partner Contact Person Relationship'),
		('MASSOBJTYP','BUS1006001','Business partner employee'),
		('MASSOBJTYP','BUS1006003','Business Partner Employee Relationship'),
		('MASSOBJTYP','IS_BUS1006','Business Partner for Drag&Relate Insurance'),
		('MASSOBJTYP','BUSISB990','Business Partner for Financial Services'),
		('MASSOBJTYP','ZBP_00','Business partner for group 00'),
		('MASSOBJTYP','ZBP_01','Business partner for group 01'),
		('MASSOBJTYP','ZBP_03','Business partner for group 03'),
		('MASSOBJTYP','ZBP_04','Business partner for group 04'),
		('MASSOBJTYP','ZBP_06','Business partner for group 06'),
		('MASSOBJTYP','ZBP_07','Business partner for group 07'),
		('MASSOBJTYP','ZBP_08','Business partner for group 08'),
		('MASSOBJTYP','ZBP_09','Business partner for group 09'),
		('MASSOBJTYP','ZBP_10','Business partner for group 10'),
		('MASSOBJTYP','ZBP_11','Business partner for group 11'),
		('MASSOBJTYP','ZBP_12','Business partner for group 12'),
		('MASSOBJTYP','ZBP_13','Business partner for group 13'),
		('MASSOBJTYP','ZBP_14','Business partner for group 14'),
		('MASSOBJTYP','ZBP_15','Business partner for group 15'),
		('MASSOBJTYP','ZBP_16','Business partner for group 16'),
		('MASSOBJTYP','ZBP_17','Business partner for group 17'),
		('MASSOBJTYP','ZBP_18','Business partner for group 18'),
		('MASSOBJTYP','ZBP_19','Business partner for group 19'),
		('MASSOBJTYP','ZBP_20','Business partner for group 20'),
		('MASSOBJTYP','ZBP_21','Business partner for group 21'),
		('MASSOBJTYP','ZBP_22','Business partner for group 22'),
		('MASSOBJTYP','ZBP_23','Business partner for group 23'),
		('MASSOBJTYP','ZBP_24','Business partner for group 24'),
		('MASSOBJTYP','ZBP_25','Business partner for group 25'),
		('MASSOBJTYP','ZBP_26','Business partner for group 26'),
		('MASSOBJTYP','ZBP_27','Business partner for group 27'),
		('MASSOBJTYP','ZBP_28','Business partner for group 28'),
		('MASSOBJTYP','ZBP_29','Business partner for group 29'),
		('MASSOBJTYP','ZBP_30','Business partner for group 30'),
		('MASSOBJTYP','ZBP_31','Business partner for group 31'),
		('MASSOBJTYP','ZBP_32','Business partner for group 32'),
		('MASSOBJTYP','ZBP_33','Business partner for group 33'),
		('MASSOBJTYP','ZBP_34','Business partner for group 34'),
		('MASSOBJTYP','ZBP_35','Business partner for group 35'),
		('MASSOBJTYP','ZBP_36','Business partner for group 36'),
		('MASSOBJTYP','ZBP_37','Business partner for group 37'),
		('MASSOBJTYP','ZBP_38','Business partner for group 38'),
		('MASSOBJTYP','ZBP_39','Business partner for group 39'),
		('MASSOBJTYP','ZBP_40','Business partner for group 40'),
		('MASSOBJTYP','BUS1006004','Business Partner Group Hierarchy'),
		('MASSOBJTYP','BUS4403','Business partner item of a subledger accounting document in IS-U'),
		('MASSOBJTYP','BUSISB993','Business Partner Relationship with Shareholding Data'),
		('MASSOBJTYP','BUS1006006','Business Partner Shareholder Relationship'),
		('MASSOBJTYP','CLAIM_BP','Business partner test'),
		('MASSOBJTYP','BUS1036','Business process'),
		('MASSOBJTYP','BUS1114','Business process group'),
		('MASSOBJTYP','BUS1137','Business Process Structure CO'),
		('MASSOBJTYP','BUS4100','Business User'),
		('MASSOBJTYP','BUSMILEAGE','BUSMILEAGE'),
		('MASSOBJTYP','BUS6120','BW InfoSet'),
		('MASSOBJTYP','CADOCUMENT','CA Document'),
		('MASSOBJTYP','ISPPDOCUM','CA Document for IS-IS/CD'),
		('MASSOBJTYP','CALENDAR','Calendar'),
		('MASSOBJTYP','BUSAGR1','Call a transaction'),
		('MASSOBJTYP','BUSTSTC','Call a transaction'),
		('MASSOBJTYP','SPH_CDATA','Call data'),
		('MASSOBJTYP','HELP','Call extended help from workflow'),
		('MASSOBJTYP','PIQBUS7051','Campus Management Notification'),
		('MASSOBJTYP','PDRELA_040','Cancellation'),
		('MASSOBJTYP','ERC_CDCY','Candidacy in E-Recruiting'),
		('MASSOBJTYP','HRCDCY_NAV','Candidacy in SAP E-Recruiting'),
		('MASSOBJTYP','ERC_CAND','Candidate in E-Recruiting'),
		('MASSOBJTYP','HRCAND_NAV','Candidate in SAP E-Recruiting'),
		('MASSOBJTYP','T024C','CAP planner group'),
		('MASSOBJTYP','BPR_CAPWCP','capacity load'),
		('MASSOBJTYP','TC27','Capacity planner group'),
		('MASSOBJTYP','CARCAPACIT','CARCAPACIT'),
		('MASSOBJTYP','BUSISM002','Carrier Route'),
		('MASSOBJTYP','SCASE','Case'),
		('MASSOBJTYP','RMPSCASE','Case in Records Management for Public Sector'),
		('MASSOBJTYP','BUS2023','Cash Journal Document'),
		('MASSOBJTYP','IDOCEXTBON','Cash register receipt'),
		('MASSOBJTYP','BUS5540','CashFlowTransaction'),
		('MASSOBJTYP','BUS1189','Category Management Project'),
		('MASSOBJTYP','CATT','CATT procedure'),
		('MASSOBJTYP','CATT_INST','CATT run [instance of a CATT procedure]'),
		('MASSOBJTYP','CATT_ALE_1','CATT Session for ALE'),
		('MASSOBJTYP','J_3GEQUI','CEM Equipment'),
		('MASSOBJTYP','/SAPCEM/01','CEM Requirement Item'),
		('MASSOBJTYP','J_3GBELK','CEM shipping document header'),
		('MASSOBJTYP','J_3GBELP','CEM shipping document item'),
		('MASSOBJTYP','BUS1039','Change'),
		('MASSOBJTYP','J_3GBU1022','Change asset'),
		('MASSOBJTYP','USMD_CDOC','Change Document'),
		('MASSOBJTYP','ZMATCHANGE','Change of Material'),
		('MASSOBJTYP','USMD_CREQ','Change Request'),
		('MASSOBJTYP','BUS1088','Characteristic'),
		('MASSOBJTYP','BUS1161','Characteristic in Profitability Analysis'),
		('MASSOBJTYP','BUS1173','Characteristic values table'),
		('MASSOBJTYP','BUS1164','Characteristics Hierarchy in Profitability Analysis'),
		('MASSOBJTYP','BUS1029','Chart of Accounts'),
		('MASSOBJTYP','CA_CHECK','Check for Outgoing Payment in Contract Accounts Receivable and Payable'),
		('MASSOBJTYP','CHECKLIST','Checklist'),
		('MASSOBJTYP','BUS2176','Checklist Header'),
		('MASSOBJTYP','BUS2174','Checklist Item'),
		('MASSOBJTYP','BUS2168','Checklist Item in Checklist Template'),
		('MASSOBJTYP','BUS2171','Checklist Template'),
		('MASSOBJTYP','CCPROCED','CIC editor process'),
		('MASSOBJTYP','SAP0002','CIC process with BDC'),
		('MASSOBJTYP','CCPROCCT','CIC process with CATT'),
		('MASSOBJTYP','SAP0003','CIC process with HTML'),
		('MASSOBJTYP','CCPROCMT','CIC process with method'),
		('MASSOBJTYP','CCPROCWF','CIC process with Workflow'),
		('MASSOBJTYP','BUSISMCIC','CIC Support Object'),
		('MASSOBJTYP','CCPCICSUPP','CIC Support Object'),
		('MASSOBJTYP','SDISPOSITN','Circular'),
		('MASSOBJTYP','BUS7050','Claim'),
		('MASSOBJTYP','CLAIMAPMNT','Claim Appointment'),
		('MASSOBJTYP','SCLMAPMNT','Claim Appointment'),
		('MASSOBJTYP','CLAIM_PART','Claim Participant'),
		('MASSOBJTYP','CLAIM_POCC','Claim Participant Occurrence'),
		('MASSOBJTYP','CLAIMSUBOB','Claim Subobject'),
		('MASSOBJTYP','CFC_PAYRUN','Clarif. Processing: Payment Run'),
		('MASSOBJTYP','CFC_ULIVE','Clarif. Processing: Payment Run'),
		('MASSOBJTYP','CFC_BROKER','Clarification Processing: Broker Report'),
		('MASSOBJTYP','CFC_RECL','Clarification processing: Money laundering'),
		('MASSOBJTYP','CFC_PAYLOT','Clarification Processing: Payment Lot'),
		('MASSOBJTYP','CFC_OBJAP','Clarification worklist processing'),
		('MASSOBJTYP','BUS1003','Class'),
		('MASSOBJTYP','BUS1082011','Class for PDR Object Distribution'),
		('MASSOBJTYP','EWACLASS','Classification'),
		('MASSOBJTYP','CLEANOBJ','Cleaning Object'),
		('MASSOBJTYP','BUS2022','Clearing Case'),
		('MASSOBJTYP','/KYK/FICIC','Clearing of Open Items [Customer/Vendor/General Ledger]'),
		('MASSOBJTYP','FAGL_CLOCO','Closing Cockpit'),
		('MASSOBJTYP','SKWG_OBJ','CM Object'),
		('MASSOBJTYP','SKWG_PKG','CM Package'),
		('MASSOBJTYP','SKWG_WFPKG','CM Workflow Package'),
		('MASSOBJTYP','BUS1138','CO Statistical Key Figure'),
		('MASSOBJTYP','BUS5108','CO Transaction'),
		('MASSOBJTYP','BUS1139','CO: Resource'),
		('MASSOBJTYP','IDOCRCLROL','CO: Rollup or recon.ledger'),
		('MASSOBJTYP','QPGR','Code group'),
		('MASSOBJTYP','CPETASK','Collaboration Task'),
		('MASSOBJTYP','BUSJBDCOLL','Collateral - SEM Banking'),
		('MASSOBJTYP','BUSISB101','Collateral Agreement'),
		('MASSOBJTYP','UBCEDOC','Collection of Inbound Documents'),
		('MASSOBJTYP','VKLFALL1','Collections/Disbursements Clarification Case'),
		('MASSOBJTYP','PAYOH','Collective Payment Request'),
		('MASSOBJTYP','BUS2126002','Collective Vendor Billing Document'),
		('MASSOBJTYP','BUSJBDCP','Commercial Paper - SEM Banking'),
		('MASSOBJTYP','PRJ_NAV','commercial_project'),
		('MASSOBJTYP','BUS5530','CommercialPaper'),
		('MASSOBJTYP','CACSCASE','Commission Case'),
		('MASSOBJTYP','CACSCONTR','Commission Contract'),
		('MASSOBJTYP','CACSBUPA','Commission Contract Partner'),
		('MASSOBJTYP','CACSDOC','Commission Document'),
		('MASSOBJTYP','BUS2111','Commission Settlement Document'),
		('MASSOBJTYP','BUS0032','Commitment Item'),
		('MASSOBJTYP','HRFPM_RUN','Commitment Run PBC'),
		('MASSOBJTYP','BUSCPEC_FO','Commodity Customizing Formula'),
		('MASSOBJTYP','BUSCPEC_TE','Commodity Customizing Formula'),
		('MASSOBJTYP','BUSCPEC_TR','Commodity Customizing Formula'),
		('MASSOBJTYP','BUSCPED_FO','Commodity Customizing Formula'),
		('MASSOBJTYP','BUSCPED_TE','Commodity Customizing Formula'),
		('MASSOBJTYP','BUS5800','CommodityForward'),
		('MASSOBJTYP','BUS5120','CommodityMasterData'),
		('MASSOBJTYP','BUS5810','CommoditySwap'),
		('MASSOBJTYP','BUS0014','Company'),
		('MASSOBJTYP','BUS0002','Company Code'),
		('MASSOBJTYP','KNB1','Company code customer'),
		('MASSOBJTYP','LFB1','Company code vendor'),
		('MASSOBJTYP','USRCOMPANY','Company for company address'),
		('MASSOBJTYP','BUS1508','Comparative Group [RE-FX]'),
		('MASSOBJTYP','/CUM/CUNIT','Compatible Unit'),
		('MASSOBJTYP','COMPCARGB','COMPCARGB'),
		('MASSOBJTYP','BUSISM040','Complaint for Shipping Order'),
		('MASSOBJTYP','BUS2108','Complaint from Subscriber/Retailer'),
		('MASSOBJTYP','BUS2145','Complaint in Agency Business'),
		('MASSOBJTYP','/KYK/COMPL','Complaints'),
		('MASSOBJTYP','BUS1231','Completeness Check and MM ALE Distribution'),
		('MASSOBJTYP','BUS1176','Component [Integrated Product and Process Engineering]'),
		('MASSOBJTYP','BUS2151','Components Group [JIT Call Entry]'),
		('MASSOBJTYP','BUS3005','Condition'),
		('MASSOBJTYP','BUS2235','Condition Contract'),
		('MASSOBJTYP','BUS30010','Condition Maintenance Service'),
		('MASSOBJTYP','BUS3052','Configuration definition'),
		('MASSOBJTYP','BUS3052001','Configuration folder'),
		('MASSOBJTYP','IDOCALEAUD','Confirmations of IDoc Processing Status in Target System'),
		('MASSOBJTYP','BUS7003','Confirmations to Time Management'),
		('MASSOBJTYP','TSHRCONNEC','Connection of HR Target Component to CATS II'),
		('MASSOBJTYP','TSLOCONNEC','Connection of Target Components CO, PS and PM to CATS II'),
		('MASSOBJTYP','LAWCONSENG','Consolidated Engines in the License Administration Workbench'),
		('MASSOBJTYP','LAWCONSUTY','Consolidated User Types in the License Administration Workbench'),
		('MASSOBJTYP','LAWCONSUSR','Consolidated Users in the License Administration Workbench'),
		('MASSOBJTYP','SAP_11107','Consolidation business area'),
		('MASSOBJTYP','BUS1025','Consolidation chart of accounts'),
		('MASSOBJTYP','IDOCLCROLL','Consolidation data transfer'),
		('MASSOBJTYP','IDOCPCROLL','Consolidation data transfer'),
		('MASSOBJTYP','BUS1120','Consolidation dimension'),
		('MASSOBJTYP','BUS1027','Consolidation group'),
		('MASSOBJTYP','BUS1026','Consolidation ledger'),
		('MASSOBJTYP','BUS1024','Consolidation unit'),
		('MASSOBJTYP','BUS1122','Consolidation: Document type'),
		('MASSOBJTYP','BUS1121','Consolidation: Subitem categories'),
		('MASSOBJTYP','/CUM/CONSM','Construction Measure'),
		('MASSOBJTYP','/SAPPCE/01','Construction Progress Report'),
		('MASSOBJTYP','CON0417','contact information'),
		('MASSOBJTYP','BPR_CONTP','contact person'),
		('MASSOBJTYP','CON04172','Contacts'),
		('MASSOBJTYP','EEINFTYLOG','Container for Infotype Log Entries'),
		('MASSOBJTYP','WASTESLOC','Container Location'),
		('MASSOBJTYP','BPR_CONTR','contract'),
		('MASSOBJTYP','CA_CRDRTNG','Contract A/R &A/P Creditworthiness'),
		('MASSOBJTYP','CA_RETURN','Contract A/R&A/P Returns'),
		('MASSOBJTYP','ACCOUNT','Contract Account'),
		('MASSOBJTYP','CA_DUNNING','Contract Accounts Receivable and Payable Dunning'),
		('MASSOBJTYP','CANRZAA','Contract Accounts Receivable and Payable Repayment Number'),
		('MASSOBJTYP','CA_PAYMINC','Contract Accounts Receivable and Payable: Incoming Payment'),
		('MASSOBJTYP','CADOCUITEM','Contract Accounts Receivable and Payable: Line Item'),
		('MASSOBJTYP','CACHARGE','Contract Accounts Receivable: Charge Document'),
		('MASSOBJTYP','BUSISM012','Contract in Advertising Management'),
		('MASSOBJTYP','PS_OBJECT','Contract Object for Public Sector Applications'),
		('MASSOBJTYP','BUS1516','Contract Offer [RE-FX]'),
		('MASSOBJTYP','CA_BUS1006','Contract Partner'),
		('MASSOBJTYP','CA_VREF_GP','Contract Partner'),
		('MASSOBJTYP','CONTRACTES','Contract social insurance Spain'),
		('MASSOBJTYP','HRMASTER','Control object for HR master data replication'),
		('MASSOBJTYP','ORGMASTER','Control object for org. master data replication'),
		('MASSOBJTYP','BUS1281','Control Plan'),
		('MASSOBJTYP','BUS2166','Control Plan Item'),
		('MASSOBJTYP','BUS2165','Control Plan Version'),
		('MASSOBJTYP','BUS2115','Control recipe'),
		('MASSOBJTYP','BUS0004','Controlling area'),
		('MASSOBJTYP','BUS2072','Controlling Document'),
		('MASSOBJTYP','BUS2070','Controlling Object'),
		('MASSOBJTYP','IDOC21','Converted IDocs from Release 2.1/2.2'),
		('MASSOBJTYP','BUS11691','COPA Derivation Rule'),
		('MASSOBJTYP','BUS1168','COPAQuery'),
		('MASSOBJTYP','BUS1520','Correction Object [RE-FX]'),
		('MASSOBJTYP','BUS20370','Corrective Action for Audit'),
		('MASSOBJTYP','GRPC_CASEC','Corrective Action Preventive Action Plan'),
		('MASSOBJTYP','BUS4401','Correspondence'),
		('MASSOBJTYP','HRCORR_NAV','Correspondence for navigation in LSO'),
		('MASSOBJTYP','BUS0012','Cost Center'),
		('MASSOBJTYP','BUS1112','Cost center group'),
		('MASSOBJTYP','BUS1030','Cost Element'),
		('MASSOBJTYP','BUS1113','Cost element group'),
		('MASSOBJTYP','BUS2044','Cost Estimate'),
		('MASSOBJTYP','UBCCEFILE','Cost Event File'),
		('MASSOBJTYP','BUS2137','Cost Management Tool: Template'),
		('MASSOBJTYP','BUS2076','Cost Object Node'),
		('MASSOBJTYP','BUS204401','Costing Item'),
		('MASSOBJTYP','BUS2058','CostingRun'),
		('MASSOBJTYP','DRCOUNTRY','Country [Drag&Relate]'),
		('MASSOBJTYP','LSO_TRAINI','Course'),
		('MASSOBJTYP','HRCGRP_NAV','Course Group obj for navigation in LSO'),
		('MASSOBJTYP','HRCOUR_NAV','Course obj for navigation in LSO'),
		('MASSOBJTYP','LSO_PARTIC','Course Participation'),
		('MASSOBJTYP','LSO_TRTYPE','Course Type'),
		('MASSOBJTYP','HRCTYP_NAV','Course Type obj for navigation in LSO'),
		('MASSOBJTYP','TSCPRCONNE','cProjects Connection to New CATS'),
		('MASSOBJTYP','BUSISM0030','Create Contract'),
		('MASSOBJTYP','BUS0022','Credit control area'),
		('MASSOBJTYP','T024B','Credit management credit rep.group'),
		('MASSOBJTYP','BUS2094','Credit memo request'),
		('MASSOBJTYP','T024P','Credit mngmnt credit representative'),
		('MASSOBJTYP','BUSISM126P','CRM Business Activity [Proxy]'),
		('MASSOBJTYP','CATS','Cross-application time sheet'),
		('MASSOBJTYP','/ISDFPS/CM','Cross-System Command'),
		('MASSOBJTYP','/CUM/DESGN','CU Design'),
		('MASSOBJTYP','/CUM/CUINS','CU Instance'),
		('MASSOBJTYP','/CUM/ORDER','CU Order'),
		('MASSOBJTYP','BUS1090','Currency'),
		('MASSOBJTYP','SAP85207','Currency conversion plan'),
		('MASSOBJTYP','ZBUS7051','Custom General Notifiction'),
		('MASSOBJTYP','ZUS2032','Custom Sales Order'),
		('MASSOBJTYP','BPR_CUST','customer'),
		('MASSOBJTYP','BUS1007','Customer'),
		('MASSOBJTYP','KNA1','Customer'),
		('MASSOBJTYP','DRCUSTOM','Customer [Drag&Relate]'),
		('MASSOBJTYP','MDMKNA1','Customer [MDM]'),
		('MASSOBJTYP','SCUSTOMER','Customer [SAP training]'),
		('MASSOBJTYP','BUS3007','Customer account'),
		('MASSOBJTYP','BUS2037','Customer billing document [abstract]'),
		('MASSOBJTYP','BUS2037001','Customer billing document list'),
		('MASSOBJTYP','BPR_CUCPIT','customer cockpit'),
		('MASSOBJTYP','BUS2033','Customer complaint order'),
		('MASSOBJTYP','BCONTACT','Customer Contact'),
		('MASSOBJTYP','ISUCONTACT','Customer Contact [IS-U]'),
		('MASSOBJTYP','BUS2026','Customer Contact in Collections Management'),
		('MASSOBJTYP','BUS2034','Customer Contract'),
		('MASSOBJTYP','BUS1010','Customer credit limit'),
		('MASSOBJTYP','BUS2094001','Customer Credit Memo Request for DRM'),
		('MASSOBJTYP','BUS2096001','Customer Debit Memo Request for DRM'),
		('MASSOBJTYP','BUS2019','Customer document'),
		('MASSOBJTYP','ZKNA1','Customer ext.: Make-to-order, new customers'),
		('MASSOBJTYP','ZZKNA1','Customer ext.: Make-to-order, new customers'),
		('MASSOBJTYP','BPR_CUFACT','customer fact sheet'),
		('MASSOBJTYP','VBRK','Customer Individual Billing Document'),
		('MASSOBJTYP','BUS2030','Customer Inquiry'),
		('MASSOBJTYP','BUS2030001','Customer Inquiry with BOS'),
		('MASSOBJTYP','ZZBUS2032','Customer order - ext.'),
		('MASSOBJTYP','BUS2051','Customer outline agreement'),
		('MASSOBJTYP','BUS2144001','Customer payroll'),
		('MASSOBJTYP','BUS2031','Customer Quotation'),
		('MASSOBJTYP','KNVV','Customer Sales Area'),
		('MASSOBJTYP','BUS2035','Customer scheduling agreement'),
		('MASSOBJTYP','PTASK','Customer task'),
		('MASSOBJTYP','BUS2144','Customer-Specific Settlement Document'),
		('MASSOBJTYP','ISSR2','Customizing'),
		('MASSOBJTYP','/DSD/MECPT','Customizing Cockpit'),
		('MASSOBJTYP','CSOBJ_TREE','Customizing Objects in Application Component Hierarchy'),
		('MASSOBJTYP','BEPROJECT','Customizing project'),
		('MASSOBJTYP','CUST_TRAN','Customizing Transaction'),
		('MASSOBJTYP','/CWM/BUS70','CWM Handling Unit'),
		('MASSOBJTYP','BUS1078','Dangerous goods'),
		('MASSOBJTYP','/ISDFPS/GG','Dangerous Goods Up to Release 4.7'),
		('MASSOBJTYP','BUS4010','DART: Data Extract File'),
		('MASSOBJTYP','BUS4011','DART: Data View File'),
		('MASSOBJTYP','BUS2132','Data Cleansing Case'),
		('MASSOBJTYP','XALREPORT','Data Collector Message for the CCMS Monitoring Architecutre - XML'),
		('MASSOBJTYP','WEIGHDATAF','Data Finder for Weighing Data'),
		('MASSOBJTYP','BUS5104','Data for Hedge Management'),
		('MASSOBJTYP','DM40L','Data model'),
		('MASSOBJTYP','DXPROJECT','Data Transfer Project'),
		('MASSOBJTYP','DXRUN','Data Transfer Run'),
		('MASSOBJTYP','BUS6116','DataStore Object'),
		('MASSOBJTYP','DAYCOVERNG','Day Covering'),
		('MASSOBJTYP','DOMINANT','Day dominants'),
		('MASSOBJTYP','DPWTY_RTPA','Dealer Portal Business Object Return Part Item'),
		('MASSOBJTYP','DPWTY_OBJ','Dealer Portal Warranty BO Warranty Object'),
		('MASSOBJTYP','DPWTY_CLM','Dealer Portal Warranty Business Object Claim'),
		('MASSOBJTYP','DPWTY_CNT','Dealer Portal Warranty Business Object Contract'),
		('MASSOBJTYP','DPWTY_RCL','Dealer Portal Warranty Business Object Recall'),
		('MASSOBJTYP','Z_BUS2096','Debit Memo'),
		('MASSOBJTYP','ZBUS2096','Debit Memo'),
		('MASSOBJTYP','BUS2096','Debit memo request'),
		('MASSOBJTYP','SWF_OBJ','Default OBN for Executing Object Methods'),
		('MASSOBJTYP','SWF_WIOBN','Default OBN for Work Item Display/Execution'),
		('MASSOBJTYP','SALXMON','Defines a monitor'),
		('MASSOBJTYP','SALXMNSET','Defines a monitor set'),
		('MASSOBJTYP','SALXMNTREE','Defines a monitor tree'),
		('MASSOBJTYP','XALMTE','Defines a Monitor Tree Element'),
		('MASSOBJTYP','XALALERT','Defines a system alert'),
		('MASSOBJTYP','/KYK/DELIV','Delivery'),
		('MASSOBJTYP','BPR_DELIV','delivery'),
		('MASSOBJTYP','LIPS','Delivery item [only for optical archiving link]'),
		('MASSOBJTYP','WASTEDELIV','Delivery Lock'),
		('MASSOBJTYP','BUS6050','Delivery Processing'),
		('MASSOBJTYP','BUSISM013','Delivery Viability Set'),
		('MASSOBJTYP','/KYK/DM','Demand Management'),
		('MASSOBJTYP','SWFDEMO3','Demo: Approval procedure'),
		('MASSOBJTYP','SWFDEMO4','Demo: Approval procedure'),
		('MASSOBJTYP','SWFDEMO2','Demo: Circular'),
		('MASSOBJTYP','SWFDEMO1','Demo: Extended approval procedure'),
		('MASSOBJTYP','BUS5520','DepositAtNotice'),
		('MASSOBJTYP','T024L','Design office'),
		('MASSOBJTYP','ORGCHEARM','Designation for organizational reassignment'),
		('MASSOBJTYP','FORM','Desktop form'),
		('MASSOBJTYP','PRELD3DE','DEUEV Statement'),
		('MASSOBJTYP','BUS7030','Development Subprofile'),
		('MASSOBJTYP','DEVICE','Device'),
		('MASSOBJTYP','ISUDEVINFO','Device info record'),
		('MASSOBJTYP','BUS1238','DFPS Material Requisition'),
		('MASSOBJTYP','/ISDFPS/MT','DFPS Request Material Master'),
		('MASSOBJTYP','/ISDFPS/PQ','DFPS: Cross-System Purchase Requisition'),
		('MASSOBJTYP','/ISDFPS/PO','DFPS: Recipient PO'),
		('MASSOBJTYP','/ISDFPS/GR','DFPS: Replicate Goods Receipt'),
		('MASSOBJTYP','/ISDFPS/SV','DFPS: Site Survey'),
		('MASSOBJTYP','BEDIAVAR','Diagram variants'),
		('MASSOBJTYP','INPSDISACT','Diciplinary Action India Public Sector'),
		('MASSOBJTYP','BUS1178008','Digital Asset'),
		('MASSOBJTYP','/XFT/DIOD1','DIOD1'),
		('MASSOBJTYP','DISCONNECT','Disconnection'),
		('MASSOBJTYP','DISACTION','Disconnection document activity'),
		('MASSOBJTYP','CA_WLIA_N','Disconnection Notification'),
		('MASSOBJTYP','BUS3052003','Dispatch of a configuration folder'),
		('MASSOBJTYP','BUSN2MVDR','Dispatch Order for Med. Document'),
		('MASSOBJTYP','APPT_REC','Dispatcher for Incoming iCalendar Objects'),
		('MASSOBJTYP','/NAM/DISP','Dispatching Object'),
		('MASSOBJTYP','INFOLIST','Display infosystem batch list'),
		('MASSOBJTYP','HELPVALUES','Display input help in interfaces'),
		('MASSOBJTYP','BPR_MATAVO','display material availability'),
		('MASSOBJTYP','BPR_MATDOC','display material document'),
		('MASSOBJTYP','/KYK/QT','Display/Change Quotes'),
		('MASSOBJTYP','BUS2022001','Dispute Case [FI-AR]'),
		('MASSOBJTYP','BUS2022002','Dispute Case [FI-CA]'),
		('MASSOBJTYP','BUS0006001','Distribution chain'),
		('MASSOBJTYP','TVTW','Distribution channel'),
		('MASSOBJTYP','/ISDFPS/PK','Distribution of Packing Conditions'),
		('MASSOBJTYP','TSPA','Division'),
		('MASSOBJTYP','W_VIRT_DOC','Doc. no. for which no document exists'),
		('MASSOBJTYP','DRAW','Document'),
		('MASSOBJTYP','BUS1082','Document distribution order'),
		('MASSOBJTYP','BUS1082002','Document distribution order package'),
		('MASSOBJTYP','BPR_DOCFLW','document flow item'),
		('MASSOBJTYP','RMPSDOC','Document in Records Management for Public Sector'),
		('MASSOBJTYP','BSEG_MMIV','Document line in accounting doc. in invoice verification'),
		('MASSOBJTYP','BUS1082001','Document partial order'),
		('MASSOBJTYP','DRB','Document Relationship Browser'),
		('MASSOBJTYP','BUS1081','Document structure'),
		('MASSOBJTYP','WF_DOCTMPL','Document template [for workflow]'),
		('MASSOBJTYP','MS_WORDDOT','Document templates in MS-Word'),
		('MASSOBJTYP','MESSAGE','Document with Recipient List'),
		('MASSOBJTYP','ISUSLDCMNT','Document/sub-ledger document'),
		('MASSOBJTYP','BPR_DOCS','documents'),
		('MASSOBJTYP','/SAPPCE/04','Down Payment Chain: Barcode Pop-Up'),
		('MASSOBJTYP','/SAPPCE/05','Down Payment Chain: Verification'),
		('MASSOBJTYP','IDOCISUCOA','Download confirmation/rejection of bill consolidator logon/logoff'),
		('MASSOBJTYP','BUS1064','Drawing Factors'),
		('MASSOBJTYP','IDOCWVINVE','DRS: Download Phys. Inv. Docs Upload Phys. Inv. Count Data'),
		('MASSOBJTYP','USER_TRANS','Dummy for SWHACTOR --> SY-UNAME'),
		('MASSOBJTYP','SAP_12113','Dunning Area'),
		('MASSOBJTYP','VDUNHIST','Dunning History for Contract'),
		('MASSOBJTYP','FIODUNNING','Dunning Letter'),
		('MASSOBJTYP','/CWM/LIKP','Duplication with CWM Data'),
		('MASSOBJTYP','EAM_EQUI','EAM Equipment'),
		('MASSOBJTYP','EAM_FLOC','EAM Functional Location'),
		('MASSOBJTYP','EAM_LRP','EAM Linear Reference Pattern'),
		('MASSOBJTYP','EAM_MTI','EAM Maintenance Item'),
		('MASSOBJTYP','EAM_MTP','Eam maintenance plan'),
		('MASSOBJTYP','EAM_ORD','EAM Order'),
		('MASSOBJTYP','EAM_ASSET','EAMS Asset Viewer'),
		('MASSOBJTYP','EAMS_ASSET','EAMS Asset Viewer'),
		('MASSOBJTYP','EAMS_EQUI','EAMS Equipment'),
		('MASSOBJTYP','EAMS_FLOC','EAMS functionallocation'),
		('MASSOBJTYP','EAM_GISV','EAMS GIS Viewer'),
		('MASSOBJTYP','EAM_INFOC','EAMS Infocenter'),
		('MASSOBJTYP','EAMS_INFOC','EAMS Infocenter'),
		('MASSOBJTYP','EAM_JOBLS','EAMS Joblist'),
		('MASSOBJTYP','EAMS_JOBLS','EAMS Joblist'),
		('MASSOBJTYP','EAM_MD','EAMS Measurement Doc'),
		('MASSOBJTYP','EAMS_MD','EAMS Measurement Doc'),
		('MASSOBJTYP','EAM_MP','EAMS Measuring Point'),
		('MASSOBJTYP','EAMS_MP','EAMS Measuring Point'),
		('MASSOBJTYP','EAM_NTF','EAMS Notification'),
		('MASSOBJTYP','EAMS_NTF','EAMS Notification'),
		('MASSOBJTYP','EAM_JOB','eams_job'),
		('MASSOBJTYP','EAMS_JOB','eams_job_oif'),
		('MASSOBJTYP','FMRE','Earmarked funds document item'),
		('MASSOBJTYP','BUS2086','Earmarked Funds Value Adjustment Document'),
		('MASSOBJTYP','BBPBUS2081','EBP Incoming Invoice'),
		('MASSOBJTYP','EBPP_SPART','EBPP SubParty'),
		('MASSOBJTYP','ECATT','eCATT Object'),
		('MASSOBJTYP','ECO','ECH: Change object'),
		('MASSOBJTYP','ZECMDRAW','ECM Document'),
		('MASSOBJTYP','YDRAW','ECO with Doc. Status'),
		('MASSOBJTYP','USMD_EDTN','Edition'),
		('MASSOBJTYP','BUS3018','EE time quota'),
		('MASSOBJTYP','BUS1240','EHS: Incident/Accident Log'),
		('MASSOBJTYP','BPR_FND_CD','EHSM Change Documents'),
		('MASSOBJTYP','BPR_FNDLHR','EHSM LOcation Hierarchy'),
		('MASSOBJTYP','BPR_FND_UL','EHSM Where Used List'),
		('MASSOBJTYP','EICFOLLWUP','EIC Activity Follow-Up'),
		('MASSOBJTYP','EICFOLUPVP','EIC Activity Follow-Up'),
		('MASSOBJTYP','EICCONTACT','EIC Contact Details'),
		('MASSOBJTYP','EICCONTVP','EIC Contact Details'),
		('MASSOBJTYP','EICIBITEM','EIC Inbox: SAPConnect Entry'),
		('MASSOBJTYP','EICSLA','EIC Service Level Agreement'),
		('MASSOBJTYP','EICSLAVP','EIC Service Level Agreement'),
		('MASSOBJTYP','RMELEMENT','Element from Records Management'),
		('MASSOBJTYP','EMMACASE','EMMA: Case'),
		('MASSOBJTYP','EMMAJOB','EMMA: Job'),
		('MASSOBJTYP','EMMAPROC','EMMA: Process'),
		('MASSOBJTYP','BUS1065','Employee'),
		('MASSOBJTYP','ZBUS1065','Employee'),
		('MASSOBJTYP','BUS3029','Employee - benefits'),
		('MASSOBJTYP','BUS302905','Employee - benefits - credit plan'),
		('MASSOBJTYP','BUS302904','Employee - benefits - flexible spending account'),
		('MASSOBJTYP','BUS302901','Employee - benefits - health plan'),
		('MASSOBJTYP','BUS302902','Employee - benefits - insurance'),
		('MASSOBJTYP','BUS302906','Employee - benefits - miscellaneous'),
		('MASSOBJTYP','BUS302903','Employee - benefits - savings plan'),
		('MASSOBJTYP','BUS302900','Employee - benefits item'),
		('MASSOBJTYP','BUS7020','Employee - compensation adjustment'),
		('MASSOBJTYP','EMPLOITALY','Employee - Italy'),
		('MASSOBJTYP','ZEMPLOYEET','Employee - time'),
		('MASSOBJTYP','ABSENCE','Employee Absence'),
		('MASSOBJTYP','ABSCEQUOTA','Employee Absence Quota'),
		('MASSOBJTYP','ABSQUOTSTL','Employee Absence Quota for Leave'),
		('MASSOBJTYP','SLQUOTAPOS','Employee absence quota leave item'),
		('MASSOBJTYP','ADDRESSEMP','Employee Address'),
		('MASSOBJTYP','ADDREMPFR','Employee address [France]'),
		('MASSOBJTYP','ADDREMPCH','Employee address CH'),
		('MASSOBJTYP','ADDREMPDE','Employee Address in Germany'),
		('MASSOBJTYP','ADDREMPJP','Employee Address JP'),
		('MASSOBJTYP','ADDREMPNL','Employee address NL'),
		('MASSOBJTYP','ADDREMPE','Employee address Spain'),
		('MASSOBJTYP','ADDREMPUS','Employee address US'),
		('MASSOBJTYP','EMPALTNAME','Employee alternative name'),
		('MASSOBJTYP','ATTENDANCE','Employee attendance'),
		('MASSOBJTYP','EMPATTABS','Employee attendance or absence'),
		('MASSOBJTYP','ATTCEQUOTA','Employee attendance quota'),
		('MASSOBJTYP','BUS7002','Employee availability schedule'),
		('MASSOBJTYP','BANKJP','Employee Bank Detail JP'),
		('MASSOBJTYP','BANKNZ','Employee bank details Newzealand'),
		('MASSOBJTYP','BASICPAY','Employee basic pay'),
		('MASSOBJTYP','CPF','Employee basic pay'),
		('MASSOBJTYP','BASPAYPOS','Employee basic pay item'),
		('MASSOBJTYP','BENADJREAS','Employee benefit adjustment reason'),
		('MASSOBJTYP','BUS302907','Employee benefits stock purchase plan'),
		('MASSOBJTYP','EMPCAPFODE','Employee Capital Formation - Germany'),
		('MASSOBJTYP','EMPLCOMM','Employee communication'),
		('MASSOBJTYP','DATESPECS','Employee date specification'),
		('MASSOBJTYP','PREL','Employee Document'),
		('MASSOBJTYP','EXTBANKPAY','Employee external bank payments'),
		('MASSOBJTYP','FAMILYINT','Employee family/related person [abstract]'),
		('MASSOBJTYP','FAMILYHK','Employee Family/related Person HK'),
		('MASSOBJTYP','FAMILYID','Employee family/related person Indonesia'),
		('MASSOBJTYP','FAMILY','Employee family/related person international'),
		('MASSOBJTYP','FAMILYJP','Employee Family/related person JP'),
		('MASSOBJTYP','FAMILYMY','Employee family/related person Malaysia'),
		('MASSOBJTYP','FAMILYNL','Employee family/related person NL'),
		('MASSOBJTYP','FAMILYSG','Employee family/related person Singapore'),
		('MASSOBJTYP','FAMILYE','Employee family/related person Spain'),
		('MASSOBJTYP','FAMILYTW','Employee family/related person Taiwan'),
		('MASSOBJTYP','FAMILYTH','Employee family/related person Thailand'),
		('MASSOBJTYP','GENBENINFO','Employee general benefits information'),
		('MASSOBJTYP','BUS0029','Employee group'),
		('MASSOBJTYP','EMPLOYEEI','Employee information'),
		('MASSOBJTYP','EMPLOYEESU','Employee information according to infotype and subtype'),
		('MASSOBJTYP','EMPLOYEEIP','Employee information by item'),
		('MASSOBJTYP','EMPLOYEEIT','Employee information differentiated by type'),
		('MASSOBJTYP','INTCONTROL','Employee internal control data'),
		('MASSOBJTYP','ZINTCTRL','Employee internal control data'),
		('MASSOBJTYP','ADDPAYMENT','Employee one-off payment'),
		('MASSOBJTYP','ORGASSIGNM','Employee organizational assignment'),
		('MASSOBJTYP','PERSDATA','Employee personal data - international'),
		('MASSOBJTYP','PERSDATINT','Employee personal data [abstract]'),
		('MASSOBJTYP','PERSDATAHK','Employee Personal Data HK'),
		('MASSOBJTYP','PERSDATAJP','Employee Personal data JP'),
		('MASSOBJTYP','PERSDATAMY','Employee personal data Malaysia'),
		('MASSOBJTYP','EMPPERSID','Employee personal Identification'),
		('MASSOBJTYP','EMPPREVIER','Employee previous employer'),
		('MASSOBJTYP','ADDREMPAU','Employee private address Australia'),
		('MASSOBJTYP','ADDREMPHK','Employee private address Hongkong'),
		('MASSOBJTYP','ADDREMPID','Employee Private Address Indonesia'),
		('MASSOBJTYP','ADDREMPMY','Employee private address Malaysia'),
		('MASSOBJTYP','ADDREMPNZ','Employee private address Newzealand'),
		('MASSOBJTYP','ADDREMPSG','Employee Private Address Singapore'),
		('MASSOBJTYP','ADDREMPTW','Employee private address Taiwan'),
		('MASSOBJTYP','ADDREMPTH','Employee Private Address Thailand'),
		('MASSOBJTYP','/MRSS/SQWR','Employee profile'),
		('MASSOBJTYP','BUS7004','Employee remuneration statement'),
		('MASSOBJTYP','EMPSALPACK','Employee Salary Package'),
		('MASSOBJTYP','SOCINSNL','Employee Social Insurance Netherlands'),
		('MASSOBJTYP','SOCINSES','Employee social insurance Spain [ES]'),
		('MASSOBJTYP','BUS0024','Employee subgroup'),
		('MASSOBJTYP','EMPSUPANAU','Employee superannuation Australia'),
		('MASSOBJTYP','ORGCH','Employee Switzerland addition org. assignment'),
		('MASSOBJTYP','SOCINSCH','Employee Switzerland social insurance'),
		('MASSOBJTYP','RESSTATCH','Employee Switzerland status of residence permit'),
		('MASSOBJTYP','TAXINFCH','Employee Switzerland withholding tax'),
		('MASSOBJTYP','EMPTAXAU','Employee Tax Information Australia'),
		('MASSOBJTYP','TAXINFNL','Employee Tax Information Netherlands'),
		('MASSOBJTYP','EMPTAXTH','Employee Tax Information Thailand'),
		('MASSOBJTYP','BUS7013','Employee time overview'),
		('MASSOBJTYP','BUS7025','Employee time sheet'),
		('MASSOBJTYP','EMPLOYEEAU','Employee time specifications Australia'),
		('MASSOBJTYP','EMPLOYEEHK','Employee time specifications Hongkong'),
		('MASSOBJTYP','EMPLOYEEID','Employee time specifications Indonesia'),
		('MASSOBJTYP','EMPLOYEEJP','Employee time specifications Japan'),
		('MASSOBJTYP','EMPLOYEEMY','Employee time specifications Malaysia'),
		('MASSOBJTYP','EMPLOYEENZ','Employee time specifications Newzealand'),
		('MASSOBJTYP','EMPLOYEENL','Employee time specifications NL'),
		('MASSOBJTYP','EMPLOYEESG','Employee time specifications Singapore'),
		('MASSOBJTYP','EMPLOYEEE','Employee time specifications Spain'),
		('MASSOBJTYP','EMPLOYEECH','Employee time specifications Switzerland'),
		('MASSOBJTYP','EMPLOYEETW','Employee time specifications Taiwan'),
		('MASSOBJTYP','EMPLOYEETH','Employee time specifications Thailand'),
		('MASSOBJTYP','EMPLOYEEUS','Employee time specifications US'),
		('MASSOBJTYP','BUS2089','Employee Trip'),
		('MASSOBJTYP','BUS2089A','Employee Trip Receipt'),
		('MASSOBJTYP','WORKTIME','Employee Working Time'),
		('MASSOBJTYP','BUS7016','Employee: EE Time Valuation Specifications'),
		('MASSOBJTYP','BUS2079','Employee: Enter Employee Times'),
		('MASSOBJTYP','EMPLOYEEGB','EMPLOYEEGB'),
		('MASSOBJTYP','EMPLOYEEIC','Employees for Employee Interaction Center'),
		('MASSOBJTYP','TAXCERPYDE','Employment Tax Statement Germany ELSTER'),
		('MASSOBJTYP','/KYK/ECM','Engineering Change Management'),
		('MASSOBJTYP','ECM','Engineering Change Management: Change master'),
		('MASSOBJTYP','BUS1210','Engineering Change Order'),
		('MASSOBJTYP','BUS1211','Engineering Change Request'),
		('MASSOBJTYP','/KYK/PRODV','Engineering Production Version'),
		('MASSOBJTYP','LAWENGINE','Engines in the License Administration Workbench'),
		('MASSOBJTYP','ORGUNITEXT','Enhanced Organizational Unit'),
		('MASSOBJTYP','USMD_ENTY','Entity Type'),
		('MASSOBJTYP','BUS3033','Entity view 6093 customer-material-information'),
		('MASSOBJTYP','WITRFCID','Entry for tRFC'),
		('MASSOBJTYP','BPR_EQUIP','equipment'),
		('MASSOBJTYP','EQUI','Equipment'),
		('MASSOBJTYP','PDRELA_021','Equipment'),
		('MASSOBJTYP','ISU_EQUI','Equipment [+ IS-U Functions]'),
		('MASSOBJTYP','BUS1227','Equipment Package [EPA] Force ID Relationship'),
		('MASSOBJTYP','EQUI_EXT2','Equipment Subtype in EA-APPL'),
		('MASSOBJTYP','EXCEPTHAND','Error Handling'),
		('MASSOBJTYP','ISUSWTELOG','Error Log for Switch Document'),
		('MASSOBJTYP','CCPMATH','Evaluator for mathematical expressions'),
		('MASSOBJTYP','FKKBIEDR','Event  Detail  Record'),
		('MASSOBJTYP','SKWG_SBSCR','Event Linkage for CM_Subscription'),
		('MASSOBJTYP','BUSCOMPXPD','Events and Status Information'),
		('MASSOBJTYP','BUSEXPD','Events and Status Information'),
		('MASSOBJTYP','BUS1279','Exception to Dangerous Goods Regulations'),
		('MASSOBJTYP','OIA_BUS003','Exchange Agreement'),
		('MASSOBJTYP','BUS1093','Exchange Rate'),
		('MASSOBJTYP','J_1IEXCINV','Excise Invoice [India]'),
		('MASSOBJTYP','FOPC_ACTIO','Execute Task'),
		('MASSOBJTYP','BWFUTLCALL','Execution Service for Workflow'),
		('MASSOBJTYP','EMPAWEXERC','Exercise an Award'),
		('MASSOBJTYP','BUS1157','Expenditure Program Definition'),
		('MASSOBJTYP','BUS2144002','Expenses settlement'),
		('MASSOBJTYP','EXPERTPROF','Expert Profile'),
		('MASSOBJTYP','BUS5115','Exposure'),
		('MASSOBJTYP','BUS5990','Exposure Management 2.0'),
		('MASSOBJTYP','BUSISM030','Ext. Interface for Home Delivery Settlement'),
		('MASSOBJTYP','IDOCEXTBED','Ext. requirement cust./store'),
		('MASSOBJTYP','IDOCEDLNOT','Ext.agt delivery notes suppliers'),
		('MASSOBJTYP','BUS2002001','Extended Network in Plug-In'),
		('MASSOBJTYP','BUS2001001','Extended Project Definition in Plug-In'),
		('MASSOBJTYP','BUS2054001','Extended WBS in Plug-In'),
		('MASSOBJTYP','/OPT/B2081','Extension of BUS2081 - LIV Header Level Object'),
		('MASSOBJTYP','BUSISM008P','External Advertising Management Sales Document'),
		('MASSOBJTYP','BUSISM007P','External Business Partner'),
		('MASSOBJTYP','COMMPROC','External communication operation'),
		('MASSOBJTYP','BUSISM012P','External Contract in Advertising Management'),
		('MASSOBJTYP','IDOCEXTDOC','External Documents in IDoc'),
		('MASSOBJTYP','PDOTYPE_U','External organization [\'Company\' in Training and Event Management]'),
		('MASSOBJTYP','PDOTYPE_H','External person'),
		('MASSOBJTYP','PROXY0001','External sales support document'),
		('MASSOBJTYP','BUS1062','External Securities Account Statement'),
		('MASSOBJTYP','EXTSRV','External service'),
		('MASSOBJTYP','EEWAGECOMP','External Wage Components for an employee'),
		('MASSOBJTYP','WAGECOMP','External Wage Components for an Employee'),
		('MASSOBJTYP','ZMAIL','External/Internal mail'),
		('MASSOBJTYP','XBPJOB','Externally controllable background [an interface]'),
		('MASSOBJTYP','BUSJBDFCTY','Facility - SEM Banking'),
		('MASSOBJTYP','FACTORYCAL','Factory calendar'),
		('MASSOBJTYP','BUS1182','Factory Layout [Integrated Product and Process Engineering]'),
		('MASSOBJTYP','BUS1280','Failure Mode and Effects Analysis'),
		('MASSOBJTYP','FAMILYIT','Family/ reference person'),
		('MASSOBJTYP','FAMILYUS','FAMILYUS'),
		('MASSOBJTYP','FICORR','FI Correspondence with UUID'),
		('MASSOBJTYP','IDOCFIDCCH','FI document change'),
		('MASSOBJTYP','IDOC21INFI','FI invoice receipt converted from 2.1'),
		('MASSOBJTYP','CA_VTREF','FI-CA Contract'),
		('MASSOBJTYP','CA_CONTACC','FI-CA Contract Account'),
		('MASSOBJTYP','CA_CODUNN','FI-CA Correspondence Dunning'),
		('MASSOBJTYP','CA_DOC','FI-CA Document'),
		('MASSOBJTYP','CA_DMS','FI-CA Document [DMS]'),
		('MASSOBJTYP','FSCLNITEM','FI-CA Ext.: Line Item'),
		('MASSOBJTYP','FSC_RETURN','FI-CA Ext.: Returns'),
		('MASSOBJTYP','CA_CREDINF','FI-CA Info'),
		('MASSOBJTYP','FICAVIEWS','FI-CA Information Views'),
		('MASSOBJTYP','CA_DOCPOS','FI-CA Line Item'),
		('MASSOBJTYP','CA_PAYINFO','FI-CA Payment Information'),
		('MASSOBJTYP','CA_PAYFCC','FI-CA Payment Information [FCC]'),
		('MASSOBJTYP','CA_INDPAY','FI-CA Payment Specification'),
		('MASSOBJTYP','CA_ERROR','FI-CA Program Error'),
		('MASSOBJTYP','CA_P2P','FI-CA Promise to Pay'),
		('MASSOBJTYP','CA_RECKEY','FI-CA Reconciliation Key'),
		('MASSOBJTYP','CA_RPAYREQ','FI-CA Repayment Request'),
		('MASSOBJTYP','CA_KEYPP','FI-CA Subarea for Parallel Mass Processing'),
		('MASSOBJTYP','CA_WLI','FI-CA Work Item'),
		('MASSOBJTYP','CA_WLIA','FI-CA Work Item'),
		('MASSOBJTYP','CA_WL','FI-CA Work Item List'),
		('MASSOBJTYP','CA_WRTOFF','FI-CA Write Off'),
		('MASSOBJTYP','CASECURITY','FI-CA: Security deposit'),
		('MASSOBJTYP','USMD_FLTR','Filter Criteria'),
		('MASSOBJTYP','FIN_REORG','FIN_REORG'),
		('MASSOBJTYP','BUS1098','Financial index value'),
		('MASSOBJTYP','BUS1076','Financial Product [security class]'),
		('MASSOBJTYP','BUSJBDFP','Financial Product [Security Class]'),
		('MASSOBJTYP','BUS2042','Financial Transaction'),
		('MASSOBJTYP','BUS1178007','FinancialServiceProduct'),
		('MASSOBJTYP','BUS1178003','Financing Product'),
		('MASSOBJTYP','USMD_SRCH','Find'),
		('MASSOBJTYP','BUS1022','Fixed asset'),
		('MASSOBJTYP','BUS1056','Fixed asset ledger'),
		('MASSOBJTYP','BUS3052002','Fixed product folder'),
		('MASSOBJTYP','BUSJBDFTD','Fixed-Term Deposit - SEM Banking'),
		('MASSOBJTYP','BUS5510','FixedTermDeposit'),
		('MASSOBJTYP','DRSFLIGHT','Flight [Drag&Relate]'),
		('MASSOBJTYP','SBOOKAUX','Flight booking'),
		('MASSOBJTYP','DRBBOOK','Flight Booking [Drag&Relate]'),
		('MASSOBJTYP','DRSBOOK','Flight Booking [Drag&Relate]'),
		('MASSOBJTYP','SBOOK','Flight booking [SAP training]'),
		('MASSOBJTYP','DRSPFLI','Flight Connection [Drag&Relate]'),
		('MASSOBJTYP','SFLCONN','Flight connection offered by travel agency'),
		('MASSOBJTYP','SFLTRIP','Flight trip'),
		('MASSOBJTYP','SFLIGHT','Flight with connection data [SAP training]'),
		('MASSOBJTYP','BUS0027','FM Area'),
		('MASSOBJTYP','CACSOAWL','FOA: Worklist for Object Assignment'),
		('MASSOBJTYP','BUS1239','Force Element'),
		('MASSOBJTYP','BUS1221','Force Element Force ID'),
		('MASSOBJTYP','BUS1225','Force Element Supply Relationship'),
		('MASSOBJTYP','BUS5600','Foreign exchange'),
		('MASSOBJTYP','BUS5760','Foreign Exchange Option'),
		('MASSOBJTYP','BUSJBDFX','Foreign Exchange Transactions in SEM Banking'),
		('MASSOBJTYP','BUS1101','Forex swap rate'),
		('MASSOBJTYP','DYNP_FORM','Form'),
		('MASSOBJTYP','EMPLOYTXDE','Form for Employment Tax Notification'),
		('MASSOBJTYP','FORMABSENC','Form: Notification of Absence'),
		('MASSOBJTYP','ISUFRMALLC','Formula Allocation in IS-U'),
		('MASSOBJTYP','BUSJBDFRA','Forward Rate Agreement - SEM Banking'),
		('MASSOBJTYP','FPBMONITOR','FPB Application Monitor'),
		('MASSOBJTYP','FPIA_INV','FPIA Incoming Invoice'),
		('MASSOBJTYP','BUS2103','Free-of-charge Subsequent Delivery'),
		('MASSOBJTYP','CCPROCFO','Front office process for customer care'),
		('MASSOBJTYP','BUSISI001','FS-CD: Broker Report'),
		('MASSOBJTYP','BUSISI006','FS-CD: Contract Account'),
		('MASSOBJTYP','BUSISI004','FS-CD: Contract Account [Obsolete]'),
		('MASSOBJTYP','BUSISI007','FS-CD: Insurance Object'),
		('MASSOBJTYP','BUSISI003','FS-CD: Insurance Object [Obsolete]'),
		('MASSOBJTYP','BUSISI009','FS-CD: Insurance Object-Business Partner'),
		('MASSOBJTYP','EBPPBILL','FSCM Biller Direct Bill'),
		('MASSOBJTYP','CLAIM','FS-CM Claim'),
		('MASSOBJTYP','ICLCCEVENT','FS-CM Claim Bundle'),
		('MASSOBJTYP','SUBCLAIM','FS-CM Subclaim'),
		('MASSOBJTYP','ICLACT','FS-CM Task in Claim'),
		('MASSOBJTYP','ICLEACT','FS-CM Task in Claim Bundle'),
		('MASSOBJTYP','BUS5101','FTRAdditionalFlow'),
		('MASSOBJTYP','BUS5102','FTRCondition'),
		('MASSOBJTYP','BUS5103','FTRPaymentDetail'),
		('MASSOBJTYP','BUS0023','Functional Area'),
		('MASSOBJTYP','BPR_FUNCTL','functional location'),
		('MASSOBJTYP','BUS0010','Functional Location'),
		('MASSOBJTYP','BUS0034','Fund'),
		('MASSOBJTYP','BUS0038','Funded Program'),
		('MASSOBJTYP','BUS0033','Funds Center'),
		('MASSOBJTYP','BUS5700','Future'),
		('MASSOBJTYP','BUS5106','FX Transaction'),
		('MASSOBJTYP','BUS2069','G/L account document'),
		('MASSOBJTYP','BRF1000','General BRF Object'),
		('MASSOBJTYP','BUS1134','General Contract [Real Estate]'),
		('MASSOBJTYP','BUS1079','General Cost Object'),
		('MASSOBJTYP','BUS1028','General ledger'),
		('MASSOBJTYP','BUS7051','General Notification'),
		('MASSOBJTYP','SWOTBASDAT','General object type'),
		('MASSOBJTYP','ERC_OBJECT','General Object Type of ERC Objects'),
		('MASSOBJTYP','BUS1194','General Recipe'),
		('MASSOBJTYP','SAP0001','General service functions for BAPIs'),
		('MASSOBJTYP','WASTETOOLS','General Service Functions for IS-Waste'),
		('MASSOBJTYP','BUS1197','Generic Engineering Node [iPPE]'),
		('MASSOBJTYP','REPORT','Generic Object for Reports'),
		('MASSOBJTYP','BUSJBDGETR','Generic Transaction for SEM Banking'),
		('MASSOBJTYP','BUSISM003','Geographical Unit'),
		('MASSOBJTYP','CLAIMINFO','Get Claim Information'),
		('MASSOBJTYP','ISUGBCIF','GIS Business Connector Interface'),
		('MASSOBJTYP','ASSIGNCHKL','Global Assignment Check List'),
		('MASSOBJTYP','GLOBASREQ','Global Assignment Request'),
		('MASSOBJTYP','BUS6801','Global Trade Services: Customs Processing: Customs Document - Interface'),
		('MASSOBJTYP','IDOCGLROLL','GLX: Rollup of GL tables'),
		('MASSOBJTYP','GGD11A2034','Golden Gate Customer Contract Object'),
		('MASSOBJTYP','GGD11A2032','Golden Gate Customer Order Object'),
		('MASSOBJTYP','GGD11A2031','Golden Gate Customer Quotation Object'),
		('MASSOBJTYP','GGD11A1045','Golden Gate Software License Business Object'),
		('MASSOBJTYP','BPR_GOODSI','goods issue'),
		('MASSOBJTYP','/SAPCEM/02','Goods movement'),
		('MASSOBJTYP','BPR_GOODSM','goods movement'),
		('MASSOBJTYP','BUS2017','Goods Movement'),
		('MASSOBJTYP','/CWM/BUS17','Goods Movement CWM'),
		('MASSOBJTYP','/ISDFPS/WB','Goods Movement DFPS'),
		('MASSOBJTYP','BUS2017OIL','Goods Movement Oil'),
		('MASSOBJTYP','BPR_GREC','goods receipt'),
		('MASSOBJTYP','MKPF','Goods receipt'),
		('MASSOBJTYP','GOSFLIGHT','GOS Extension Flight Data'),
		('MASSOBJTYP','CCPSJUMP','Goto in front office process'),
		('MASSOBJTYP','BUS0035','Grant'),
		('MASSOBJTYP','EMPAWARD','Granting of an Award'),
		('MASSOBJTYP','WASTEGUARC','Guarantor Contract'),
		('MASSOBJTYP','WASTEGUARP','Guarantor Contract Item'),
		('MASSOBJTYP','ALERT_CONF','Handler for Inbound Alerts'),
		('MASSOBJTYP','WI_MAILREC','Handler for messages to work items'),
		('MASSOBJTYP','BUS3070','Handling unit'),
		('MASSOBJTYP','BPR_HND_UN','handling_unit'),
		('MASSOBJTYP','BUS1119','Hazardous Substance'),
		('MASSOBJTYP','BUS1311','HC Appointment'),
		('MASSOBJTYP','BUS1309','HC Business Partner'),
		('MASSOBJTYP','BUS2098','HC Case Diagnosis'),
		('MASSOBJTYP','BUS1303','HC Case Procedure'),
		('MASSOBJTYP','BUS2099','HC Case Service'),
		('MASSOBJTYP','BUS1301','HC diagnosis coding catalog'),
		('MASSOBJTYP','BUS1310','HC Institution'),
		('MASSOBJTYP','BUS1308','HC Insurance Verification Document'),
		('MASSOBJTYP','BUS1410','HC Medical/Nursing Services'),
		('MASSOBJTYP','BUS1304','HC org. unit service'),
		('MASSOBJTYP','BUS1084','HC Patient'),
		('MASSOBJTYP','BUS2097','HC Patient Case'),
		('MASSOBJTYP','BUS1306','HC Patient Movement'),
		('MASSOBJTYP','BUS1307','HC PatientCaseBillingDocument'),
		('MASSOBJTYP','BUS1300','HC Service Catalog'),
		('MASSOBJTYP','BUS1305','HC Service Master'),
		('MASSOBJTYP','BUS1302','HC surgical procedure catalog'),
		('MASSOBJTYP','BUS5105','Hedge Plan'),
		('MASSOBJTYP','RMPSPESPRT','Help Object for Incoming E-Mail'),
		('MASSOBJTYP','BUDOCUMENT','Hierarchy document'),
		('MASSOBJTYP','BEFILTER','Hierarchy filter'),
		('MASSOBJTYP','BESTRUCT','Hierarchy Structure'),
		('MASSOBJTYP','HIGHDUTY','Higher Duty'),
		('MASSOBJTYP','BUS2112','Home delivery settlement document'),
		('MASSOBJTYP','ZDOTYPE_E','HR Business Eventf'),
		('MASSOBJTYP','ZSP_TRIP','HR Demonstration of CRM ICWC'),
		('MASSOBJTYP','ZSPWC_TRIP','HR Demonstration of CRM ICWC'),
		('MASSOBJTYP','PDOTYPE_SH','HR Position'),
		('MASSOBJTYP','STATEMENTS','HR Statements'),
		('MASSOBJTYP','PBC_NOTES','HROBJECT'),
		('MASSOBJTYP','BUS7015','HR-PDC: Manager for Calculating Expenditures'),
		('MASSOBJTYP','BUS7014','HR-PDC: Manager for external employee time events'),
		('MASSOBJTYP','BUS1013','IBAN [International Bank Account Number]'),
		('MASSOBJTYP','ICCHAT','ICCHATObject'),
		('MASSOBJTYP','ICLPAY','ICL Payment'),
		('MASSOBJTYP','BUS3081','ICRC: BOR Object for Reconciliation Process 001.'),
		('MASSOBJTYP','BUS3082','ICRC: BOR Object for Reconciliation Process 002.'),
		('MASSOBJTYP','BUS3083','ICRC: BOR Object for Reconciliation Process 003.'),
		('MASSOBJTYP','TRANSID','ID of tRFC communication process'),
		('MASSOBJTYP','Z_QUOTE','IDES version of Customer Quotation'),
		('MASSOBJTYP','Z_VENDOR','IDES Version of Vendor'),
		('MASSOBJTYP','IDOCAPPL','IDoc'),
		('MASSOBJTYP','IDOCDISUPL','IDoc disconnection upload'),
		('MASSOBJTYP','ICLIDOCEVT','IDOC Event Triggers'),
		('MASSOBJTYP','IDOCCOGRP9','IDOC for account groups [Profit Center Accounting]'),
		('MASSOBJTYP','IDOCACPJMM','IDOC for Accounting Goods Movement'),
		('MASSOBJTYP','IDOCACLREC','IDOC for Accounting Invoice'),
		('MASSOBJTYP','IDOCACLPAY','IDoc for Accounting Invoice Receipt'),
		('MASSOBJTYP','IDOCCOGRP5','IDOC for activity type groups'),
		('MASSOBJTYP','IDOCCOAMAS','IDoc for activity types'),
		('MASSOBJTYP','IDOCMMADDI','IDoc for additionals'),
		('MASSOBJTYP','IDOCFIDCC1','IDOC for all FI documents'),
		('MASSOBJTYP','IDOCFIDCC2','IDOC for all FI documents'),
		('MASSOBJTYP','IDOCASSMOD','Idoc for assortment modules'),
		('MASSOBJTYP','IDOCHRPRS','IDOC for Attendances for Time Management'),
		('MASSOBJTYP','IDOCFINSTA','IDOC for bank statements'),
		('MASSOBJTYP','IDOCWMBBIN','IDoc for blocking storage bins'),
		('MASSOBJTYP','IDOCWMCATO','IDoc for Cancelling Transfer Orders'),
		('MASSOBJTYP','IDOCCHRMAS','IDoc for Characteristics'),
		('MASSOBJTYP','IDOCCLSMAS','IDoc for Class Transfer'),
		('MASSOBJTYP','IDOCCLFMAS','IDoc for Classification'),
		('MASSOBJTYP','IDOCCODCMT','IDoc for CO documents'),
		('MASSOBJTYP','IDOCCOTOTL','IDoc for CO totals records'),
		('MASSOBJTYP','IDOCCOMITM','IDoc for COMM_ITEM [Commitment Item]'),
		('MASSOBJTYP','IDOCCONF11','IDoc for communication channel 1 [CONF11]'),
		('MASSOBJTYP','IDOCCONF21','IDoc for communication channel 2 [CONF21]'),
		('MASSOBJTYP','IDOCCONF22','IDoc for communication channel 2 [CONF22]'),
		('MASSOBJTYP','IDOCCONF31','IDoc for communication channel 3 [CONF31]'),
		('MASSOBJTYP','IDOCCONF32','IDoc for communication channel 3 [CONF32]'),
		('MASSOBJTYP','IDOCCONF41','IDoc for communication channel 4 [CONF41]'),
		('MASSOBJTYP','IDOCCONF42','IDoc for communication channel 4 [CONF42]'),
		('MASSOBJTYP','IDOCCONF51','IDoc for communications channel 4 [CONF42]'),
		('MASSOBJTYP','IDOCCOND_A','IDOC for conditions'),
		('MASSOBJTYP','IDOCCNPMAS','IDOC for Configuration Profile'),
		('MASSOBJTYP','IDOCRCYLST','IDoc for confirming recovery objects'),
		('MASSOBJTYP','IDOCWMTOCO','IDoc for Confirming Transfer Orders'),
		('MASSOBJTYP','IDOCVTMMAS','IDoc for Contents of Variant Tables'),
		('MASSOBJTYP','IDOCBLAOCH','IDoc for contract changes'),
		('MASSOBJTYP','IDOCBLAORD','IDoc for contracts'),
		('MASSOBJTYP','IDPKCONDAT','IDoc for control data adjustment'),
		('MASSOBJTYP','IDOCCOCOKA','IDoc for control segment CO object/cost element'),
		('MASSOBJTYP','IDOCCOGRP','IDOC for cost center hierarchy'),
		('MASSOBJTYP','IDOCCOGRP1','IDOC for cost center hierarchy'),
		('MASSOBJTYP','IDOCCOACTV','IDoc for cost center/activity type'),
		('MASSOBJTYP','IDOCCOSMAS','IDOC for cost centers'),
		('MASSOBJTYP','IDOCCOELEM','IDoc for cost elements'),
		('MASSOBJTYP','IDOCWMTREQ','IDoc for Creating/Cancelling Transf.Reqs.'),
		('MASSOBJTYP','IDOCCREMAS','IDoc for creditor master'),
		('MASSOBJTYP','IDOCDEBMAS','IDoc for customers'),
		('MASSOBJTYP','IDOCCOPCPA','IDOC for data transmission CO-PC -> CO-PA'),
		('MASSOBJTYP','IDOCDELCON','IDoc for Days Collective Delivery Note /Delivery Confirmation'),
		('MASSOBJTYP','IDOCDOCMAS','IDoc for Documents'),
		('MASSOBJTYP','IDOCWMINVE','IDoc for Entering Actual Count Data for WM Inventory'),
		('MASSOBJTYP','IDOCWMMBXY','IDoc for Entering Goods Movements in Materials Management'),
		('MASSOBJTYP','IDOCSHIPPL','IDOC for externally planned transports'),
		('MASSOBJTYP','IDOCFIDCMT','IDoc for FI documents'),
		('MASSOBJTYP','IDOCFIROLL','IDoc for FI rollups'),
		('MASSOBJTYP','IDOCALFW','IDoc for Forwarding'),
		('MASSOBJTYP','IDOCFUNDFE','IDoc for Fund Requesting'),
		('MASSOBJTYP','IDOCFUNDMA','IDoc for FUNDM [ Fund ]'),
		('MASSOBJTYP','IDOCGLMAST','IDoc for G/L accounts'),
		('MASSOBJTYP','IDOCCOAFET','IDoc for getting activity type master data'),
		('MASSOBJTYP','IDOCCOSFET','IDoc for getting cost center master data'),
		('MASSOBJTYP','IDOCDEBFET','IDoc for getting customer master data'),
		('MASSOBJTYP','IDOCGLFETC','IDoc for getting G/L account master data'),
		('MASSOBJTYP','IDOCMATFET','IDoc for getting material master data'),
		('MASSOBJTYP','IDOCKNOMAS','IDoc for Global Object Dependencies'),
		('MASSOBJTYP','IDOCHRPAYP','IDOC for HR - days carried over FI/CO'),
		('MASSOBJTYP','IDOCHRMD','IDOC for HR master data and organizational data'),
		('MASSOBJTYP','IDOCWMPIHU','IDoc for Inbound Transfer Orders'),
		('MASSOBJTYP','IDOCWMTORD','IDoc for Inbound Transfer Orders'),
		('MASSOBJTYP','IDOCHRINW','IDOC for Incentive Wages Time Tickets'),
		('MASSOBJTYP','IDOCSOPGEN','IDoc for Info Structure Data Exchange'),
		('MASSOBJTYP','IDOCINVCON','IDoc for Inventory Controlling'),
		('MASSOBJTYP','IDOCJV_INV','IDoc for Invoice & Operating Expense Stm'),
		('MASSOBJTYP','IDOCDELINS','IDOC for JIT/ROr suppliers'),
		('MASSOBJTYP','IDOCJVCABI','IDOC for JV Invoices/Operating Statement'),
		('MASSOBJTYP','IDOCJVUSBI','IDOC for JV Invoices/Operating Statement'),
		('MASSOBJTYP','IDOCKANBAN','IDoc for kanban calls'),
		('MASSOBJTYP','IDOCLIKOND','IDoc for listing conditions'),
		('MASSOBJTYP','IDOCOILLDD','IDOC for loading related data from depot'),
		('MASSOBJTYP','IDOCLOCKBX','IDOC for lockbox data'),
		('MASSOBJTYP','IDOCBOMMAT','IDOC for material BOMs'),
		('MASSOBJTYP','IDOCMATMAS','IDoc for material master'),
		('MASSOBJTYP','IDOCWMSUMO','IDoc for Moving Storage Unit'),
		('MASSOBJTYP','IDOCSRCLST','IDOC for order book'),
		('MASSOBJTYP','IDOCCOGRP3','IDOC for Order Groups'),
		('MASSOBJTYP','IDOCREMADV','IDoc for payment advice notes'),
		('MASSOBJTYP','IDOCPRCMAS','IDOC for Profit Center'),
		('MASSOBJTYP','IDOCCOGRG7','IDOC for profit Center groups'),
		('MASSOBJTYP','IDOCCOGRP6','IDOC for profit Center groups'),
		('MASSOBJTYP','IDOCCOPAGN','IDoc for Profitability Analysis'),
		('MASSOBJTYP','IDOCDELORD','IDoc for purchase orders'),
		('MASSOBJTYP','IDOCREQRES','IDoc for purchase requisition/reservation'),
		('MASSOBJTYP','IDOCINFREC','IDOC for purchasing info record'),
		('MASSOBJTYP','IDOCEKSEKS','IDoc for purchasing information systems'),
		('MASSOBJTYP','IDOCQUALIT','IDoc for quality data'),
		('MASSOBJTYP','IDOCBLAREL','IDoc for release order statistics for distributed contracts'),
		('MASSOBJTYP','IDOCREQOTE','IDoc for REQOTE'),
		('MASSOBJTYP','IDOCCMREQU','IDoc for requesting TR-CM data'),
		('MASSOBJTYP','IDOCCREFET','IDoc for requisition vendors'),
		('MASSOBJTYP','IDOCARTMAS','IDoc for retail materials'),
		('MASSOBJTYP','IDOCPRCFET','IDOC for retrieving profit center master data'),
		('MASSOBJTYP','IDOCRCYFET','IDoc for retrieving recovery objects'),
		('MASSOBJTYP','IDOCRCYRSP','IDoc for returning recovery objects'),
		('MASSOBJTYP','IDOCACCSTA','IDoc for RP account statments'),
		('MASSOBJTYP','IDOCRPMFIF','IDOC for RPM financial data'),
		('MASSOBJTYP','IDOCSISDEL','IDoc for Sales Information System Delivery'),
		('MASSOBJTYP','IDOCSISINV','IDoc for Sales Information System Invoices'),
		('MASSOBJTYP','IDOCSISCSO','IDoc for Sales Information Systems'),
		('MASSOBJTYP','IDOCSEQJIT','IDoc for Sequenced JIT Call'),
		('MASSOBJTYP','IDOCSRVMAS','IDoc for service master record'),
		('MASSOBJTYP','IDOCVTAMAS','IDoc for Structures of Variant Tables'),
		('MASSOBJTYP','IDOCTRXSTA','IDoc for tracking message'),
		('MASSOBJTYP','IDOCHRTRVL','IDoc for transfer of trip costs accounting to FI'),
		('MASSOBJTYP','IDOCPROACT','IDoc for transferring sales/stock data'),
		('MASSOBJTYP','IDOCCMSEND','IDoc for TR-CM data'),
		('MASSOBJTYP','IDOCISMR','IDOC for upload: meter reding document -> meter reading results'),
		('MASSOBJTYP','IDOCISRO','IDoc for uploading route for service of service frequency'),
		('MASSOBJTYP','IDOCWMCUST','IDoc for user-defined messages'),
		('MASSOBJTYP','IDOCCOGRP2','IDOC für cost element groups'),
		('MASSOBJTYP','IDOCISUMSC','Idoc ISU_MSCONS'),
		('MASSOBJTYP','IDOCISUD00','IDoc ISU_REQUEST'),
		('MASSOBJTYP','IDOCSDSMCP','IDoc ISU_SDSM_COMP'),
		('MASSOBJTYP','IDOCSDSMOR','IDoc ISU_SDSM_ORDER'),
		('MASSOBJTYP','IDOCISUMSO','IDoc maintenence service order'),
		('MASSOBJTYP','IDPKGLMAST','IDoc mass inbound proc. GLMAST'),
		('MASSOBJTYP','IDOCDESADV','IDoc message DESADV'),
		('MASSOBJTYP','IDOCFTRCON','IDoc Message FTRCON [Financial Transaction Confirmation]'),
		('MASSOBJTYP','IDOCSYIDOC','IDoc Message IDoc Type'),
		('MASSOBJTYP','IDOCINVOIC','IDoc Message INVOIC'),
		('MASSOBJTYP','IDOCORDCHG','IDoc message ORDCHG'),
		('MASSOBJTYP','IDOCORDERS','IDoc message ORDERS'),
		('MASSOBJTYP','IDOCORDRSP','IDoc Message ORDRSP'),
		('MASSOBJTYP','IDOCSYRECD','IDoc Message Record Types'),
		('MASSOBJTYP','IDOCSTATUS','IDoc Message STATUS'),
		('MASSOBJTYP','IDOCTXTRAW','IDoc Message Text'),
		('MASSOBJTYP','IDOCOMSEND','IDoc outage end: Update ISUSM order and create contacts'),
		('MASSOBJTYP','IDOCGSVERF','IDoc output: Self-billing procedure for component suppliers'),
		('MASSOBJTYP','IDPKFIDCC1','IDOC package for message type FIDCC1'),
		('MASSOBJTYP','IDPKFIDCC2','IDOC package for message type FIDCC2'),
		('MASSOBJTYP','IDPKWMPIHU','IDoc package with message type WMTORD'),
		('MASSOBJTYP','IDPKWMTORD','IDoc package with message type WMTORD'),
		('MASSOBJTYP','IDPKSHPMNT','IDOC packages of output type SHPMNT'),
		('MASSOBJTYP','IDOCPACKET','IDoc packet'),
		('MASSOBJTYP','IDPKALFW','IDoc packet for forwarding'),
		('MASSOBJTYP','IDPKCOAFET','IDoc packet for getting activity type masters'),
		('MASSOBJTYP','IDPKCOSFET','IDoc packet for getting cost center masters'),
		('MASSOBJTYP','IDPKDEBFET','IDoc packet for getting customer masters'),
		('MASSOBJTYP','IDPKGLFETC','IDoc packet for getting G/L account masters'),
		('MASSOBJTYP','IDPKMATFET','IDoc packet for getting material masters'),
		('MASSOBJTYP','IDPKJVCABI','IDOC packet for Message type JVCABI'),
		('MASSOBJTYP','IDPKJVUSBI','IDOC packet for Message type JVUSBI'),
		('MASSOBJTYP','IDPKFUNDFE','IDoc Packet for Requesting Fund'),
		('MASSOBJTYP','IDPKPRCFET','IDOC packet for retrieving profit center master record'),
		('MASSOBJTYP','IDPKCOPCPA','IDOC packet for transmission CO-PC -> CO-PA'),
		('MASSOBJTYP','IDPKBLAORD','IDoc packet of message type BLAORD'),
		('MASSOBJTYP','IDPKBLAREL','IDoc packet of message type BLAREL'),
		('MASSOBJTYP','IDPKBLAOCH','IDoc packet with message type BLAOCH'),
		('MASSOBJTYP','IDPKCMREQU','IDOC packet with message type CMREQU'),
		('MASSOBJTYP','IDPKCMSEND','IDOC packet with message type CMSEND'),
		('MASSOBJTYP','IDPKCOACTV','IDoc packet with message type COACTV'),
		('MASSOBJTYP','IDPKCOAMAS','IDoc packet with message type COAMAS'),
		('MASSOBJTYP','IDPKCOCOKA','IDoc packet with message type COCOKA'),
		('MASSOBJTYP','IDPKCODCMT','IDoc packet with message type CODCMT'),
		('MASSOBJTYP','IDPKCOELEM','IDoc packet with message type COELEM'),
		('MASSOBJTYP','IDPKCOTOTL','IDoc packet with message type COTOTL'),
		('MASSOBJTYP','IDPKFIDCCH','IDoc packet with message type FIDCCH'),
		('MASSOBJTYP','IDPKFIDCMT','IDoc packet with message type FIDCMT'),
		('MASSOBJTYP','IDPKSISDEL','IDoc packet with message type SISDEL'),
		('MASSOBJTYP','IDPKSISINV','IDoc packet with message type SISINV'),
		('MASSOBJTYP','IDPKWMBBIN','IDoc packet with message type WMBBIN'),
		('MASSOBJTYP','IDPKWMCATO','IDoc packet with message type WMCATO'),
		('MASSOBJTYP','IDPKWMINFO','IDoc packet with message type WMINFO'),
		('MASSOBJTYP','IDPKWMINVE','IDoc packet with message type WMINVE'),
		('MASSOBJTYP','IDPKWMSUMO','IDoc packet with message type WMSUMO'),
		('MASSOBJTYP','IDPKWMTREQ','IDoc packet with message type WMSUMO'),
		('MASSOBJTYP','IDPKWMTOCO','IDoc packet with message type WMTOCO'),
		('MASSOBJTYP','IDPKSOPGEN','IDoc packet with reference message type SOPGEN'),
		('MASSOBJTYP','IDOCPAKET','IDoc packets'),
		('MASSOBJTYP','IDPKCHRMAS','IDoc packets of message type CHRMAS'),
		('MASSOBJTYP','IDPKCLFMAS','IDoc packets of message type CLFMAS'),
		('MASSOBJTYP','IDPKCREMAS','IDoc packets with message type IDPKCREMAS'),
		('MASSOBJTYP','IDPKDELORD','IDoc packets with message type ORDERS'),
		('MASSOBJTYP','IDPKORDERS','IDoc packets with message type ORDERS'),
		('MASSOBJTYP','IDPKWMMBXY','IDoc packets with message type WMMBXY'),
		('MASSOBJTYP','IDOCEANREF','IDOC part with an EAN reference [POS upload]'),
		('MASSOBJTYP','IDOCARTICL','IDoc part with master data of a material [POS upload]'),
		('MASSOBJTYP','IDOCISUADV','IDoc rejection'),
		('MASSOBJTYP','IDOCSTATIS','IDoc Statistics'),
		('MASSOBJTYP','STATRECORD','IDoc Status Record'),
		('MASSOBJTYP','IDOCIDCREF','IDoc Type for References for Electronic Signature'),
		('MASSOBJTYP','IDOCMDIUPL','IDoc: MDI upload'),
		('MASSOBJTYP','IDOCISOE','IDOC: Outage end/update ISUSMORDER'),
		('MASSOBJTYP','IDOCACSREQ','IDoc: RP Account Statement Request'),
		('MASSOBJTYP','IDOCSTOACT','IDoc: Stock activity [ESP]'),
		('MASSOBJTYP','IHC_PN','IHC Payment Order [Obsolete]'),
		('MASSOBJTYP','PDRELA_028','Impartation'),
		('MASSOBJTYP','IMG_PROJ','Implementation Project'),
		('MASSOBJTYP','XMISESSION','Implementing the XMI'),
		('MASSOBJTYP','PS_INCORR','Inbound Correspondence for Public Sector Applications'),
		('MASSOBJTYP','BPR_INBDEL','inbound delivery'),
		('MASSOBJTYP','BUS2015','Inbound delivery'),
		('MASSOBJTYP','ADBUS2015','Inbound delivery [AD]'),
		('MASSOBJTYP','ZBUS2015','Inbound delivery Enhanced'),
		('MASSOBJTYP','/CWM/BUS15','Inbound Delivery with CWM'),
		('MASSOBJTYP','IDOCWNTYRQ','Inbound IDoc [IC]: Warranty Request'),
		('MASSOBJTYP','IDOCWNTYCF','Inbound IDoc [IV]: Warranty Confirmation'),
		('MASSOBJTYP','BUS2081HSC','Inbound Invoice_HSC'),
		('MASSOBJTYP','BUS1171','Inbound price catalog'),
		('MASSOBJTYP','BPR_HS_INC','Incident'),
		('MASSOBJTYP','BPR_RP_INC','Incident Report'),
		('MASSOBJTYP','/XFT/INV01','Incoming invoice'),
		('MASSOBJTYP','BUS2081','Incoming Invoice'),
		('MASSOBJTYP','BUS2081OI','Incoming Invoice'),
		('MASSOBJTYP','ADBUS2081','Incoming Invoice [AD]'),
		('MASSOBJTYP','/XFT/INV02','Incoming invoice: Approval'),
		('MASSOBJTYP','BUS1170','Incoming or Outgoing Correspondence for Loan'),
		('MASSOBJTYP','RMPSPOST','Incoming Post Item'),
		('MASSOBJTYP','PDRELA_003','Incorporation'),
		('MASSOBJTYP','BUS1278','Individual Object / Product'),
		('MASSOBJTYP','BUS1278001','Individual Object / Product Material'),
		('MASSOBJTYP','PFVALSCH','Individual Values of PF Member'),
		('MASSOBJTYP','BUS6112','InfoCube'),
		('MASSOBJTYP','BUS6108','InfoObject'),
		('MASSOBJTYP','BUS6113','InfoObject Catalog'),
		('MASSOBJTYP','BUS6109','InfoPackage'),
		('MASSOBJTYP','SYSSERVICE','Information About SAP System Services [WPs]'),
		('MASSOBJTYP','IDOCWMINFO','Information Record from Subsystem'),
		('MASSOBJTYP','WDK_QUERY','InfoSet Query'),
		('MASSOBJTYP','BUS6107','InfoSource Data Provider'),
		('MASSOBJTYP','BUS6114','InfoSource Data Request'),
		('MASSOBJTYP','BUS6105','InfoSource Hierarchy Transfer'),
		('MASSOBJTYP','BUS6103','InfoSource Master'),
		('MASSOBJTYP','BUS6104','InfoSource Master Transfer'),
		('MASSOBJTYP','BUS6102','InfoSource Transaction'),
		('MASSOBJTYP','BUS6106','InfoSource Transaction Transfer'),
		('MASSOBJTYP','INFOTYP','Infotype'),
		('MASSOBJTYP','IDCREATION','Init.data creat.doc.'),
		('MASSOBJTYP','BPR_INQUIR','inquiry'),
		('MASSOBJTYP','BUS2045','Inspection lot'),
		('MASSOBJTYP','QMTB','Inspection Method'),
		('MASSOBJTYP','BUS204501','Inspection operation'),
		('MASSOBJTYP','BUS204502','Inspection operation characteristic'),
		('MASSOBJTYP','BUS204503','Inspection operation inspection point'),
		('MASSOBJTYP','/SPE/INSPE','Inspection Outcome [SPM]'),
		('MASSOBJTYP','BUS1023','Inspection plan'),
		('MASSOBJTYP','BUS1191','Inspection plan'),
		('MASSOBJTYP','INSTMNTPLN','Installment Plan'),
		('MASSOBJTYP','BUS1096001','Instance of a variant configuration'),
		('MASSOBJTYP','PDRELA_026','Instructor'),
		('MASSOBJTYP','IO','Insurance Object'),
		('MASSOBJTYP','BUSISI010','InsuranceCollectionDisbursementRequest'),
		('MASSOBJTYP','BUS1178004','Intellectual Property'),
		('MASSOBJTYP','BUS5550','InterestRateInstrument'),
		('MASSOBJTYP','CODEGEN','Interface generator'),
		('MASSOBJTYP','SWOTIF','Interface type'),
		('MASSOBJTYP','IDOC','Intermediate Document [IDoc]'),
		('MASSOBJTYP','BUS3052004','Internal configuration folder [CEP]'),
		('MASSOBJTYP','BUS2075','Internal order'),
		('MASSOBJTYP','BPR_IO','internal order for lean staffing'),
		('MASSOBJTYP','POS_UP_DOC','Internal POS upload document'),
		('MASSOBJTYP','ISU_IAC','Internet object'),
		('MASSOBJTYP','/XFT/INV50','INV Cycle'),
		('MASSOBJTYP','WLB0001','Investment buying Retail'),
		('MASSOBJTYP','BUS1057','Investment program'),
		('MASSOBJTYP','DPSPP_INVO','Invoice'),
		('MASSOBJTYP','/ORS/INVAP','Invoice Approval Object'),
		('MASSOBJTYP','/KYK/IDOC','Invoice Document'),
		('MASSOBJTYP','VBRL','Invoice list'),
		('MASSOBJTYP','INVRADVDOC','Invoice or RemAdv Document'),
		('MASSOBJTYP','BUS5107','IR Transaction'),
		('MASSOBJTYP','/ISDFPS/CR','ISDFPS Batches'),
		('MASSOBJTYP','/ISDFPS/VL','ISDFPS Relocation'),
		('MASSOBJTYP','/ISDFPS/VS','ISDFPS Relocation'),
		('MASSOBJTYP','BUSISMSD01','IS-M/SD: ND Notification'),
		('MASSOBJTYP','BUSISM027B','IS-M: Bank Returns Research'),
		('MASSOBJTYP','BUSISM027D','IS-M: Carrier Route Research'),
		('MASSOBJTYP','BUSISM001','IS-M: Change Number'),
		('MASSOBJTYP','BUSISM027O','IS-M: Order Research'),
		('MASSOBJTYP','BUSISM014','IS-M: Return Request'),
		('MASSOBJTYP','/SAPMP/BMU','IS-MP: Batch-Specific Material Quantity Unit'),
		('MASSOBJTYP','/SAPMP/STM','IS-MP: Standard Material'),
		('MASSOBJTYP','FOPC_CASEI','Issue'),
		('MASSOBJTYP','GRPC_CASEI','Issue'),
		('MASSOBJTYP','BUSISM016','Issue Sequence'),
		('MASSOBJTYP','WASTESDQUO','IS-U Customer Quotation'),
		('MASSOBJTYP','ISUDERSUP','IS-U deregulation help'),
		('MASSOBJTYP','DEVICETYPE','IS-U device category'),
		('MASSOBJTYP','ISUFINDER','IS-U search function [data finder]'),
		('MASSOBJTYP','ISUSERPROV','ISU Service Provider'),
		('MASSOBJTYP','ISUSETTLUN','ISU Settlement Unit'),
		('MASSOBJTYP','ISUACCTCLS','IS-U: Account Class'),
		('MASSOBJTYP','ISUADDRESS','IS-U: Address'),
		('MASSOBJTYP','PRINTDOC','IS-U: Bill Printout Document'),
		('MASSOBJTYP','SCHEMA','IS-U: billing schema'),
		('MASSOBJTYP','ISUPARTNER','IS-U: business partner'),
		('MASSOBJTYP','CONNOBJ','IS-U: Connection Object'),
		('MASSOBJTYP','ISUACCOUNT','IS-U: contract account'),
		('MASSOBJTYP','ISUSDQUOTA','IS-U: Customer Quotation'),
		('MASSOBJTYP','ISUTASK','IS-U: Data Exchange Task'),
		('MASSOBJTYP','DEVLOC','IS-U: Device Location'),
		('MASSOBJTYP','DISCOUNT','IS-U: discount/surcharge'),
		('MASSOBJTYP','ISUSECTOR','IS-U: division'),
		('MASSOBJTYP','ISUFFEE','IS-U: franchise contract'),
		('MASSOBJTYP','ISUIDEPROC','IS-U: IDE process'),
		('MASSOBJTYP','ISUIDETRAN','IS-U: IDE transaction'),
		('MASSOBJTYP','ISUBUSVIEW','IS-U: information view'),
		('MASSOBJTYP','IDOCDCHNG','IS-U: Installation removal and replacement of devices'),
		('MASSOBJTYP','ISUPRDOC','IS-U: Parked Document'),
		('MASSOBJTYP','ISU_PRICE','IS-U: Price'),
		('MASSOBJTYP','PRICE','IS-U: price'),
		('MASSOBJTYP','RATE','IS-U: rate'),
		('MASSOBJTYP','ISUSDORPOS','IS-U: Sales Document Item'),
		('MASSOBJTYP','ISUSDORDER','IS-U: Sales Order'),
		('MASSOBJTYP','ISULOT','IS-U: sample lot'),
		('MASSOBJTYP','SERVFREQ','IS-U: Service frequency'),
		('MASSOBJTYP','SFTOSDOC','IS-U: Service Frequency for Service Contract'),
		('MASSOBJTYP','ISUSMNOTIF','IS-U: Service notification'),
		('MASSOBJTYP','ISUSMORDER','IS-U: Service Order'),
		('MASSOBJTYP','ISUSRVPROD','IS-U: Service Product'),
		('MASSOBJTYP','ISUCHTICKT','ISU-Change Ticket'),
		('MASSOBJTYP','ISUCRMCNCT','ISU-CRM Connector'),
		('MASSOBJTYP','ISUCRMCNTR','ISU-CRM Contract [CRM Order Item]'),
		('MASSOBJTYP','ISUSETTL','ISU-EDM: Settlement'),
		('MASSOBJTYP','ISUIDESWD','IS-U-IDE Switch Document'),
		('MASSOBJTYP','ISUSWITCHD','IS-U-IDE Switch Document'),
		('MASSOBJTYP','WASTEPRDCT','IS-U-WA: Sales Application'),
		('MASSOBJTYP','WASTESDCTR','IS-U-WA: SD Contract'),
		('MASSOBJTYP','WASTESDINV','IS-U-WA: SD Invoice'),
		('MASSOBJTYP','BROREP_POS','Item for a broker report'),
		('MASSOBJTYP','ZZVBAP2032','Item in a customer order'),
		('MASSOBJTYP','MSEG','Item in Material Document'),
		('MASSOBJTYP','CFC_CRPO','Itemize Credit Clarification'),
		('MASSOBJTYP','VBRP','Itemized customer billing document item'),
		('MASSOBJTYP','BUS2118','JIT call'),
		('MASSOBJTYP','BUS2150','JIT Call [Inbound]'),
		('MASSOBJTYP','BUS2152','JIT/JIS Call Outbound'),
		('MASSOBJTYP','BUS1160','JOA Equity Group'),
		('MASSOBJTYP','PDOTYPE_C','Job [Description of Positions]'),
		('MASSOBJTYP','BPJOB','Job in background processing'),
		('MASSOBJTYP','HRJOB_NAV','Job in SAP E-Recruiting'),
		('MASSOBJTYP','ERC_POST','Job Posting in E-Recruiting'),
		('MASSOBJTYP','HRPOST_NAV','Job Posting in SAP E-Recruiting'),
		('MASSOBJTYP','BUS1519','Joint Liability [RE-FX]'),
		('MASSOBJTYP','BUS1163','Joint Operating Agreement'),
		('MASSOBJTYP','CCPSJUMPON','JUMP object for customer care process'),
		('MASSOBJTYP','BUS1075','Kanban'),
		('MASSOBJTYP','BUS1172','Kanban control cycle'),
		('MASSOBJTYP','/KYK/FIPAY','Kayak FI Paymen'),
		('MASSOBJTYP','/KYK/PO','Kayak MM Purchase Order'),
		('MASSOBJTYP','/KYK/VEND','Kayak MM Vendor'),
		('MASSOBJTYP','KW_WF','KW Workflow Object'),
		('MASSOBJTYP','LABRELZA','Lab.Relations ZA'),
		('MASSOBJTYP','RMS_LABEL','Label Set'),
		('MASSOBJTYP','EMPLOYLRZA','Labour Relations Case / Employee'),
		('MASSOBJTYP','BUS1502','Land [RE-FX]'),
		('MASSOBJTYP','BUS1129','Land register'),
		('MASSOBJTYP','BUS1510','Land Register [RE-FX]'),
		('MASSOBJTYP','LAUNCHPAD','Launchpad'),
		('MASSOBJTYP','BUS1236','Layout Module Fixture'),
		('MASSOBJTYP','/KYK/SO','Lean Order'),
		('MASSOBJTYP','LSO_LEARN','Learner'),
		('MASSOBJTYP','BUS1130','Lease-out'),
		('MASSOBJTYP','VIMI04','Lease-out correspondence'),
		('MASSOBJTYP','BUS1033','Ledger'),
		('MASSOBJTYP','LEGALENTES','Legal person Spain'),
		('MASSOBJTYP','BUS6800','Legal Services: Customs Processing: Customs Document'),
		('MASSOBJTYP','BUS6850','Legal Services: Customs Processing: Customs Product Master'),
		('MASSOBJTYP','BUS6870','Legal Services: Customs Processing: License'),
		('MASSOBJTYP','BUS6880','Legal Services: Customs Processing: Periodic Declaration'),
		('MASSOBJTYP','/ISDFPS/E1','LES Information'),
		('MASSOBJTYP','BUSJBDLM','Limits in SEM Banking'),
		('MASSOBJTYP','BUS1183','Line Balance [Integrated Product and Process Engineering]'),
		('MASSOBJTYP','COMM_ORDER','Link CALLID <-> Communication request'),
		('MASSOBJTYP','BUSISB108','Liquidation object'),
		('MASSOBJTYP','MCYA','LIS exception: Early warning'),
		('MASSOBJTYP','CACASEITMS','List of Contract Accounts Receivable and Payable Items for Case'),
		('MASSOBJTYP','CAITEMLIST','List of Document Items in FI-CA Documents'),
		('MASSOBJTYP','BPR_SL_DOC','list sales document'),
		('MASSOBJTYP','BUSJBDDETR','Listed Transactions - SEM Banking'),
		('MASSOBJTYP','BUS1046','Listing of all Input and Output Materials'),
		('MASSOBJTYP','BUS0005001','Loading point'),
		('MASSOBJTYP','BUS2049','Loans'),
		('MASSOBJTYP','BUSJBDLOAN','Loans - SEM Banking'),
		('MASSOBJTYP','BPR_FNDLOC','Location'),
		('MASSOBJTYP','PDOTYPE_F','Location'),
		('MASSOBJTYP','OIA_BUS002','Logical Inventory Adjustment [LIA]'),
		('MASSOBJTYP','BPR_LOGINV','logistic invoice'),
		('MASSOBJTYP','/OPT/LIV','Logistic Invoice Line Item'),
		('MASSOBJTYP','/KYK/LTP','Long Term Planning'),
		('MASSOBJTYP','LOT','Lot number'),
		('MASSOBJTYP','ISULOYACC','Loyalty account'),
		('MASSOBJTYP','LSO_MISC','LSO Help Functions'),
		('MASSOBJTYP','SELFITEMTO','Mail to MRP controller'),
		('MASSOBJTYP','BUS1229','Maintenance [MNT] Force Element ID Relationship'),
		('MASSOBJTYP','BPR_MNOTIF','maintenance notification'),
		('MASSOBJTYP','BUS2038','Maintenance Notification'),
		('MASSOBJTYP','BPR_MORDER','maintenance order'),
		('MASSOBJTYP','BUS2007','Maintenance order'),
		('MASSOBJTYP','J_3GBU2007','Maintenance order'),
		('MASSOBJTYP','BUS2007A','Maintenance Order BAPI'),
		('MASSOBJTYP','BPR_MOCONF','maintenance order confirmation'),
		('MASSOBJTYP','BUS2128','Maintenance order confirmation'),
		('MASSOBJTYP','AFVC_PM','Maintenance order operation'),
		('MASSOBJTYP','BPR_MAPLAN','maintenance plan'),
		('MASSOBJTYP','BUS1020','Maintenance plan'),
		('MASSOBJTYP','T024I','Maintenance planner group'),
		('MASSOBJTYP','BUS0008003','Maintenance planning plant'),
		('MASSOBJTYP','BUS1019','Maintenance task list'),
		('MASSOBJTYP','BPR_MKORDP','make-to-order planning'),
		('MASSOBJTYP','BUS1124','Management contract [Real Estate]'),
		('MASSOBJTYP','BUS7007','Manager for attendances/absences'),
		('MASSOBJTYP','BUS7023','Manager for external payroll'),
		('MASSOBJTYP','BUS7012','Manager for external remuneration specifications'),
		('MASSOBJTYP','BUS7031','Manager for operative planned working times'),
		('MASSOBJTYP','BUS7023CA','Manager for transfer payroll account Canada'),
		('MASSOBJTYP','BUS7023US','Manager for transfer payroll account US'),
		('MASSOBJTYP','BUS7011','Manager: External attendances/absences'),
		('MASSOBJTYP','BUS7010','Manager: External Personnel Time Entries'),
		('MASSOBJTYP','BUS1515','Mandate [RE-FX]'),
		('MASSOBJTYP','UTILPREPAY','Mangement of Prepayment Meter'),
		('MASSOBJTYP','BILLDOCMAN','Manual billing document'),
		('MASSOBJTYP','BUS3061','Manual Planning for Merchandise and Assortment Planning'),
		('MASSOBJTYP','UCDOC','Manual Posting'),
		('MASSOBJTYP','BUS2048','Manufacturing order'),
		('MASSOBJTYP','BUS1073','Markdown Plan'),
		('MASSOBJTYP','BUS1241','Markdown Proposal'),
		('MASSOBJTYP','BUS1094','Market Data'),
		('MASSOBJTYP','BUSJBDMDFX','Market Data: Exchange Rates - SEM Banking'),
		('MASSOBJTYP','BUSJBDMDIX','Market Data: Indexes - SEM Banking'),
		('MASSOBJTYP','BUSJBDMDIR','Market Data: Reference Interest Rates - SEM Banking'),
		('MASSOBJTYP','BUSJBDMDSE','Market Data: Security Prices - SEM Banking'),
		('MASSOBJTYP','BUSJBDMDVO','Market Data: Volatility - SEM Banking'),
		('MASSOBJTYP','BUSISM023','Marketing Campaign Media'),
		('MASSOBJTYP','IDPKALEAUD','Mass input for message type ALEAUD'),
		('MASSOBJTYP','IDPKFIROLL','Mass input for message type FIROLL'),
		('MASSOBJTYP','IDPKGLROLL','Mass input for message type GLROLL'),
		('MASSOBJTYP','IDPKPCROLL','Mass input for message type GLROLL'),
		('MASSOBJTYP','IDPKLCROLL','Mass input for message type LCROLL'),
		('MASSOBJTYP','IDPKRCLROL','Mass input for message type RCLROL'),
		('MASSOBJTYP','MASS','Mass Maintenance'),
		('MASSOBJTYP','BUS2095','Master contract'),
		('MASSOBJTYP','BUSISM021','Master Data Generator: IS-M Log'),
		('MASSOBJTYP','QPMK','Master inspection characteristic'),
		('MASSOBJTYP','BUS1041','Master recipe'),
		('MASSOBJTYP','BUS1141','Master Settlement Unit [Real Estate]'),
		('MASSOBJTYP','BPR_MAT','material'),
		('MASSOBJTYP','BUS1001','Material'),
		('MASSOBJTYP','BUS1178001','Material'),
		('MASSOBJTYP','MDMMARA','Material [MDM]'),
		('MASSOBJTYP','BUS2085','Material allocation table'),
		('MASSOBJTYP','BUS1080','Material BOM'),
		('MASSOBJTYP','MAST','Material BOM'),
		('MASSOBJTYP','BUS1187','Material Category'),
		('MASSOBJTYP','BUS1226','Material Container [MC] Force ID Relationship'),
		('MASSOBJTYP','/KYK/MDOC','Material Document'),
		('MASSOBJTYP','BUS1072','Material Group'),
		('MASSOBJTYP','BUS1001004','Material inspection control'),
		('MASSOBJTYP','BUS2028','Material inventory'),
		('MASSOBJTYP','BPR_MATMAS','material master'),
		('MASSOBJTYP','BUS1222','Material Package'),
		('MASSOBJTYP','/CWM/BUS28','Material Physical Inventory CWM'),
		('MASSOBJTYP','BUS1220','Material Planning Object'),
		('MASSOBJTYP','BUS1223','Material Planning Object [MPO] Force ID Relationship'),
		('MASSOBJTYP','BUS1014','Material Price Change Document'),
		('MASSOBJTYP','BUS2093','Material reservation'),
		('MASSOBJTYP','MATTYPE','Material type'),
		('MASSOBJTYP','BUS1016','Material Valuation Segment'),
		('MASSOBJTYP','BUS2250','MDG Change Request'),
		('MASSOBJTYP','EQUI_EXT','MDM Equipment'),
		('MASSOBJTYP','BUS0010EXT','MDM Functional Location'),
		('MASSOBJTYP','ISUMDUSRQ','MDUS Request'),
		('MASSOBJTYP','BPR_MSMDOC','measurement document'),
		('MASSOBJTYP','BUS2092','Measurement Document'),
		('MASSOBJTYP','SAP_65106','Measuring Point'),
		('MASSOBJTYP','BUSISM019','Media Product Master'),
		('MASSOBJTYP','BUS1400','Medical Document'),
		('MASSOBJTYP','BUS1405','Medical Enhancements to Service Catalog'),
		('MASSOBJTYP','IDOCMSG','Message for IDoc Error Handling'),
		('MASSOBJTYP','CCPSMSG','Message Output'),
		('MASSOBJTYP','MTRREADDOC','Meter reading document'),
		('MASSOBJTYP','READUNIT','Meter reading unit'),
		('MASSOBJTYP','FOPC_SCHL','MIC Schedule'),
		('MASSOBJTYP','/SAPMP/BOM','Mill Products: Bill of Material'),
		('MASSOBJTYP','/SAPMP/GMT','Mill Products: Goods Movement'),
		('MASSOBJTYP','/SAPMP/GMC','Mill Products: Goods Movement and Batch Classification'),
		('MASSOBJTYP','/SAPMP/POC','Mill Products: Production Order Confirmation'),
		('MASSOBJTYP','/SAPMP/PCC','Mill Products: Production Order Confirmation and Batch Classification'),
		('MASSOBJTYP','/SAPMP/ROU','Mill Products: Routing'),
		('MASSOBJTYP','/KYK/INFRC','MM Info Record'),
		('MASSOBJTYP','IDOC21INMM','MM invoice receipt converted from 2.1'),
		('MASSOBJTYP','FVDMODCALC','Model Calculation for Loan'),
		('MASSOBJTYP','MODELLING','Modeling Object'),
		('MASSOBJTYP','PDOTYPE_SM','Module'),
		('MASSOBJTYP','/KYK/MT','Monitoring'),
		('MASSOBJTYP','BUSISB106','Movables as Collateral Objects'),
		('MASSOBJTYP','BUS1521','Move Plan [RE-FX]'),
		('MASSOBJTYP','MOVEINDOC','Move-In Document'),
		('MASSOBJTYP','MOVEINOUT','Move-in/out processing'),
		('MASSOBJTYP','OIA_BUS001','Movement-based netting document'),
		('MASSOBJTYP','MOVEOUTDOC','Move-out document'),
		('MASSOBJTYP','/KYK/PP','MRP'),
		('MASSOBJTYP','ISA_T024D','MRP controller group [ISA]'),
		('MASSOBJTYP','T024D','MRP group'),
		('MASSOBJTYP','BUS3020','MRP List'),
		('MASSOBJTYP','MSWFA_TM','MS WFD Time Management ESS'),
		('MASSOBJTYP','MSWFD_TM','MS WFD Time Management ESS'),
		('MASSOBJTYP','BUS6110','Multi-dimensional Provider for BW Metadata and Master Data'),
		('MASSOBJTYP','BUS6111','Multidimensional Resulting Qty'),
		('MASSOBJTYP','/ISDFPS/NI','NATO Stock Number'),
		('MASSOBJTYP','TRAVEL_NAV','Navigation in Travel Management Web Applications'),
		('MASSOBJTYP','BPR_NETWRK','network'),
		('MASSOBJTYP','BUS2002','Network'),
		('MASSOBJTYP','YBUS2002','Network'),
		('MASSOBJTYP','ZZBUS2002','Network'),
		('MASSOBJTYP','AFVC_NETW','Network activity'),
		('MASSOBJTYP','PSAFRU','Network confirmation'),
		('MASSOBJTYP','MLST_NETW','Network milestone'),
		('MASSOBJTYP','/NFM/BILDC','NFM Processing: Customer Individual Billing Document'),
		('MASSOBJTYP','/NFM/CUINQ','NFM Processing: Customer Inquiry'),
		('MASSOBJTYP','/NFM/CUQOT','NFM Processing: Customer Quotation'),
		('MASSOBJTYP','/NFM/ININV','NFM Processing: Incoming Invoice'),
		('MASSOBJTYP','/NFM/PUORD','NFM Processing: Purchase Order'),
		('MASSOBJTYP','/NFM/SAORD','NFM Processing: Sales Order'),
		('MASSOBJTYP','/NFM/STMAT','NFM Processing: Standard Material'),
		('MASSOBJTYP','NINSURANCE','NINSURANCE'),
		('MASSOBJTYP','BUS2143','Nota Fiscal'),
		('MASSOBJTYP','WFNOTE','Note in a workflow'),
		('MASSOBJTYP','FINCALMTX','Note in financial calendar'),
		('MASSOBJTYP','SPH_NOTE','Notes on Call'),
		('MASSOBJTYP','BUS1514','Notice of Assessment [RE-FX]'),
		('MASSOBJTYP','CLAIM_NOL','Notice of Loss'),
		('MASSOBJTYP','BPR_NOTIF','notification'),
		('MASSOBJTYP','BUS7060','Notification'),
		('MASSOBJTYP','QMFE','Notification item'),
		('MASSOBJTYP','BPR_NOTIFT','notification task'),
		('MASSOBJTYP','PBS_NOTIF','Notifications'),
		('MASSOBJTYP','/ISDFPS/GC','NSN Group Class'),
		('MASSOBJTYP','FMCCFLOT','Number of Open Items for Commitment Carryforward'),
		('MASSOBJTYP','GRPC_OBN','Object Based Navigation'),
		('MASSOBJTYP','BUS3060','Object Classification'),
		('MASSOBJTYP','BUS1089','Object dependencies'),
		('MASSOBJTYP','BPR_OBJHIS','object history'),
		('MASSOBJTYP','INET','Object networking'),
		('MASSOBJTYP','HRFPM_OBJ','Object of commitment run'),
		('MASSOBJTYP','OBJONLOAN','Object on loan'),
		('MASSOBJTYP','ZOBJLOAN','Object on loan'),
		('MASSOBJTYP','OBJRELSERV','Object Relationship Service'),
		('MASSOBJTYP','TOJTB','Object Type'),
		('MASSOBJTYP','STSTOBJECT','Object Type as Generic Object Reference'),
		('MASSOBJTYP','SWOTRA','Object type attribute'),
		('MASSOBJTYP','SWOTRE','Object type event'),
		('MASSOBJTYP','SWOTRF','Object type event parameter'),
		('MASSOBJTYP','SWOTRR','Object type exception'),
		('MASSOBJTYP','FMALE_BCS','Object Type for ALE Budgeting'),
		('MASSOBJTYP','FMALE_OI','Object Type for ALE Commitment Update'),
		('MASSOBJTYP','FMALE_FI','Object Type for ALE FM Actual Update'),
		('MASSOBJTYP','DOCUMENT','Object Type for Documents'),
		('MASSOBJTYP','SWOTRK','Object type key field'),
		('MASSOBJTYP','SWOTRM','Object type method'),
		('MASSOBJTYP','SWOTRP','Object type method parameter'),
		('MASSOBJTYP','SWOTLQ','Object type parameter'),
		('MASSOBJTYP','SWOTLV','Object type verb'),
		('MASSOBJTYP','MAN_PPPI','Object-Based Navigation for Process Industry'),
		('MASSOBJTYP','SWF_FORM','OBN for Notification of Absence'),
		('MASSOBJTYP','HREMP_NAV','OBN targets for Employee'),
		('MASSOBJTYP','WI_OBSERVE','Observer for Work Items [Webflow]'),
		('MASSOBJTYP','FMCABILDOC','Obsolete Use Object Type PS_BILLDOC'),
		('MASSOBJTYP','BUS1517','Offered Object [RE-FX]'),
		('MASSOBJTYP','SYMNGTUTIL','Offers various help functions'),
		('MASSOBJTYP','SOFM','Office Document'),
		('MASSOBJTYP','SOOD','Office Document [Rel. 2.1]'),
		('MASSOBJTYP','SOFMFOL','Office Folder'),
		('MASSOBJTYP','OIW','Open Information Warehouse'),
		('MASSOBJTYP','/OPT/V9001','Open Text VIM Document'),
		('MASSOBJTYP','BUS0017','Operating concern'),
		('MASSOBJTYP','WCD_OP','Operational WCD'),
		('MASSOBJTYP','WCD_OP_IT','Operational WCD Item'),
		('MASSOBJTYP','/KYK/AT','Operations on Activity Types'),
		('MASSOBJTYP','/KYK/AUC','Operations on Asset'),
		('MASSOBJTYP','/KYK/CH','Operations on Check Register'),
		('MASSOBJTYP','/KYK/CC','Operations on Cost Centers'),
		('MASSOBJTYP','/KYK/CE','Operations on Cost Elements'),
		('MASSOBJTYP','/KYK/CU','Operations on Customer'),
		('MASSOBJTYP','/KYK/IO','Operations on Internal Orders'),
		('MASSOBJTYP','/KYK/MAT','Operations on Material Master'),
		('MASSOBJTYP','/KYK/SOURC','Operations on Source List'),
		('MASSOBJTYP','CCPTAB','Operations on tables in a container'),
		('MASSOBJTYP','DPSPP_ORD','Order'),
		('MASSOBJTYP','IDOC21ORSP','Order confirmation converted from 2.1'),
		('MASSOBJTYP','WASTEODPOS','Order for Waste Disposal'),
		('MASSOBJTYP','WASTEORDER','Order for Waste Disposal'),
		('MASSOBJTYP','BUS1117','Order Group'),
		('MASSOBJTYP','BUSISM009','Order Item in Advertising Management'),
		('MASSOBJTYP','BPR_ORDREP','order report'),
		('MASSOBJTYP','/ISDFPS/AD','Organizational Addresses'),
		('MASSOBJTYP','RMPSORGAUT','Organizational Level for Authorization Check'),
		('MASSOBJTYP','PDOTYPE_O','Organizational unit'),
		('MASSOBJTYP','HRORGU_NAV','Organizational Unit in SAP E-Recruiting'),
		('MASSOBJTYP','PDRELA_036','Organizer'),
		('MASSOBJTYP','/ORM/ACVT','ORM_ACTIVITY'),
		('MASSOBJTYP','/ORM/RISK','ORM_RISK'),
		('MASSOBJTYP','BUS5610','OTC Int. Rate Derivatives Cap/Floor'),
		('MASSOBJTYP','BUS5620','OTC Interest Rate Derivative Swap'),
		('MASSOBJTYP','BUS5630','OTC Interest Rate FRA'),
		('MASSOBJTYP','BUS1512','Other Public Register [RE-FX]'),
		('MASSOBJTYP','LIKP','Outbound Delivery'),
		('MASSOBJTYP','ADLIKP','Outbound Delivery [AD]'),
		('MASSOBJTYP','/SPE/LIKP','Outbound Delivery SPE'),
		('MASSOBJTYP','BUS1181','Outbound Price Catalog'),
		('MASSOBJTYP','BPR_OUTAGR','outline agreement'),
		('MASSOBJTYP','/KYK/CONTR','Outline Agreement [Contract]'),
		('MASSOBJTYP','BUS2052','Outline purchase agreement'),
		('MASSOBJTYP','MOFF','Outstanding material views'),
		('MASSOBJTYP','BUS6026','Overhead Planning'),
		('MASSOBJTYP','ISUPROP','Owner allocation'),
		('MASSOBJTYP','IDPKSDPACK','Pack data confirmation'),
		('MASSOBJTYP','TDEVC','Package'),
		('MASSOBJTYP','IDPKBETMAS','Package of IDocs with message cat. IDPKBETMAS'),
		('MASSOBJTYP','IDPKFINSTA','Package of IDOCs with message type FINSTA'),
		('MASSOBJTYP','IDPKLOCKBX','Package of IDOCs with message type LOCKBX'),
		('MASSOBJTYP','IDPKCOGRP3','Packages From IDOCs With Message Type COGRP3'),
		('MASSOBJTYP','IDPKCOMITM','Packages of IDocs with message category COMM_ITEM'),
		('MASSOBJTYP','ICLIDOCPCK','Packages of IDocs with Message Category ICL_INVOICE'),
		('MASSOBJTYP','IDPKCONDA2','Packet for CONDA2'),
		('MASSOBJTYP','IDPKDESADV','Packet of IDocs for shipping notification'),
		('MASSOBJTYP','IDPKCONF11','Packet of IDocs with message type CONF11'),
		('MASSOBJTYP','IDPKCONF21','Packet of IDocs with message type CONF21'),
		('MASSOBJTYP','IDPKCONF22','Packet of IDocs with message type CONF22'),
		('MASSOBJTYP','IDPKCONF31','Packet of IDocs with message type CONF31'),
		('MASSOBJTYP','IDPKCONF32','Packet of IDocs with message type CONF32'),
		('MASSOBJTYP','IDPKCONF41','Packet of IDocs with message type CONF41'),
		('MASSOBJTYP','IDPKCONF42','Packet of IDocs with message type CONF42'),
		('MASSOBJTYP','IDPKCONF51','Packet of IDocs with message type CONF42'),
		('MASSOBJTYP','IDPKCOSMAS','Packet of IDocs with message type COSMAS'),
		('MASSOBJTYP','IDPKDOCMAS','Packet of IDocs with message type DOCMAS'),
		('MASSOBJTYP','IDPKFUNDMA','Packet of IDocs with message type FUNDMA'),
		('MASSOBJTYP','IDPKINFREC','Packet of IDOCs with message type INFREC'),
		('MASSOBJTYP','IDPKRCYFET','Packet of IDocs with message type RCYFET'),
		('MASSOBJTYP','IDPKRCYLST','Packet of IDocs with message type RCYLST'),
		('MASSOBJTYP','IDPKREMADV','Packet of IDocs with message type REMADV'),
		('MASSOBJTYP','IDPKREQRES','Packet of IDOCs with message type REQRES'),
		('MASSOBJTYP','IDPKSRCLST','Packet of IDOCs with message type SRCLST'),
		('MASSOBJTYP','IDPKWP_EAN','Packet of IDOCs with message type WP_EAN'),
		('MASSOBJTYP','IDPKWP_PLU','Packet of IDOCs with message type WP_PLU'),
		('MASSOBJTYP','IDPKWPUERR','Packet of IDOCs with message type WPUERR'),
		('MASSOBJTYP','IDPKWPUPAE','Packet of IDOCs with message type WPUPAE'),
		('MASSOBJTYP','IDPKWMCUST','Packet of IDOCs with user-defined message'),
		('MASSOBJTYP','IDPKEDLNOT','Packet of messages with message type EDLNOT'),
		('MASSOBJTYP','IDPKGSVERF','Packet of messages with message type EDLNOT'),
		('MASSOBJTYP','IDPKRCYRSP','Packets of IDcos with message type RCYRSP'),
		('MASSOBJTYP','IDPKCREFET','Packets of IDocs for requisition of vendors'),
		('MASSOBJTYP','IDPKACLPAY','Packets of IDOCs with Message Type ACLPAY'),
		('MASSOBJTYP','IDPKACLREC','Packets of IDOCs with Message Type ACLREC'),
		('MASSOBJTYP','IDPKACPJMM','Packets of IDOCs with Message Type ACPJMM'),
		('MASSOBJTYP','IDPKBOMDOC','Packets of IDOCs with message type BOMDOC'),
		('MASSOBJTYP','IDPKBOMMAT','Packets of IDOCs with message type BOMMAT'),
		('MASSOBJTYP','IDPKCLSMAS','Packets of IDocs with message type CLSMAS'),
		('MASSOBJTYP','IDPKCNPMAS','Packets of IDOCs with message type CNPMAS'),
		('MASSOBJTYP','IDPKCOGRP','Packets of IDOCs with message type COGRP'),
		('MASSOBJTYP','IDPKCOGRP1','Packets of IDOCs with message type COGRP1'),
		('MASSOBJTYP','IDPKCOGRP2','Packets of IDOCs with message type COGRP2'),
		('MASSOBJTYP','IDPKCOGRP5','Packets of IDOCs with message type COGRP5'),
		('MASSOBJTYP','IDPKCOGRP6','Packets of IDOCs with message type COGRP6'),
		('MASSOBJTYP','IDPKCOGRP7','Packets of IDOCs with message type COGRP6'),
		('MASSOBJTYP','IDPKCOGRP9','Packets of IDOCs with message type COGRP9'),
		('MASSOBJTYP','IDPKCOND_A','Packets of IDOCs with message type COND_A'),
		('MASSOBJTYP','IDPKCOPAGN','Packets of IDocs with message type COPAGN'),
		('MASSOBJTYP','IDPKDEBMAS','Packets of IDocs with message type DEBMAS'),
		('MASSOBJTYP','IDPKDELINS','Packets of IDocs with message type DELINS'),
		('MASSOBJTYP','IDPKEKSEKS','Packets of IDocs with message type EKSEKS'),
		('MASSOBJTYP','IDPKHRMD','Packets of IDOCs with message type HRMD_A'),
		('MASSOBJTYP','IDPKRPMFIF','Packets of IDOCs with message type HRMD_A'),
		('MASSOBJTYP','IDPKHRPAYP','Packets of IDOCs with message type HRPAYP'),
		('MASSOBJTYP','IDPKHRTRVL','Packets of IDOCs with message type HRTRVL'),
		('MASSOBJTYP','IDPKINVCON','Packets of IDocs with message type INVCON'),
		('MASSOBJTYP','IDPKINVOIC','Packets of IDocs with message type INVOIC'),
		('MASSOBJTYP','IDPKJV_INV','Packets of IDocs with Message Type JV00'),
		('MASSOBJTYP','IDPKKNOMAS','Packets of IDOCs with message type KNOMAS'),
		('MASSOBJTYP','IDPKMATMAS','Packets of IDocs with message type MATMAS'),
		('MASSOBJTYP','IDPKOILLDD','Packets of IDocs with message type OILLDD'),
		('MASSOBJTYP','IDPKORDCHG','Packets of IDocs with message type ORDCHG'),
		('MASSOBJTYP','IDPKORDRSP','Packets of IDocs with message type ORDRSP'),
		('MASSOBJTYP','IDPKPRCMAS','Packets of IDOCs with message type PRCMAS'),
		('MASSOBJTYP','IDPKREQOTE','Packets of IDocs with message type REQOTE'),
		('MASSOBJTYP','IDPKSHIPPL','Packets of IDOCs with message type SHIPPL'),
		('MASSOBJTYP','IDPKSISCSO','Packets of IDocs with message type SISCSO'),
		('MASSOBJTYP','IDPKSRVMAS','Packets of IDOCs with message type SRVMAS'),
		('MASSOBJTYP','IDPKVTAMAS','Packets of IDOCs with message type VTAMAS'),
		('MASSOBJTYP','IDPKVTMMAS','Packets of IDOCs with message type VTMMAS'),
		('MASSOBJTYP','IDOCSDPACK','Packing confirmation'),
		('MASSOBJTYP','BUS3071','Packing Instruction'),
		('MASSOBJTYP','BUS1511','Parcel [RE-FX]'),
		('MASSOBJTYP','BUS1513','Parcel Update [RE-FX]'),
		('MASSOBJTYP','/OPT/FIPP','Parked Accounting Invoice Extension'),
		('MASSOBJTYP','FIPP','Parked Document'),
		('MASSOBJTYP','Z_FIPP','Parked document verified externally'),
		('MASSOBJTYP','HRPART_NAV','Participant obj for navigation in LSO'),
		('MASSOBJTYP','BUS1507','Participation Group [RE-FX]'),
		('MASSOBJTYP','BUS1037','Partner Sales Activity'),
		('MASSOBJTYP','BUS1420','Patient Pathway'),
		('MASSOBJTYP','FIOPAYAVIS','Payment Advice'),
		('MASSOBJTYP','VBWF15','Payment authorized for rel.'),
		('MASSOBJTYP','BUS1186','Payment Card'),
		('MASSOBJTYP','BUS6016','Payment card'),
		('MASSOBJTYP','BUS2120','Payment Item'),
		('MASSOBJTYP','BUS2119','Payment Order'),
		('MASSOBJTYP','BUSISI005','Payment Plan'),
		('MASSOBJTYP','BUSISI013','Payment Plan Item'),
		('MASSOBJTYP','BUS2021','Payment Request'),
		('MASSOBJTYP','FMPSO','Payment Request in Funds Management'),
		('MASSOBJTYP','PAYSCHEME','Payment Scheme'),
		('MASSOBJTYP','BUS2055','Payroll'),
		('MASSOBJTYP','BUS0020','Payroll area'),
		('MASSOBJTYP','BUS2056','Payroll evaluation'),
		('MASSOBJTYP','BUS7001','Payroll for Travel Expenses'),
		('MASSOBJTYP','BUS7008','Payroll posting document'),
		('MASSOBJTYP','BUS7009','Payroll posting document for posting to Accounting'),
		('MASSOBJTYP','PD_1001','PD Infotype Relationship [1001]'),
		('MASSOBJTYP','PDOTYPES','PD Object Types'),
		('MASSOBJTYP','BUSISM034','PDEX Shipping Notification'),
		('MASSOBJTYP','EMPLOYEEDE','Periodic Employee Specification - Germany'),
		('MASSOBJTYP','STATPAYPER','Periodical employer statement for each payroll period'),
		('MASSOBJTYP','STRUPERST','Persistence for structures'),
		('MASSOBJTYP','BUS1009','Person'),
		('MASSOBJTYP','FOPC_PERS','Person'),
		('MASSOBJTYP','BPR_FND_PD','Person Details'),
		('MASSOBJTYP','ZHRBEN0001','Person Number'),
		('MASSOBJTYP','TCC11','Person responsible for changes of this type'),
		('MASSOBJTYP','TCC13','Person responsible for object changes of this type'),
		('MASSOBJTYP','SCHEDULE','Personal Appointment Calendar'),
		('MASSOBJTYP','LAWUSRPOBJ','Personalization Data for the User in the LAW'),
		('MASSOBJTYP','BUS0030','Personnel area'),
		('MASSOBJTYP','PERSAREAES','Personnel area specification Spain'),
		('MASSOBJTYP','PERSAREACH','Personnel area specification Switz.'),
		('MASSOBJTYP','PD_COST_PL','Personnel cost planning scenario'),
		('MASSOBJTYP','PD_COST_GR','Personnel cost scenario group'),
		('MASSOBJTYP','PDOTYPE_B','Personnel development plan'),
		('MASSOBJTYP','PERSCLERK','Personnel Officer'),
		('MASSOBJTYP','BUS0019','Personnel subarea'),
		('MASSOBJTYP','BUS7019','Person\'s qualification'),
		('MASSOBJTYP','QUALIFIC','Person\'s qualification'),
		('MASSOBJTYP','BUS7017','Person\'s qualification profile'),
		('MASSOBJTYP','VBWF09','Persons release amount'),
		('MASSOBJTYP','BUS2173','Phase'),
		('MASSOBJTYP','BUS2167','Phase in Project Template'),
		('MASSOBJTYP','BUS1091','Phrase'),
		('MASSOBJTYP','BUS1100','Phrase set'),
		('MASSOBJTYP','IDOCEXTIVU','Phys. inv./sales val. change'),
		('MASSOBJTYP','BPR_PINVDC','physical inventory document'),
		('MASSOBJTYP','BUS1180','Physical sample'),
		('MASSOBJTYP','BPR_PISH','PI sheet'),
		('MASSOBJTYP','BUS4200000','PI Sheets and Work Instructions'),
		('MASSOBJTYP','IDOCSDPICK','Picking confirmation'),
		('MASSOBJTYP','IDPKSDPICK','Picking confirmation'),
		('MASSOBJTYP','BUS6031','Plan data transfer to CO'),
		('MASSOBJTYP','BPR_PLNORD','planed order'),
		('MASSOBJTYP','GLOBASSIGN','Planned Global Assignment'),
		('MASSOBJTYP','BUS3027','Planned independent requirements'),
		('MASSOBJTYP','BUS2004','Planned Order'),
		('MASSOBJTYP','PDRELA_033','Planned training'),
		('MASSOBJTYP','BUS1166','Planning Package for Profitability Analysis'),
		('MASSOBJTYP','BUS1145','Planning Package in SEM-BPS'),
		('MASSOBJTYP','BUS1167','Planning Profitability Analysis'),
		('MASSOBJTYP','BUS1600','Planning: General Ledger Accounting [New]'),
		('MASSOBJTYP','BUS0008','Plant'),
		('MASSOBJTYP','IDOCBETMAS','Plant'),
		('MASSOBJTYP','BUS1086','Plant layout'),
		('MASSOBJTYP','BUS1083','Plant layout module'),
		('MASSOBJTYP','BUS1083A','Plant Layout Module'),
		('MASSOBJTYP','BUS0008001','Plant storage area'),
		('MASSOBJTYP','BUS0008002','Plant subdivision - location'),
		('MASSOBJTYP','ISUPOD','Point of Delivery'),
		('MASSOBJTYP','ISUNBSERVC','Point of delivery service [not billed]'),
		('MASSOBJTYP','IDOCPUWB','POS Inbound Goods Movement'),
		('MASSOBJTYP','IDOCWP_EAN','POS: Inbound and outbound transfer of EAN assignments'),
		('MASSOBJTYP','IDOCWP_PLU','POS: inbound and outbound transfer of material master'),
		('MASSOBJTYP','IDOCWPUUMS','POS: inbound transfer of aggregated daily sales volumes'),
		('MASSOBJTYP','IDOCWPUERR','POS: Upload messages SRS/POS/SCS'),
		('MASSOBJTYP','IDOCWPUPAE','POS: Upload price changes'),
		('MASSOBJTYP','PDOTYPE_S','Position'),
		('MASSOBJTYP','HRPOSI_NAV','Position in SAP E-Recruiting'),
		('MASSOBJTYP','BUSJBDPOS','Positions - SEM Banking'),
		('MASSOBJTYP','CITY','Postal city'),
		('MASSOBJTYP','POSTALCODE','Postal code'),
		('MASSOBJTYP','BUSISM031','Postal Unit City'),
		('MASSOBJTYP','BUSISM032','Postal Unit Street'),
		('MASSOBJTYP','/SAPPO/OR','Postprocessing Order'),
		('MASSOBJTYP','MDS_PPO_OR','Postprocessing Order in Master Data Synchronization'),
		('MASSOBJTYP','PPFDEMO','PPF Demo Object'),
		('MASSOBJTYP','PDRELA_027','Prebooking'),
		('MASSOBJTYP','PREMISES','Premise'),
		('MASSOBJTYP','PDRELA_029','Prerequisite'),
		('MASSOBJTYP','PDRELA_034','Previous attendance'),
		('MASSOBJTYP','BUS1237','Price Plan'),
		('MASSOBJTYP','BUS123701','Price Planning User Group'),
		('MASSOBJTYP','BUS30110','Pricing Condition'),
		('MASSOBJTYP','/KYK/COND','Pricing Conditions'),
		('MASSOBJTYP','BUS105001','Primary wage type'),
		('MASSOBJTYP','BUS4402','Print action record'),
		('MASSOBJTYP','PRINTLIST','Print List'),
		('MASSOBJTYP','WIPRIOCHAN','Priority change for work item'),
		('MASSOBJTYP','DRPBOOK','Private Flight Booking [Drag&Relate]'),
		('MASSOBJTYP','ROPC','Process Chain Instance'),
		('MASSOBJTYP','BUS2114','Process Characteristic'),
		('MASSOBJTYP','SAP0004','Process CIC with Component Calls'),
		('MASSOBJTYP','BEPROC','Process components'),
		('MASSOBJTYP','BEEVENT','Process event'),
		('MASSOBJTYP','BEFUNCT','Process function'),
		('MASSOBJTYP','BUS2110','Process message'),
		('MASSOBJTYP','BEDIA','Process model diagram component'),
		('MASSOBJTYP','BEGROUP','Process model group'),
		('MASSOBJTYP','BEPROCVAR','Process model process variant'),
		('MASSOBJTYP','BPR_PROCO','process order'),
		('MASSOBJTYP','BUS0001','Process order'),
		('MASSOBJTYP','BUS2016','Process Order Confirmation'),
		('MASSOBJTYP','SPATH','Process Route in Workflow'),
		('MASSOBJTYP','SPATHPOS','Process Route Item in Workflow'),
		('MASSOBJTYP','BPR_FNDPSE','Process Setup'),
		('MASSOBJTYP','HRPROC_NAV','Process Template in SAP E-Recruiting'),
		('MASSOBJTYP','BUS6015','Procurement transaction'),
		('MASSOBJTYP','BUS1178','Product'),
		('MASSOBJTYP','BUS1071','Product Catalog'),
		('MASSOBJTYP','PRD_FLOW_N','Product Flow Network'),
		('MASSOBJTYP','ISUPRODLOG','Product log IS-U'),
		('MASSOBJTYP','BUS6034','Product Model Data Exchange [STEP]'),
		('MASSOBJTYP','BUS10507','Production Backflush Receiver'),
		('MASSOBJTYP','BUS1196','Production Model [Integrated Product and Process Engineering]'),
		('MASSOBJTYP','BPR_PRODO','production order'),
		('MASSOBJTYP','BUS2005','Production order'),
		('MASSOBJTYP','BPR_PRODOC','production order confirmation'),
		('MASSOBJTYP','BUS2116','Production order confirmation'),
		('MASSOBJTYP','AFVC_PROD','Production order operation'),
		('MASSOBJTYP','BPR_PRODOP','production order PI confirmation'),
		('MASSOBJTYP','MLST_PROD','Production order trigger point'),
		('MASSOBJTYP','BUS1193','Production Resource [Integrated Product and Process Engineering]'),
		('MASSOBJTYP','BUS1038','Production resources and tools'),
		('MASSOBJTYP','T024F','Production scheduler group'),
		('MASSOBJTYP','PROFCATGES','Professional Category Spain'),
		('MASSOBJTYP','ISUPROFILE','Profile in Energy Data Management [EDM]'),
		('MASSOBJTYP','BUS0015','Profit center'),
		('MASSOBJTYP','BUS2073','Profit Center Document'),
		('MASSOBJTYP','BUS1116','Profit Center Group'),
		('MASSOBJTYP','BUS2077','Profitability segment'),
		('MASSOBJTYP','PDOTYPE_SC','Program of Study'),
		('MASSOBJTYP','BUS1158','Program Sub-Tree'),
		('MASSOBJTYP','BPR_PROJCT','project'),
		('MASSOBJTYP','BUS2172','Project'),
		('MASSOBJTYP','BUS2001','Project definition'),
		('MASSOBJTYP','/SAPPCE/02','Project Plan Data'),
		('MASSOBJTYP','BUS2177','Project Role in a Project'),
		('MASSOBJTYP','BUS2178','Project Role in the Project or Checklist Template'),
		('MASSOBJTYP','BUS2170','Project Template'),
		('MASSOBJTYP','PROLLAAGB','PROLLAAGB'),
		('MASSOBJTYP','PROLLCAR','PROLLCAR'),
		('MASSOBJTYP','BUS1068','Promotion'),
		('MASSOBJTYP','BUS1128','Property'),
		('MASSOBJTYP','WASTEPROP','Property'),
		('MASSOBJTYP','BUS1224','Provisions Packages [PPA] Force ID Relationship'),
		('MASSOBJTYP','PROXY0011','Proxy customer free delivery in Customer Relationship Management'),
		('MASSOBJTYP','PROXY0009','Proxy for customer debit memo request in Customer Relationship Management'),
		('MASSOBJTYP','PROXY0002','Proxy for customer in Customer Relationship Management'),
		('MASSOBJTYP','PROXY0007','Proxy for service notification in Customer Relationship Management'),
		('MASSOBJTYP','PROXY0003','Proxy to contact person in Customer Relationship Management'),
		('MASSOBJTYP','PROXY0008','Proxy to customer credit memo in Customer Relationship Management'),
		('MASSOBJTYP','PROXY0004','Proxy to customer inquiry in Customer Relationship Management'),
		('MASSOBJTYP','PROXY0006','Proxy to customer order in Customer Relationship Management'),
		('MASSOBJTYP','PROXY0005','Proxy to customer quotation in Customer Relationship Management'),
		('MASSOBJTYP','PROXY0010','Proxy to customer return in Customer Relationship Management'),
		('MASSOBJTYP','PROXYITEM','Proxy work item for remote work item'),
		('MASSOBJTYP','HOLIDAYCAL','Public holiday calendar'),
		('MASSOBJTYP','PS_BILLDOC','Public Sector Billing Document'),
		('MASSOBJTYP','PS_INVDOC','Public Sector Invoicing Document'),
		('MASSOBJTYP','HRPUBL_NAV','Publication in SAP E-Recruiting'),
		('MASSOBJTYP','IDOC21OCHG','Purch.order change receipt converted 2.1'),
		('MASSOBJTYP','BUS2013','Purch.scheduling agreement'),
		('MASSOBJTYP','BUS2014','Purchase contract'),
		('MASSOBJTYP','BPR_PURORD','purchase order'),
		('MASSOBJTYP','BUS2012','Purchase Order'),
		('MASSOBJTYP','ZZBUS2012','Purchase Order'),
		('MASSOBJTYP','BUS2161','Purchase Order - Accounting Share'),
		('MASSOBJTYP','PSEKKO','Purchase order change based on network changes'),
		('MASSOBJTYP','FREBUS2012','Purchase Order F&R [Subtype of BUS2012]'),
		('MASSOBJTYP','IDOC21ORD','Purchase order/order converted from 2.1'),
		('MASSOBJTYP','BUSISM017','Purchase Quantity for Contract'),
		('MASSOBJTYP','BPR_PURREQ','purchase requisition'),
		('MASSOBJTYP','BUS2105','Purchase requisition'),
		('MASSOBJTYP','BUS2009','Purchase requisition item'),
		('MASSOBJTYP','BUS1230','Purchase Requisition: DFPS MM'),
		('MASSOBJTYP','BUS2013002','Purchase scheduling agreement release'),
		('MASSOBJTYP','EKKO','Purchasing document'),
		('MASSOBJTYP','T024','Purchasing group'),
		('MASSOBJTYP','BPR_PURINF','purchasing info record'),
		('MASSOBJTYP','BUS3003','Purchasing information'),
		('MASSOBJTYP','BUS0007','Purchasing Organization'),
		('MASSOBJTYP','LFM1','Purchasing Organization Vendor'),
		('MASSOBJTYP','PDOTYPE_Q','Qualification type'),
		('MASSOBJTYP','PDOTYPE_QK','Qualification type group'),
		('MASSOBJTYP','BUS7018','Qualifications Catalog'),
		('MASSOBJTYP','BUS2117','Quality certificate'),
		('MASSOBJTYP','BUS2101','Quality information - procurement'),
		('MASSOBJTYP','BPR_QNOTIF','quality notification'),
		('MASSOBJTYP','BUS2078','Quality notification'),
		('MASSOBJTYP','BEQUESTION','Question'),
		('MASSOBJTYP','BUS20310','Question List'),
		('MASSOBJTYP','BUS2031010','Question List Item'),
		('MASSOBJTYP','HRQSNR_NAV','Questionnaires'),
		('MASSOBJTYP','QUEUE','Queue in qRFC'),
		('MASSOBJTYP','BUS2031001','Quotation with BOS'),
		('MASSOBJTYP','USER','R/3 System user'),
		('MASSOBJTYP','RATECAT','Rate category'),
		('MASSOBJTYP','BUS1518','RE Search Request [RE-FX]'),
		('MASSOBJTYP','/J7L/BUS01','REA Article'),
		('MASSOBJTYP','/J7L/BUS02','REA Packaging'),
		('MASSOBJTYP','/J7L/BUS03','REA Reference Article'),
		('MASSOBJTYP','CA_ICSHDEP','Read Contract Accounts Receivable and Payable'),
		('MASSOBJTYP','CA_INTERST','Read Contract Accounts Receivable and Payable'),
		('MASSOBJTYP','BUS1505','Real Estate Contract [RE-FX]'),
		('MASSOBJTYP','BUSISB104','Real Estate Object'),
		('MASSOBJTYP','BUS3017','Rebate agreement'),
		('MASSOBJTYP','BUS3031','Rebate agreement - sales'),
		('MASSOBJTYP','BUS3030','Rebate arrangement: Purchasing'),
		('MASSOBJTYP','BUSISB112','Receivable'),
		('MASSOBJTYP','BUS2025','Receivables Data'),
		('MASSOBJTYP','BUS2025001','Receivables Data [Interaction Center]'),
		('MASSOBJTYP','RECIPIENT','Recipient with send attributes'),
		('MASSOBJTYP','HRPSSG_ROF','Recommending officer'),
		('MASSOBJTYP','BUS3080','Reconciliation Item for Reconciliation of Intercompany Balances'),
		('MASSOBJTYP','BUS1058','Reconciliation ledger'),
		('MASSOBJTYP','RMPSREC','Record in Records Management for Public Sector'),
		('MASSOBJTYP','RECORD','Record in Records Management System'),
		('MASSOBJTYP','RMPSPRO','Records Management TNA General Functions'),
		('MASSOBJTYP','PAYRC','Recovery request'),
		('MASSOBJTYP','BUS2061','Recruitment request'),
		('MASSOBJTYP','RECURRPAY','Recurring employee payment/deduction'),
		('MASSOBJTYP','ISUREDEMP','Redemption Document for Loyalty Account'),
		('MASSOBJTYP','CA_REF_DOC','Reference Document for an FI-CA Document'),
		('MASSOBJTYP','BUS1097','Reference interest rate'),
		('MASSOBJTYP','BUS1190','Reference operation set'),
		('MASSOBJTYP','BUS2164','Reference to a Checklist Template'),
		('MASSOBJTYP','BUS2007_01','Refurbishment Order'),
		('MASSOBJTYP','REGIOGROUP','Regional Structure Grouping'),
		('MASSOBJTYP','IDOCPART','Related part of an IDoc'),
		('MASSOBJTYP','BUS1212','Release Order'),
		('MASSOBJTYP','BUS2127','REM Backflush'),
		('MASSOBJTYP','BUS2142','REM Backflush'),
		('MASSOBJTYP','FOPC_CASEP','Remediation Plan'),
		('MASSOBJTYP','GRPC_CASEP','Remediation Plan'),
		('MASSOBJTYP','REMOTE_WLC','Remote integrated inbox'),
		('MASSOBJTYP','REMOTEITEM','Remote work item [http]'),
		('MASSOBJTYP','BUS1140','Rental - Management of Interested Parties: Rental Request'),
		('MASSOBJTYP','BUS1504','Rental Object [RE-FX]'),
		('MASSOBJTYP','BUS1131','Rental offer'),
		('MASSOBJTYP','BUS1133','Rental unit'),
		('MASSOBJTYP','BUS1132','Rental: Application'),
		('MASSOBJTYP','BUS1074','Repayment Schedule Sets'),
		('MASSOBJTYP','BUS1228','Reportable Item Code [RIC] Force ID Relationship'),
		('MASSOBJTYP','CA_REQUEST','Request'),
		('MASSOBJTYP','BPR_REQFQ','request for quotation'),
		('MASSOBJTYP','BUS2010','Request for quotation'),
		('MASSOBJTYP','IDOC21REQ','Request for quotation converted from 2.1'),
		('MASSOBJTYP','CTREQUEST','Request in Change & Transport System'),
		('MASSOBJTYP','RQRSMSG','Request Response Message'),
		('MASSOBJTYP','JOBREQUIRE','Requirement'),
		('MASSOBJTYP','ERC_REQUI','Requisition in E-Recruiting'),
		('MASSOBJTYP','HRREQU_NAV','Requisition in SAP E-Recruiting'),
		('MASSOBJTYP','MSS_REQ','Requisition object used in MSS Recruitment scenario'),
		('MASSOBJTYP','BUSISM027','Research'),
		('MASSOBJTYP','PDRELA_023','Reservation'),
		('MASSOBJTYP','WASTESAMPL','Reserve Sample'),
		('MASSOBJTYP','/OPT/OST','Resolution Option'),
		('MASSOBJTYP','PDOTYPE_G','Resource'),
		('MASSOBJTYP','PDRELA_022','Resource requirements'),
		('MASSOBJTYP','PDOTYPE_R','Resource type'),
		('MASSOBJTYP','WIRESUBMIT','Resubmission for Work Item Created'),
		('MASSOBJTYP','BUS2024','Resubmission in Collections Management'),
		('MASSOBJTYP','RPRIRBLIST','Results list of report RPRIRB00'),
		('MASSOBJTYP','BUS1001001','Retail material'),
		('MASSOBJTYP','SAP40319','Retail revaluation'),
		('MASSOBJTYP','BUS6060','Retail Revenue Management Interface'),
		('MASSOBJTYP','BUS1069','Retail Site'),
		('MASSOBJTYP','BUS2113','Return order for magazines and newspapers'),
		('MASSOBJTYP','BUS2102','Returns'),
		('MASSOBJTYP','BUS1059','Revenue element'),
		('MASSOBJTYP','REVIEW','Review'),
		('MASSOBJTYP','BUSISB105','Right'),
		('MASSOBJTYP','/MRSS/CD','RM Candidate'),
		('MASSOBJTYP','/MRSS/CDEV','RM Candidate-Event'),
		('MASSOBJTYP','/MRSS/CDAG','RM Candidate-Event-Agent'),
		('MASSOBJTYP','/MRSS/CDSG','RM Candidate-Event-SP Group'),
		('MASSOBJTYP','/MRSS/DM','RM Demand'),
		('MASSOBJTYP','/MRSS/DMEV','RM Demand-Event'),
		('MASSOBJTYP','/MRSS/DMAG','RM Demand-Event-Agent'),
		('MASSOBJTYP','/MRSS/DMSG','RM Demand-Event-SP Group'),
		('MASSOBJTYP','/MRSS/RQ','RM Request'),
		('MASSOBJTYP','/MRSS/RO','RM Role'),
		('MASSOBJTYP','/MRSS/ROEV','RM Role-Event'),
		('MASSOBJTYP','/MRSS/ROAG','RM Role-Event-Agent'),
		('MASSOBJTYP','/MRSS/ATCH','RMFS Attachment BO'),
		('MASSOBJTYP','ROLE','Role'),
		('MASSOBJTYP','BUSROLEMAN','Role Generator [Update of Authorizations]'),
		('MASSOBJTYP','BUS1127','Room [Real Estate]'),
		('MASSOBJTYP','HRROOM_NAV','Room obj for navigation in LSO'),
		('MASSOBJTYP','BPR_ROUGHG','rough goods receipt'),
		('MASSOBJTYP','BUS2090','Rough goods receipt'),
		('MASSOBJTYP','/DSD/RTACC','Route Settlement DSD'),
		('MASSOBJTYP','BUS1012','Routing'),
		('MASSOBJTYP','RPMAGENT','rpmagent'),
		('MASSOBJTYP','BUS0006003','Sales area'),
		('MASSOBJTYP','BPR_SLSDOC','sales document'),
		('MASSOBJTYP','VBAK','Sales document [Only Use for Optical Archiving]'),
		('MASSOBJTYP','VBAP','Sales document item'),
		('MASSOBJTYP','TVKGR','Sales group'),
		('MASSOBJTYP','TVBUR','Sales Office'),
		('MASSOBJTYP','BPR_SLSORD','sales order'),
		('MASSOBJTYP','BUS2032','Sales Order'),
		('MASSOBJTYP','BUS2107','Sales Order for Newspapers and Magazines'),
		('MASSOBJTYP','BUS2107001','Sales Order Item for Newspapers and Magazines'),
		('MASSOBJTYP','MILL_VSPOS','Sales order item with changeable version'),
		('MASSOBJTYP','BUS2032001','Sales Order with BOS'),
		('MASSOBJTYP','BUS0006','Sales Organization'),
		('MASSOBJTYP','BUS0006002','Sales organization - division - assignment'),
		('MASSOBJTYP','SAP_30304','Sales Price Calculations'),
		('MASSOBJTYP','BUS1051','Sales promotion'),
		('MASSOBJTYP','VBKA','Sales Support Document'),
		('MASSOBJTYP','SAP_12116','Sales tax area'),
		('MASSOBJTYP','SCHEDULER','SAP Appointment Calendar'),
		('MASSOBJTYP','BARCODE','SAP ArchiveLink bar code entry'),
		('MASSOBJTYP','IMAGEPATH','SAP ArchiveLink Document Access via Path'),
		('MASSOBJTYP','IMAGELINK','SAP ArchiveLink links to stored documents'),
		('MASSOBJTYP','BUS0815','SAP ArchiveLink Test Object Type'),
		('MASSOBJTYP','TWFDB','SAP ArchiveLink Workflow Document Type'),
		('MASSOBJTYP','USR01','SAP user'),
		('MASSOBJTYP','USR01DOHR','SAP user with HR master data'),
		('MASSOBJTYP','SUBSTITUTE','SAPoffice: User substitution'),
		('MASSOBJTYP','SPH_ADMIN','SAPphone Administration'),
		('MASSOBJTYP','VOICE_CALL','SAPphone: Telephone call'),
		('MASSOBJTYP','STD_TEXT','SAPscript standard text'),
		('MASSOBJTYP','BUS1177','Scenario for Merchandise and Assortment Planning'),
		('MASSOBJTYP','SMANMERGE','Schedule Manager: Container'),
		('MASSOBJTYP','BPSTEPSMAN','Schedule Manager: Schedule Step'),
		('MASSOBJTYP','BPJOB_SMAN','Schedule Mananger: Job Scheduling'),
		('MASSOBJTYP','BUSISM017P','Scheduling Agreement'),
		('MASSOBJTYP','DRDYNFIELD','Screen Field for Drag&Relate'),
		('MASSOBJTYP','ISUSDCONF','SD configuration'),
		('MASSOBJTYP','WASTESDORD','SD Order'),
		('MASSOBJTYP','SAP_20116','Season'),
		('MASSOBJTYP','BUSISB103','Securities Account'),
		('MASSOBJTYP','BUS5770','Securities Lending'),
		('MASSOBJTYP','BUSJBDSETR','Security Order - SEM Banking'),
		('MASSOBJTYP','BUS1099','Security price'),
		('MASSOBJTYP','BUS5200','SecurityTransaction'),
		('MASSOBJTYP','QPAM','Selected set'),
		('MASSOBJTYP','/ISDFPS/T2','Send ALE Test Data'),
		('MASSOBJTYP','/ISDFPS/T3','Send ALE Test Data'),
		('MASSOBJTYP','/ISDFPS/T4','Send ALE Test Data'),
		('MASSOBJTYP','/ISDFPS/T5','Send ALE Test Data'),
		('MASSOBJTYP','/ISDFPS/T6','Send ALE Test Data'),
		('MASSOBJTYP','/ISDFPS/T7','Send ALE Test Data'),
		('MASSOBJTYP','SEPAMANDAT','SEPA Mandate'),
		('MASSOBJTYP','SEPAMAND_1','SEPA Mandate [FI-CA]'),
		('MASSOBJTYP','BPR_SERV','service'),
		('MASSOBJTYP','BUS1005','Service'),
		('MASSOBJTYP','BUS2091','Service entry sheet'),
		('MASSOBJTYP','BUS2096002','Service Entry Sheet [Debit Memo Request with BOS]'),
		('MASSOBJTYP','BUS2080','Service notification'),
		('MASSOBJTYP','BUS2088','Service order'),
		('MASSOBJTYP','BUS2129','Service order confirmation'),
		('MASSOBJTYP','WTYSC0001','Service Order functions related to warranty'),
		('MASSOBJTYP','BUS2088A','Service Order with BAPI'),
		('MASSOBJTYP','BUS1178002','Service Product'),
		('MASSOBJTYP','BUS1005001','Services for BOS'),
		('MASSOBJTYP','AII_000001','Services for Partners'),
		('MASSOBJTYP','AG_RETURN','Services for RETURN Paramter'),
		('MASSOBJTYP','SERVFREQH','Services for Service Frequency'),
		('MASSOBJTYP','PDRELA_051','Session'),
		('MASSOBJTYP','PDRELA_052','Session attendance'),
		('MASSOBJTYP','BUS2100','Settlement request'),
		('MASSOBJTYP','BUS2100002','Settlement Request'),
		('MASSOBJTYP','BUS2100001','Settlement Request List'),
		('MASSOBJTYP','BUS1125','Settlement unit [Real Estate]'),
		('MASSOBJTYP','BUS1506','Settlement Unit [RE-FX]'),
		('MASSOBJTYP','COCF_SN','Shift Note'),
		('MASSOBJTYP','WORKFPLAN','Shift plan'),
		('MASSOBJTYP','BPR_SHFREP','shift report'),
		('MASSOBJTYP','COCF_SR','Shift Report'),
		('MASSOBJTYP','IDOCSHPMNT','Shipment'),
		('MASSOBJTYP','IDOC21DESA','Shipping notif.converted from 2.1'),
		('MASSOBJTYP','BUS0005','Shipping point'),
		('MASSOBJTYP','BUSISM026','Shipping Problem Message'),
		('MASSOBJTYP','/KYK/SHPFL','Shopfloor Specialist'),
		('MASSOBJTYP','SIPAYGRPES','SI contribution group Spain'),
		('MASSOBJTYP','SOCINSDOCD','SI Statement of Contributions Paid [Germany]'),
		('MASSOBJTYP','FOPC_CASES','Sign-Off'),
		('MASSOBJTYP','GRPC_CASES','Sign-Off'),
		('MASSOBJTYP','BILLDOCSIM','Simulated billing document'),
		('MASSOBJTYP','BUS2126001','Single Vendor Billing Document'),
		('MASSOBJTYP','BUS1501','Site [RE-FX]'),
		('MASSOBJTYP','BUS1198','Site Recipe'),
		('MASSOBJTYP','SUPCOLNOT','SMI Monitor'),
		('MASSOBJTYP','BUS1175','Solution'),
		('MASSOBJTYP','BUS117501','solution search feedback'),
		('MASSOBJTYP','/XFT/SOP01','SOP Release Process'),
		('MASSOBJTYP','BUS6025','Source Determination'),
		('MASSOBJTYP','/EACA/PRNT','Source Document'),
		('MASSOBJTYP','/EACA/PMLI','Source Document Display [Pure Profit Record]'),
		('MASSOBJTYP','BUS2053','Source list'),
		('MASSOBJTYP','BUS6101','Source System'),
		('MASSOBJTYP','ADBUS2040','Spec 2000 Upload: Confirmation'),
		('MASSOBJTYP','ADBUS2012','SPEC2000 A&D-MM Purchase Order'),
		('MASSOBJTYP','ADBUS2010','SPEC2000 A&D-MM RFQ'),
		('MASSOBJTYP','ADBUS2030','SPEC2000 A&D-SD Inquiry'),
		('MASSOBJTYP','ADBUS2032','SPEC2000 A&D-SD sales order'),
		('MASSOBJTYP','IDOCSPEC2K','SPEC2K IDoc'),
		('MASSOBJTYP','PDRELA_020','Specialization'),
		('MASSOBJTYP','BUS1077','Specification'),
		('MASSOBJTYP','BUS1092','Specification report'),
		('MASSOBJTYP','WDK_PRINT','Spool to PDF'),
		('MASSOBJTYP','SRM_CON','SRM Contacts'),
		('MASSOBJTYP','SRM_DOC','SRM Documents'),
		('MASSOBJTYP','SRM_STH','SRM Stakeholder'),
		('MASSOBJTYP','FSSCF4','SSC F4 help'),
		('MASSOBJTYP','SSCF4','SSC F4 Help'),
		('MASSOBJTYP','SAWE_SA','Staff assignment navigation'),
		('MASSOBJTYP','BUS1001006','Standard material'),
		('MASSOBJTYP','/CWM/BUS06','Standard Material CWM'),
		('MASSOBJTYP','STASK','Standard task'),
		('MASSOBJTYP','WORKINGWI','Standard work item for dialog steps'),
		('MASSOBJTYP','CCPRECEIVE','Start of Workflow for Inbound Documents'),
		('MASSOBJTYP','CERTIFPAYD','Statement for Payroll Germany'),
		('MASSOBJTYP','BPR_STATUS','status'),
		('MASSOBJTYP','UCSTAT','Status Changes'),
		('MASSOBJTYP','BUS7005','Status event'),
		('MASSOBJTYP','BUS7005_1','Status event'),
		('MASSOBJTYP','BUS1197001','Status of Generic Engineering Node'),
		('MASSOBJTYP','BUS1176002','Status of the Product Structure Variant'),
		('MASSOBJTYP','AINITIATOR','Step Ad Hoc Properties [Default _WF_INITIATOR]'),
		('MASSOBJTYP','APOSSIBLE','Step Ad Hoc Properties [Default _WF_INITIATOR]'),
		('MASSOBJTYP','BPSTEP','Step in background processing'),
		('MASSOBJTYP','BPR_STCKOV','stock overview'),
		('MASSOBJTYP','BPR_STCKRQ','stock requirement list'),
		('MASSOBJTYP','BUS2180','Stock tracking in DRM'),
		('MASSOBJTYP','OIB_BUS001','Storage Object Tank Dip Reading'),
		('MASSOBJTYP','BUS6032','Store Order Service'),
		('MASSOBJTYP','IDOCWGSREQ','Store Orders IS Retail'),
		('MASSOBJTYP','STREET','Street Name'),
		('MASSOBJTYP','STRTROUTE','Street route'),
		('MASSOBJTYP','PDOTYPE_ST','Student'),
		('MASSOBJTYP','STACCOUNT','Student Account'),
		('MASSOBJTYP','/NAM/B040','Subtype for Shipping Order Complaint'),
		('MASSOBJTYP','/NAM/B2108','Subtype for Subscription Complaint'),
		('MASSOBJTYP','TASK','Super Type for the 4 Task Types [TTS, WF, WS]'),
		('MASSOBJTYP','BPR_SUPPL','supplier'),
		('MASSOBJTYP','BPR_SUCONF','supplier confirmation'),
		('MASSOBJTYP','SAP_70113','Supply area'),
		('MASSOBJTYP','ISUGRID','Supply Grid'),
		('MASSOBJTYP','ISUSUPSCEN','Supply Scenario'),
		('MASSOBJTYP','CCPSUPPORT','Support objects for CC process'),
		('MASSOBJTYP','CCPSSO','Support Objekt for SAP Office'),
		('MASSOBJTYP','HRSUPG_NAV','Support Team in SAP E-Recruiting'),
		('MASSOBJTYP','BUSJBDSWAP','Swap - SEM Banking'),
		('MASSOBJTYP','/ISDFPS/SL','Sychronize Logical System'),
		('MASSOBJTYP','BUS1174','Symptom'),
		('MASSOBJTYP','SYSALERT','System Alert for Workflow Connection'),
		('MASSOBJTYP','/ISDFPS/EV','System Event'),
		('MASSOBJTYP','SYSTEM','System object type [!!!only for Workflow Wizards!!!]'),
		('MASSOBJTYP','LAWSYSTEM','Systems in the License Administration Workbench'),
		('MASSOBJTYP','T_RECEIVE1','T_RECEIVE1'),
		('MASSOBJTYP','BUS6115','Tabular Provider for InfoSet Data'),
		('MASSOBJTYP','HRTALG_NAV','Talent Group in SAP E-Recruiting'),
		('MASSOBJTYP','BUS2175','Task'),
		('MASSOBJTYP','WF_TASK','Task as step in workflow'),
		('MASSOBJTYP','BUS2169','Task in Project or Checklist Template'),
		('MASSOBJTYP','EAM_TL','Task List'),
		('MASSOBJTYP','/XFT/0001','task manager'),
		('MASSOBJTYP','GRFN_PLAN','Task Plan of GRC Process Control'),
		('MASSOBJTYP','GRPC_PLAN','Task Plan of GRC Process Control'),
		('MASSOBJTYP','QMSM','Tasks'),
		('MASSOBJTYP','TRM_NAVI','Tax Revenue Management Navigations'),
		('MASSOBJTYP','OIG_BUS002','TD Service for Object, Shipment and Master Data'),
		('MASSOBJTYP','OIG_BUS001','TD Shipment'),
		('MASSOBJTYP','SRANCHOR','Technical anchor to link objects per SR persistence'),
		('MASSOBJTYP','DECISION','Technical implementation of a user decision'),
		('MASSOBJTYP','TECHINST','Technical installation'),
		('MASSOBJTYP','EAM_TO','Technical Object'),
		('MASSOBJTYP','ISTBILLDOC','Telco Billing Document'),
		('MASSOBJTYP','CP_CALL','Telephone call'),
		('MASSOBJTYP','CIC_CALL','Telephone Call in Customer Interaction Center'),
		('MASSOBJTYP','SRTPINGTF1','Test BAPI endpoint for a web service'),
		('MASSOBJTYP','CATALOG','Test catalog'),
		('MASSOBJTYP','FOPC_CASEL','Test Log'),
		('MASSOBJTYP','GRPC_CASEL','Test Log'),
		('MASSOBJTYP','BIND_TEST','Test object for binding'),
		('MASSOBJTYP','BORTEST','Test Object for BO Runtime'),
		('MASSOBJTYP','BUS1205','Test object for CIC data flow - INTERNAL ONLY'),
		('MASSOBJTYP','SWE_CD_TST','Test Object for Event Creation from Change Documents'),
		('MASSOBJTYP','PACKAGE','Test Package'),
		('MASSOBJTYP','PLAN','Test plan'),
		('MASSOBJTYP','FOPC_CASET','Testing'),
		('MASSOBJTYP','GRPC_CASET','Testing'),
		('MASSOBJTYP','ACT_TEXT','Text for [IMG] Activity'),
		('MASSOBJTYP','MS_WORD','Texts in Microsoft Word'),
		('MASSOBJTYP','TFW_MTP','TFW Mini-Template'),
		('MASSOBJTYP','HIGHTIME','Time information created from high duty'),
		('MASSOBJTYP','SAWE_TPS','Time Planning Sheet'),
		('MASSOBJTYP','TIMEFRAME','Time segment/time frame'),
		('MASSOBJTYP','CATSXT','Time Sheet for Service Providers'),
		('MASSOBJTYP','BUS7024','Time sheet manager'),
		('MASSOBJTYP','TIMESHREC','Time sheet record'),
		('MASSOBJTYP','EMPLOYEET','Time specification of employee [international]'),
		('MASSOBJTYP','BUSISM022','Title Master'),
		('MASSOBJTYP','WF_DESIGN','Tools for designing workflows'),
		('MASSOBJTYP','BUSISB044','Total Commitment'),
		('MASSOBJTYP','BUS5640','TotalReturnSwap'),
		('MASSOBJTYP','BUS1178006','Trade Item'),
		('MASSOBJTYP','BUS2124','Trading Contract'),
		('MASSOBJTYP','PD_SCM_MSG','Training and Event Management Correspondence'),
		('MASSOBJTYP','CA_TSTC','Transaction'),
		('MASSOBJTYP','TSTC','Transaction'),
		('MASSOBJTYP','TSTC_PAR','Transaction'),
		('MASSOBJTYP','TSTC_UIF','Transaction'),
		('MASSOBJTYP','ZERP','Transaction'),
		('MASSOBJTYP','IDOCMONITO','Transfer of incorrect Idocs to Monitor'),
		('MASSOBJTYP','ISTFILEHIS','Transfer of telephone number disconnection file'),
		('MASSOBJTYP','BPR_TRORD','transfer order'),
		('MASSOBJTYP','BUS2130','Transfer Price Agreement'),
		('MASSOBJTYP','BUS2131','Transfer Price Allocation'),
		('MASSOBJTYP','BUSISM015','Transfer Request'),
		('MASSOBJTYP','BPR_TRANS','transport'),
		('MASSOBJTYP','CTPROPOSAL','Transport proposal in CTS'),
		('MASSOBJTYP','VTTK','Transportation'),
		('MASSOBJTYP','BUS0021','Transportation Planning Point'),
		('MASSOBJTYP','SAGENCY','Travel agency [SAP training]'),
		('MASSOBJTYP','TRAVEL','Travel documents in optical archive'),
		('MASSOBJTYP','BUS2140','Travel Expenses Document for Posting to Accounting'),
		('MASSOBJTYP','TRAVELREQ','Travel Scenario: Travel Request'),
		('MASSOBJTYP','TRLOAPPR_1','Treasury Loans: Release Workflow'),
		('MASSOBJTYP','TRLOAPPR_3','Treasury Loans: Release Workflow'),
		('MASSOBJTYP','TRLOAPPROV','Treasury Loans: Release Workflow'),
		('MASSOBJTYP','BPAR','Treasury/Real Estate Business Partner'),
		('MASSOBJTYP','RMXT_TRIAL','Trial'),
		('MASSOBJTYP','RMXT_PLOS','Trial: QM'),
		('MASSOBJTYP','ZCALLPAGE','Trip Expense'),
		('MASSOBJTYP','TRAVEL_VER','Trip Version for Optical Archive'),
		('MASSOBJTYP','BUSISM011','Truck Route'),
		('MASSOBJTYP','OIJ_BUS002','TSW Location'),
		('MASSOBJTYP','OIJ_BUS005','TSW Ticket'),
		('MASSOBJTYP','OIJ_BUS004','TSWNomination'),
		('MASSOBJTYP','OIJ_BUS003','TSWPartnerRole'),
		('MASSOBJTYP','OIJ_BUS001','TSWTransportSystem'),
		('MASSOBJTYP','BUSISM004','Unloading Point'),
		('MASSOBJTYP','BUSISM006','Unloading rule'),
		('MASSOBJTYP','BUSISM005','Unloading Viab.Set'),
		('MASSOBJTYP','BUS1169','Update CO-PA Actual Data'),
		('MASSOBJTYP','IDOCISUCOE','Upload consolidator logon - new logon/change/logoff'),
		('MASSOBJTYP','URLRUNTIME','URL at Runtime'),
		('MASSOBJTYP','FAGL_USER','User'),
		('MASSOBJTYP','SOUA','User agent'),
		('MASSOBJTYP','LAWUTYPE','User Types in the License Administration Workbench'),
		('MASSOBJTYP','BUS1162','User-Defined Characteristic in CO-PA'),
		('MASSOBJTYP','BUS1165','User-Defined Characteristics Hierarchies in Profitability Analysis'),
		('MASSOBJTYP','LAWUSER','Users in the License Administration Workbench'),
		('MASSOBJTYP','FAVORIT_UK','User-specific bookmark'),
		('MASSOBJTYP','ISUCONTRCT','Utility contract'),
		('MASSOBJTYP','INSTLN','Utility Installation'),
		('MASSOBJTYP','ISUPRODUCT','Utility product'),
		('MASSOBJTYP','ISUSERVICE','Utility service'),
		('MASSOBJTYP','T024W','Valid purchasing organization for plant'),
		('MASSOBJTYP','VALIDATION','Validation in Special Purpose Ledger'),
		('MASSOBJTYP','BUS1018','Valuated Project Stock'),
		('MASSOBJTYP','BUS1017','Valuated Sales Order Stock'),
		('MASSOBJTYP','BUSJBDVATR','Variable Transaction - SEM Banking'),
		('MASSOBJTYP','BUS1096','Variant Configuration'),
		('MASSOBJTYP','BUS1194001','Variant of a General Recipe'),
		('MASSOBJTYP','BUS1176001','Variants of a Product Structure Node'),
		('MASSOBJTYP','EAM_VB','vb_viewer'),
		('MASSOBJTYP','BUS1401','VC Interface Design'),
		('MASSOBJTYP','BUS1200','Vehicle'),
		('MASSOBJTYP','BUS1008','Vendor'),
		('MASSOBJTYP','LFA1','Vendor'),
		('MASSOBJTYP','ZVENDOR_1','Vendor'),
		('MASSOBJTYP','MDMLFA1','Vendor [MDM]'),
		('MASSOBJTYP','BUS3008','Vendor account'),
		('MASSOBJTYP','BUS2126','Vendor billing document'),
		('MASSOBJTYP','BUS2020','Vendor document'),
		('MASSOBJTYP','/OPT/VPR','Vendor Portal Registration: Master User ID'),
		('MASSOBJTYP','BUS2011','Vendor quotation'),
		('MASSOBJTYP','BUS2126003','Vendor Settlement'),
		('MASSOBJTYP','BUS2125','Vendor-Related Customer Billing Document List'),
		('MASSOBJTYP','ISA_FLMP','Vendor\'s mail partner for material ordered via releases'),
		('MASSOBJTYP','BUS2163','Version Header for Snapshot or Simulation'),
		('MASSOBJTYP','VCLDATA','View Cluster Data'),
		('MASSOBJTYP','VIEWDATA','View Data'),
		('MASSOBJTYP','/DSD/VC_VL','Visit List'),
		('MASSOBJTYP','/DSD/VC_VP','Visit Plan'),
		('MASSOBJTYP','BUSISM035','Visit Plan'),
		('MASSOBJTYP','DPVMS_BUPA','VMS DP: Business Partner'),
		('MASSOBJTYP','DPVMS_OPTY','VMS DP: Operation Type'),
		('MASSOBJTYP','/OPT/VPRST','VSS Registration Status Configuration'),
		('MASSOBJTYP','W2FORM','W2FORM'),
		('MASSOBJTYP','W4W5INFOUS','W4W5INFOUS'),
		('MASSOBJTYP','BUS1050','Wage type'),
		('MASSOBJTYP','BUS0009','Warehouse Complex'),
		('MASSOBJTYP','BUS3021','Warehouse Inventory'),
		('MASSOBJTYP','BUS3016','Warehouse Stock'),
		('MASSOBJTYP','BUS2018','Warehouse Transfer Order'),
		('MASSOBJTYP','BUS2065','Warehouse transfer request'),
		('MASSOBJTYP','BUS1178005','Warranty'),
		('MASSOBJTYP','BUS2222','Warranty Claim'),
		('MASSOBJTYP','WASTEBILL','Waste Billing Category'),
		('MASSOBJTYP','CONTAINER','Waste Container'),
		('MASSOBJTYP','WASTECONTR','Waste Disposal Contract for CIC'),
		('MASSOBJTYP','WASTEWDOC','Waste Disposal Order'),
		('MASSOBJTYP','WASTEROUTE','Waste management route'),
		('MASSOBJTYP','COMWCBCONF','WCB Configuration Approval'),
		('MASSOBJTYP','WCD_TM','WCD Template'),
		('MASSOBJTYP','WCD_TM_IT','WCD Template Item'),
		('MASSOBJTYP','WDK_SWF','WDK_SWF'),
		('MASSOBJTYP','BUS1184','Web Profile [Trading Contract]'),
		('MASSOBJTYP','WEBSERVICE','WebFlow Service'),
		('MASSOBJTYP','EWEIGHOBJ','Weighing Process'),
		('MASSOBJTYP','WFTA','WF test object asynchronous'),
		('MASSOBJTYP','WFTS','WF test object sychronous'),
		('MASSOBJTYP','WFA_OP','WFM operational hours'),
		('MASSOBJTYP','WFM_CRM_OP','WFM operational hours'),
		('MASSOBJTYP','WFMC_KAPPL','WFMC: Output application'),
		('MASSOBJTYP','WFMC_KSCHL','WFMC: Output type'),
		('MASSOBJTYP','WF_WORDTPL','WORD document: Notification of absence with data from workflow'),
		('MASSOBJTYP','WAP','Work Approval'),
		('MASSOBJTYP','WAPI','Work Approval Item'),
		('MASSOBJTYP','BUS2054','Work breakdown structure'),
		('MASSOBJTYP','BUS0011','Work center'),
		('MASSOBJTYP','PDOTYPE_A','Work Center [Human Resources]'),
		('MASSOBJTYP','CRHD','Work center [Logistics]'),
		('MASSOBJTYP','WCA','Work Clearance Application'),
		('MASSOBJTYP','WCD','Work Clearance Document'),
		('MASSOBJTYP','WCD_ITEM','Work Clearance Document Item'),
		('MASSOBJTYP','APPR_WCM','Work Clearance Management Approvals'),
		('MASSOBJTYP','WORKITEM','Work item'),
		('MASSOBJTYP','CONTITEM','Work item as anchor for a data container'),
		('MASSOBJTYP','WIDEADRAIS','Work Item Deadline Reached'),
		('MASSOBJTYP','FLOWITEM','Work Item for [Sub]Workflows'),
		('MASSOBJTYP','BATCHITEM','Work item for background steps'),
		('MASSOBJTYP','NOTIFYITEM','Work item for completion message'),
		('MASSOBJTYP','DEADLITEM','Work item for deadlines'),
		('MASSOBJTYP','SELFITEM','Work Item for Dialog Steps on Itself'),
		('MASSOBJTYP','CCPCICWI','Work item for processing in Customer Interaction Center'),
		('MASSOBJTYP','EVENTITEM','Work item for wait step'),
		('MASSOBJTYP','WIMDH','Work item with deadline monitoring'),
		('MASSOBJTYP','WIMEVT','Work item with event communication'),
		('MASSOBJTYP','WIMTASK','Work item with task link'),
		('MASSOBJTYP','ISUWIMUSER','Work item with user interaction'),
		('MASSOBJTYP','WIMUSER','Work item with user interaction'),
		('MASSOBJTYP','WIODH','Work item without deadline monitoring'),
		('MASSOBJTYP','WIOTASK','Work item without task link'),
		('MASSOBJTYP','WIOUSER','Work item without user interaction'),
		('MASSOBJTYP','BUS7022','Work list for compensation adjustments'),
		('MASSOBJTYP','BUS1048','Work Schedule'),
		('MASSOBJTYP','T024A','Work scheduler group'),
		('MASSOBJTYP','OCCLEAVEFR','Work Stopped [F]'),
		('MASSOBJTYP','WORKFLOW','Workflow definition'),
		('MASSOBJTYP','WF_DOC','Workflow document'),
		('MASSOBJTYP','SWF_TST_01','Workflow Exit Test BOR object'),
		('MASSOBJTYP','WRFOTBPRC','Workflow for OTB Procurement'),
		('MASSOBJTYP','HRPSSG_AO','Workflow Object specific to pubic sector Singapore'),
		('MASSOBJTYP','HRPSSG_RO','Workflow Object specific to pubic sector Singapore'),
		('MASSOBJTYP','PSSGOBTYPE','Workflow Object specific to pubic sector Singapore'),
		('MASSOBJTYP','WFPRC','Workflow process 2.1'),
		('MASSOBJTYP','TWFPT','Workflow process type 2.1'),
		('MASSOBJTYP','WFSTACK','Workflow stack 2.1'),
		('MASSOBJTYP','WFLOW','Workflow task'),
		('MASSOBJTYP','SFLOW','Workflow template'),
		('MASSOBJTYP','ACHANGE','Workflow-Driven Ad Hoc Change of Agents'),
		('MASSOBJTYP','ROPC_WF','WorkflowProcess'),
		('MASSOBJTYP','WFRESOURCE','Workforce Management Resource'),
		('MASSOBJTYP','ARCHLISTWI','Worklist'),
		('MASSOBJTYP','HRREC_WL','Worklist of Recruiter'),
		('MASSOBJTYP','SCMA_WLIST','Worklist of Schedule Manager'),
		('MASSOBJTYP','/XFT/0002','XftTaskCycle'),
		('MASSOBJTYP','Z_BUS2088','Z_BUS2088'),
		('MASSOBJTYP','Z_MAIL_VC','Z_MAIL_VC'),
		('MASSOBJTYP','ZBASICPAY','ZBASICPAY'),
		('MASSOBJTYP','ZBUS1080','ZBUS1080'),
		('MASSOBJTYP','ZBUS2001','zbus2001'),
		('MASSOBJTYP','ZBUS2075','ZBUS2075 internal order subtype'),
		('MASSOBJTYP','ZBUS2172','ZBUS2172'),
		('MASSOBJTYP','ZBUS7050','ZBUS7050'),
		('MASSOBJTYP','ZCATS','ZCATS'),
		('MASSOBJTYP','ZDRAW','ZDRAW'),
		('MASSOBJTYP','ZECM','ZECM'),
		('MASSOBJTYP','ZEMPFACT','ZEMPFACT'),
		('MASSOBJTYP','ZERC_CDCY','ZERC_CDCY'),
		('MASSOBJTYP','ZERCOBJECT','ZERCOBJECT'),
		('MASSOBJTYP','ZHCMGPOBJ','ZHCMGPOBJ'),
		('MASSOBJTYP','ZHRBENUSFS','ZHRBENUSFS'),
		('MASSOBJTYP','ZKEBD','ZKEBD'),
		('MASSOBJTYP','ZMSS_REQ','ZMSS_REQ'),
		('MASSOBJTYP','ZPA40','zpa40'),
		('MASSOBJTYP','ZPDRELA025','ZPDRELA025'),
		('MASSOBJTYP','ZPUOC_10','zpuoc_10'),
		('MASSOBJTYP','ZQUOTATION','ZQUOTATION'),
		('MASSOBJTYP','ZRPM_STATU','ZRPM_STATU'),
		('MASSOBJTYP','ZTRIP1','ZTRIP1'),
		('MASSOBJTYP','ZTRIPDECI','ZTripDeci'),
		('MASSOBJTYP','ZZLIKP','ZZLIKP'),
		('OTYPE','*','[All Values]'),
		('OTYPE','CC','[No Field Value Text Found]'),
		('OTYPE','CH','[No Field Value Text Found]'),
		('OTYPE','CL','[No Field Value Text Found]'),
		('OTYPE','CR','[No Field Value Text Found]'),
		('OTYPE','CT','[No Field Value Text Found]'),
		('OTYPE','DE','[No Field Value Text Found]'),
		('OTYPE','RP','[No Field Value Text Found]'),
		('OTYPE','RS','[No Field Value Text Found]'),
		('OTYPE','10','Á÷±º'),
		('OTYPE','MA','Account Group'),
		('OTYPE','P6','Account Group'),
		('OTYPE','PU','ACO User Group'),
		('OTYPE','OE','Activity'),
		('OTYPE','SI','Activity [EIC]'),
		('OTYPE','O7','Activity Category'),
		('OTYPE','O6','Activity Group'),
		('OTYPE','RA','Advertisement'),
		('OTYPE','XO','ALE filter object'),
		('OTYPE','XC','ALE filter object combin.'),
		('OTYPE','XS','ALE logical system'),
		('OTYPE','XF','ALE split function'),
		('OTYPE','AP','Applicant'),
		('OTYPE','ND','Application'),
		('OTYPE','FA','Application component'),
		('OTYPE','BA','Appraisal'),
		('OTYPE','BS','Appraisal Model'),
		('OTYPE','VA','Appraisal template'),
		('OTYPE','BU','Budget Structure Element'),
		('OTYPE','ID','Business area'),
		('OTYPE','BP','Business Partner'),
		('OTYPE','PR','Business process'),
		('OTYPE','PG','Business process group'),
		('OTYPE','NE','Candidacy'),
		('OTYPE','NA','Candidate'),
		('OTYPE','KA','Capacity [Logistics]'),
		('OTYPE','LB','Career'),
		('OTYPE','P5','Central Control'),
		('OTYPE','OS','Central Opportunity'),
		('OTYPE','CP','Central person'),
		('OTYPE','MP','Central Process'),
		('OTYPE','PK','Central Process'),
		('OTYPE','MG','Central Process Group'),
		('OTYPE','MT','Central Process Step'),
		('OTYPE','O1','Central Risk'),
		('OTYPE','PL','Central Subprocess'),
		('OTYPE','IA','Company'),
		('OTYPE','U','Company'),
		('OTYPE','IC','Company code'),
		('OTYPE','IF','Cons business area'),
		('OTYPE','PT','Contact person'),
		('OTYPE','RL','Context Role'),
		('OTYPE','MO','Control Objective'),
		('OTYPE','PM','Control Objective'),
		('OTYPE','IH','Controlling area'),
		('OTYPE','K','Cost center'),
		('OTYPE','KG','Cost center group'),
		('OTYPE','E','Course'),
		('OTYPE','L','Course Group'),
		('OTYPE','EK','Course Program'),
		('OTYPE','D','Course Type'),
		('OTYPE','IB','Credit control area'),
		('OTYPE','BG','Criteria Group'),
		('OTYPE','VB','Criteria Group'),
		('OTYPE','BK','Criterion'),
		('OTYPE','VC','Criterion'),
		('OTYPE','EC','Curriculum'),
		('OTYPE','DC','Curriculum Type'),
		('OTYPE','KU','Customer'),
		('OTYPE','B','Development Plan'),
		('OTYPE','BL','Development Plan Group'),
		('OTYPE','IO','Distribution chain'),
		('OTYPE','IN','Distribution channel'),
		('OTYPE','IL','Division'),
		('OTYPE','ET','E-Learning'),
		('OTYPE','I3','Employee group'),
		('OTYPE','I2','Employee subgroup'),
		('OTYPE','P7','Entity-Level Control'),
		('OTYPE','XP','Expert'),
		('OTYPE','XG','Expert group'),
		('OTYPE','EG','Exposure group'),
		('OTYPE','H','External person'),
		('OTYPE','IG','FM area'),
		('OTYPE','FN','Functional Area'),
		('OTYPE','IE','Functional area'),
		('OTYPE','99','Implementations'),
		('OTYPE','UE','Instructional Unit'),
		('OTYPE','UD','Instructional Unit Type'),
		('OTYPE','EP','Inv.program position'),
		('OTYPE','C','Job'),
		('OTYPE','JF','Job Family'),
		('OTYPE','WG','Knowledge Area'),
		('OTYPE','OK','KRI Business Rules'),
		('OTYPE','O4','KRI Implementation'),
		('OTYPE','O5','KRI Instance'),
		('OTYPE','OA','KRI Template'),
		('OTYPE','OJ','Learning objective'),
		('OTYPE','OR','Legal entity'),
		('OTYPE','IU','Loading point'),
		('OTYPE','M8','Local Account Group'),
		('OTYPE','P8','Local Account Group'),
		('OTYPE','P2','Local Control'),
		('OTYPE','P9','Local Entity-Level Ctrl.'),
		('OTYPE','M9','Local Mgmt Control Group'),
		('OTYPE','P0','Local Process'),
		('OTYPE','M2','Local Process Step'),
		('OTYPE','P1','Local Subprocess'),
		('OTYPE','F','Location'),
		('OTYPE','IK','Location'),
		('OTYPE','LA','Logistics work center'),
		('OTYPE','MC','Management Cockpit'),
		('OTYPE','MM','Management Control Group'),
		('OTYPE','M','Material'),
		('OTYPE','OG','Objective'),
		('OTYPE','II','Operating concern'),
		('OTYPE','OL','Opportunity'),
		('OTYPE','OM','Opportunity Category'),
		('OTYPE','VJ','Organizational Goal'),
		('OTYPE','O','Organizational unit'),
		('OTYPE','P','Person'),
		('OTYPE','IZ','Personnel area'),
		('OTYPE','I1','Personnel subarea'),
		('OTYPE','SR','Planned staff requirement'),
		('OTYPE','IJ','Plant'),
		('OTYPE','IW','Plant storage area'),
		('OTYPE','S','Position'),
		('OTYPE','NC','Posting'),
		('OTYPE','M1','Process'),
		('OTYPE','M4','Process [Scope]'),
		('OTYPE','M0','Process Group'),
		('OTYPE','P4','Process in Project Scope'),
		('OTYPE','VH','Process Item'),
		('OTYPE','M3','Process Step'),
		('OTYPE','PC','Profit center'),
		('OTYPE','PH','Profit center group'),
		('OTYPE','ZP','Project'),
		('OTYPE','KI','Prospect'),
		('OTYPE','IX','Purchasing organization'),
		('OTYPE','Q','Qualification'),
		('OTYPE','QB','Qualification Block'),
		('OTYPE','QK','Qualification group'),
		('OTYPE','RI','Recruitment Instrument'),
		('OTYPE','RF','Reference Force Element'),
		('OTYPE','P3','Referenced Control'),
		('OTYPE','O9','Regulation / Policy'),
		('OTYPE','O8','Regulation / Policy Group'),
		('OTYPE','OB','Regulation / Policy Req.'),
		('OTYPE','RE','Report [with variant]'),
		('OTYPE','OD','Request'),
		('OTYPE','QP','Requirements profile [LO]'),
		('OTYPE','NB','Requisition'),
		('OTYPE','RQ','Requisition'),
		('OTYPE','RR','Requisition Request [ISR]'),
		('OTYPE','G','Resource'),
		('OTYPE','R','Resource type'),
		('OTYPE','RY','Responsibility'),
		('OTYPE','MR','Risk'),
		('OTYPE','OF','Risk'),
		('OTYPE','PN','Risk'),
		('OTYPE','O0','Risk Category'),
		('OTYPE','AG','Role'),
		('OTYPE','AC','Rule'),
		('OTYPE','IQ','Sales area'),
		('OTYPE','IS','Sales group'),
		('OTYPE','IR','Sales office'),
		('OTYPE','IM','Sales organization'),
		('OTYPE','IP','SalesOrg-division-assignt'),
		('OTYPE','SO','SAP Organizational object'),
		('OTYPE','MS','Scorecard'),
		('OTYPE','VE','Service'),
		('OTYPE','IT','Shipping point'),
		('OTYPE','TS','Standard task'),
		('OTYPE','NG','Support Group'),
		('OTYPE','NF','Talent Group'),
		('OTYPE','TB','Talent Group'),
		('OTYPE','RM','Talent Review Meeting'),
		('OTYPE','T','Task'),
		('OTYPE','TG','Task group'),
		('OTYPE','PQ','Test Plan'),
		('OTYPE','TN','Training Need'),
		('OTYPE','TP','Training Plan'),
		('OTYPE','TR','Transaction'),
		('OTYPE','IV','Transp. planning point'),
		('OTYPE','US','User'),
		('OTYPE','UG','User group'),
		('OTYPE','MV','Value Driver Tree'),
		('OTYPE','IY','Warehouse complex'),
		('OTYPE','PJ','WBS element [project]'),
		('OTYPE','WA','Work area'),
		('OTYPE','A','Work Center'),
		('OTYPE','WI','Work item'),
		('OTYPE','WE','Workflow event'),
		('OTYPE','WO','Workflow object'),
		('OTYPE','WM','Workflow object method'),
		('OTYPE','WT','Workflow object type'),
		('OTYPE','WF','Workflow task'),
		('OTYPE','WS','Workflow template'),
		('PLNTY','E','Equipment Task List'),
		('PLNTY','A','General maintenance task list'),
		('PLNTY','Q','Inspection Plan'),
		('PLNTY','2','Master Recipe'),
		('PLNTY','R','Rate Routing'),
		('PLNTY','S','Reference Operation Set'),
		('PLNTY','M','Reference Rate Routing'),
		('PLNTY','3','Rough-cut Planning Profile'),
		('PLNTY','N','Routing'),
		('PLNTY','0','Standard Network'),
		('PLNTY','T','Task List for Funct. Location'),
		('PPFCODE','AKTI','Activate'),
		('PPFCODE','GENE','Approve'),
		('PPFCODE','HITS','Career plan simulation'),
		('PPFCODE','HITK','Career planning hit list'),
		('PPFCODE','AEND','Change'),
		('PPFCODE','AENK','Change canteen field'),
		('PPFCODE','AENT','Change temporarily'),
		('PPFCODE','COP','Copy'),
		('PPFCODE','COPY','Copy object'),
		('PPFCODE','COPR','Copy room'),
		('PPFCODE','INSE','Create'),
		('PPFCODE','MASS','Create'),
		('PPFCODE','INSG','Create from OS/2'),
		('PPFCODE','DEL','Delete'),
		('PPFCODE','DELO','Delete object'),
		('PPFCODE','CUTI','Delimit'),
		('PPFCODE','CUT','Delimit object'),
		('PPFCODE','DISP','Display'),
		('PPFCODE','DUTY','Essential relationship'),
		('PPFCODE','QUIC','Fast Data Entry'),
		('PPFCODE','HITW','Hit list for E&T Planning'),
		('PPFCODE','INIT','Initialization'),
		('PPFCODE','INTE','Integration'),
		('PPFCODE','LISD','List Display'),
		('PPFCODE','LIST','List display with change'),
		('PPFCODE','NEWL','New Language'),
		('PPFCODE','PLVO','Propose change'),
		('PPFCODE','PLVG','Proposed plan from OS/2'),
		('PPFCODE','ABLN','Reject'),
		('PPFCODE','SIMU','Simulation'),
		('PPFCODE','BEAN','Submit'),
		('PPFCODE','VORS','Succession plan screening'),
		('QMASTMOD','0304','Change insp. method'),
		('QMASTMOD','0204','Change master insp. charac.'),
		('QMASTMOD','0211','Changes to unplanned charac. possible [res. recording]'),
		('QMASTMOD','0302','Create insp. method'),
		('QMASTMOD','0202','Create master inspection charac.'),
		('QMASTMOD','0303','Create validity period for inspection method'),
		('QMASTMOD','0203','Create validity period for master inspection characteristic'),
		('QMASTMOD','9000','Customer variants for use in customer exits'),
		('QMASTMOD','0305','Delete insp. method'),
		('QMASTMOD','0205','Delete master insp. charac.'),
		('QMASTMOD','0306','Display insp. method'),
		('QMASTMOD','0206','Display master insp. charac.'),
		('QMASTMOD','0310','Include insp. method [mast. insp. charac. task list]'),
		('QMASTMOD','0210','Include mast. insp. charac. [insp. plan cert.profile spec]'),
		('QMASTMOD','0201','Processing of authorization group in master insp. charac.'),
		('QMASTMOD','0101','Processing of authorization group in sample-drawing proc.'),
		('QMASTMOD','0301','Processing of authorization group in the insp. method'),
		('QMASTMOD','0102','Processing of sample-drawing procedure'),
		('QMATMODUS','I','Actual quantity correction for insp. lot'),
		('QMATMODUS','0','Customer variants for use in customer exits'),
		('QMATMODUS','N','Digital signature for physical-sample drawing confirmation'),
		('QMATMODUS','A','Edit the material authorization group in the material master'),
		('QMATMODUS','M','Electronic signature [results recording]'),
		('QMATMODUS','L','Electronic signature [usage decision]'),
		('QMATMODUS','O','Flexible Inspection Specifications'),
		('QMATMODUS','H','Make quantity transfer posting for insp. lot'),
		('QMATMODUS','B','Process inspection completion and usage decision'),
		('QMATMODUS','C','Process inspection lot'),
		('QMATMODUS','D','Process inspection results [insp. Characteristics  defects]'),
		('QMATMODUS','G','Process material specification'),
		('QMATMODUS','E','Process QM information records [purchasing sales and dist.]'),
		('QMATMODUS','F','Process quality levels'),
		('QMATMODUS','J','Processing sample master record'),
		('QMATMODUS','K','Release phys. sample drawing/phys. sample'),
		('QPRUEFART','*','[All]'),
		('QPRUEFART','07','Audit Inspection'),
		('QPRUEFART','04','Final Inspection at GR from Production'),
		('QPRUEFART','02','Goods Issue Inspection'),
		('QPRUEFART','01','Goods Receipt Inspection for Order'),
		('QPRUEFART','0101','Goods Receipt Inspection Model'),
		('QPRUEFART','0102','Goods Receipt Inspection Preliminary'),
		('QPRUEFART','1601','Initial Test [Stability Studies]'),
		('QPRUEFART','03','In-Process Insp. for Production Order'),
		('QPRUEFART','13','In-Process Insp. for Run Schedule Header'),
		('QPRUEFART','0800','Insp Lot w. Insp Stock at QM Activation'),
		('QPRUEFART','11','Insp. for Delivery to Cust. w/o Order'),
		('QPRUEFART','10','Insp. for Delivery to Customer w. Order'),
		('QPRUEFART','0303','Inspection during Production'),
		('QPRUEFART','Z15','Inspection for competitor sample [LIMS]'),
		('QPRUEFART','12','Inspection for Delivery in General'),
		('QPRUEFART','05','Inspection for Other Goods Receipt'),
		('QPRUEFART','15','Inspection for Physical Sample'),
		('QPRUEFART','06','Inspection for Returns from Customer'),
		('QPRUEFART','16','Inspection for Storage Condition [Stabi]'),
		('QPRUEFART','17','Inspection from External System'),
		('QPRUEFART','14','Inspection in Plant Maintenance'),
		('QPRUEFART','1602','Manual Insp. Lot for Storage Cond [Stab]'),
		('QPRUEFART','Z2','Manual inspection lot [LIMS]'),
		('QPRUEFART','1001','Model Insp. for Delivery with Order'),
		('QPRUEFART','89','Other Inspection'),
		('QPRUEFART','0130','Receiving Insp. at GR from Ext. Process.'),
		('QPRUEFART','09','Recurring Inspection'),
		('QPRUEFART','08','Stock Transfer Inspection'),
		('REPID','RFFOUS_C','[No Field Value Found]'),
		('REPID','RPCDTBU0','[No Field Value Found]'),
		('REPID','SAPDBPNP','[No Field Value Found]'),
		('S_ADMI_FCD','UMON','Administer Update Records [without Update System]'),
		('S_ADMI_FCD','MEMO','Allocation of SAP memory management [RSMEMORY]'),
		('S_ADMI_FCD','SM21','Analyze system log'),
		('S_ADMI_FCD','ST0R','Analyze traces'),
		('S_ADMI_FCD','DBA','Authorization for Database Administration'),
		('S_ADMI_FCD','QDEL','Authorization to delete a queue:  RSTRFCQDS,  RSTRFCIDS'),
		('S_ADMI_FCD','AUDA','Basis audit administration'),
		('S_ADMI_FCD','AUDD','Basis audit display auth.'),
		('S_ADMI_FCD','BTCH','Batch input test environment'),
		('S_ADMI_FCD','ST0M','Change trace switches'),
		('S_ADMI_FCD','SPAR','Client-specific spool administration'),
		('S_ADMI_FCD','SPTR','Client-specific TemSe administration'),
		('S_ADMI_FCD','T000','Create new client'),
		('S_ADMI_FCD','PRIN','Cross-User Maintenance of Default Print Values'),
		('S_ADMI_FCD','SCP2','Database character conversion'),
		('S_ADMI_FCD','UDSP','Display Update Requests and their Data'),
		('S_ADMI_FCD','UBUF','Execute Report RSUSR405'),
		('S_ADMI_FCD','TOUC','Execution of report TOUCHALL'),
		('S_ADMI_FCD','ICFA','ICF Administration Authorization [Transaction SICF]'),
		('S_ADMI_FCD','ICFS','ICF Authorization for PUBLIC Services [Transaction SICF]'),
		('S_ADMI_FCD','ICFR','ICF Recorder Authorization for Administration Console'),
		('S_ADMI_FCD','IGS','IGS Administration Authorization [Transaction SIGS]'),
		('S_ADMI_FCD','LANG','Language handling configuration'),
		('S_ADMI_FCD','LC01','Live Cache Administration [Display Functions]'),
		('S_ADMI_FCD','LC04','Live Cache Administration [Initialization]'),
		('S_ADMI_FCD','LC02','Live Cache Administration [Start, Stop]'),
		('S_ADMI_FCD','LC03','liveCache Administration [Integration, Configuration]'),
		('S_ADMI_FCD','TLCK','Lock/unlock transactions'),
		('S_ADMI_FCD','FONT','Maintenance of SAPscript font data'),
		('S_ADMI_FCD','SMSS','MS SQL Server : Command Window'),
		('S_ADMI_FCD','NADM','Network administration using trans. SM54, SM55 and SM58'),
		('S_ADMI_FCD','' '','No Authorization'),
		('S_ADMI_FCD','COLA','OLE administration'),
		('S_ADMI_FCD','X25','Open X.25 connection for SAP'),
		('S_ADMI_FCD','PADM','Process administration using trans. SM04, SM50'),
		('S_ADMI_FCD','SYNC','Reset buffers [buffer synchr. with $sync $tab...]'),
		('S_ADMI_FCD','RSET','Reset/delete data without archiving'),
		('S_ADMI_FCD','RFCA','RFC Administration Authorization [Transaction SM59]'),
		('S_ADMI_FCD','SLIC','SAPLICENSE: Transaction SLICENSE'),
		('S_ADMI_FCD','F4MX','Search help support by switching ActiveX on/off'),
		('S_ADMI_FCD','SCP1','Settings for character sets languages…'),
		('S_ADMI_FCD','SPAD','Spool administration [all clients]'),
		('S_ADMI_FCD','SPAM','Spool administration [cross-client job authorization]'),
		('S_ADMI_FCD','SPAA','Spool administration [device administration]'),
		('S_ADMI_FCD','SPAC','Spool administration [device type character sets]'),
		('S_ADMI_FCD','SPAB','Spool administration [general settings]'),
		('S_ADMI_FCD','SP0R','Spool request management [all users]'),
		('S_ADMI_FCD','SM02','System Messages'),
		('S_ADMI_FCD','TCTR','System-wide table control settings'),
		('S_ADMI_FCD','CONV','Table conversion by release upgrade'),
		('S_ADMI_FCD','SPTD','TemSe administration [all clients]'),
		('S_ADMI_FCD','TRNL','Translation administration [Transaction SLW2]'),
		('S_ADMI_FCD','TRNR','Translation administration SLWA/SLWB'),
		('S_ADMI_FCD','UNIX','UNIX commands'),
		('S_ADMI_FCD','UADM','Update Administration'),
		('S_ADMI_FCD','SP01','Use of SP01 [all users]'),
		('S_ADMI_FCD','SPOS','Use of Transaction SP01 [all systems]'),
		('S_ENQ_ACT','ALL','All privileges including: deletion of lock entries of foreign users in foreign clients, activation/deactivation of enqueue-logging, activation/deactivation of complete functionality, emergency operation, deactivation of warning text on first deletion'),
		('S_ENQ_ACT','DLFU','Delete Foreign User - deletes lock entries of foreign users in the same client'),
		('S_ENQ_ACT','DLOU','Delete Own User - deletes the user\'s own lock entries'),
		('S_ENQ_ACT','DPFC','Display Foreign Client - displays lock entries of foreign users in foreign clients'),
		('S_ENQ_ACT','DPFU','Display Foreign User - displays lock entries of foreign users in the same client'),
		('SAAFKT','ADM','Administrator'),
		('SAAFKT','PROJ','Project Manager'),
		('SAAFKT','USER','Project Member'),
		('TCD','PU12','[No Field Value Found]'),
		('TCD','LQ02','Transfer Posting in Invent. Mgmt'),
		('TTYPE','CLCP','Client Transports'),
		('TTYPE','CUST','Customizing Requests'),
		('TTYPE','PIEC','Piece Lists'),
		('TTYPE','PATC','Preliminary Corrections and Deliveries'),
		('TTYPE','MOVE','Relocation Transports'),
		('TTYPE','TASK','Tasks'),
		('TTYPE','TRAN','Transport of Copies'),
		('TTYPE','DTRA','Workbench Requests'),
		('VERWE','Z1','[No Field Value Text Found]'),
		('VERWE','Z2','[No Field Value Text Found]'),
		('VERWE','2','Engineering/design'),
		('VERWE','6','Goods issue'),
		('VERWE','7','Goods issue'),
		('VERWE','601','Goods issue pattern'),
		('VERWE','5','Goods receipt'),
		('VERWE','501','Goods receipt model'),
		('VERWE','51','Goods receipt model'),
		('VERWE','502','Goods receipt prelim'),
		('VERWE','53','GR external process.'),
		('VERWE','9','Material check'),
		('VERWE','4','Plant maintenance'),
		('VERWE','1','Production'),
		('VERWE','3','Universal');
  
 