-- -----------------------------------------------------------------------
-- Recreating the MC reponse table and minor changes to MC response file
-- -----------------------------------------------------------------------
DROP TABLE IF EXISTS mc_check_response;
DROP TABLE IF EXISTS mc_response;
CREATE TABLE IF NOT EXISTS `mc_response` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `check_id` int(11) NOT NULL,
  `user` varchar(12) NOT NULL,
  `comment` text,
  `is_owner` tinyint(1) DEFAULT '0',
  `accepted` tinyint(1) DEFAULT '0',
  `positive` tinyint(1) DEFAULT '0',
  `submitted` tinyint(1) DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS mc_check_response_file;
DROP TABLE IF EXISTS mc_response_file;
CREATE TABLE IF NOT EXISTS `mc_response_file` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `response_id` int(11) NOT NULL,
  `comment` text,
  `file_name` tinytext,
  `file` mediumblob,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;