-- ------------------------------------------
-- UPDATE FOR Consolidated License Categories 
-- ------------------------------------------
ALTER TABLE `license_category` 
ADD COLUMN `license_category_consolidated_id` INT NULL DEFAULT NULL AFTER `license_map_su01`;

CREATE TABLE IF NOT EXISTS `license_category_consolidated` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `category` VARCHAR(120) NULL,
  `cost` INT NULL DEFAULT NULL,
  `dash_incl` TINYINT NULL DEFAULT '0',
  `dash_abbr` VARCHAR(12) NULL DEFAULT NULL,
PRIMARY KEY (`id`));

ALTER TABLE `license_category_consolidated` 
ADD COLUMN `quantity` INT NULL AFTER `dash_abbr`,
ADD COLUMN `license_type` INT NULL AFTER `quantity`;

CREATE TABLE IF NOT EXISTS `license_type` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `type` VARCHAR(45) NULL,
  PRIMARY KEY (`id`));
  
INSERT INTO license_type (type)
VALUES ('User license'), ('Engine measurement'), ('Self-declaration product'), ('Other');