-- -------------------------------------------
-- Create table to store auth. objects not
-- to show in SU53 for certain projects.
-- -------------------------------------------

CREATE TABLE IF NOT EXISTS `apm_proj_obj_no_su53` (
  `project` VARCHAR(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `object_id` INT(11) NOT NULL,
  PRIMARY KEY (`project`, `object_id`),
  INDEX `index_apm_proj_obj_no_su53_object` (`object_id` ASC),
  CONSTRAINT `fk_apm_proj_obj_no_su53_project`
    FOREIGN KEY (`project`)
    REFERENCES `cehior_auth_proj_header` (`proj_name`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_apm_proj_obj_no_su53_object_id`
    FOREIGN KEY (`object_id`)
    REFERENCES `sod_auth_object` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
COMMENT = 'Objects not to show in SU53 for project';

INSERT INTO cehior_auth_lang (textid, lang, text) VALUES 
  (517, 'EN', 'Auth. objects to hide in SU53'),
  (517, 'DA', 'Aut. objekter som gemmes i SU53'),
  (517, 'DE', 'Ber. Objekte in SU53 zu verbergen');
