--------------------------------------------------
-- New table for SU24 follow-up tasks
-- Created 20100706
--------------------------------------------------

CREATE TABLE IF NOT EXISTS `su24_follow_up` (
  `id` bigint(20) NOT NULL auto_increment,
  `task_id` bigint(20) NOT NULL,
  `role` varchar(30) NOT NULL,
  `executed` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `task_role` (`task_id`,`role`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;

CREATE TABLE IF NOT EXISTS `issue_subtask` (
  `issue_event_id` bigint(20) NOT NULL,
  `task_id` bigint(20) NOT NULL,
  `subtask_id` bigint(20) NOT NULL,
  PRIMARY KEY  (`issue_event_id`),
  KEY `task_sub` (`task_id`, `subtask_id`),
  CONSTRAINT `issue_subtask_ibfk_2` FOREIGN KEY (`task_id`) REFERENCES `cehior_auth_header_task` (`taeller`),
  CONSTRAINT `issue_subtask_ibfk_1` FOREIGN KEY (`issue_event_id`) REFERENCES `issue_event` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `cehior_auth_lang` VALUES
(489, 'EN', 'Execute subtask'), 
(489, 'DA', 'Udfør subtask'),
(489, 'DE', 'Teilaufgabe ausführen'), 
(489, 'SL', 'Izvršiti podopravila'),
(490, 'EN', 'Display subtasks'), 
(490, 'DA', 'Vis subtasks'), 
(490, 'DE', 'Teilaufgaben Zeigen'), 
(490, 'SL', 'Prikaži podopravila'),
(491, 'EN', 'SU24 Subtasks'), 
(491, 'DA', 'SU24 subtasks'), 
(491, 'DE', 'SU24 Teilaufgaben'), 
(491, 'SL', 'SU24 podopravila'),
(492, 'EN', 'Affected roles'), 
(492, 'DA', 'Påvirkede roller'), 
(492, 'DE', 'Betroffene Rollen'), 
(492, 'SL', 'Prizadeti vlog'),
(493, 'EN', 'Has been executed'), 
(493, 'DA', 'Er udført'), 
(493, 'DE', 'Ausgeführt '), 
(493, 'SL', 'Izvršena'),
(494, 'EN', 'Not executed'), 
(494, 'DA', 'Ikke udført'), 
(494, 'DE', 'Nicht ausgeführt'), 
(494, 'SL', 'Ne izvrši'),
(495, 'EN', 'Task not executed'), 
(495, 'DA', 'Task ikke udført'), 
(495, 'DE', 'Aufgabe nicht ausgeführt'), 
(495, 'SL', 'Naloga ni bil izvršen'),
(496, 'EN', 'Task closed'), 
(496, 'DA', 'Task lukket'), 
(496, 'DE', 'Aufgabe geschlossen'), 
(496, 'SL', 'Naloga se je zaključila'),
(497, 'EN', 'Add object to tcode'), 
(497, 'DA', 'Tilføj objekt til tcode'), 
(497, 'DE', 'Hinzufügen Objekts zu tcode'), 
(497, 'SL', 'Dodaj nasprotuje tcode'),
(498, 'EN', 'Change check indicator'), 
(498, 'DA', 'Ændr check indikator'), 
(498, 'DE', 'Veränderung Check Indikator'), 
(498, 'SL', 'Spremeni preverite indikator'),
(499, 'EN', 'Add values'), 
(499, 'DA', 'Tilføj værdier'), 
(499, 'DE', 'Hinzufügen Werte'), 
(499, 'SL', 'Dodaj vrednot');
