--------------------------------------------------
-- DB Schema Baseline
-- Based on version 2.3 (including patch_1)
-- Created 20090908, TNS
--------------------------------------------------


--
-- Table structure for table `cehior_auth_1251`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_1251` (
  `Taeller` bigint(20) NOT NULL auto_increment,
  `system` varchar(6) NOT NULL,
  `client` varchar(4) NOT NULL,
  `agr_name` varchar(30) NOT NULL,
  `counter` smallint(6) NOT NULL default '0',
  `object` varchar(12) NOT NULL,
  `auth` varchar(12) NOT NULL,
  `variant` varchar(4) NOT NULL,
  `field` varchar(10) NOT NULL,
  `low` varchar(40) NOT NULL,
  `high` varchar(40) NOT NULL,
  `modified` char(1) NOT NULL,
  `deleted` char(1) NOT NULL,
  `copied` char(1) NOT NULL,
  `neu` char(1) NOT NULL,
  `node` int(11) NOT NULL default '0',
  PRIMARY KEY  (`Taeller`),
  KEY `system` (`system`),
  KEY `client` (`client`),
  KEY `agr_name` (`agr_name`),
  KEY `counter` (`counter`),
  KEY `object` (`object`),
  KEY `auth` (`auth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='AGR_1251';

--
-- Table structure for table `cehior_auth_1252`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_1252` (
  `Taeller` bigint(20) NOT NULL auto_increment,
  `unikid` varchar(32) NOT NULL,
  `proj_name` varchar(20) NOT NULL,
  `system` varchar(6) NOT NULL,
  `client` varchar(4) NOT NULL,
  `agr_name` varchar(30) NOT NULL,
  `counter` smallint(6) NOT NULL default '0',
  `varbl` varchar(40) NOT NULL,
  `low` varchar(40) NOT NULL,
  `high` varchar(40) NOT NULL,
  PRIMARY KEY  (`Taeller`),
  KEY `unikid` (`unikid`),
  KEY `system` (`system`),
  KEY `client` (`client`),
  KEY `agr_name` (`agr_name`),
  KEY `counter` (`counter`),
  KEY `object` (`varbl`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='AGR_1251';

--
-- Table structure for table `cehior_auth_1252_data`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_1252_data` (
  `Taeller` bigint(20) NOT NULL auto_increment,
  `unikid` varchar(32) NOT NULL,
  `proj_name` varchar(20) NOT NULL,
  `system` varchar(6) NOT NULL,
  `client` varchar(4) NOT NULL,
  `agr_name` varchar(30) NOT NULL,
  `counter` varchar(6) NOT NULL default '0',
  `varbl` varchar(40) NOT NULL,
  `low` varchar(40) NOT NULL,
  `high` varchar(40) NOT NULL,
  PRIMARY KEY  (`Taeller`),
  KEY `unikid` (`unikid`),
  KEY `system` (`system`),
  KEY `client` (`client`),
  KEY `agr_name` (`agr_name`),
  KEY `counter` (`counter`),
  KEY `object` (`varbl`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='AGR_1251';

--
-- Table structure for table `cehior_auth_agr_hier`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_agr_hier` (
  `unikid` int(11) NOT NULL auto_increment,
  `client` char(3) NOT NULL,
  `agr_name` varchar(40) NOT NULL,
  `object_id` varchar(8) NOT NULL,
  `parent_id` varchar(8) NOT NULL,
  `folder` char(1) NOT NULL,
  `sort_order` varchar(8) NOT NULL,
  `reporttype` char(2) NOT NULL,
  `report` varchar(48) NOT NULL,
  `menu_level` char(2) NOT NULL,
  `sap_guid` varchar(32) NOT NULL,
  `attributes` varchar(10) NOT NULL,
  `target_sys` varchar(32) NOT NULL,
  `x_pos` int(11) NOT NULL default '0',
  `y_pos` int(11) NOT NULL default '0',
  `book_info` varchar(12) NOT NULL,
  `source_agr` varchar(40) NOT NULL,
  UNIQUE KEY `unikid` (`unikid`),
  KEY `agr_name` (`agr_name`),
  KEY `report` (`report`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth agr_user';

--
-- Table structure for table `cehior_auth_agr_hiert`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_agr_hiert` (
  `unikid` int(11) NOT NULL auto_increment,
  `client` char(3) NOT NULL,
  `agr_name` varchar(40) NOT NULL,
  `spras` char(1) NOT NULL,
  `object_id` varchar(8) NOT NULL,
  `text` varchar(80) NOT NULL,
  UNIQUE KEY `unikid` (`unikid`),
  KEY `agr_name` (`agr_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth agr_user';

--
-- Table structure for table `cehior_auth_agr_tcodes`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_agr_tcodes` (
  `moder` varchar(40) NOT NULL,
  `agr_name` varchar(30) NOT NULL,
  `type` char(2) NOT NULL,
  `tcode` varchar(48) NOT NULL,
  `dato` date NOT NULL default '0000-00-00',
  `entydig` bigint(20) NOT NULL default '0',
  `flertydig` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`agr_name`,`type`,`tcode`),
  KEY `moder` (`moder`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_agr_texts`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_agr_texts` (
  `unikid` int(11) NOT NULL auto_increment,
  `client` char(3) NOT NULL,
  `agr_name` varchar(40) NOT NULL,
  `spras` char(1) NOT NULL,
  `line` varchar(8) NOT NULL,
  `text` varchar(80) NOT NULL,
  UNIQUE KEY `unikid` (`unikid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth agr_user';

--
-- Table structure for table `cehior_auth_agr_user`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_agr_user` (
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `projekt` varchar(10) NOT NULL,
  `rolle` varchar(40) NOT NULL,
  `bruger` varchar(12) NOT NULL,
  `kollekt` char(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth agr_user';

--
-- Table structure for table `cehior_auth_agr_user_r3`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_agr_user_r3` (
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `rolle` varchar(40) NOT NULL,
  `bruger` varchar(12) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth agr_user';

--
-- Table structure for table `cehior_auth_analyse_1251`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_analyse_1251` (
  `Taeller` bigint(20) NOT NULL auto_increment,
  `unikid` varchar(32) NOT NULL,
  `system` varchar(6) NOT NULL,
  `client` varchar(4) NOT NULL,
  `agr_name` varchar(30) NOT NULL,
  `counter` int(6) NOT NULL default '0',
  `object` varchar(10) NOT NULL,
  `auth` varchar(12) NOT NULL,
  `variant` varchar(4) NOT NULL,
  `field` varchar(10) NOT NULL,
  `low` varchar(40) NOT NULL,
  `high` varchar(40) NOT NULL,
  `modified` char(1) NOT NULL,
  `deleted` char(1) NOT NULL,
  `copied` char(1) NOT NULL,
  `neu` char(1) NOT NULL,
  `node` int(6) NOT NULL default '0',
  PRIMARY KEY  (`Taeller`),
  KEY `unikid` (`unikid`),
  KEY `system` (`system`),
  KEY `client` (`client`),
  KEY `agr_name` (`agr_name`),
  KEY `counter` (`counter`),
  KEY `object` (`object`),
  KEY `auth` (`auth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='AGR_1251';

--
-- Table structure for table `cehior_auth_analyse_1252`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_analyse_1252` (
  `Taeller` bigint(20) NOT NULL auto_increment,
  `unikid` varchar(32) NOT NULL,
  `system` varchar(6) NOT NULL,
  `client` varchar(4) NOT NULL,
  `agr_name` varchar(30) NOT NULL,
  `counter` smallint(6) NOT NULL default '0',
  `varbl` varchar(40) NOT NULL,
  `low` varchar(40) NOT NULL,
  `high` varchar(40) NOT NULL,
  PRIMARY KEY  (`Taeller`),
  KEY `unikid` (`unikid`),
  KEY `system` (`system`),
  KEY `client` (`client`),
  KEY `agr_name` (`agr_name`),
  KEY `counter` (`counter`),
  KEY `object` (`varbl`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='AGR_1251';

--
-- Table structure for table `cehior_auth_analyse_level_0`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_analyse_level_0` (
  `taeller` bigint(20) NOT NULL auto_increment,
  `unikid` varchar(32) NOT NULL,
  `system` varchar(6) NOT NULL,
  `client` varchar(5) NOT NULL,
  `tcode` varchar(20) NOT NULL,
  `moder` varchar(30) NOT NULL,
  `datter` varchar(30) NOT NULL,
  `object` varchar(10) NOT NULL,
  `no_object` char(3) NOT NULL,
  `found` char(1) NOT NULL,
  `org_level` char(1) NOT NULL,
  `org_varbl` varchar(40) NOT NULL,
  `datter_text` varchar(80) default NULL,
  `tcode_flag` char(1) default NULL,
  PRIMARY KEY  (`taeller`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 PACK_KEYS=0 COMMENT='Auth level 0 analyse tabel R/3';

--
-- Table structure for table `cehior_auth_bw_agr_1251`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_bw_agr_1251` (
  `system` varchar(6) NOT NULL,
  `client` varchar(4) NOT NULL,
  `agr_name` varchar(30) NOT NULL,
  `counter` smallint(6) NOT NULL default '0',
  `object` varchar(12) NOT NULL,
  `auth` varchar(12) NOT NULL,
  `variant` varchar(4) NOT NULL,
  `field` varchar(10) NOT NULL,
  `low` varchar(40) NOT NULL,
  `high` varchar(40) NOT NULL,
  `modified` char(1) NOT NULL,
  `deleted` char(1) NOT NULL,
  `copied` char(1) NOT NULL,
  `neu` char(1) NOT NULL,
  `node` int(11) NOT NULL default '0',
  PRIMARY KEY  (`system`,`client`,`agr_name`,`counter`),
  KEY `client` (`client`,`agr_name`,`counter`),
  KEY `object` (`object`,`low`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='AGR_1251';

--
-- Table structure for table `cehior_auth_bw_cube_def`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_bw_cube_def` (
  `system` varchar(6) NOT NULL,
  `client` varchar(4) NOT NULL,
  `kube` varchar(30) NOT NULL,
  `infoarea` varchar(30) NOT NULL,
  `status` char(3) NOT NULL,
  `creat_date` date NOT NULL default '0000-00-00',
  `chg_date` date NOT NULL default '0000-00-00',
  `gruppe` varchar(20) NOT NULL,
  `ovner` varchar(20) NOT NULL,
  `kubeinfotext` mediumtext NOT NULL,
  PRIMARY KEY  (`system`,`client`,`kube`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='BW Kube definition header';

--
-- Table structure for table `cehior_auth_bw_kube_infoobj`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_bw_kube_infoobj` (
  `taeller` int(11) NOT NULL auto_increment,
  `system` varchar(6) NOT NULL,
  `client` varchar(4) NOT NULL,
  `kube` varchar(12) NOT NULL,
  `infoobj` varchar(30) NOT NULL,
  `authrelevant` char(3) NOT NULL,
  PRIMARY KEY  (`taeller`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_bw_kube_text`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_bw_kube_text` (
  `taeller` int(11) NOT NULL auto_increment,
  `system` varchar(6) NOT NULL,
  `client` varchar(4) NOT NULL,
  `kube` varchar(12) NOT NULL,
  `kort_text` varchar(20) NOT NULL,
  `lang_text` varchar(60) NOT NULL,
  PRIMARY KEY  (`taeller`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_bw_multicube`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_bw_multicube` (
  `taeller` int(11) NOT NULL auto_increment,
  `system` varchar(6) NOT NULL,
  `client` varchar(4) NOT NULL,
  `mult_kube` varchar(12) NOT NULL,
  `kube` varchar(12) NOT NULL,
  PRIMARY KEY  (`taeller`),
  KEY `mult_kube` (`mult_kube`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_bw_rsdcubet`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_bw_rsdcubet` (
  `system` varchar(6) NOT NULL,
  `client` varchar(4) NOT NULL,
  `infocube` varchar(30) NOT NULL,
  `txtsh` varchar(20) NOT NULL,
  `txtlg` varchar(30) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='RSDCUBET';

--
-- Table structure for table `cehior_auth_bw_rsstobjdir`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_bw_rsstobjdir` (
  `system` varchar(6) NOT NULL,
  `client` varchar(5) NOT NULL,
  `infocube` varchar(30) NOT NULL,
  `objct` varchar(30) NOT NULL,
  `akt` char(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='RSSTOBJDIR';

--
-- Table structure for table `cehior_auth_bw_rsstobjdir_task`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_bw_rsstobjdir_task` (
  `unik` varchar(32) NOT NULL,
  `system` varchar(6) NOT NULL,
  `client` varchar(5) NOT NULL,
  `infocube` varchar(30) NOT NULL,
  `objct` varchar(30) NOT NULL,
  `akt` char(1) NOT NULL,
  `operation` varchar(20) NOT NULL,
  `create_date` date NOT NULL default '0000-00-00',
  `create_time` time NOT NULL default '00:00:00',
  `create_user` varchar(12) NOT NULL,
  `finish_date` date NOT NULL default '0000-00-00',
  `finish_time` time NOT NULL default '00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='RSSTOBJDIR';

--
-- Table structure for table `cehior_auth_bw_zbwstatprod`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_bw_zbwstatprod` (
  `system` varchar(6) NOT NULL,
  `client` varchar(4) NOT NULL,
  `kube` varchar(30) NOT NULL,
  `bruger` varchar(12) NOT NULL,
  `dato` date NOT NULL default '0000-00-00',
  `rapport` varchar(30) NOT NULL,
  `rapport_text` varchar(32) NOT NULL,
  `kube_text` varchar(20) NOT NULL,
  `hits` int(11) NOT NULL default '0',
  KEY `system` (`system`),
  KEY `client` (`client`),
  KEY `kube` (`kube`),
  KEY `kube_2` (`kube`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_bw_zbwstatprod_total`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_bw_zbwstatprod_total` (
  `system` varchar(6) NOT NULL,
  `client` varchar(4) NOT NULL,
  `kube` varchar(30) NOT NULL,
  `dato` date NOT NULL default '0000-00-00',
  `hits` int(11) NOT NULL default '0',
  KEY `system` (`system`),
  KEY `client` (`client`),
  KEY `kube` (`kube`),
  KEY `kube_2` (`kube`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_container`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_container` (
  `unikid` varchar(32) NOT NULL,
  `role` varchar(30) NOT NULL,
  `object` varchar(10) NOT NULL,
  `auth` varchar(12) NOT NULL,
  `felt` varchar(10) NOT NULL default '0',
  `vaerdi` varchar(40) NOT NULL default '0',
  KEY `unikid` (`unikid`),
  KEY `role` (`role`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_datter_moder`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_datter_moder` (
  `datter` varchar(40) NOT NULL,
  `moder` varchar(40) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth moder datter tcode hits ';

--
-- Table structure for table `cehior_auth_delta_tcode`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_delta_tcode` (
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `dato` date NOT NULL default '0000-00-00',
  `tcode` varchar(40) NOT NULL,
  UNIQUE KEY `tcode_2` (`tcode`),
  KEY `dato` (`dato`),
  KEY `tcode` (`tcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='TEST HTTP';

--
-- Table structure for table `cehior_auth_gatl_support`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_gatl_support` (
  `unikid` varchar(32) NOT NULL,
  `user` varchar(12) NOT NULL,
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `open` varchar(1) NOT NULL,
  `open_date` date default NULL,
  `open_time` time default NULL,
  `closed` char(1) default NULL,
  `close_date` date default NULL,
  `close_time` time default NULL,
  `active` char(1) NOT NULL default '0',
  `active_date` date default NULL,
  `active_time` time default NULL,
  PRIMARY KEY  (`unikid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_header`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_header` (
  `unikid` varchar(32) NOT NULL,
  `serial_no` int(10) unsigned NOT NULL auto_increment,
  `class` varchar(12) default NULL,
  `user` varchar(12) NOT NULL,
  `titel` varchar(30) NOT NULL,
  `fornavn` varchar(40) NOT NULL,
  `efternavn` varchar(40) NOT NULL,
  `dato` varchar(100) NOT NULL,
  `tid` varchar(100) NOT NULL,
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `status` varchar(10) NOT NULL,
  `container` char(1) NOT NULL,
  `testcase` varchar(20) default NULL,
  `testcasestep` varchar(6) default NULL,
  `trin` char(3) NOT NULL default '0',
  `responsible` varchar(20) default NULL,
  `extissueno` varchar(32) default NULL,
  PRIMARY KEY  (`serial_no`),
  UNIQUE KEY `unikid` (`unikid`),
  KEY `dato` (`dato`,`tid`),
  KEY `proj_stat` (`user`,`system`,`client`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_header_system`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_header_system` (
  `task` varchar(10) NOT NULL,
  `source_system` varchar(8) NOT NULL,
  `source_client` char(3) NOT NULL,
  `target_system` varchar(8) NOT NULL,
  `target_client` char(3) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_header_task`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_header_task` (
  `taeller` bigint(20) NOT NULL auto_increment,
  `unikid` varchar(32) NOT NULL,
  `create_user` varchar(12) NOT NULL default '',
  `create_date` date NOT NULL default '0000-00-00',
  `create_time` time NOT NULL default '00:00:00',
  `finish_date` date NOT NULL default '0000-00-00',
  `finish_time` time NOT NULL default '00:00:00',
  `finish_user` varchar(12) NOT NULL default '',
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `task` varchar(10) NOT NULL,
  `task_owner` varchar(12) NOT NULL default '',
  `task_approver` varchar(12) NOT NULL default '',
  `status` varchar(10) NOT NULL default '',
  `trin` char(3) NOT NULL default '0',
  `issuenum` int(11) default '0',
  PRIMARY KEY  (`taeller`),
  KEY `unikid` (`unikid`),
  KEY `system` (`system`,`client`),
  KEY `issuenum` (`issuenum`),
  KEY `create_date` (`create_date`,`create_time`),
  KEY `finish_date` (`finish_date`,`finish_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_info_text`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_info_text` (
  `langu` varchar(100) NOT NULL,
  `cust` varchar(5) NOT NULL,
  `line` int(11) NOT NULL default '0',
  `text` varchar(120) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_lang`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_lang` (
  `unikid` int(11) NOT NULL auto_increment,
  `textid` int(11) NOT NULL,
  `lang` varchar(32) default 'EN',
  `text` text,
  `type` varchar(1024) default NULL,
  `comment` text,
  `file` varchar(1024) default NULL,
  `screen` varchar(1024) default NULL,
  PRIMARY KEY  (`unikid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_moder_datter_tcode`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_moder_datter_tcode` (
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `projekt` varchar(10) NOT NULL,
  `moder` varchar(40) NOT NULL,
  `datter` varchar(40) NOT NULL,
  `tcode` varchar(40) NOT NULL,
  `hits` bigint(20) NOT NULL default '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth moder datter tcode hits ';

--
-- Table structure for table `cehior_auth_moder_datter_tcode_test`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_moder_datter_tcode_test` (
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `projekt` varchar(10) NOT NULL,
  `moder` varchar(40) NOT NULL,
  `datter` varchar(40) NOT NULL,
  `tcode` varchar(40) NOT NULL,
  `hits` bigint(20) NOT NULL default '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth moder datter tcode hits ';

--
-- Table structure for table `cehior_auth_obj_gatling`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_obj_gatling` (
  `unikid` varchar(32) NOT NULL,
  `counter` bigint(20) NOT NULL,
  `object` varchar(10) NOT NULL,
  `felt` varchar(10) NOT NULL,
  `value` varchar(40) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_obj_value`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_obj_value` (
  `unikid` varchar(32) NOT NULL,
  `class` varchar(4) default NULL COMMENT 'Auth. object class',
  `object` varchar(10) NOT NULL,
  `felt` varchar(10) NOT NULL,
  `value` varchar(40) NOT NULL,
  PRIMARY KEY  (`unikid`,`object`,`felt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_org_details`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_org_details` (
  `role` varchar(40) NOT NULL,
  `user` varchar(12) NOT NULL,
  `name` varchar(50) NOT NULL,
  `usr_grp` varchar(12) NOT NULL,
  `dprtmnt1` varchar(25) NOT NULL,
  `dprtmnt2` varchar(25) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_orgx_1251`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_orgx_1251` (
  `Taeller` bigint(20) NOT NULL auto_increment,
  `system` varchar(6) NOT NULL,
  `client` varchar(4) NOT NULL,
  `agr_name` varchar(30) NOT NULL,
  `counter` smallint(6) NOT NULL default '0',
  `object` varchar(12) NOT NULL,
  `auth` varchar(12) NOT NULL,
  `variant` varchar(4) NOT NULL,
  `field` varchar(10) NOT NULL,
  `low` varchar(40) NOT NULL,
  `high` varchar(40) NOT NULL,
  `modified` char(1) NOT NULL,
  `deleted` char(1) NOT NULL,
  `copied` char(1) NOT NULL,
  `neu` char(1) NOT NULL,
  `node` int(11) NOT NULL default '0',
  PRIMARY KEY  (`Taeller`),
  KEY `system` (`system`),
  KEY `client` (`client`),
  KEY `agr_name` (`agr_name`),
  KEY `counter` (`counter`),
  KEY `object` (`object`),
  KEY `auth` (`auth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='AGR_1251';

--
-- Table structure for table `cehior_auth_original_tcode`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_original_tcode` (
  `taeller` int(11) NOT NULL auto_increment,
  `tcode1` varchar(48) NOT NULL,
  `tcode2` varchar(48) NOT NULL,
  PRIMARY KEY  (`taeller`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_proj_1251`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_proj_1251` (
  `Taeller` bigint(20) NOT NULL auto_increment,
  `unikid` varchar(32) NOT NULL default '',
  `proj_name` varchar(20) NOT NULL,
  `system` varchar(6) NOT NULL,
  `client` varchar(4) NOT NULL,
  `agr_name` varchar(30) NOT NULL,
  `counter` varchar(6) NOT NULL default '0',
  `object` varchar(12) NOT NULL,
  `auth` varchar(12) NOT NULL,
  `variant` varchar(4) NOT NULL,
  `field` varchar(10) NOT NULL,
  `low` varchar(40) NOT NULL,
  `high` varchar(40) NOT NULL,
  `modified` char(1) NOT NULL,
  `deleted` char(1) NOT NULL,
  `copied` char(1) NOT NULL,
  `neu` char(1) NOT NULL,
  `node` int(11) NOT NULL default '0',
  PRIMARY KEY  (`Taeller`),
  KEY `unikid` (`unikid`),
  KEY `system` (`system`),
  KEY `client` (`client`),
  KEY `agr_name` (`agr_name`),
  KEY `counter` (`counter`),
  KEY `object` (`object`),
  KEY `auth` (`auth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='AGR_1251';

--
-- Table structure for table `cehior_auth_proj_1252`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_proj_1252` (
  `Taeller` bigint(20) NOT NULL auto_increment,
  `unikid` varchar(32) NOT NULL,
  `proj_name` varchar(20) NOT NULL,
  `system` varchar(6) NOT NULL,
  `client` varchar(4) NOT NULL,
  `agr_name` varchar(30) NOT NULL,
  `counter` smallint(6) NOT NULL default '0',
  `varbl` varchar(40) NOT NULL,
  `low` varchar(40) NOT NULL,
  `high` varchar(40) NOT NULL,
  PRIMARY KEY  (`Taeller`),
  KEY `unikid` (`unikid`),
  KEY `system` (`system`),
  KEY `client` (`client`),
  KEY `agr_name` (`agr_name`),
  KEY `counter` (`counter`),
  KEY `object` (`varbl`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='AGR_1251';

--
-- Table structure for table `cehior_auth_proj_header`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_proj_header` (
  `proj_name` varchar(20) NOT NULL,
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `auth_group` varchar(12) NOT NULL default '' COMMENT 'Authorization group',
  `create_date` date NOT NULL default '0000-00-00',
  `start_date` date NOT NULL default '0000-00-00',
  `end_date` date NOT NULL default '0000-00-00',
  `create_user` varchar(12) NOT NULL,
  `task` varchar(30) NOT NULL,
  `text` longtext NOT NULL,
  `status` int(11) NOT NULL default '0',
  `new_roles` tinyint(1) NOT NULL default '0' COMMENT 'True (1) when new roles have been added',
  PRIMARY KEY  (`proj_name`),
  KEY `proj_name` (`proj_name`),
  KEY `system` (`system`),
  KEY `client` (`client`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_proj_menu`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_proj_menu` (
  `taeller` bigint(20) NOT NULL auto_increment,
  `unikid` varchar(59) NOT NULL,
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `proj_name` varchar(20) NOT NULL,
  `proj_rolle` varchar(40) NOT NULL,
  `new_role` varchar(40) NOT NULL,
  `agr_name` varchar(40) NOT NULL,
  `object_id` varchar(8) NOT NULL,
  `parent_id` varchar(8) NOT NULL,
  `folder` char(1) NOT NULL,
  `sort_order` varchar(8) NOT NULL,
  `reporttype` char(2) NOT NULL,
  `report` varchar(48) NOT NULL,
  `menu_level` char(2) NOT NULL,
  `sap_guid` varchar(32) NOT NULL,
  `attributes` varchar(10) NOT NULL,
  `target_sys` varchar(32) NOT NULL,
  `x_pos` int(11) NOT NULL default '0',
  `y_pos` int(11) NOT NULL default '0',
  `book_info` varchar(12) NOT NULL,
  `source_agr` varchar(40) NOT NULL,
  PRIMARY KEY  (`taeller`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth agr_user';

--
-- Table structure for table `cehior_auth_proj_menu_source`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_proj_menu_source` (
  `taeller` bigint(20) NOT NULL auto_increment,
  `unikid` varchar(59) NOT NULL,
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `proj_name` varchar(20) NOT NULL,
  `proj_rolle` varchar(40) NOT NULL,
  `new_role` varchar(40) NOT NULL,
  `agr_name` varchar(40) NOT NULL,
  `object_id` varchar(8) NOT NULL,
  `parent_id` varchar(8) NOT NULL,
  `folder` char(1) NOT NULL,
  `sort_order` varchar(8) NOT NULL,
  `reporttype` char(2) NOT NULL,
  `report` varchar(48) NOT NULL,
  `menu_level` char(2) NOT NULL,
  `sap_guid` varchar(32) NOT NULL,
  `attributes` varchar(10) NOT NULL,
  `target_sys` varchar(32) NOT NULL,
  `x_pos` int(11) NOT NULL default '0',
  `y_pos` int(11) NOT NULL default '0',
  `book_info` varchar(12) NOT NULL,
  `source_agr` varchar(40) NOT NULL,
  `sod` char(1) NOT NULL,
  `comp_level` char(2) NOT NULL,
  PRIMARY KEY  (`taeller`),
  KEY `unikid` (`unikid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth agr_user';

--
-- Table structure for table `cehior_auth_proj_menu_source_kopi`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_proj_menu_source_kopi` (
  `taeller` bigint(20) NOT NULL auto_increment,
  `unikid` varchar(59) NOT NULL,
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `proj_name` varchar(20) NOT NULL,
  `proj_rolle` varchar(40) NOT NULL,
  `new_role` varchar(40) NOT NULL,
  `agr_name` varchar(40) NOT NULL,
  `object_id` varchar(8) NOT NULL,
  `parent_id` varchar(8) NOT NULL,
  `folder` char(1) NOT NULL,
  `sort_order` varchar(8) NOT NULL,
  `reporttype` char(2) NOT NULL,
  `report` varchar(48) NOT NULL,
  `menu_level` char(2) NOT NULL,
  `sap_guid` varchar(32) NOT NULL,
  `attributes` varchar(10) NOT NULL,
  `target_sys` varchar(32) NOT NULL,
  `x_pos` int(11) NOT NULL default '0',
  `y_pos` int(11) NOT NULL default '0',
  `book_info` varchar(12) NOT NULL,
  `source_agr` varchar(40) NOT NULL,
  `sod` char(1) NOT NULL,
  PRIMARY KEY  (`taeller`),
  KEY `unikid` (`unikid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth agr_user';

--
-- Table structure for table `cehior_auth_proj_menu_target`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_proj_menu_target` (
  `taeller` bigint(20) NOT NULL auto_increment,
  `unikid` varchar(59) NOT NULL,
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `proj_name` varchar(20) NOT NULL,
  `proj_rolle` varchar(40) NOT NULL,
  `new_role` varchar(40) NOT NULL,
  `agr_name` varchar(40) NOT NULL,
  `object_id` varchar(8) NOT NULL,
  `parent_id` varchar(8) NOT NULL,
  `folder` char(1) NOT NULL,
  `sort_order` varchar(8) NOT NULL,
  `reporttype` char(2) NOT NULL,
  `report` varchar(48) NOT NULL,
  `menu_level` char(2) NOT NULL,
  `sap_guid` varchar(32) NOT NULL,
  `attributes` varchar(10) NOT NULL,
  `target_sys` varchar(32) NOT NULL,
  `x_pos` int(11) NOT NULL default '0',
  `y_pos` int(11) NOT NULL default '0',
  `book_info` varchar(12) NOT NULL,
  `source_agr` varchar(40) NOT NULL,
  `sod` char(1) NOT NULL,
  `comp_level` char(2) NOT NULL,
  PRIMARY KEY  (`taeller`),
  KEY `agr_name` (`agr_name`),
  KEY `report` (`report`),
  KEY `system` (`system`),
  KEY `client` (`client`),
  KEY `proj_name` (`proj_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth agr_user';

--
-- Table structure for table `cehior_auth_proj_menu_target_kopi`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_proj_menu_target_kopi` (
  `taeller` bigint(20) NOT NULL auto_increment,
  `unikid` varchar(59) NOT NULL,
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `proj_name` varchar(20) NOT NULL,
  `proj_rolle` varchar(40) NOT NULL,
  `new_role` varchar(40) NOT NULL,
  `agr_name` varchar(40) NOT NULL,
  `object_id` varchar(8) NOT NULL,
  `parent_id` varchar(8) NOT NULL,
  `folder` char(1) NOT NULL,
  `sort_order` varchar(8) NOT NULL,
  `reporttype` char(2) NOT NULL,
  `report` varchar(48) NOT NULL,
  `menu_level` char(2) NOT NULL,
  `sap_guid` varchar(32) NOT NULL,
  `attributes` varchar(10) NOT NULL,
  `target_sys` varchar(32) NOT NULL,
  `x_pos` int(11) NOT NULL default '0',
  `y_pos` int(11) NOT NULL default '0',
  `book_info` varchar(12) NOT NULL,
  `source_agr` varchar(40) NOT NULL,
  `sod` char(1) NOT NULL,
  PRIMARY KEY  (`taeller`),
  KEY `agr_name` (`agr_name`),
  KEY `report` (`report`),
  KEY `system` (`system`),
  KEY `client` (`client`),
  KEY `proj_name` (`proj_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth agr_user';

--
-- Table structure for table `cehior_auth_proj_menu_text`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_proj_menu_text` (
  `unikid` varchar(140) NOT NULL,
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `proj_rolle` varchar(40) NOT NULL,
  `new_role` varchar(40) NOT NULL,
  `agr_name` varchar(40) NOT NULL,
  `spras` char(1) NOT NULL,
  `object_id` varchar(8) NOT NULL,
  `text` varchar(80) NOT NULL,
  PRIMARY KEY  (`unikid`),
  KEY `system` (`system`),
  KEY `client` (`client`),
  KEY `agr_name` (`agr_name`),
  KEY `system_2` (`system`,`client`,`agr_name`),
  KEY `system_3` (`system`,`client`,`agr_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth agr_user';

--
-- Table structure for table `cehior_auth_proj_roller`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_proj_roller` (
  `taeller` bigint(20) NOT NULL auto_increment,
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `proj_name` varchar(20) NOT NULL,
  `rolle` varchar(40) NOT NULL,
  `role_desc` varchar(80) default NULL,
  `select_date` date NOT NULL default '0000-00-00',
  `select_time` time NOT NULL default '00:00:00',
  `original_rolle` varchar(40) NOT NULL default '',
  `new_role` varchar(40) NOT NULL default '',
  `org_level` varchar(50) NOT NULL default '',
  `agr_name_lock` char(1) NOT NULL default '',
  `date_import` date NOT NULL default '0000-00-00',
  `time_import` time NOT NULL default '00:00:00',
  `date_r3_create` date NOT NULL default '0000-00-00',
  `time_r3_create` time NOT NULL default '00:00:00',
  `comp_level` char(2) NOT NULL default '',
  PRIMARY KEY  (`taeller`),
  KEY `proj_name` (`proj_name`,`rolle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth agr_user';

--
-- Table structure for table `cehior_auth_proj_roller_comp`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_proj_roller_comp` (
  `taeller` bigint(20) NOT NULL auto_increment,
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `proj_name` varchar(20) NOT NULL,
  `original_rolle` varchar(40) NOT NULL,
  `new_role` varchar(40) NOT NULL,
  `comp_role` varchar(40) NOT NULL,
  `date_r3_create` date NOT NULL default '0000-00-00',
  `time_r3_create` time NOT NULL default '00:00:00',
  PRIMARY KEY  (`taeller`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth agr_user';

--
-- Table structure for table `cehior_auth_proj_roller_kopi`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_proj_roller_kopi` (
  `taeller` bigint(20) NOT NULL auto_increment,
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `proj_name` varchar(20) NOT NULL,
  `rolle` varchar(40) NOT NULL,
  `select_date` date NOT NULL default '0000-00-00',
  `select_time` time NOT NULL default '00:00:00',
  `original_rolle` varchar(40) NOT NULL,
  `new_role` varchar(40) NOT NULL,
  `org_level` varchar(50) NOT NULL,
  `agr_name_lock` char(1) NOT NULL,
  `date_import` date NOT NULL default '0000-00-00',
  `time_import` time NOT NULL default '00:00:00',
  `date_r3_create` date NOT NULL default '0000-00-00',
  `time_r3_create` time NOT NULL default '00:00:00',
  PRIMARY KEY  (`taeller`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth agr_user';

--
-- Table structure for table `cehior_auth_proj_roller_tcode`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_proj_roller_tcode` (
  `taeller` bigint(20) NOT NULL auto_increment,
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `proj_name` varchar(20) NOT NULL,
  `rolle` varchar(40) NOT NULL,
  `select_date` date NOT NULL default '0000-00-00',
  `select_time` time NOT NULL default '00:00:00',
  `tcode` varchar(40) NOT NULL,
  `tcode_text` varchar(36) default NULL,
  `test` varchar(1) default NULL,
  `neg_test` varchar(1) default NULL,
  `sign_off` varchar(1) default NULL,
  PRIMARY KEY  (`taeller`),
  KEY `proj_name` (`proj_name`,`rolle`,`tcode`,`test`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth agr_user';

--
-- Table structure for table `cehior_auth_proj_roller_temp`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_proj_roller_temp` (
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `proj_name` varchar(20) NOT NULL,
  `rolle` varchar(40) NOT NULL,
  `role_desc` varchar(80) default NULL,
  `dato` date NOT NULL default '0000-00-00',
  `tcode` varchar(48) NOT NULL,
  `tcode_text` varchar(36) default NULL,
  KEY `system` (`system`),
  KEY `client` (`client`),
  KEY `proj_name` (`proj_name`),
  KEY `rolle` (`rolle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth agr_user';

--
-- Table structure for table `cehior_auth_proj_test_rolle_use`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_proj_test_rolle_use` (
  `unikid` varchar(82) NOT NULL,
  `proj_name` varchar(20) NOT NULL,
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `bruger` varchar(12) NOT NULL,
  `rolle` varchar(30) NOT NULL,
  `tcode` varchar(40) NOT NULL,
  `first_hit` date NOT NULL default '0000-00-00',
  `last_hit` date NOT NULL default '0000-00-00',
  `hits` bigint(20) NOT NULL default '0',
  `test_stat` varchar(12) default NULL,
  KEY `unikid` (`unikid`,`proj_name`,`system`,`client`,`bruger`,`rolle`,`tcode`),
  KEY `proj_stat` (`proj_name`,`system`,`client`,`bruger`,`rolle`,`test_stat`,`hits`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth agr_user';

--
-- Table structure for table `cehior_auth_proj_test_roller`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_proj_test_roller` (
  `proj_name` varchar(20) NOT NULL,
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `user` varchar(12) NOT NULL,
  `rolle` varchar(40) NOT NULL,
  `owner` varchar(12) default ' ',
  `select_date` date NOT NULL default '0000-00-00',
  `select_time` time NOT NULL default '00:00:00',
  `date_r3_create` date NOT NULL default '0000-00-00',
  `time_r3_create` time NOT NULL default '00:00:00',
  KEY `index` (`proj_name`,`rolle`,`user`,`system`,`client`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth agr_user';

--
-- Table structure for table `cehior_auth_proj_test_roller_delta`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_proj_test_roller_delta` (
  `proj_name` varchar(20) NOT NULL,
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `user` varchar(12) NOT NULL,
  `rolle` varchar(40) NOT NULL,
  `mode` varchar(5) default NULL,
  `test_container` varchar(1) default NULL,
  `owner` varchar(12) NOT NULL default '',
  `select_date` date NOT NULL default '0000-00-00',
  `select_time` time NOT NULL default '00:00:00',
  `date_r3_create` date NOT NULL default '0000-00-00',
  `time_r3_create` time NOT NULL default '00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth agr_user';

--
-- Table structure for table `cehior_auth_proj_test_user`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_proj_test_user` (
  `proj_name` varchar(20) NOT NULL,
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `test_user` varchar(12) NOT NULL,
  `origin_user` varchar(12) default '',
  `testcontainer` varchar(30) NOT NULL,
  `first_name` varchar(40) default NULL,
  `last_name` varchar(40) default NULL,
  `pw` varchar(12) default NULL,
  `select_date` date NOT NULL default '0000-00-00',
  `select_time` time NOT NULL default '00:00:00',
  `create_date` date NOT NULL default '0000-00-00',
  `create_time` time NOT NULL default '00:00:00',
  `create_user` varchar(12) NOT NULL default '',
  `create_cua` char(1) default NULL,
  `mail` varchar(250) default ' ',
  `test_container` varchar(30) default NULL,
  PRIMARY KEY  (`system`,`client`,`test_user`),
  KEY `proj` (`proj_name`,`system`,`client`,`test_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_proj_use_sod`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_proj_use_sod` (
  `taeller` bigint(20) NOT NULL auto_increment,
  `system` varchar(8) NOT NULL,
  `client` char(3) NOT NULL,
  `proj_name` varchar(20) NOT NULL,
  `rolle` varchar(40) NOT NULL,
  `select_date` date NOT NULL default '0000-00-00',
  `select_time` time NOT NULL default '00:00:00',
  `nr_tcodes` int(40) NOT NULL default '0',
  `nr_tcodes_used` int(40) NOT NULL default '0',
  `nr_sod` int(11) NOT NULL default '0',
  PRIMARY KEY  (`taeller`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auth agr_user';

--
-- Table structure for table `cehior_auth_reports`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_reports` (
  `id` int(10) unsigned NOT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(250) default NULL,
  `type` int(11) NOT NULL default '1',
  `query` mediumtext NOT NULL,
  `group` varchar(200) default NULL,
  `group_query` mediumtext,
  `active` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`id`),
  KEY `name` (`name`),
  KEY `active` (`active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_reports_selections`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_reports_selections` (
  `report_id` varchar(10) NOT NULL,
  `number` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(250) default NULL,
  `type` varchar(20) NOT NULL,
  `options` varchar(250) default NULL,
  `values` mediumtext,
  PRIMARY KEY  (`report_id`,`number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_resp`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_resp` (
  `responsible` varchar(10) NOT NULL,
  PRIMARY KEY  (`responsible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_sap_menu`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_sap_menu` (
  `taeller` int(11) NOT NULL auto_increment,
  `gruppe` varchar(20) NOT NULL,
  `tcode` varchar(40) NOT NULL,
  `level` int(11) NOT NULL default '0',
  `objectid` int(11) NOT NULL default '0',
  `level0` int(11) NOT NULL default '0',
  `level1` int(11) NOT NULL default '0',
  `level2` int(11) NOT NULL default '0',
  `level3` int(11) NOT NULL default '0',
  `level4` int(11) NOT NULL default '0',
  `level5` int(11) NOT NULL default '0',
  `level6` int(11) NOT NULL default '0',
  `level7` int(11) NOT NULL default '0',
  `level8` int(11) NOT NULL default '0',
  `level9` int(11) NOT NULL default '0',
  `level10` int(11) NOT NULL default '0',
  `level11` int(11) NOT NULL default '0',
  `level12` int(11) NOT NULL default '0',
  `level13` int(11) NOT NULL default '0',
  `level14` int(11) NOT NULL default '0',
  `level15` int(11) NOT NULL default '0',
  `level16` int(11) NOT NULL default '0',
  `level17` int(11) NOT NULL default '0',
  `level18` int(11) NOT NULL default '0',
  `level19` int(11) NOT NULL default '0',
  `level20` int(11) NOT NULL default '0',
  `level21` int(11) NOT NULL default '0',
  `level22` int(11) NOT NULL default '0',
  `level23` int(11) NOT NULL default '0',
  `level24` int(11) NOT NULL default '0',
  `level25` int(11) NOT NULL default '0',
  PRIMARY KEY  (`taeller`),
  KEY `tcode` (`tcode`),
  KEY `objectid` (`objectid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_sap_menu_project`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_sap_menu_project` (
  `taeller` bigint(20) NOT NULL auto_increment,
  `project` varchar(40) NOT NULL,
  `tcode` varchar(40) NOT NULL,
  `level` varchar(40) NOT NULL,
  `objectid` varchar(40) NOT NULL,
  `level0` int(11) NOT NULL default '0',
  `level1` int(11) NOT NULL default '0',
  `level2` int(11) NOT NULL default '0',
  `level3` int(11) NOT NULL default '0',
  `level4` int(11) NOT NULL default '0',
  `level5` int(11) NOT NULL default '0',
  `level6` int(11) NOT NULL default '0',
  `level7` int(11) NOT NULL default '0',
  `level8` int(11) NOT NULL default '0',
  `level9` int(11) NOT NULL default '0',
  `level10` int(11) NOT NULL default '0',
  `level11` int(11) NOT NULL default '0',
  `level12` int(11) NOT NULL default '0',
  `level13` int(11) NOT NULL default '0',
  `level14` int(11) NOT NULL default '0',
  `level15` int(11) NOT NULL default '0',
  `level16` int(11) NOT NULL default '0',
  `level17` int(11) NOT NULL default '0',
  `level18` int(11) NOT NULL default '0',
  `level19` int(11) NOT NULL default '0',
  `level20` int(11) NOT NULL default '0',
  `level21` int(11) NOT NULL default '0',
  `level22` int(11) NOT NULL default '0',
  `rolle` varchar(40) NOT NULL,
  `rolle_level` int(11) NOT NULL default '0',
  `actvt` mediumtext NOT NULL,
  `org_level` mediumtext NOT NULL,
  `nr_users` int(11) NOT NULL default '0',
  `nr_dynpros` bigint(20) NOT NULL default '0',
  `date_added` date NOT NULL default '0000-00-00',
  `time_added` time NOT NULL default '00:00:00',
  `in_menu` char(1) NOT NULL,
  `classes` mediumtext NOT NULL,
  `org_tcode` varchar(40) NOT NULL,
  PRIMARY KEY  (`taeller`),
  KEY `tcode` (`tcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Sap menu';

--
-- Table structure for table `cehior_auth_sap_roller_org`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_sap_roller_org` (
  `taeller` bigint(20) NOT NULL auto_increment,
  `project` varchar(40) NOT NULL,
  `tcode` varchar(40) NOT NULL,
  `actvt` mediumtext NOT NULL,
  `org_level` mediumtext NOT NULL,
  `nr_users` int(11) NOT NULL default '0',
  `nr_hits` int(11) NOT NULL default '0',
  `classes` mediumtext NOT NULL,
  `org_tcode` varchar(40) NOT NULL,
  PRIMARY KEY  (`taeller`),
  KEY `tcode` (`tcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Sap menu';

--
-- Table structure for table `cehior_auth_sap_roller_org_kopi`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_sap_roller_org_kopi` (
  `taeller` bigint(20) NOT NULL auto_increment,
  `project` varchar(40) NOT NULL,
  `tcode` varchar(40) NOT NULL,
  `actvt` mediumtext NOT NULL,
  `org_level` mediumtext NOT NULL,
  `nr_users` int(11) NOT NULL default '0',
  `nr_hits` int(11) NOT NULL default '0',
  `classes` mediumtext NOT NULL,
  `org_tcode` varchar(40) NOT NULL,
  PRIMARY KEY  (`taeller`),
  KEY `tcode` (`tcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Sap menu';

--
-- Table structure for table `cehior_auth_smensapnew`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_smensapnew` (
  `customized` char(1) NOT NULL,
  `parent_id` int(11) NOT NULL default '0',
  `object_id` int(11) NOT NULL default '0',
  `menu_level` int(11) NOT NULL default '0',
  `reporttype` char(2) NOT NULL,
  `report` varchar(48) NOT NULL,
  `attributes` varchar(10) NOT NULL,
  `par_menu` varchar(40) NOT NULL,
  `cust_flag` char(1) NOT NULL,
  `sap_guid` varchar(32) NOT NULL,
  `sort_order` int(11) NOT NULL default '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_smensapt`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_smensapt` (
  `lang` char(1) NOT NULL,
  `object_id` int(6) NOT NULL default '0',
  `text` varchar(80) NOT NULL,
  KEY `object_id` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Sap Menu text';

--
-- Table structure for table `cehior_auth_status_comments`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_status_comments` (
  `taeller` bigint(20) NOT NULL auto_increment,
  `unikid` varchar(32) NOT NULL,
  `dato` varchar(8) NOT NULL,
  `tid` varchar(6) NOT NULL,
  `user` varchar(12) NOT NULL,
  `status` varchar(12) NOT NULL,
  `mode` varchar(8) NOT NULL,
  `tcode` varchar(48) NOT NULL,
  `text` mediumtext,
  PRIMARY KEY  (`taeller`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_su53`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_su53` (
  `linenumb` bigint(9) NOT NULL auto_increment,
  `unikid` varchar(32) NOT NULL,
  `text` longtext NOT NULL,
  PRIMARY KEY  (`linenumb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='SU53 rapport data';

--
-- Table structure for table `cehior_auth_system_descr`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_system_descr` (
  `system` varchar(100) NOT NULL,
  `testcase` int(11) NOT NULL,
  `extissueno` int(11) NOT NULL,
  `usergroup` int(11) NOT NULL,
  `responsible` int(11) NOT NULL,
  `client` varchar(4) NOT NULL,
  `type` varchar(100) NOT NULL default '',
  `sysrolle` varchar(100) NOT NULL default '',
  `roledevl` varchar(1) NOT NULL default '',
  `createdby` varchar(100) NOT NULL default '',
  `dato` year(4) NOT NULL default '0000',
  `tid` time NOT NULL default '00:00:00',
  `gruppe` varchar(100) NOT NULL,
  `nummer` int(11) NOT NULL,
  `tekst` longtext NOT NULL,
  `cua_active` char(1) default NULL,
  `cua_master` varchar(7) default NULL,
  `cua_logsys` varchar(10) default NULL,
  `extAnalysis` char(1) default NULL COMMENT 'Extended Analysis',
  `displayproject` int(11) NOT NULL default '0',
  PRIMARY KEY  (`system`,`client`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_task_change_role`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_task_change_role` (
  `taeller` bigint(20) NOT NULL auto_increment,
  `unikid` varchar(32) NOT NULL,
  `system` varchar(6) NOT NULL,
  `client` varchar(5) NOT NULL,
  `role` varchar(30) NOT NULL,
  `user` varchar(12) NOT NULL,
  `operation` varchar(20) NOT NULL default '',
  `org` char(1) NOT NULL,
  `auth` varchar(12) NOT NULL,
  `object` varchar(10) NOT NULL,
  `field` varchar(10) NOT NULL,
  `val` varchar(20) NOT NULL,
  `create_date` date NOT NULL default '0000-00-00',
  `create_time` time NOT NULL default '00:00:00',
  `create_user` varchar(12) NOT NULL default '',
  `finish_date` date NOT NULL default '0000-00-00',
  `finish_time` time NOT NULL default '00:00:00',
  `finish_user` varchar(12) NOT NULL default '',
  PRIMARY KEY  (`taeller`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='RSSTOBJDIR';

--
-- Table structure for table `cehior_auth_task_change_role_data`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_task_change_role_data` (
  `unikid` varchar(32) NOT NULL,
  `change` varchar(1) default NULL,
  `role` varchar(30) NOT NULL,
  `object` varchar(10) NOT NULL,
  `auth` varchar(12) NOT NULL,
  `felt` varchar(10) NOT NULL default '0',
  `vaerdi` varchar(40) NOT NULL default '0',
  `tilvaerdi` varchar(40) default NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_task_change_role_data_org`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_task_change_role_data_org` (
  `unikid` varchar(32) NOT NULL,
  `change` varchar(1) NOT NULL,
  `role` varchar(30) NOT NULL,
  `var` varchar(40) NOT NULL,
  `vaerdi` varchar(40) NOT NULL,
  `tilvaerdi` varchar(40) default NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_task_user_role`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_task_user_role` (
  `taeller` bigint(20) NOT NULL auto_increment,
  `unikid` varchar(32) NOT NULL,
  `system` varchar(6) NOT NULL,
  `client` varchar(5) NOT NULL,
  `role` varchar(30) NOT NULL,
  `user` varchar(12) NOT NULL,
  `operation` varchar(20) NOT NULL default '',
  `create_date` date NOT NULL default '0000-00-00',
  `create_time` time NOT NULL default '00:00:00',
  `create_user` varchar(12) NOT NULL default '',
  `finish_date` date NOT NULL default '0000-00-00',
  `finish_time` time NOT NULL default '00:00:00',
  `finish_user` varchar(12) NOT NULL default '',
  `finish_cua` char(1) NOT NULL default '',
  PRIMARY KEY  (`taeller`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='RSSTOBJDIR';

--
-- Table structure for table `cehior_auth_tcode_conf`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_tcode_conf` (
  `unikid` varchar(32) NOT NULL,
  `tcode` varchar(48) NOT NULL,
  `text` longtext NOT NULL,
  PRIMARY KEY  (`unikid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_tcode_sod`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_tcode_sod` (
  `unikid` varchar(32) NOT NULL,
  `tcode1` varchar(48) NOT NULL,
  `tcode1_text` varchar(40) NOT NULL,
  `tcode2` varchar(48) NOT NULL,
  `tcode2_text` varchar(48) NOT NULL,
  `text` longtext NOT NULL,
  PRIMARY KEY  (`unikid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_tcode_sod_backup`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_tcode_sod_backup` (
  `unikid` varchar(32) NOT NULL,
  `tcode1` varchar(48) NOT NULL,
  `tcode1_text` varchar(40) NOT NULL,
  `tcode2` varchar(48) NOT NULL,
  `tcode2_text` varchar(48) NOT NULL,
  `text` longtext NOT NULL,
  PRIMARY KEY  (`unikid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_tcode_sod_temp`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_tcode_sod_temp` (
  `unikid` varchar(32) NOT NULL,
  `tcode1` varchar(48) NOT NULL,
  `tcode1_text` varchar(40) NOT NULL,
  `tcode2` varchar(48) NOT NULL,
  `tcode2_text` varchar(48) NOT NULL,
  `text` longtext NOT NULL,
  KEY `unikid` (`unikid`),
  KEY `tcode1` (`tcode1`),
  KEY `tcode2` (`tcode2`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_tcode_trace`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_tcode_trace` (
  `counter` int(11) NOT NULL default '0',
  `unikid` varchar(32) NOT NULL,
  `dato` varchar(8) NOT NULL,
  `tid` varchar(6) NOT NULL,
  `tcode` varchar(48) NOT NULL,
  `temid` varchar(100) NOT NULL,
  `dynpro` varchar(4) NOT NULL,
  `report` varchar(40) NOT NULL,
  `account` varchar(12) NOT NULL,
  PRIMARY KEY  (`counter`,`unikid`,`dato`,`tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_tcode_trace_test`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_tcode_trace_test` (
  `counter` int(11) NOT NULL default '0',
  `unikid` varchar(32) NOT NULL,
  `dato` varchar(8) NOT NULL,
  `tid` varchar(6) NOT NULL,
  `tcode` varchar(48) NOT NULL,
  `temid` varchar(100) NOT NULL,
  `dynpro` varchar(4) NOT NULL,
  `report` varchar(40) NOT NULL,
  `account` varchar(12) NOT NULL,
  PRIMARY KEY  (`counter`,`unikid`,`dato`,`tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_tcode_user_sod`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_tcode_user_sod` (
  `user` varchar(12) NOT NULL,
  `tcode1` varchar(48) NOT NULL,
  `tcode2` varchar(48) NOT NULL,
  `unikid` varchar(32) NOT NULL,
  KEY `unikid` (`unikid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_test_temp`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_test_temp` (
  `user` char(6) NOT NULL,
  `tcode` char(40) NOT NULL,
  `rolle` char(40) NOT NULL,
  `hits` int(11) NOT NULL default '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_tmpl_1251`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_tmpl_1251` (
  `Taeller` bigint(20) NOT NULL auto_increment,
  `system` varchar(6) NOT NULL,
  `client` varchar(4) NOT NULL,
  `agr_name` varchar(30) NOT NULL,
  `counter` smallint(6) NOT NULL default '0',
  `object` varchar(12) NOT NULL,
  `auth` varchar(12) NOT NULL,
  `variant` varchar(4) NOT NULL,
  `field` varchar(10) NOT NULL,
  `low` varchar(40) NOT NULL,
  `high` varchar(40) NOT NULL,
  `modified` char(1) NOT NULL,
  `deleted` char(1) NOT NULL,
  `copied` char(1) NOT NULL,
  `neu` char(1) NOT NULL,
  `node` int(11) NOT NULL default '0',
  PRIMARY KEY  (`Taeller`),
  KEY `system` (`system`),
  KEY `client` (`client`),
  KEY `agr_name` (`agr_name`),
  KEY `counter` (`counter`),
  KEY `object` (`object`),
  KEY `auth` (`auth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='AGR_1251';

--
-- Table structure for table `cehior_auth_trace_http_user_test`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_trace_http_user_test` (
  `Taeller` bigint(20) NOT NULL auto_increment,
  `system` varchar(8) NOT NULL,
  `client` varchar(3) NOT NULL,
  `dato` varchar(8) NOT NULL,
  `time` varchar(6) NOT NULL,
  `tcode` varchar(30) NOT NULL,
  `user` varchar(12) NOT NULL,
  `report` varchar(40) NOT NULL,
  `dynpronr` varchar(10) NOT NULL,
  `terminalid` varchar(20) NOT NULL,
  `usermode` varchar(1) NOT NULL,
  `laest` varchar(1) NOT NULL,
  `converted` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`Taeller`),
  KEY `system` (`system`,`client`,`user`,`tcode`,`dato`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_trace_st01`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_trace_st01` (
  `Taeller` bigint(20) NOT NULL auto_increment,
  `unikid` varchar(34) NOT NULL,
  `system` varchar(8) NOT NULL,
  `client` varchar(3) NOT NULL,
  `dato` varchar(8) NOT NULL,
  `time` mediumtext NOT NULL,
  `ms` varchar(6) NOT NULL,
  `tcode` varchar(30) NOT NULL,
  `user` varchar(12) NOT NULL,
  `rc` varchar(6) NOT NULL,
  `object` varchar(10) NOT NULL,
  `val` varchar(100) NOT NULL,
  `laest` varchar(1) default NULL,
  PRIMARY KEY  (`Taeller`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `cehior_auth_user_role`
--

CREATE TABLE IF NOT EXISTS `cehior_auth_user_role` (
  `unikid` varchar(32) NOT NULL,
  `role` varchar(30) NOT NULL,
  `start_dato` varchar(8) NOT NULL,
  `slut_dato` varchar(8) NOT NULL,
  `rolle_text` varchar(80) NOT NULL,
  `org_flag` varchar(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `hosted`
--

CREATE TABLE IF NOT EXISTS `hosted` (
  `customer` varchar(250) NOT NULL COMMENT 'Customer name (HTML)'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Hosted customer';

--
-- Table structure for table `sys_errors`
--

CREATE TABLE IF NOT EXISTS `sys_errors` (
  `id` int(10) unsigned NOT NULL auto_increment COMMENT 'Error id',
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP COMMENT 'When error occurred',
  `trace` mediumtext NOT NULL COMMENT 'PHP backtrace',
  `text` mediumtext NOT NULL COMMENT 'Error text',
  `sql` mediumtext COMMENT 'SQL causing error (if applicable)',
  PRIMARY KEY  (`id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `sys_sql_trace`
--

CREATE TABLE IF NOT EXISTS `sys_sql_trace` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `script` varchar(200) NOT NULL,
  `path` varchar(500) NOT NULL,
  `sql` mediumtext NOT NULL,
  `type` varchar(20) NOT NULL,
  `info` mediumtext,
  `num_rows` int(11) default NULL,
  `affected_rows` int(11) default NULL,
  `insert_id` int(11) default NULL,
  `error` mediumtext,
  PRIMARY KEY  (`id`),
  KEY `path` (`path`(333)),
  KEY `timestamp` (`timestamp`),
  KEY `script` (`script`),
  KEY `type` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=5503 DEFAULT CHARSET=utf8 COMMENT='SQL Trace';

--
-- Table structure for table `system_info`
--

CREATE TABLE IF NOT EXISTS `system_info` (
  `system` char(3) NOT NULL COMMENT 'SAP system id',
  `server` varchar(32) NOT NULL COMMENT 'Host name of server',
  `number` char(2) NOT NULL COMMENT 'SAP system number',
  PRIMARY KEY  (`system`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='SAP System Information';

--
-- Table structure for table `tc_restrict`
--

CREATE TABLE IF NOT EXISTS `tc_restrict` (
  `id` bigint(10) unsigned NOT NULL COMMENT 'Restriction ID',
  `type` char(1) NOT NULL default 'D' COMMENT 'Deny/Allow',
  `system` char(3) NOT NULL COMMENT 'SAP system',
  `client` char(3) NOT NULL COMMENT 'SAP client',
  `project` varchar(20) NOT NULL COMMENT 'APM project',
  `user` varchar(12) NOT NULL COMMENT 'SAP user',
  `class` varchar(4) NOT NULL COMMENT 'Auth. object class',
  `object` varchar(10) NOT NULL COMMENT 'Auth. object',
  `field` varchar(10) NOT NULL,
  `comment` varchar(100) default NULL,
  `status` char(1) NOT NULL COMMENT 'A=active, I=inactive, D=deleted',
  `audit_user` varchar(12) NOT NULL COMMENT 'SAP user',
  `audit_system` varchar(3) NOT NULL COMMENT 'SAP system',
  `audit_client` varchar(3) NOT NULL COMMENT 'SAP client',
  `audit_timestamp` timestamp NOT NULL default '0000-00-00 00:00:00' COMMENT 'Entry timestamp',
  PRIMARY KEY  (`type`,`system`,`client`,`project`,`user`,`class`,`object`,`field`,`status`,`audit_timestamp`,`id`),
  KEY `audit` (`audit_user`,`audit_system`,`audit_client`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Test Container Restrictions';

--
-- Table structure for table `tc_restrict_applied`
--

CREATE TABLE IF NOT EXISTS `tc_restrict_applied` (
  `issue_id` varchar(32) NOT NULL COMMENT 'Issue ID',
  `restrict_id` bigint(10) NOT NULL COMMENT 'Restriction ID',
  `restrict_value_id` bigint(10) default NULL COMMENT 'Restriction Value ID',
  KEY `idx` (`issue_id`,`restrict_id`,`restrict_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Log of applications of TC restrictions';

--
-- Table structure for table `tc_restrict_values`
--

CREATE TABLE IF NOT EXISTS `tc_restrict_values` (
  `restrict_id` bigint(10) NOT NULL COMMENT 'FK to tc_restrict.id',
  `id` bigint(10) NOT NULL COMMENT 'ID',
  `low` varchar(40) NOT NULL COMMENT 'Single or range ''from'' value',
  `high` varchar(40) NOT NULL COMMENT 'Range ''to'' value',
  `comment` varchar(100) default NULL COMMENT 'Comment',
  `status` char(1) NOT NULL COMMENT 'A=active, I=inactive, D=deleted',
  `audit_user` varchar(12) NOT NULL COMMENT 'SAP user',
  `audit_system` varchar(3) NOT NULL COMMENT 'SAP system',
  `audit_client` varchar(3) NOT NULL COMMENT 'SAP client',
  `audit_timestamp` timestamp NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`restrict_id`,`id`,`status`,`audit_timestamp`,`low`,`high`),
  KEY `audit_user` (`audit_user`,`audit_system`,`audit_client`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Test Container Restrictions - Field Values';

--
-- Table structure for table `temp_auth`
--

CREATE TABLE IF NOT EXISTS `temp_auth` (
  `guiid` char(32) NOT NULL default '',
  `object` varchar(10) NOT NULL default '',
  `values` varchar(1000) NOT NULL default '',
  `result` smallint(6) NOT NULL,
  `message` varchar(255) default NULL,
  KEY `guiid` (`guiid`,`object`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `temp_auth_post`
--

CREATE TABLE IF NOT EXISTS `temp_auth_post` (
  `id` int(11) NOT NULL auto_increment,
  `guiid` char(32) NOT NULL default '',
  `values` longtext NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `guiid` (`guiid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `temp_field`
--

CREATE TABLE IF NOT EXISTS `temp_field` (
  `guiid` char(32) NOT NULL COMMENT 'Session GUIID',
  `timestamp` timestamp NULL default CURRENT_TIMESTAMP COMMENT 'Timestamp',
  `field` varchar(10) NOT NULL COMMENT 'Object Class',
  `text` varchar(60) default NULL COMMENT 'Text',
  PRIMARY KEY  (`guiid`,`field`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Temp. Auth. Object Class list';

--
-- Table structure for table `temp_object`
--

CREATE TABLE IF NOT EXISTS `temp_object` (
  `guiid` char(32) NOT NULL COMMENT 'Session GUIID',
  `timestamp` timestamp NULL default CURRENT_TIMESTAMP COMMENT 'Timestamp',
  `class` varchar(4) NOT NULL COMMENT 'Object Class',
  `object` varchar(10) NOT NULL COMMENT 'Auth. Object',
  `text` varchar(60) default NULL COMMENT 'Text',
  `field1` varchar(10) default NULL,
  `field2` varchar(10) default NULL,
  `field3` varchar(10) default NULL,
  `field4` varchar(10) default NULL,
  `field5` varchar(10) default NULL,
  `field6` varchar(10) default NULL,
  `field7` varchar(10) default NULL,
  `field8` varchar(10) default NULL,
  `field9` varchar(10) default NULL,
  `field10` varchar(10) default NULL,
  PRIMARY KEY  (`guiid`,`class`,`object`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Temp. Auth. Object Class list';

--
-- Table structure for table `temp_object_class`
--

CREATE TABLE IF NOT EXISTS `temp_object_class` (
  `guiid` char(32) NOT NULL COMMENT 'Session GUIID',
  `timestamp` timestamp NULL default CURRENT_TIMESTAMP COMMENT 'Timestamp',
  `class` varchar(4) NOT NULL COMMENT 'Object Class',
  `text` varchar(60) default NULL COMMENT 'Text',
  PRIMARY KEY  (`guiid`,`class`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Temp. Auth. Object Class list';

--
-- Table structure for table `temp_orglvl`
--

CREATE TABLE IF NOT EXISTS `temp_orglvl` (
  `guiid` char(32) NOT NULL COMMENT 'Session GUIID',
  `timestamp` timestamp NULL default CURRENT_TIMESTAMP COMMENT 'Timestamp',
  `field` varchar(10) NOT NULL COMMENT 'Auth. Field',
  `text` varchar(60) default NULL COMMENT 'Text',
  PRIMARY KEY  (`guiid`,`field`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Temp. Auth. Object Class list';

--
-- Table structure for table `temp_role`
--

CREATE TABLE IF NOT EXISTS `temp_role` (
  `guiid` char(32) NOT NULL default '',
  `timestamp` timestamp NULL default CURRENT_TIMESTAMP,
  `role` varchar(30) NOT NULL default '',
  `description` varchar(80) NOT NULL default '',
  PRIMARY KEY  (`guiid`,`role`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `temp_role_tcode`
--

CREATE TABLE IF NOT EXISTS `temp_role_tcode` (
  `guiid` char(32) NOT NULL default '',
  `timestamp` timestamp NULL default CURRENT_TIMESTAMP,
  `role` varchar(30) NOT NULL default '',
  `tcode` varchar(20) NOT NULL default '',
  `delete_flag` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`guiid`,`role`,`tcode`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `temp_system_client_list`
--

CREATE TABLE IF NOT EXISTS `temp_system_client_list` (
  `system` char(3) NOT NULL COMMENT 'SAP System',
  `client` char(3) NOT NULL COMMENT 'SAP Client',
  `logsys` varchar(10) default NULL COMMENT 'SAP Logical System Name',
  `text` varchar(25) default NULL COMMENT 'SAP Client Description',
  PRIMARY KEY  (`system`,`client`),
  KEY `logsys` (`logsys`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Temp for storing posted system/client list';

--
-- Table structure for table `temp_system_rfc_list`
--

CREATE TABLE IF NOT EXISTS `temp_system_rfc_list` (
  `system` char(3) NOT NULL COMMENT 'SAP system',
  `destination` varchar(32) NOT NULL COMMENT 'RFC destination',
  PRIMARY KEY  (`system`,`destination`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Temp list of APM RFC destinations in system';

--
-- Table structure for table `temp_tcode`
--

CREATE TABLE IF NOT EXISTS `temp_tcode` (
  `guiid` char(32) NOT NULL default '',
  `timestamp` timestamp NULL default CURRENT_TIMESTAMP,
  `tcode` varchar(20) NOT NULL default '',
  `description` varchar(36) NOT NULL default '',
  PRIMARY KEY  (`guiid`,`tcode`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `temp_user`
--

CREATE TABLE IF NOT EXISTS `temp_user` (
  `guiid` char(32) NOT NULL default '',
  `timestamp` timestamp NULL default CURRENT_TIMESTAMP,
  `user` varchar(12) NOT NULL default '',
  `first_name` varchar(40) default NULL,
  `last_name` varchar(40) default NULL,
  `mail` varchar(250) default NULL,
  `test_container` varchar(30) default NULL,
  PRIMARY KEY  (`guiid`,`user`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `temp_user_group`
--

CREATE TABLE IF NOT EXISTS `temp_user_group` (
  `guiid` char(32) NOT NULL COMMENT 'Session GUIID',
  `timestamp` timestamp NULL default CURRENT_TIMESTAMP COMMENT 'Timestamp',
  `usgrp` varchar(12) NOT NULL COMMENT 'Object Class',
  `text` varchar(60) default NULL COMMENT 'Text',
  PRIMARY KEY  (`guiid`,`usgrp`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Temp. User Group list';

--
-- Table structure for table `temp_user_role`
--

CREATE TABLE IF NOT EXISTS `temp_user_role` (
  `guiid` char(32) NOT NULL default '',
  `timestamp` timestamp NULL default CURRENT_TIMESTAMP,
  `user` varchar(12) NOT NULL default '',
  `role` varchar(30) NOT NULL default '',
  PRIMARY KEY  (`guiid`,`user`,`role`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `trace_tcodes_detail`
--

CREATE TABLE IF NOT EXISTS `trace_tcodes_detail` (
  `id` bigint(20) NOT NULL auto_increment,
  `header_id` bigint(20) NOT NULL,
  `datetime` datetime NOT NULL,
  `tcode` varchar(30) NOT NULL,
  `report` varchar(40) NOT NULL,
  `dynpronr` varchar(10) NOT NULL,
  `terminalid` varchar(20) NOT NULL,
  `utc` datetime default NULL,
  PRIMARY KEY  (`id`),
  KEY `header_id` (`header_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `trace_tcodes_header`
--

CREATE TABLE IF NOT EXISTS `trace_tcodes_header` (
  `id` bigint(20) NOT NULL auto_increment,
  `system` varchar(8) NOT NULL,
  `client` varchar(3) NOT NULL,
  `project` varchar(20) default NULL,
  `datetime` datetime NOT NULL,
  `tcode` varchar(30) default NULL,
  `user` varchar(12) NOT NULL,
  `utc` datetime default NULL,
  PRIMARY KEY  (`id`),
  KEY `project` (`project`,`user`,`tcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `cehior_auth_reports` VALUES (1,'Project - Status report',NULL,2,'reportDataProjectStatus',NULL,NULL,1),(2,'Project - Issue details',NULL,2,'reportDataIssueDetails',NULL,NULL,1),(3,'Test Report - Test user',NULL,2,'reportDataTestUser',NULL,NULL,1),(4,'Test Report - Test execution overview',NULL,2,'reportDataTestOverview',NULL,NULL,1);

INSERT INTO `cehior_auth_reports_selections` VALUES ('1',1,'Project',NULL,'select','yes','select concat(system, \" / \", client) `group`, proj_name `option` from cehior_auth_proj_header order by `system`, client, proj_name'),('2',1,'Project',NULL,'select','yes','select concat(system, \" / \", client) `group`, proj_name `option` from cehior_auth_proj_header order by `system`, client, proj_name'),('3',1,'Project',NULL,'select','yes','select concat(system, \" / \", client) `group`, proj_name `option` from cehior_auth_proj_header order by `system`, client, proj_name'),('4',1,'Project',NULL,'select','yes','select concat(system, \" / \", client) `group`, proj_name `option` from cehior_auth_proj_header order by `system`, client, proj_name');

CREATE TABLE IF NOT EXISTS `config_issue_notification` (
  `system` varchar(3) NOT NULL,
  `client` varchar(3) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `from` varchar(320) NOT NULL,
  `toList` text NOT NULL COMMENT 'Comma separated',
  PRIMARY KEY  (`system`,`client`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `queue_issue_notification` (
  `issue_guid` varchar(32) NOT NULL,
  PRIMARY KEY  (`issue_guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

