/*
 * Decompiled with CFR 0.152.
 */
package um.report.rolebased;

import cn.DB;
import cn.Log;
import cn.Memory;
import cn.SapUser;
import cn.Tcode;
import cn.Utils;
import cn.report.CSVline;
import cn.task.Task;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import um.Usage;
import um.UsageRole;
import um.report.Parameters;
import um.report.Report;
import um.report.rolebased.DetailsBoth;
import um.report.rolebased.DetailsNone;
import um.report.rolebased.DetailsTcode;
import um.report.rolebased.DetailsUser;

public class RoleBased
extends Report {
    protected static final String composite = "C";
    private static long timeSpentLoadingtcodesUsedInRoleByUser = 0L;

    public RoleBased(Task task, Parameters params) {
        super(task, params);
        this.usage = Usage.getInstance(params.system, params.client, params.getFromDate(), params.getToDate());
    }

    @Override
    protected ArrayList<String> createHeaders() {
        ArrayList<String> line = new ArrayList<String>();
        switch (this.params.getString("group")) {
            case "b": {
                line.add(this.translator.getText("User"));
                line.add(this.translator.getText("Role"));
                line.add(this.translator.getText("Composite"));
                line.add(this.translator.getText("Tcode"));
                line.add(this.translator.getText("Days used"));
                break;
            }
            case "u": {
                line.add(this.translator.getText("User"));
                line.add(this.translator.getText("Role"));
                line.add(this.translator.getText("Composite"));
                line.add(this.translator.getText("Tcodes assigned"));
                line.add(this.translator.getText("Tcodes used"));
                break;
            }
            case "t": {
                line.add(this.translator.getText("Role"));
                line.add(this.translator.getText("Composite"));
                line.add(this.translator.getText("Tcode"));
                line.add(this.translator.getText("Users with role assigned"));
                line.add(this.translator.getText("Users who have used tcode"));
                break;
            }
            case "n": {
                line.add(this.translator.getText("Role"));
                line.add(this.translator.getText("Composite"));
                line.add(this.translator.getText("Users with role assigned"));
                line.add(this.translator.getText("Users who have used role"));
                line.add(this.translator.getText("Tcodes assigned"));
                line.add(this.translator.getText("Tcodes used"));
            }
        }
        return line;
    }

    @Override
    protected boolean populateRows(CSVline line) {
        boolean notPartial = false;
        Log.log(Memory.statement("Drop table if exists."));
        DB.update("DROP TABLE IF EXISTS `" + this.getCSVtable() + "`;");
        Object statement = "";
        int reportType = 0;
        switch (this.params.getString("group")) {
            case "b": {
                statement = DetailsBoth.getCSVStatement(this);
                reportType = 1;
                break;
            }
            case "u": {
                statement = DetailsUser.getCSVStatement(this);
                reportType = 2;
                break;
            }
            case "t": {
                statement = DetailsTcode.getCSVStatement(this);
                reportType = 3;
                break;
            }
            case "n": {
                statement = DetailsNone.getCSVStatement(this);
                reportType = 4;
            }
        }
        if (this.params.isExcel()) {
            Log.log("Excel limit as minimum.");
            statement = this.params.getLimit() > 0 && this.params.getLimit() < 0x100000 ? (String)statement + "LIMIT " + this.params.getLimit() + ";" : (String)statement + "LIMIT 1048576;";
        } else if (this.params.getLimit() > 0) {
            statement = (String)statement + "LIMIT " + this.params.getLimit() + ";";
        } else {
            Log.log("WARNING!!! NO LIMIT!!!");
        }
        Log.log(Memory.statement("um.report.rolebased.RoleBased move data.\n" + (String)statement));
        int numberOfRows = DB.update((String)statement);
        Log.log(Memory.statement("um.report.rolebased.RoleBased moved " + numberOfRows + " data rows."));
        Log.log(Memory.statement("um.report.rolebased.RoleBased loading all tcodes."));
        Tcode.loadAllTcodes(this.params.system, this.params.client);
        notPartial = RoleBased.populateRows(this, line, numberOfRows, reportType);
        Log.log(Memory.statement("Drop table if exists."));
        DB.update("DROP TABLE IF EXISTS `" + this.getCSVtable() + "`;");
        Log.log("Time spent loading which users has roles: " + UsageRole.timeSpentLoadingUsers + "ms");
        Log.log("Time spent loading timeSpentLoadingTcodeById: " + Tcode.timeUsedLoadingTcodesById + "ms");
        Log.log("Time spent loading tcodesUsedInRoleByUser: " + timeSpentLoadingtcodesUsedInRoleByUser + "ms");
        Log.log("Time spent finding compositeAssigningRole: " + timeSpentFindingCompositeAssigningRole + "ms");
        return notPartial;
    }

    protected void addRoleSelections(CSVline line, UsageRole role) {
        if (this.params.getBoolean("addRoleDesc")) {
            line.add(role.getDescription());
        }
        if (this.params.getBoolean("addRoleSapStar")) {
            line.add(role.getSapStarLicense(this.translator));
        }
        if (this.params.getBoolean("addCat")) {
            line.add(role.getLicenseCategoryName());
        }
        if (this.params.getBoolean("addRoleAttr")) {
            line.add(role.getRoleJournalAttributeOutput());
        }
    }

    private static boolean populateRows(RoleBased report, CSVline line, int numberOfRows, int reportType) {
        PreparedStatement PS = DB.prepareStatement("SELECT * FROM `" + report.getCSVtable() + "` WHERE report_id > ? AND report_id <= ?;");
        boolean memoryOK = Memory.ok();
        boolean spaceInFile = true;
        int porSize = 50000;
        int portions = Utils.ceilDivider(numberOfRows, 50000);
        report.task.setStatusDetails(report.translator.getText("Writing {1} of {2}", new String[]{"0", "" + numberOfRows}));
        try {
            long startingTime = System.currentTimeMillis();
            int current = 0;
            for (int portion = 0; portion <= portions && memoryOK && spaceInFile; ++portion) {
                String s;
                int start = portion * 50000;
                int end = start + 50000 > numberOfRows ? numberOfRows : start + 50000;
                Log.log(Memory.statement("Getting data portion " + portion + " / " + portions + ", " + start + " < row no <= " + end));
                PS.setInt(1, start);
                PS.setInt(2, end);
                ResultSet rs = PS.executeQuery();
                int numberOfRowsInPortion = end > numberOfRows ? numberOfRows - start : 50000;
                int tellPoint = Utils.ceilDivider(numberOfRowsInPortion, 50);
                while (rs.next() && memoryOK && spaceInFile) {
                    switch (reportType) {
                        case 1: {
                            spaceInFile = DetailsBoth.writeContent(line, report, DetailsBoth.makeData(report, rs));
                            break;
                        }
                        case 2: {
                            spaceInFile = DetailsUser.writeContent(line, report, DetailsUser.makeData(report, rs));
                            break;
                        }
                        case 3: {
                            spaceInFile = DetailsTcode.writeContent(line, report, DetailsTcode.makeData(report, rs));
                            break;
                        }
                        case 4: {
                            spaceInFile = DetailsNone.writeContent(line, report, DetailsNone.makeData(report, rs));
                        }
                    }
                    if (++current % tellPoint == 0 || System.currentTimeMillis() - startingTime > 30000L) {
                        s = report.translator.getText("Writing {1} of {2}", new String[]{"" + current, "" + numberOfRows});
                        report.task.setStatusDetails(s);
                        Log.log(Memory.statement(s));
                        startingTime = System.currentTimeMillis();
                    }
                    if (memoryOK = Memory.ok()) continue;
                    Memory.garbageCollector();
                    memoryOK = Memory.ok();
                }
                rs.close();
                s = report.translator.getText("Writing {1} of {2}", new String[]{"" + current, "" + numberOfRows});
                report.task.setStatusDetails(s);
                Log.log(Memory.statement(s));
            }
            Log.log(Memory.statement(report.translator.getText("Writing {1} of {2}", new String[]{"" + current, "" + numberOfRows})));
        }
        catch (Exception e) {
            Log.log("um.report.rolebased.RoleBased getting data CSV FAILED!");
            Log.logException(e);
            return false;
        }
        if (!memoryOK) {
            Log.log("um.report.rolebased.RoleBased STOPPED DUE TO MEMORY LIMITATIONS!");
        }
        if (!spaceInFile) {
            Log.log("um.report.rolebased.RoleBased STOPPED DUE TO FILESIZE LIMITATIONS!");
        }
        return memoryOK && spaceInFile;
    }

    protected static int tcodesUsedInRoleByUser(UsageRole role, SapUser user, Usage usage) {
        long startTime = System.currentTimeMillis();
        int count = 0;
        for (Tcode tcode : role.getUMTcodes()) {
            if (usage.getDaysUsed(user, tcode) <= 0) continue;
            ++count;
        }
        timeSpentLoadingtcodesUsedInRoleByUser += System.currentTimeMillis() - startTime;
        return count;
    }

    protected static int tcodesUsedInRoleByUsers(UsageRole role, Usage usage) {
        int count = 0;
        for (Tcode tcode : role.getUMTcodes()) {
            boolean tcodeUsed = false;
            for (SapUser su : role.getUsers()) {
                if (!usage.isUsedTcode(tcode.id) || usage.getDaysUsed(su, tcode) <= 0) continue;
                tcodeUsed = true;
                break;
            }
            if (!tcodeUsed) continue;
            ++count;
        }
        return count;
    }

    protected static int usersUsedRole(UsageRole role, Usage usage) {
        int count = 0;
        for (SapUser su : role.getUsers()) {
            boolean userUsedRole = false;
            for (Tcode tcode : role.getUMTcodes()) {
                if (!usage.isUsedTcode(tcode.id) || usage.getDaysUsed(su, tcode) <= 0) continue;
                userUsedRole = true;
                break;
            }
            if (!userUsedRole) continue;
            ++count;
        }
        return count;
    }

    protected static int usersUsedTcode(UsageRole role, Tcode tcode, Usage usage) {
        int count = 0;
        if (usage.isUsedTcode(tcode.id)) {
            for (SapUser su : role.getUsers()) {
                if (usage.getDaysUsed(su, tcode) <= 0) continue;
                ++count;
            }
        }
        return count;
    }
}

