/*
 * Decompiled with CFR 0.152.
 */
package um.report.rolebased;

import cn.Log;
import cn.Tcode;
import cn.Utils;
import cn.report.CSVline;
import java.sql.ResultSet;
import java.sql.SQLException;
import um.UsageRole;
import um.report.Report;
import um.report.rolebased.RoleBased;

class DetailsTcode {
    private final UsageRole role;
    private final Tcode tcode;
    private boolean isUsed = false;

    private DetailsTcode(UsageRole role, Tcode tcode) {
        this.role = role;
        this.tcode = tcode;
    }

    static DetailsTcode makeData(RoleBased report, ResultSet rs) {
        try {
            UsageRole role;
            Tcode tcode = Tcode.getById(rs.getInt("tcode_id"));
            int role_id = rs.getInt("role_id");
            if (UsageRole.exists(role_id)) {
                role = UsageRole.getExisting(role_id);
            } else {
                String description = report.params.getBoolean("addRoleDesc") ? rs.getString("description") : "";
                int licCatId = report.params.getBoolean("addCat") ? rs.getInt("license_category_id") : -1;
                role = UsageRole.create(role_id, rs.getString("role"), description, rs.getString("type").contentEquals("C"), report.params.system, report.params.client, licCatId);
                role.setUserCount(rs.getInt("ucount"));
            }
            DetailsTcode rbd = new DetailsTcode(role, tcode);
            if (rbd.role.getUserCount() > 0 && !Utils.isEmpty(tcode.name)) {
                rbd.isUsed = report.usage.isUsedTcode(tcode.id);
            }
            return rbd;
        }
        catch (SQLException e) {
            Log.log("DetailsTcode makeData FAILED!");
            Log.logException(e);
            return null;
        }
    }

    static boolean writeContent(CSVline line, RoleBased report, DetailsTcode rbd) {
        if (rbd.role.isComposite) {
            line.add("");
            line.add(rbd.role.name);
        } else {
            line.add(rbd.role.name);
            line.add("");
        }
        line.add(rbd.tcode.name);
        line.add("" + rbd.role.getUserCount());
        if (rbd.isUsed) {
            line.add("" + RoleBased.usersUsedTcode(rbd.role, rbd.tcode, report.usage));
        } else {
            line.add("0");
        }
        if (report.params.getBoolean("addMonthOfLastUsage")) {
            if (rbd.isUsed) {
                line.add(report.usage.getLastUsage(rbd.tcode, rbd.role));
            } else {
                line.add("");
            }
        }
        if (report.params.getBoolean("addTcodeDesc")) {
            line.add(rbd.tcode.description);
        }
        report.addRoleSelections(line, rbd.role);
        boolean goOn = line.write();
        line.reset();
        if (!goOn) {
            Log.log("DetailsTcode writeContent CSVfile has returned FALSE, either because file is maxed out or something FAILED!");
        }
        return goOn;
    }

    static String getCSVStatement(Report report) {
        StringBuilder cre = new StringBuilder("CREATE TABLE `" + report.getCSVtable() + "` (\n\t`report_id` int NOT NULL AUTO_INCREMENT, \n");
        if (report.params.getBoolean("addRoleDesc")) {
            cre.append("description varchar(80),\n");
        }
        if (report.params.getBoolean("addCat")) {
            cre.append("license_category_id int,\n");
        }
        cre.append("\t`ucount` int,\n\t`tcode_id` int,\n\t`tcode` varchar(20),\n\t`role_id` int,\n\t`type` CHAR(1),\n\t`role` varchar(30),\n\tPRIMARY KEY (`report_id`) \n) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci \n");
        return cre.toString() + DetailsTcode.getStatement(report);
    }

    private static String getStatement(Report report) {
        StringBuilder sql = new StringBuilder("SELECT \n");
        String um_role_tcode_name = "um_role_tcode";
        if (report.params.getBoolean("addRoleDesc")) {
            sql.append("r.description,\n");
        }
        if (report.params.getBoolean("addCat")) {
            sql.append("r.license_category_id,\n");
        }
        sql.append("(SELECT COUNT(user_id) FROM um_user_role WHERE role_id = r.id AND um_delete = 0) AS ucount,\nrt.tcode_id AS tcode_id,\nr.id AS role_id,\nr.type,\nr.role\nFROM um_role AS r \nLEFT JOIN " + um_role_tcode_name + " AS rt ON rt.role_id = r.id AND rt.um_delete = 0 \n");
        if (report.params.getRoleJournalAttributes().length > 0) {
            sql.append("LEFT JOIN um_role_attributes AS ra ON ra.role_id = r.id \n");
        }
        if (!Utils.isEmpty(report.user_ids) || !Utils.isEmpty(report.userGroups) || report.params.excludeUsersExpired() || report.params.excludeUsersLocked()) {
            sql.append("LEFT JOIN um_user_role AS ur ON ur.role_id = r.id AND ur.um_delete = 0 \nLEFT JOIN um_user AS u ON u.id = ur.user_id AND u.um_delete = 0 \n");
        }
        sql.append("WHERE\n\tr.system = '" + report.params.system + "' AND r.client = '" + report.params.client + "' AND \tr.um_delete = 0\n");
        Report.sqlAddRoleSelections(sql, report);
        Report.sqlAddUserSelections(sql, report);
        Report.sqlAddTcodeSelections(sql, report);
        return sql.toString();
    }
}

