/*
 * Decompiled with CFR 0.152.
 */
package um.report.rolebased;

import cn.Log;
import cn.SapUser;
import cn.Tcode;
import cn.Utils;
import cn.report.CSVline;
import java.sql.Date;
import java.sql.ResultSet;
import um.Usage;
import um.UsageRole;
import um.report.Report;
import um.report.rolebased.RoleBased;

class DetailsBoth {
    private final SapUser user;
    private final UsageRole role;
    private final Tcode tcode;
    private final boolean isUsed;
    private final boolean indirect;

    private DetailsBoth(SapUser user, UsageRole role, Tcode tcode, boolean indirect, Usage usage) {
        this.user = user;
        this.role = role;
        this.tcode = tcode;
        boolean bl = this.indirect = indirect && user.getId() > 0;
        this.isUsed = role.getUserCount() > 0 && !Utils.isEmpty(tcode.name) && user.getId() > 0 ? usage.isUsedTcode(tcode.id) && usage.isUsedUser(user.getId()) : false;
    }

    static DetailsBoth makeData(RoleBased report, ResultSet rs) {
        try {
            UsageRole role;
            SapUser user = SapUser.getById(rs.getInt("user_id"));
            Tcode tcode = Tcode.getById(rs.getInt("tcode_id"));
            int role_id = rs.getInt("role_id");
            if (UsageRole.exists(role_id)) {
                role = UsageRole.getExisting(role_id);
            } else {
                String description = report.params.getBoolean("addRoleDesc") ? rs.getString("description") : "";
                int licCatId = report.params.getBoolean("addCat") ? rs.getInt("license_category_id") : -1;
                role = UsageRole.create(role_id, rs.getString("role"), description, rs.getString("type").contentEquals("C"), report.params.system, report.params.client, licCatId);
            }
            DetailsBoth rbd = report.params.getBoolean("addComp") ? new DetailsBoth(user, role, tcode, !rs.getBoolean("direct"), report.usage) : new DetailsBoth(user, role, tcode, false, report.usage);
            return rbd;
        }
        catch (Exception e) {
            Log.log("um.report.rolebased.GroupingBoth makeData FAILED!");
            Log.logException(e);
            return null;
        }
    }

    static boolean writeContent(CSVline line, RoleBased report, DetailsBoth rbd) {
        line.add(rbd.user.username);
        if (rbd.role.isComposite) {
            line.add("");
            line.add(rbd.role.name);
        } else {
            line.add(rbd.role.name);
            if (report.params.getBoolean("addComp") && rbd.indirect) {
                line.add(Report.getCompositesAssigningRole(rbd.user.getId(), rbd.role.id));
            } else {
                line.add("");
            }
        }
        line.add(rbd.tcode.name);
        if (rbd.isUsed) {
            line.add("" + report.usage.getDaysUsed(rbd.user, rbd.tcode));
        } else {
            line.add("0");
        }
        if (report.params.getBoolean("addMonthOfLastUsage")) {
            if (rbd.isUsed) {
                Date lastUsed = report.usage.getLastUsage(rbd.user.getId(), rbd.tcode.id);
                line.add(lastUsed == null ? "" : lastUsed.toString());
            } else {
                line.add("");
            }
        }
        if (report.params.getBoolean("addTcodeDesc")) {
            line.add(rbd.tcode.description);
        }
        report.addRoleSelections(line, rbd.role);
        if (report.params.getBoolean("addAlt")) {
            line.add(Report.getAlternativeRoles(rbd.user, rbd.tcode.name));
        }
        Report.addUserInformation(report.params, line, rbd.user, report.translator);
        boolean goOn = line.write();
        line.reset();
        if (!goOn) {
            Log.log("CSVfile has returned FALSE, either because file is maxed out or something FAILED!");
        }
        return goOn;
    }

    static String getCSVStatement(Report report) {
        StringBuilder cre = new StringBuilder("CREATE TABLE `" + report.getCSVtable() + "` (\n\t`report_id` int NOT NULL AUTO_INCREMENT, \n");
        if (report.params.getBoolean("addRoleDesc")) {
            cre.append("description varchar(80),\n");
        }
        if (report.params.getBoolean("addCat")) {
            cre.append("license_category_id int,\n");
        }
        if (report.params.getBoolean("addComp")) {
            cre.append("direct tinyint,\n");
        }
        cre.append("\t`role_id` int,\n\t`type` CHAR(1),\n\t`role` varchar(30),\n\t`user_id` int,\n\t`tcode_id` int,\n\tPRIMARY KEY (`report_id`) \n) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci \n");
        return cre.toString() + DetailsBoth.getStatement(report);
    }

    private static String getStatement(Report report) {
        StringBuilder sql = new StringBuilder("SELECT \n");
        String um_role_tcode_name = "um_role_tcode";
        if (report.params.getBoolean("addRoleDesc")) {
            sql.append("r.description,\n");
        }
        if (report.params.getBoolean("addCat")) {
            sql.append("r.license_category_id,\n");
        }
        if (report.params.getBoolean("addComp")) {
            sql.append("ur.direct,\n");
        }
        sql.append("r.id AS role_id,\nr.type,\nr.role,\nur.user_id AS user_id,\nrt.tcode_id AS `tcode_id`\nFROM um_role AS r \nLEFT JOIN " + um_role_tcode_name + " AS rt ON rt.role_id = r.id AND rt.um_delete = 0 \nLEFT JOIN um_user_role AS ur ON ur.role_id = r.id AND ur.um_delete = 0 \n");
        if (!Utils.isEmpty(report.user_ids) || !Utils.isEmpty(report.userGroups) || report.params.excludeUsersExpired() || report.params.excludeUsersLocked()) {
            sql.append("LEFT JOIN um_user AS u ON u.id = ur.user_id AND u.um_delete = 0 \n");
        }
        if (report.params.getRoleJournalAttributes().length > 0) {
            sql.append("LEFT JOIN um_role_attributes AS ra ON ra.role_id = r.id \n");
        }
        sql.append("WHERE\n\tr.system = '" + report.params.system + "' AND r.client = '" + report.params.client + "' AND \tr.um_delete = 0\n");
        Report.sqlAddRoleSelections(sql, report);
        Report.sqlAddUserSelections(sql, report);
        Report.sqlAddTcodeSelections(sql, report);
        return sql.toString();
    }
}

