/*
 * Decompiled with CFR 0.152.
 */
package um.report.roleUsageMatch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import um.report.roleUsageMatch.RoleUsageComparison;

class UsageMatchObject {
    private String user;
    private HashMap<String, Double> percentage;
    private HashMap<Integer, Integer> roleCount;
    private HashMap<String, Integer> extra;
    private HashMap<String, ArrayList<String>> roleTcodes;

    public UsageMatchObject(String user) {
        this.user = user;
        this.roleCount = new HashMap();
        this.extra = new HashMap();
        this.percentage = new HashMap();
        this.roleTcodes = new HashMap();
    }

    public UsageMatchObject(String user, HashMap<String, Integer> extra, HashMap<String, Double> percentage, HashMap<String, ArrayList<String>> roleTcodes) {
        this.user = user;
        this.extra = extra;
        this.percentage = percentage;
        this.roleTcodes = roleTcodes;
    }

    public List<String> sortByExtra() {
        List<String> sortedKeys = this.extra.keySet().stream().sorted(new RoleUsageComparison.CompareByExtra(this.extra, this.percentage)).collect(Collectors.toList());
        return sortedKeys;
    }

    public List<String> sortByPercent() {
        List<String> sortedKeys = this.percentage.keySet().stream().sorted(new RoleUsageComparison.CompareByPercentage(this.extra, this.percentage)).collect(Collectors.toList());
        return sortedKeys;
    }

    public void addRoleCount(Integer role, int count) {
        this.roleCount.put(role, count);
    }

    public void addExtraCount(String role, int extra) {
        this.extra.put(role, extra);
    }

    public void addPercentage(String role, Double percent) {
        this.percentage.put(role, percent);
    }

    public void addMatchingTcodes(String role, ArrayList<String> roleTcode) {
        this.roleTcodes.putIfAbsent(role, roleTcode);
    }

    public String getUserName() {
        return this.user;
    }

    public HashMap<String, Double> getPercentage() {
        return this.percentage;
    }

    public HashMap<String, Integer> getExtraCount() {
        return this.extra;
    }

    public HashMap<String, ArrayList<String>> getMatchingTcodes() {
        return this.roleTcodes;
    }

    public HashMap<Integer, Integer> getCount() {
        return this.roleCount;
    }

    public void setMatchingTcodes(HashMap<String, ArrayList<String>> roleCodes) {
        this.roleTcodes = roleCodes;
    }

    public void setPercentage(HashMap<String, Double> percent) {
        this.percentage = percent;
    }

    public void setExtraCount(HashMap<String, Integer> extra) {
        this.extra = extra;
    }
}

