/*
 * Decompiled with CFR 0.152.
 */
package um.report.roleUsageMatch;

import cn.Config;
import cn.Log;
import cn.Utils;
import cn.report.CSVfile;
import cn.report.CSVline;
import cn.task.Task;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import um.report.Parameters;
import um.report.Report;
import um.report.roleUsageMatch.RoleUsageDataGetter;
import um.report.roleUsageMatch.RoleUsageDetails;
import um.report.roleUsageMatch.UsageMatchObject;

public class RoleUsageMatch
extends Report {
    private HashMap<String, String[]> usageByUser;
    private HashMap<Integer, String[]> usageByRole;
    private ArrayList<UsageMatchObject> scoreByUser;

    public RoleUsageMatch(Task task, Parameters params) {
        super(task, params);
        this.usageByUser = RoleUsageDataGetter.getUsageByUser(task, params, this.translator);
        this.usageByRole = RoleUsageDataGetter.getUsageByRole(task, params, this.translator);
        this.scoreByUser = RoleUsageDataGetter.getCoverage(this.usageByUser, this.usageByRole, task, params, this.translator);
    }

    @Override
    protected ArrayList<String> createHeaders() {
        Log.log("Starting data sheet headers");
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(this.translator.getText("User"));
        headers.add(this.translator.getText("Tcode"));
        headers.add(this.translator.getText("Coverage %"));
        headers.add(this.translator.getText("Coverage"));
        headers.add(this.translator.getText("Extra in role"));
        headers.add(this.translator.getText("Role"));
        headers.add("Tcodes in role");
        return headers;
    }

    @Override
    protected boolean populateRows(CSVline line) {
        Boolean status = RoleUsageDetails.roleUsageDetails(line, this.scoreByUser, this.task, this.params, this.translator, this.usageByRole, this.usageByUser);
        return status;
    }

    protected ArrayList<String> extraHeader() {
        Log.log("Starting extra data sheet headers");
        ArrayList<String> headers = new ArrayList<String>();
        if (this.params.getBoolean("addGroup")) {
            headers.add(this.translator.getText("User group"));
        }
        if (this.params.getBoolean("addName")) {
            headers.add(this.translator.getText("Name"));
        }
        if (this.params.getBoolean("addEmail")) {
            headers.add(this.translator.getText("Email"));
        }
        headers.add(this.translator.getText("User"));
        headers.add(this.translator.getText("Coverage %"));
        headers.add(this.translator.getText("Coverage"));
        headers.add(this.translator.getText("Extra total"));
        headers.add(this.translator.getText("Extra in role"));
        headers.add(this.translator.getText("Role"));
        headers.add(this.translator.getText("Missing tcodes"));
        headers.add(this.translator.getText("Extra tcodes in role"));
        return headers;
    }

    @Override
    public boolean makeReport() {
        String outputFilename;
        Log.log("making new usage match report");
        this.task.setStatusDetails(this.translator.getText("Preparing report"));
        Log.log("Creating selections sheet.");
        ArrayList<String[]> lines = this.getSelectionsSheetContent();
        String baseFilename = "UM_Report_" + this.task.id;
        if (this.params.isExcel()) {
            Log.log("Excel format chosen.");
            outputFilename = baseFilename + "_selections.csv";
            Log.log("Creating selections file '" + outputFilename + "' .");
        } else {
            Log.log("CSV format chosen.");
            outputFilename = baseFilename + ".csv";
            lines.add(new String[]{"", ""});
            lines.add(new String[]{"", ""});
            Log.log("Creating selections and data file '" + outputFilename + "' .");
        }
        CSVfile output = new CSVfile(outputFilename, this.params.isExcel());
        Log.log("Writing selections to file '" + outputFilename + "' .");
        for (String[] line : lines) {
            output.writeUnformattedLine(line);
        }
        if (this.params.isExcel()) {
            Log.log("Closing selections file '" + outputFilename + "' .");
            output.close();
        }
        Log.log("Preparing output.");
        if (this.params.isExcel()) {
            outputFilename = baseFilename + ".csv";
            Log.log("Creating data file '" + outputFilename + "' .");
            output = new CSVfile(outputFilename, true);
        }
        Log.log("Creating headers.");
        ArrayList<String> headers = this.createHeaders();
        this.standardHeaders(headers);
        CharSequence[] headerArray = headers.toArray(Utils.EMPTYSTRINGARRAY);
        Log.log("Adding headers:\n" + String.join((CharSequence)" | ", headerArray));
        output.writeUnformattedLine((String[])headerArray);
        Log.log("Populating data rows with " + headerArray.length + " columns.");
        CSVline line = new CSVline(output, headerArray.length);
        this.task.setStatusDetails(this.translator.getText("Analyzing..."));
        boolean notPartial = this.populateRows(line);
        if (this.params.isExcel()) {
            Log.log("Closing data file '" + outputFilename + "' .");
            output.close();
        }
        Log.log("Preparing Extra Data.");
        if (this.params.isExcel()) {
            outputFilename = baseFilename + "_extra.csv";
            Log.log("Creating extra data file '" + outputFilename + "' .");
            output = new CSVfile(outputFilename, true);
        }
        Log.log("Creating headers for Extra data.");
        ArrayList<String> headersExtra = this.extraHeader();
        CharSequence[] headerArrayExtra = headersExtra.toArray(Utils.EMPTYSTRINGARRAY);
        Log.log("Adding headers:\n" + String.join((CharSequence)" | ", headerArrayExtra));
        output.writeUnformattedLine((String[])headerArrayExtra);
        Log.log("Populating data rows with " + headerArrayExtra.length + " columns.");
        CSVline lineExtra = new CSVline(output, headerArrayExtra.length);
        this.task.setStatusDetails(this.translator.getText("Analyzing..."));
        boolean extra = RoleUsageDetails.writeExtraContent(lineExtra, true, this.scoreByUser, this.usageByUser, this.params);
        if (this.params.isExcel()) {
            Log.log("Closing data file '" + outputFilename + "' .");
            output.close();
        }
        Log.log("Preparing Fewer Roles Data.");
        if (this.params.isExcel()) {
            outputFilename = baseFilename + "_fewer.csv";
            Log.log("Creating fewer roles data file '" + outputFilename + "' .");
            output = new CSVfile(outputFilename, true);
        }
        Log.log("Creating headers for fewer roles data.");
        ArrayList<String> headersFewer = this.extraHeader();
        CharSequence[] headerArrayFewer = headersFewer.toArray(Utils.EMPTYSTRINGARRAY);
        Log.log("Adding headers:\n" + String.join((CharSequence)" | ", headerArrayFewer));
        output.writeUnformattedLine((String[])headerArrayFewer);
        Log.log("Populating data rows with " + headerArrayFewer.length + " columns.");
        CSVline lineFewer = new CSVline(output, headerArrayFewer.length);
        this.task.setStatusDetails(this.translator.getText("Analyzing..."));
        boolean fewer = RoleUsageDetails.writeExtraContent(lineFewer, false, this.scoreByUser, this.usageByUser, this.params);
        Log.log("Closing CSV file.");
        output.close();
        Log.log("Datahandling finished.");
        if (this.params.isExcel()) {
            this.task.setStatusDetails(this.translator.getText("Converting to .xlsx"));
            this.task.getAttributes().setReportFilename(Config.getReportPath() + baseFilename + ".xlsx");
        } else {
            try {
                long size = Files.size(Paths.get(output.getFilename(), new String[0]));
                if (size > 0x3200000L) {
                    this.task.setStatusDetails(this.translator.getText("Compressing file size {1}B", new String[]{"" + size}));
                    this.task.getAttributes().setReportFilename(CSVfile.compressToZipFile(output.getFilename()));
                }
            }
            catch (IOException e) {
                Log.log("Unable to get filesize from '" + output.getFilename() + "'.");
                Log.logException(e);
            }
        }
        return notPartial;
    }
}

