/*
 * Decompiled with CFR 0.152.
 */
package um.report.roleUsageMatch;

import cn.Log;
import cn.SapUser;
import cn.Tcode;
import cn.Translator;
import cn.report.CSVline;
import cn.task.Task;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import um.UsageRole;
import um.report.Parameters;
import um.report.roleUsageMatch.UsageMatchObject;

class RoleUsageDetails {
    RoleUsageDetails() {
    }

    private static String getTcodeDesc(String tcodeName, String system, String client) {
        int tcodeID = Tcode.getIdFromName(tcodeName, system, client);
        return Tcode.getById((int)tcodeID).description;
    }

    public static boolean roleUsageDetails(CSVline line, ArrayList<UsageMatchObject> userObjects, Task task, Parameters params, Translator translator, HashMap<Integer, String[]> usageByRole, HashMap<String, String[]> usageByUser) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00%");
        for (UsageMatchObject user : userObjects) {
            String userName = user.getUserName();
            task.setStatusDetails(translator.getText("Analyzing..."));
            String[] userTcodes = usageByUser.get(userName);
            int noOfUserTcodes = userTcodes.length;
            SapUser sapUser = new SapUser(userName, params.system, params.client);
            for (String userTcode : userTcodes) {
                UsageRole role = null;
                for (Integer role_id : user.getCount().keySet()) {
                    if (UsageRole.exists(role_id)) {
                        role = UsageRole.getExisting(role_id);
                    }
                    if (!UsageRole.exists(role_id)) {
                        Log.log("didnt exist");
                    }
                    CharSequence[] roleTcodes = usageByRole.get(role_id);
                    int noOfRoleTcodes = roleTcodes.length;
                    int count = user.getCount().get(role_id);
                    double percentage = (double)count / (double)noOfUserTcodes * 100.0;
                    user.addPercentage(role.name, percentage);
                    Integer extra = noOfRoleTcodes - count;
                    user.addExtraCount(role.name, extra);
                    user.addMatchingTcodes(role.name, new ArrayList<String>(Arrays.asList(roleTcodes)));
                    for (String string : roleTcodes) {
                        Boolean status;
                        if (!string.equals(userTcode)) continue;
                        line.add(userName);
                        line.add(string);
                        String formattedPercentage = decimalFormat.format(percentage / 100.0);
                        line.add(formattedPercentage);
                        line.add(count + " / " + noOfUserTcodes);
                        line.add(extra.toString());
                        line.add(role.name);
                        line.add(String.join((CharSequence)", ", roleTcodes));
                        if (params.getBoolean("addTcodeDesc")) {
                            String tdesc = RoleUsageDetails.getTcodeDesc(string, params.system, params.client);
                            line.add(tdesc);
                        }
                        if (params.getBoolean("addRoleDesc")) {
                            line.add(role.description);
                        }
                        if (params.getBoolean("addRoleSapStar")) {
                            line.add(role.getSapStarLicense(translator));
                        }
                        if (params.getBoolean("addCat")) {
                            line.add(role.getLicenseCategoryName());
                        }
                        if (params.getBoolean("addRoleAttr")) {
                            line.add(role.getRoleJournalAttributeOutput());
                        }
                        if (params.getBoolean("addGroup")) {
                            line.add(sapUser.getUserGroup());
                        }
                        if (params.getBoolean("addName")) {
                            line.add(sapUser.getFirstName() + " " + sapUser.getLastName());
                        }
                        if (params.getBoolean("addEmail")) {
                            line.add(sapUser.getEmail());
                        }
                        if ((status = Boolean.valueOf(line.write())).booleanValue()) continue;
                        Log.log("RoleUsageDetails: UM Report Usage Report has no more space, returning false");
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public static boolean writeExtraContent(CSVline line, boolean sortbyExtra, ArrayList<UsageMatchObject> userObjects, HashMap<String, String[]> usageByUser, Parameters params) {
        block0: for (UsageMatchObject user : userObjects) {
            boolean running = true;
            SapUser sapUser = new SapUser(user.getUserName(), params.system, params.client);
            UsageMatchObject currentUser = new UsageMatchObject(user.getUserName(), user.getExtraCount(), user.getPercentage(), user.getMatchingTcodes());
            Log.log("did current user instiate: " + currentUser.getUserName() + "get Extra " + currentUser.getExtraCount());
            ArrayList assignedTcodes = new ArrayList();
            ArrayList<String> usedTcodes = new ArrayList<String>(Arrays.asList(usageByUser.get(user.getUserName())));
            ArrayList<String> missingList = new ArrayList<String>(Arrays.asList(usageByUser.get(user.getUserName())));
            Integer lastIteration = 0;
            Integer extra = 0;
            List<Object> sortedKeys = new ArrayList();
            String role = "";
            while (running) {
                sortedKeys = sortbyExtra ? currentUser.sortByExtra() : currentUser.sortByPercent();
                if (sortedKeys.size() > 0) {
                    role = (String)sortedKeys.get(0);
                    assignedTcodes.addAll(currentUser.getMatchingTcodes().get(role));
                    ArrayList<String> missingTcodes = new ArrayList<String>(missingList);
                    missingTcodes.removeAll(assignedTcodes);
                    ArrayList extraTcodes = new ArrayList(currentUser.getMatchingTcodes().get(role));
                    extraTcodes.removeAll(usedTcodes);
                    HashSet<String> intersectionSet = new HashSet<String>(usedTcodes);
                    intersectionSet.retainAll(new HashSet(assignedTcodes));
                    String[] coveredTcodes = intersectionSet.toArray(new String[0]);
                    double percentage = 100.0 - (double)missingTcodes.size() / (double)usedTcodes.size() * 100.0;
                    Integer extraTcodesNum = extraTcodes.size();
                    extra = extra + extraTcodesNum;
                    String covered = coveredTcodes.length + " / " + usedTcodes.size();
                    if (params.getBoolean("addGroup")) {
                        line.add(sapUser.getUserGroup());
                    }
                    if (params.getBoolean("addName")) {
                        line.add(sapUser.getUserName());
                    }
                    if (params.getBoolean("addEmail")) {
                        line.add(sapUser.getEmail());
                    }
                    DecimalFormat decimalFormat = new DecimalFormat("0.00%");
                    String formattedPercentage = decimalFormat.format(percentage / 100.0);
                    line.add(user.getUserName());
                    line.add(formattedPercentage);
                    line.add(covered);
                    line.add(extra.toString());
                    line.add(extraTcodesNum.toString());
                    line.add(role);
                    line.add(String.join((CharSequence)", ", missingTcodes));
                    line.add(String.join((CharSequence)", ", extraTcodes));
                    boolean status = line.write();
                    if (!status) {
                        return false;
                    }
                    Log.log("should trigger? " + lastIteration + " is equal to " + missingTcodes.size() + " " + (lastIteration.intValue() == missingTcodes.size()));
                    if (missingTcodes.size() == 0) {
                        Log.log("Stop looking as usage is covered");
                        running = false;
                        continue block0;
                    }
                    if (lastIteration.intValue() == missingTcodes.size()) {
                        Log.log("Stop looking as coverage is not improving by adding more roles");
                        running = false;
                        continue block0;
                    }
                    sortedKeys = RoleUsageDetails.runComparison(missingTcodes, currentUser, sortedKeys, sortbyExtra);
                    lastIteration = missingTcodes.size();
                    Log.log("done loop. ");
                    continue;
                }
                running = false;
                continue block0;
            }
        }
        Log.log("does it ever return?");
        return true;
    }

    private static List<String> runComparison(ArrayList<String> missingTcodes, UsageMatchObject user, List<String> sortedRoles, boolean sortbyExtra) {
        HashMap<String, ArrayList<String>> newRoleTcodes = new HashMap<String, ArrayList<String>>();
        HashMap<String, Double> newPercentage = new HashMap<String, Double>();
        HashMap<String, Integer> newExtra = new HashMap<String, Integer>();
        block0: for (String role : sortedRoles) {
            ArrayList<String> currentlyUsed = new ArrayList<String>((Collection)user.getMatchingTcodes().get(role));
            for (String tcode : currentlyUsed) {
                if (!missingTcodes.contains(tcode)) continue;
                newRoleTcodes.put(role, currentlyUsed);
                Integer intersectCount = RoleUsageDetails.countIntersection(missingTcodes, currentlyUsed);
                double newPercent = (double)intersectCount.intValue() / (double)missingTcodes.size() * 100.0;
                newPercentage.put(role, newPercent);
                newExtra.put(role, currentlyUsed.size() - intersectCount);
                continue block0;
            }
        }
        user.setMatchingTcodes(newRoleTcodes);
        user.setExtraCount(newExtra);
        user.setPercentage(newPercentage);
        List<Object> sortedKeys = new ArrayList();
        sortedKeys = sortbyExtra ? user.sortByExtra() : user.sortByPercent();
        return sortedKeys;
    }

    private static Integer countIntersection(ArrayList<String> list1, ArrayList<String> list2) {
        HashSet<String> set = new HashSet<String>(list1);
        Integer count = 0;
        for (String element : list2) {
            if (!set.contains(element)) continue;
            Integer n = count;
            count = count + 1;
        }
        return count;
    }
}

