/*
 * Decompiled with CFR 0.152.
 */
package um.report.roleUsageMatch;

import cn.DB;
import cn.Log;
import cn.Translator;
import cn.task.Task;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import um.UsageRole;
import um.report.Parameters;
import um.report.roleUsageMatch.UsageMatchObject;

class RoleUsageDataGetter {
    RoleUsageDataGetter() {
    }

    private static String getUsageTable(String system, String client) {
        return "um_usage_" + system + "_" + client;
    }

    public static HashMap<String, String[]> getUsageByUser(Task task, Parameters params, Translator translator) {
        HashMap<String, ArrayList<String>> usageByUser = new HashMap<String, ArrayList<String>>();
        task.setStatusDetails(translator.getText("Finding usage"));
        String table = RoleUsageDataGetter.getUsageTable(params.getUsageSystem(), params.getUsageClient());
        String userFilter = params.getStringArray("user").length > 0 ? " AND `user` IN ('" + String.join((CharSequence)"','", params.getStringArray("user")) + "')" : "";
        try {
            PreparedStatement PS_usageMatch = DB.prepareStatement("SELECT `user`, `tcode` FROM  `" + table + "` WHERE date BETWEEN ? AND ? " + userFilter + " GROUP BY `user`, `tcode` ORDER BY `user`;");
            PS_usageMatch.setDate(1, params.getFromDate());
            PS_usageMatch.setDate(2, params.getToDate());
            ResultSet rs = PS_usageMatch.executeQuery();
            while (rs.next()) {
                String user = rs.getString("user");
                String tcode = rs.getString("tcode");
                if (tcode == null || tcode.isEmpty()) continue;
                usageByUser.compute(user, (key, existingArray) -> {
                    if (existingArray == null) {
                        ArrayList<String> newArray = new ArrayList<String>();
                        newArray.add(tcode);
                        return newArray;
                    }
                    existingArray.add(tcode);
                    return existingArray;
                });
            }
            rs.close();
            Log.log("Usage found");
        }
        catch (Exception e) {
            Log.log("um.report.RoleUsageMatch failed to get Usage");
            Log.logException(e);
        }
        HashMap<String, String[]> usageByUserList = RoleUsageDataGetter.convertToMapArray(usageByUser);
        return usageByUserList;
    }

    public static HashMap<Integer, String[]> getUsageByRole(Task task, Parameters params, Translator translator) {
        HashMap<Integer, ArrayList<String>> usagebyRole = new HashMap<Integer, ArrayList<String>>();
        task.setStatusDetails(translator.getText("Finding Roles"));
        String roleFilter = params.getStringArray("role").length > 0 ? " AND `role` IN ('" + String.join((CharSequence)"','", params.getStringArray("role")) + "')" : "";
        try {
            PreparedStatement PS_roleMatch = DB.prepareStatement("SELECT r.`id`,r.`type`,r.`license_category_id`,r.`description`, `role`, low AS tcode FROM um_role AS r JOIN um_role_auth AS a ON r.id = a.role_id WHERE\t`system` = '" + params.system + "' AND `client` = '" + params.client + "' " + roleFilter + " AND `object` = 'S_TCODE' AND `field` = 'TCD' AND a.um_delete=0 AND r.um_delete=0 ORDER BY role, tcode;");
            ResultSet rs = PS_roleMatch.executeQuery();
            while (rs.next()) {
                Integer role_id = rs.getInt("id");
                String tcode = rs.getString("tcode");
                if (tcode != null && !tcode.isEmpty()) {
                    usagebyRole.compute(role_id, (key, existingArray) -> {
                        if (existingArray == null) {
                            ArrayList<String> newArray = new ArrayList<String>();
                            newArray.add(tcode);
                            return newArray;
                        }
                        existingArray.add(tcode);
                        return existingArray;
                    });
                }
                if (UsageRole.exists(role_id)) continue;
                String description = params.getBoolean("addRoleDesc") ? rs.getString("description") : "";
                int licCatId = params.getBoolean("addCat") ? rs.getInt("license_category_id") : -1;
                UsageRole.create(role_id, rs.getString("role"), description, rs.getString("type").contentEquals("C"), params.system, params.client, licCatId);
            }
            rs.close();
            Log.log("Roles found");
        }
        catch (Exception e) {
            Log.log("um.report.RoleUsageMatch failed to get Roles");
            Log.logException(e);
        }
        HashMap<Integer, String[]> usageByRoleList = RoleUsageDataGetter.convertToMapArrayInt(usagebyRole);
        return usageByRoleList;
    }

    private static HashMap<String, String[]> convertToMapArray(HashMap<String, ArrayList<String>> mapList) {
        HashMap<String, String[]> mapArray = new HashMap<String, String[]>();
        for (String key : mapList.keySet()) {
            ArrayList<String> list = mapList.get(key);
            String[] array = list.toArray(new String[0]);
            mapArray.put(key, array);
        }
        return mapArray;
    }

    private static HashMap<Integer, String[]> convertToMapArrayInt(HashMap<Integer, ArrayList<String>> mapList) {
        HashMap<Integer, String[]> mapArray = new HashMap<Integer, String[]>();
        for (Integer key : mapList.keySet()) {
            ArrayList<String> list = mapList.get(key);
            String[] array = list.toArray(new String[0]);
            mapArray.put(key, array);
        }
        return mapArray;
    }

    private static int similarities(String[] userTcodes, String[] roleTcodes) {
        int count = 0;
        block0: for (String userTcode : userTcodes) {
            for (String roleTcode : roleTcodes) {
                if (!userTcode.equals(roleTcode)) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    public static ArrayList<UsageMatchObject> getCoverage(HashMap<String, String[]> usageByUser, HashMap<Integer, String[]> usageByRole, Task task, Parameters params, Translator translator) {
        task.setStatusDetails(translator.getText("Calculating..."));
        ArrayList<UsageMatchObject> scoreByUser = new ArrayList<UsageMatchObject>();
        for (String user : usageByUser.keySet()) {
            UsageMatchObject userInfo = new UsageMatchObject(user);
            usageByUser.get(user);
            for (Integer role : usageByRole.keySet()) {
                int count = RoleUsageDataGetter.similarities(usageByUser.get(user), usageByRole.get(role));
                if (count <= 0) continue;
                userInfo.addRoleCount(role, count);
            }
            scoreByUser.add(userInfo);
        }
        return scoreByUser;
    }
}

