/*
 * Decompiled with CFR 0.152.
 */
package um.report;

import cn.DB;
import cn.Log;
import cn.Memory;
import cn.SapUser;
import cn.Tcode;
import cn.Utils;
import cn.report.CSVline;
import cn.task.Task;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import um.Usage;
import um.UsageMapping;
import um.UsageRecord;
import um.UsageRole;
import um.report.Parameters;
import um.report.Report;

class UsageOnly
extends Report {
    private static final ArrayList<UsageRole> assigningRoles = new ArrayList();
    private static final ArrayList<UsageRole> currentRoles = new ArrayList();
    private static SapUser currentUser = null;
    private static PreparedStatement PS_load_roles = null;

    UsageOnly(Task task, Parameters params) {
        super(task, params);
        Log.log("Loading usage data.");
        this.usage = this.readUsage();
        if (params.getBoolean("addUsageMapping")) {
            Log.log("Preping usage mapping.");
            UsageMapping.setSystemClient(params.system, params.client);
        }
    }

    @Override
    protected ArrayList<String> createHeaders() {
        ArrayList<String> line = new ArrayList<String>();
        switch (this.params.getString("group")) {
            case "b": {
                line.add(this.translator.getText("User"));
                line.add(this.translator.getText("Tcode"));
                line.add(this.translator.getText("Program"));
                line.add(this.translator.getText("Type"));
                if (this.params.getBoolean("addUsageMappingType")) {
                    line.add(this.translator.getText("Type description"));
                }
                line.add(this.translator.getText("Days used"));
                if (!this.params.getBoolean("addUsageMapping")) break;
                line.add(this.translator.getText("Mapped transaction"));
                line.add(this.translator.getText("Mapped program"));
                line.add(this.translator.getText("Mapped type"));
                break;
            }
            case "u": {
                line.add(this.translator.getText("User"));
                line.add(this.translator.getText("Tcodes used"));
                break;
            }
            case "t": {
                line.add(this.translator.getText("Tcode"));
                line.add(this.translator.getText("Program"));
                line.add(this.translator.getText("Type"));
                if (this.params.getBoolean("addUsageMappingType")) {
                    line.add(this.translator.getText("Type description"));
                }
                line.add(this.translator.getText("Users who have used tcode"));
                if (!this.params.getBoolean("addUsageMapping")) break;
                line.add(this.translator.getText("Mapped transaction"));
                line.add(this.translator.getText("Mapped program"));
                line.add(this.translator.getText("Mapped type"));
            }
        }
        return line;
    }

    @Override
    protected boolean populateRows(CSVline line) {
        String group = this.params.getString("group");
        int numberOfRecords = this.usage.getUsageArray().length;
        int tellPoint = Utils.ceilDivider(numberOfRecords, 25);
        int counter = 0;
        String maxOutput = "" + numberOfRecords;
        UsageRole[] assigningRoles = UsageRole.EMPTY_ROLEARRAY;
        for (UsageRecord ur : this.usage.getUsageArray()) {
            switch (group) {
                case "b": {
                    line.add(ur.getUser());
                    line.add(ur.getTcode());
                    line.add(ur.getProgram());
                    line.add(ur.getType());
                    if (!this.params.getBoolean("addUsageMappingType")) break;
                    line.add(this.usage.getTypeDescription(ur.getType()));
                    break;
                }
                case "u": {
                    line.add(ur.getUser());
                    break;
                }
                case "t": {
                    line.add(ur.getTcode());
                    line.add(ur.getProgram());
                    line.add(ur.getType());
                    if (!this.params.getBoolean("addUsageMappingType")) break;
                    line.add(this.usage.getTypeDescription(ur.getType()));
                }
            }
            line.add("" + ur.getUsage());
            if (this.params.getBoolean("addUsageMapping")) {
                UsageMapping um = UsageMapping.getMapping(ur.getTcode(), ur.getProgram(), ur.getType());
                line.add(um.mapped_transaction);
                line.add(um.mapped_program);
                line.add(um.mapped_type);
            }
            if (this.params.getBoolean("addMonthOfLastUsage")) {
                line.add(ur.getLast_used().toString());
            }
            if (this.params.getBoolean("addTcodeDesc")) {
                line.add(Tcode.getById((int)ur.getTcode_id()).description);
            }
            SapUser user = new SapUser(ur.getUser(), this.params.system, this.params.client);
            Report.addUserInformation(this.params, line, user, this.translator);
            if (this.params.getBoolean("addAssignmentIndicator")) {
                line.add(UsageOnly.isTcodeAssigned(user, ur.getTcode()) ? this.translator.getText("Yes") : this.translator.getText("No"));
            }
            if (this.params.getBoolean("addAssigningRoles")) {
                UsageRole[] usageRoleArray = assigningRoles = ur.getTcode() == null ? UsageRole.EMPTY_ROLEARRAY : UsageOnly.getAssigningRoles(user, ur.getTcode());
                if (this.params.getBoolean("addAssigningRolesSplit")) {
                    if (assigningRoles.length > 0) {
                        ArrayList<String> roleNames = new ArrayList<String>();
                        UsageRole[] usageRoleArray2 = assigningRoles;
                        int n = usageRoleArray2.length;
                        for (int i = 0; i < n; ++i) {
                            UsageRole assigningRole = usageRoleArray2[i];
                            roleNames.add(assigningRole.name);
                        }
                        line.add(String.join((CharSequence)", ", roleNames.toArray(Utils.EMPTYSTRINGARRAY)));
                    } else {
                        line.add("");
                    }
                    line.write();
                } else if (assigningRoles.length > 0) {
                    line.start();
                    for (UsageRole assigningRole : assigningRoles) {
                        line.add(assigningRole.name);
                        if (this.params.getBoolean("addAssigningRolesDescription")) {
                            line.add(assigningRole.description);
                        }
                        if (this.params.getBoolean("addAssigningRolesSapStar")) {
                            line.add(assigningRole.getSapStarLicense(this.translator));
                        }
                        if (this.params.getBoolean("addAssigningRolesLicense")) {
                            line.add(assigningRole.getLicenseCategoryName());
                        }
                        if (this.params.getBoolean("addAssigningRolesAlternatives")) {
                            line.add(UsageOnly.getAlternativeRoles(user, ur.getTcode()));
                        }
                        line.write();
                        line.reset();
                    }
                    line.clear();
                } else {
                    line.add("");
                    if (this.params.getBoolean("addAssigningRolesDescription")) {
                        line.add("");
                    }
                    if (this.params.getBoolean("addAssigningRolesSapStar")) {
                        line.add("");
                    }
                    if (this.params.getBoolean("addAssigningRolesLicense")) {
                        line.add("");
                    }
                    if (this.params.getBoolean("addAssigningRolesAlternatives")) {
                        line.add(UsageOnly.getAlternativeRoles(user, ur.getTcode()));
                    }
                    line.write();
                }
            } else {
                if (this.params.getBoolean("addAssigningRolesAlternatives")) {
                    line.add(UsageOnly.getAlternativeRoles(user, ur.getTcode()));
                }
                line.write();
            }
            if (++counter % tellPoint != 0) continue;
            String s = this.translator.getText("Writing {1} of {2}", new String[]{"" + counter, maxOutput});
            Log.log(Memory.statement(s));
            this.task.setStatusDetails(s);
        }
        return true;
    }

    protected Usage readUsage() {
        String table = Usage.getUsageTable(this.params.system, this.params.client);
        if (DB.isTable(table)) {
            String sql = this.getStatement(table);
            return Usage.getUsageFromStatement(sql, this.params.system, this.params.client, this.params.getFromDate(), this.params.getToDate());
        }
        Log.log("NO USAGE EXISTS for " + this.params.system + " / " + this.params.client + ". Table does not exist " + table);
        return Usage.getInstance(this.params.system, this.params.client, this.params.getFromDate(), this.params.getToDate());
    }

    private String getStatement(String table) {
        StringBuilder sql = new StringBuilder("SELECT MAX(date) AS last_used, ");
        switch (this.params.getString("group")) {
            case "b": {
                sql.append("COUNT(DISTINCT(usagetable.date)) AS `usage`, ");
                break;
            }
            case "u": {
                sql.append("COUNT(DISTINCT(usagetable.tcode)) AS `usage`, ");
                break;
            }
            case "t": {
                sql.append("COUNT(DISTINCT(usagetable.user)) AS `usage`, ");
                break;
            }
            default: {
                sql.append("0 AS `usage`, ");
            }
        }
        sql.append("usagetable.* FROM `" + table + "` AS usagetable \n");
        if (!Utils.isEmpty(this.user_ids) || !Utils.isEmpty(this.userGroups) || this.params.excludeUsersExpired() || this.params.excludeUsersLocked()) {
            sql.append("LEFT JOIN um_user AS u ON u.user = usagetable.user AND u.um_delete = 0 AND u.system = '" + this.params.system + "' AND u.client = '" + this.params.client + "'\n");
        }
        if (!Utils.isEmpty(this.tcode_ids)) {
            sql.append("LEFT JOIN um_tcode AS ut ON ut.tcode = usagetable.tcode AND ut.um_delete = 0 AND ut.system = '" + this.params.system + "' AND ut.client = '" + this.params.client + "'\n");
        }
        sql.append("WHERE `date` <> '0000-00-00'\n");
        if (this.params.getFromDate() != null) {
            sql.append("AND `date` >= '" + this.params.getFromDate() + "'\n");
        }
        if (this.params.getToDate() != null) {
            sql.append("AND `date` <= '" + this.params.getToDate() + "'\n");
        }
        if (!Utils.isEmpty(this.tcode_ids)) {
            sql.append("AND ut.id IN (" + Utils.toQuotedString(this.tcode_ids) + ")\n");
        }
        Report.sqlAddUserSelections(sql, this);
        switch (this.params.getString("group")) {
            case "b": {
                sql.append("GROUP BY `user`, `tcode`, `program`, `type` ORDER BY `user` ASC, `tcode` ASC, last_used DESC\n");
                break;
            }
            case "u": {
                sql.append("GROUP BY `user` ORDER BY `user` ASC, last_used DESC\n");
                break;
            }
            case "t": {
                sql.append("GROUP BY `tcode` ORDER BY `tcode` ASC, last_used DESC\n");
            }
        }
        if (this.params.isExcel() && (this.params.getLimit() == 0 || this.params.getLimit() > 1000000)) {
            sql.append("LIMIT 1048576;");
        } else if (this.params.getLimit() > 0) {
            sql.append("LIMIT " + this.params.getLimit() + ";");
        }
        Log.log("Usage statement:\n" + sql.toString());
        return sql.toString();
    }

    private static UsageRole[] getAssigningRoles(SapUser user, String tcode) {
        assigningRoles.clear();
        for (UsageRole role : UsageOnly.getUserRoles(user)) {
            if (!role.hasTcode(tcode)) continue;
            assigningRoles.add(role);
        }
        return assigningRoles.toArray(UsageRole.EMPTY_ROLEARRAY);
    }

    private static boolean isTcodeAssigned(SapUser user, String tcode) {
        for (UsageRole role : UsageOnly.getUserRoles(user)) {
            if (!role.hasTcode(tcode)) continue;
            return true;
        }
        return false;
    }

    private static ArrayList<UsageRole> getUserRoles(SapUser user) {
        if (currentUser != user) {
            currentRoles.clear();
            if (PS_load_roles == null) {
                PS_load_roles = DB.prepareStatement("SELECT id, `role`, `description`, `type`, `system`, `client`, `license_category_id` FROM um_role WHERE id IN (\tSELECT role_id FROM um_user_role WHERE user_id = ? AND `direct` = 1);");
            }
            if (user.getId() > 0) {
                try {
                    PS_load_roles.setInt(1, user.getId());
                    ResultSet rs = PS_load_roles.executeQuery();
                    while (rs.next()) {
                        UsageRole role = new UsageRole(rs.getInt(1), rs.getString(2), rs.getString(3), rs.getString(4).contentEquals("C"), rs.getString(5), rs.getString(6), rs.getInt(7));
                        currentRoles.add(role);
                    }
                    rs.close();
                }
                catch (Exception e) {
                    Log.log("UsageRole failed at getUserRoles().");
                    Log.logException(e);
                }
            }
            currentUser = user;
        }
        return currentRoles;
    }
}

