/*
 * Decompiled with CFR 0.152.
 */
package um.report;

import cn.DB;
import cn.Log;
import cn.Memory;
import cn.SapStarLicense;
import cn.SapUser;
import cn.Tcode;
import cn.Utils;
import cn.report.CSVline;
import cn.task.Task;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import org.apache.commons.collections4.CollectionUtils;
import um.Usage;
import um.UsageRole;
import um.report.Parameters;
import um.report.Report;

class SapStar
extends Report {
    private static PreparedStatement currentLicense;

    SapStar(Task task, Parameters params) {
        super(task, params);
    }

    @Override
    protected boolean populateRows(CSVline line) {
        String statement = this.getStatement();
        Log.log("um.report.SapStar getting data.\n" + statement);
        if (!Utils.isEmpty(statement)) {
            Usage usage = Usage.getUsageFromStatement(statement, this.params.system, this.params.client, this.params.getFromDate(), this.params.getToDate());
            currentLicense = DB.prepareStatement("SELECT step FROM um_dash_star_user AS udsu \nWHERE udsu.user_id = ?;");
            int[] user_ids = this.params.getUserIdsFromParams();
            int numberOfRows = user_ids.length;
            Log.log("um.report.SapStar populateRows found " + numberOfRows + " users to check.");
            int tellPoint = Utils.ceilDivider(numberOfRows, 25);
            int counter = 0;
            for (int user_id : user_ids) {
                SapUser user = SapUser.getById(user_id);
                line.add(user.getUserName());
                line.add(SapStarLicense.getLicenseText(this.params.system, this.params.client, SapStar.getCurrentSapStar(user_id), this.translator));
                line.add(SapStarLicense.getLicenseText(this.params.system, this.params.client, SapStar.getUsageSapStarStep(user, usage), this.translator));
                if (this.params.getBoolean("addGroup")) {
                    line.add(user.getUserGroup());
                }
                if (this.params.getBoolean("addName")) {
                    line.add(user.getName());
                }
                if (this.params.getBoolean("addEmail")) {
                    line.add(user.getEmail());
                }
                if (this.params.getBoolean("addALic")) {
                    line.add(user.getSU01License());
                }
                if (this.params.getBoolean("addLock")) {
                    line.add(user.isLocked() ? this.translator.getText("Yes") : this.translator.getText("No"));
                }
                line.write();
                if (++counter % tellPoint != 0) continue;
                String s = this.translator.getText("Writing {1} of {2}", new String[]{"" + counter, "" + numberOfRows});
                Log.log(Memory.statement(s));
                this.task.setStatusDetails(s);
            }
            String s = this.translator.getText("Writing {1} of {2}", new String[]{"" + counter, "" + numberOfRows});
            Log.log(Memory.statement(s));
            this.task.setStatusDetails(s);
            Log.log("um.report.SapStar data insertion done.");
        }
        return true;
    }

    private static int getCurrentSapStar(int user_id) {
        try {
            currentLicense.setInt(1, user_id);
            return DB.preparedStatementGetCount(currentLicense);
        }
        catch (Exception e) {
            Log.log("um.report.SapStar getCurrentSapStar(" + user_id + ") FAILED!");
            Log.logException(e);
            return -1;
        }
    }

    private static int getUsageSapStarStep(SapUser user, Usage usage) {
        int step = -1;
        if (usage.isUsedUser(user.getId())) {
            UsageRole[] roles = UsageRole.getRolesForUser(user);
            ArrayList<Tcode> tcodesUsed = usage.getTcodesUsedByUser(user.getId());
            for (UsageRole r : roles) {
                boolean usedTcodesInRole;
                ArrayList<Tcode> tcodesInRole = r.getUMTcodes();
                boolean bl = usedTcodesInRole = CollectionUtils.intersection(tcodesInRole, tcodesUsed).size() > 0;
                if (!usedTcodesInRole) continue;
                if (r.getSapStarStep() < step && r.getSapStarStep() > 0 || step <= 0) {
                    step = r.getSapStarStep();
                    continue;
                }
                if (step >= 0) continue;
                step = r.getSapStarStep();
            }
        }
        return step;
    }

    @Override
    protected ArrayList<String> createHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(this.translator.getText("Username"));
        headers.add(this.translator.getText("SAP Star license"));
        headers.add(this.translator.getText("SAP Star license usage"));
        return headers;
    }

    private String getStatement() {
        Log.log("um.report.SapStar building statement.");
        String table = Usage.getUsageTable(this.params.system, this.params.client);
        if (DB.isTable(table)) {
            String statement = "SELECT COUNT(DISTINCT(`date`)) AS `usage`, MAX(date) AS last_used, t.* \nFROM `" + table + "` AS t \nLEFT JOIN um_user ON \tum_user.user = t.user AND um_user.system = '" + this.params.system + "' AND um_user.client = " + this.params.client + "\nWHERE \n\t`tcode` <> '' AND \t`tcode` NOT IN (SELECT service FROM um_service WHERE `system` = '" + this.params.system + "' AND `client` = '" + this.params.client + "') AND \t`tcode` NOT IN (SELECT `start` FROM um_start WHERE `system` = '" + this.params.system + "' AND `client` = '" + this.params.client + "') AND \t`date` <> '0000-00-00' ";
            if (this.user_ids.length > 0) {
                statement = statement + "AND um_user.id IN (" + Utils.toQuotedString(this.user_ids) + ") \n";
            } else {
                if (this.params.excludeUsersExpired()) {
                    statement = statement + "AND (um_user.valid_to IS NULL OR um_user.valid_to >= CURDATE() OR um_user.valid_to = '0000-00-00') \n";
                }
                if (this.params.excludeUsersLocked()) {
                    statement = statement + "AND IFNULL(um_user.locked, 'U') <> 'L' \n";
                }
            }
            if (this.params.getFromDate() != null) {
                statement = statement + "AND `date` >= '" + this.params.getFromDate() + "' \n";
            }
            if (this.params.getToDate() != null) {
                statement = statement + "AND `date` <= '" + this.params.getToDate() + "' \n";
            }
            statement = statement + "GROUP BY user, tcode ORDER BY t.user, last_used DESC \n";
            statement = statement + "LIMIT 1048576;";
            return statement;
        }
        Log.log(table + " does not exist. There is no data to get.");
        return null;
    }
}

