/*
 * Decompiled with CFR 0.152.
 */
package um.report;

import cn.Arguments;
import cn.Config;
import cn.DB;
import cn.Log;
import cn.SapUser;
import cn.Tcode;
import cn.Translator;
import cn.Utils;
import cn.report.CSVfile;
import cn.report.CSVline;
import cn.task.Task;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import um.LicenseCategory;
import um.RoleJournalAttribute;
import um.Usage;
import um.UsageRole;
import um.report.Fiori;
import um.report.Parameters;
import um.report.SapStar;
import um.report.UsageOnly;
import um.report.roleUsageMatch.RoleUsageMatch;
import um.report.rolebased.RoleBased;

public abstract class Report {
    public static final String OUTPUT_WRITETEXT = "Analyzing...";
    public static final String OUTPUT_STATUSTEXT = "Writing {1} of {2}";
    protected static final String group_b = "b";
    protected static final String group_u = "u";
    protected static final String group_t = "t";
    protected static final String group_n = "n";
    public Usage usage;
    protected final String grouping;
    public final Task task;
    public final Parameters params;
    public final Translator translator;
    public final int[] user_ids;
    public final int[] role_ids;
    public final int[] tcode_ids;
    public final String[] userGroups;
    protected static HashMap<String, String> alternativeRoles = new HashMap();
    protected static long timeSpentFindingCompositeAssigningRole = 0L;
    private static final HashMap<String, String> COMPOSITESASSIGNINGROLE = new HashMap();
    private static PreparedStatement ps_getCompositeAssigningRole = null;

    public static String getExecutionString() {
        return Config.getJavaStandardIncludes() + " um/report/Report ";
    }

    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        int task_id = myArgs.getInt("taskid");
        Task task = Task.getById(task_id);
        boolean success = Report.doReport(task);
        DB.close();
        if (success) {
            Log.log("Task successfully completed.");
            System.out.println("Task successfully completed.");
            Log.close();
            System.exit(0);
        } else {
            Log.log("Task partially completed.");
            System.out.println("Task partially completed.");
            Log.close();
            System.exit(2);
        }
    }

    public static boolean doReport(Task task) {
        Report report;
        String type;
        Parameters params = new Parameters(task.params);
        switch (type = params.getString("type")) {
            case "FU": {
                report = new Fiori(task, params);
                break;
            }
            case "RU": {
                report = new UsageOnly(task, params);
                break;
            }
            case "NI": {
                report = new RoleBased(task, params);
                break;
            }
            case "UR": {
                report = new RoleUsageMatch(task, params);
                break;
            }
            case "SS": {
                report = new SapStar(task, params);
                break;
            }
            default: {
                Log.log("UM report type: " + type + " is not available.");
                return false;
            }
        }
        Log.log("params: \n" + params.toString());
        return report.makeReport();
    }

    protected Report(Task task, Parameters params) {
        this.task = task;
        this.params = params;
        this.translator = Translator.getInstance(params.getLanguageISO());
        this.grouping = this.params.getString("group");
        this.userGroups = params.getStringArray("userGroup");
        this.user_ids = params.getUserIdsFromParams();
        this.role_ids = params.getRoleIds();
        this.tcode_ids = params.getStringArray("tcode").length > 0 ? Report.getTcodeIdsFromTcodeProperty(params) : Utils.EMPTYINTARRAY;
        LicenseCategory.setSystemClient(params.system, params.client);
    }

    protected boolean makeReport() {
        String outputFilename;
        this.task.setStatusDetails(this.translator.getText("Preparing report"));
        Log.log("Creating selections sheet.");
        ArrayList<String[]> lines = this.getSelectionsSheetContent();
        String baseFilename = "UM_Report_" + this.task.id;
        if (this.params.isExcel()) {
            Log.log("Excel format chosen.");
            outputFilename = baseFilename + "_selections.csv";
            Log.log("Creating selections file '" + outputFilename + "' .");
        } else {
            Log.log("CSV format chosen.");
            outputFilename = baseFilename + ".csv";
            lines.add(new String[]{"", ""});
            lines.add(new String[]{"", ""});
            Log.log("Creating selections and data file '" + outputFilename + "' .");
        }
        CSVfile output = new CSVfile(outputFilename, this.params.isExcel());
        Log.log("Writing selections to file '" + outputFilename + "' .");
        for (String[] line : lines) {
            output.writeUnformattedLine(line);
        }
        if (this.params.isExcel()) {
            Log.log("Closing selections file '" + outputFilename + "' .");
            output.close();
        }
        Log.log("Preparing output.");
        if (this.params.isExcel()) {
            outputFilename = baseFilename + ".csv";
            Log.log("Creating data file '" + outputFilename + "' .");
            output = new CSVfile(outputFilename, true);
        }
        Log.log("Creating headers.");
        ArrayList<String> headers = this.createHeaders();
        this.standardHeaders(headers);
        CharSequence[] headerArray = headers.toArray(Utils.EMPTYSTRINGARRAY);
        Log.log("Adding headers:\n" + String.join((CharSequence)" | ", headerArray));
        output.writeUnformattedLine((String[])headerArray);
        Log.log("Populating data rows with " + headerArray.length + " columns.");
        CSVline line = new CSVline(output, headerArray.length);
        this.task.setStatusDetails(this.translator.getText(OUTPUT_WRITETEXT));
        boolean notPartial = this.populateRows(line);
        Log.log("Closing CSV file.");
        output.close();
        Log.log("Datahandling finished.");
        if (this.params.isExcel()) {
            this.task.setStatusDetails(this.translator.getText("Converting to .xlsx"));
            this.task.getAttributes().setReportFilename(Config.getReportPath() + baseFilename + ".xlsx");
        } else {
            try {
                long size = Files.size(Paths.get(output.getFilename(), new String[0]));
                if (size > 0x3200000L) {
                    this.task.setStatusDetails(this.translator.getText("Compressing file size {1}B", new String[]{"" + size}));
                    this.task.getAttributes().setReportFilename(CSVfile.compressToZipFile(output.getFilename()));
                }
            }
            catch (IOException e) {
                Log.log("Unable to get filesize from '" + output.getFilename() + "'.");
                Log.logException(e);
            }
        }
        return notPartial;
    }

    protected abstract ArrayList<String> createHeaders();

    protected abstract boolean populateRows(CSVline var1);

    protected void standardHeaders(ArrayList<String> line) {
        if (this.params.getBoolean("addMonthOfLastUsage")) {
            line.add(this.translator.getText("Last usage"));
        }
        if (this.params.getBoolean("addTcodeDesc")) {
            line.add(this.translator.getText("Tcode description"));
        }
        if (this.params.getBoolean("addRoleDesc")) {
            line.add(this.translator.getText("Role description"));
        }
        if (this.params.getBoolean("addRoleSapStar")) {
            line.add(this.translator.getText("Sap Star"));
        }
        if (this.params.getBoolean("addCat")) {
            line.add(this.translator.getText("License category"));
        }
        if (this.params.getBoolean("addRoleAttr")) {
            line.add(this.translator.getText("Attributes"));
        }
        if (this.params.getBoolean("addAlt")) {
            line.add(this.translator.getText("Alternative roles"));
        }
        if (this.params.getBoolean("addGroup")) {
            line.add(this.translator.getText("User group"));
        }
        if (this.params.getBoolean("addName")) {
            line.add(this.translator.getText("Name"));
        }
        if (this.params.getBoolean("addEmail")) {
            line.add(this.translator.getText("Email"));
        }
        if (this.params.getBoolean("addALic")) {
            line.add(this.translator.getText("License"));
        }
        if (this.params.getBoolean("addLock")) {
            line.add(this.translator.getText("Lock status"));
        }
        if (this.params.getBoolean("addAssignmentIndicator")) {
            line.add(this.translator.getText("Assigned"));
        }
        if (this.params.getBoolean("addAssigningRoles")) {
            line.add(this.translator.getText("Assigning roles"));
            if (this.params.getBoolean("addAssigningRolesDescription")) {
                line.add(this.translator.getText("Role description"));
            }
            if (this.params.getBoolean("addAssigningRolesSapStar")) {
                line.add(this.translator.getText("Sap Star"));
            }
            if (this.params.getBoolean("addAssigningRolesLicense")) {
                line.add(this.translator.getText("License category"));
            }
        }
        if (this.params.getBoolean("addAssigningRolesAlternatives")) {
            line.add(this.translator.getText("Alternative roles"));
        }
    }

    protected ArrayList<String[]> getSelectionsSheetContent() {
        ArrayList<String[]> lines = new ArrayList<String[]>();
        String X = "X";
        lines.add(new String[]{this.translator.getText("ID"), "" + this.task.id});
        lines.add(new String[]{this.translator.getText("User"), this.task.username});
        lines.add(new String[]{this.translator.getText("System"), this.params.system});
        lines.add(new String[]{this.translator.getText("Client"), this.params.client});
        switch (this.params.getString("type")) {
            case "RU": {
                lines.add(new String[]{this.translator.getText("Type"), this.translator.getText("Usage")});
                break;
            }
            case "FU": {
                lines.add(new String[]{this.translator.getText("Type"), this.translator.getText("Fiori")});
                break;
            }
            case "NI": {
                lines.add(new String[]{this.translator.getText("Type"), this.translator.getText("Role")});
                break;
            }
            case "UR": {
                lines.add(new String[]{this.translator.getText("Type"), this.translator.getText("Role-usage matching")});
                break;
            }
            default: {
                lines.add(new String[]{this.translator.getText("Type"), this.translator.getText("Unknown")});
            }
        }
        if (this.params.isSet("usageSystem") && this.params.isSet("usageClient")) {
            lines.add(new String[]{this.translator.getText("Usage system"), this.params.getUsageSystem()});
            lines.add(new String[]{this.translator.getText("Usage client"), this.params.getUsageClient()});
        }
        if (this.params.isSet("group")) {
            switch (this.params.getString("group")) {
                case "n": {
                    lines.add(new String[]{this.translator.getText("Details"), this.translator.getText("None")});
                    break;
                }
                case "t": {
                    lines.add(new String[]{this.translator.getText("Details"), this.translator.getText("Tcode")});
                    break;
                }
                case "u": {
                    lines.add(new String[]{this.translator.getText("Details"), this.translator.getText("User")});
                    break;
                }
                case "b": {
                    lines.add(new String[]{this.translator.getText("Details"), this.translator.getText("Both")});
                }
            }
        }
        lines.add(new String[]{"", ""});
        lines.add(new String[]{this.translator.getText("From date"), this.params.getFromDate().toString()});
        lines.add(new String[]{this.translator.getText("To date"), this.params.getToDate().toString()});
        lines.add(new String[]{this.translator.getText("Days with usage data"), Report.getDaysWithUsage(this.params.system, this.params.client, this.params.getFromDate().toString(), this.params.getToDate().toString())});
        lines.add(new String[]{"", ""});
        if (!Utils.isEmpty(this.tcode_ids)) {
            lines.add(new String[]{this.translator.getText("Tcodes"), String.join((CharSequence)", ", this.params.getStringArray("tcode"))});
        }
        if (this.params.getBoolean("addUsageMappingType")) {
            lines.add(new String[]{this.translator.getText("Usage type description"), "X"});
            if (this.params.getBoolean("addUsageMapping")) {
                lines.add(new String[]{this.translator.getText("Usage mapping"), "X"});
            }
        }
        if (this.params.getBoolean("addUsageMappingType") || !Utils.isEmpty(this.tcode_ids)) {
            lines.add(new String[]{"", ""});
        }
        if (!Utils.isEmpty(this.params.getStringArray("user"))) {
            lines.add(new String[]{this.translator.getText("Users"), String.join((CharSequence)", ", this.params.getStringArray("user"))});
        }
        if (!Utils.isEmpty(this.userGroups)) {
            lines.add(new String[]{this.translator.getText("User groups"), String.join((CharSequence)", ", this.userGroups)});
        }
        if (this.params.excludeUsersLocked()) {
            lines.add(new String[]{this.translator.getText("Exclude locked users"), "X"});
        }
        if (this.params.excludeUsersExpired()) {
            lines.add(new String[]{this.translator.getText("Exclude expired users"), "X"});
        }
        if (!Utils.isEmpty(this.user_ids) || !Utils.isEmpty(this.userGroups) || this.params.excludeUsersLocked() || this.params.excludeUsersExpired()) {
            lines.add(new String[]{"", ""});
        }
        if (!Utils.isEmpty(this.params.getStringArray("role"))) {
            lines.add(new String[]{this.translator.getText("Roles"), String.join((CharSequence)", ", this.params.getStringArray("role"))});
        }
        if (this.params.getRoleJournalAttributes().length > 0) {
            lines.add(new String[]{this.translator.getText("Attributes"), RoleJournalAttribute.idsToString(this.params.system, this.params.client, this.params.getRoleJournalAttributes())});
        }
        if (this.params.getBoolean("addComp")) {
            lines.add(new String[]{this.translator.getText("Composites for indirect assignments"), "X"});
        }
        if (!Utils.isEmpty(this.params.getStringArray("role")) || this.params.getRoleJournalAttributes().length > 0 || this.params.getBoolean("addComp")) {
            lines.add(new String[]{"", ""});
        }
        if (this.params.getString("licCat").length() > 0) {
            lines.add(new String[]{this.translator.getText("License category"), LicenseCategory.getById(this.params.getInt("licCat")).getName()});
            lines.add(new String[]{"", ""});
        }
        if (this.params.getBoolean("addRoleDesc")) {
            lines.add(new String[]{this.translator.getText("Role description"), "X"});
        }
        if (this.params.getBoolean("addRoleSapStar")) {
            lines.add(new String[]{this.translator.getText("Sap Star"), "X"});
        }
        if (this.params.getBoolean("addCat")) {
            lines.add(new String[]{this.translator.getText("License category"), "X"});
        }
        if (this.params.getBoolean("addRoleAttr")) {
            lines.add(new String[]{this.translator.getText("Attributes"), "X"});
        }
        if (this.params.getBoolean("addALic")) {
            lines.add(new String[]{this.translator.getText("License"), "X"});
        }
        if (this.params.getBoolean("addLock")) {
            lines.add(new String[]{this.translator.getText("Lock status"), "X"});
        }
        if (this.params.getBoolean("addName")) {
            lines.add(new String[]{this.translator.getText("Name"), "X"});
        }
        if (this.params.getBoolean("addEmail")) {
            lines.add(new String[]{this.translator.getText("Email"), "X"});
        }
        if (this.params.getBoolean("addGroup")) {
            lines.add(new String[]{this.translator.getText("User group"), "X"});
        }
        if (this.params.getBoolean("addTcodeDesc")) {
            lines.add(new String[]{this.translator.getText("Tcode description"), "X"});
        }
        if (this.params.getBoolean("addAssignmentIndicator")) {
            lines.add(new String[]{this.translator.getText("Assigned"), "X"});
        }
        if (this.params.getBoolean("addAssigningRoles")) {
            lines.add(new String[]{this.translator.getText("Assigning roles"), "X"});
        }
        if (this.params.getBoolean("addAssigningRolesDescription")) {
            lines.add(new String[]{this.translator.getText("Role description"), "X"});
        }
        if (this.params.getBoolean("addAssigningRolesSapStar")) {
            lines.add(new String[]{this.translator.getText("Sap Star"), "X"});
        }
        if (this.params.getBoolean("addAssigningRolesLicense")) {
            lines.add(new String[]{this.translator.getText("License category"), "X"});
        }
        if (this.params.getBoolean("addAssigningRolesSplit")) {
            lines.add(new String[]{this.translator.getText("Collate assigning roles"), "X"});
        }
        if (this.params.getBoolean("addAssigningRolesAlternatives")) {
            lines.add(new String[]{this.translator.getText("Alternative roles"), "X"});
        }
        if (this.params.getBoolean("addMonthOfLastUsage")) {
            lines.add(new String[]{this.translator.getText("Last usage"), "X"});
        }
        return lines;
    }

    public static String getAlternativeRoles(SapUser user, String tcode) {
        if (!alternativeRoles.containsKey(tcode)) {
            ArrayList<String> roleNames = new ArrayList<String>();
            for (UsageRole role : UsageRole.getRolesWithTcode(tcode, user.system, user.client)) {
                roleNames.add(role.name);
            }
            alternativeRoles.put(tcode, String.join((CharSequence)", ", roleNames));
        }
        return alternativeRoles.get(tcode);
    }

    static String getDaysWithUsage(String system, String client, String fromDate, String toDate) {
        String table = Usage.getUsageTable(system, client);
        if (DB.isTable(table)) {
            ResultSet rs = DB.getData("SELECT \tCOUNT(DISTINCT(DATE(`date`))) AS `active`, \tDATEDIFF('" + toDate + "', '" + fromDate + "')+1 AS days FROM `" + table + "` WHERE DATE(`date`) BETWEEN '" + fromDate + "' AND '" + toDate + "';");
            try {
                if (rs.next()) {
                    int days = rs.getInt("days");
                    int data = rs.getInt("active");
                    return data + " / " + days;
                }
                rs.close();
            }
            catch (SQLException e) {
                Log.log("Could not get number of usage days.");
                Log.logException(e);
            }
        } else {
            Log.log(table + " does not exist. There is no data to retrieve and no usage dates to count.");
        }
        return "0 / 0";
    }

    static String getFileName(Task task) {
        String filename = "UM_Report_" + task.id + ".xlsx";
        return filename;
    }

    public static void addUserInformation(Parameters params, CSVline line, SapUser sapUser, Translator translator) {
        if (sapUser.username != null) {
            if (params.getBoolean("addGroup")) {
                line.add(sapUser.getUserGroup());
            }
            if (params.getBoolean("addName")) {
                line.add(sapUser.getFirstName() + " " + sapUser.getLastName());
            }
            if (params.getBoolean("addEmail")) {
                line.add(sapUser.getEmail());
            }
            if (params.getBoolean("addALic")) {
                line.add(sapUser.getSU01License());
            }
            if (params.getBoolean("addLock")) {
                line.add(sapUser.isLocked() ? translator.getText("Locked") : translator.getText("Not locked"));
            }
        }
    }

    public static void sqlAddUserSelections(StringBuilder sql, Report report) {
        if (Utils.isEmpty(report.user_ids)) {
            if (!Utils.isEmpty(report.userGroups)) {
                sql.append("AND u.user_group IN (" + Utils.toQuotedString(report.userGroups) + ")\n");
            }
            if (report.params.excludeUsersExpired()) {
                sql.append("AND (u.valid_to IS NULL OR u.valid_to >= CURDATE() OR u.valid_to = '0000-00-00')\n");
            }
            if (report.params.excludeUsersLocked()) {
                sql.append("AND u.locked <> 'L'\n");
            }
        } else {
            sql.append("AND u.id IN (" + Utils.toQuotedString(report.user_ids) + ")\n");
        }
    }

    public static void sqlAddRoleSelections(StringBuilder sql, Report report) {
        if (!Utils.isEmpty(report.role_ids)) {
            sql.append("AND r.id IN (" + Utils.toQuotedString(report.role_ids) + ") ");
        } else {
            switch (report.params.getString("roleType")) {
                case "S": {
                    sql.append("AND r.type = 'S' ");
                    break;
                }
                case "C": {
                    sql.append("AND r.type = 'C' ");
                    break;
                }
                case "A": {
                    sql.append("AND r.id IN (SELECT role_id FROM um_user_role \tJOIN um_user AS u ON u.id = um_user_role.user_id AND u.um_delete = 0 \tWHERE \t\tum_user_role.system = '" + report.params.system + "' AND\t\t\tum_user_role.client = '" + report.params.client + "' AND \t\tum_user_role.um_delete = 0 AND \t    u.um_delete = 0 \t) ");
                    break;
                }
            }
        }
        if (report.params.getRoleJournalAttributes().length > 0) {
            sql.append("AND attribute_choice_id IN (" + Utils.toQuotedString(report.params.getRoleJournalAttributes()) + ") ");
        }
    }

    public static void sqlAddTcodeSelections(StringBuilder sql, Report report) {
        if (!Utils.isEmpty(report.tcode_ids)) {
            sql.append("AND rt.tcode_id IN (" + Utils.toQuotedString(report.tcode_ids) + ") ");
        }
    }

    public static String getCompositesAssigningRole(int sapUser_id, int role_id) {
        String key = sapUser_id + "\t" + role_id;
        if (!COMPOSITESASSIGNINGROLE.containsKey(key)) {
            long startTime = System.currentTimeMillis();
            CharSequence[] rolenames = Utils.EMPTYSTRINGARRAY;
            if (ps_getCompositeAssigningRole == null) {
                ps_getCompositeAssigningRole = DB.prepareStatement("SELECT DISTINCT(um_role.role) FROM um_role_comp \nJOIN um_user_role ON um_user_role.user_id = ? AND um_user_role.role_id = um_role_comp.composite AND um_user_role.um_delete = 0 \nJOIN um_role ON um_role.id = um_role_comp.composite AND um_role.um_delete = 0 \nWHERE um_role_comp.single = ? AND um_role_comp.um_delete = 0 ;");
            }
            try {
                ps_getCompositeAssigningRole.setInt(1, sapUser_id);
                ps_getCompositeAssigningRole.setInt(2, role_id);
                rolenames = DB.preparedStatementGetOneTextColumn(ps_getCompositeAssigningRole);
                if (Utils.isEmpty((String[])rolenames)) {
                    Log.log("um.report.Report getCompositesAssigningRole didn't find anything ('" + sapUser_id + "' / '" + role_id + "'). Although " + role_id + " is supposedly assigned indirectly.");
                }
            }
            catch (Exception e) {
                Log.log("um.report.Report getCompositesAssigningRole FAILED! ('" + sapUser_id + "' / '" + role_id + "').");
                Log.logException(e);
            }
            timeSpentFindingCompositeAssigningRole += System.currentTimeMillis() - startTime;
            COMPOSITESASSIGNINGROLE.put(key, String.join((CharSequence)", ", rolenames));
        }
        return COMPOSITESASSIGNINGROLE.get(key);
    }

    public String getCSVtable() {
        return "temp_um_report_" + this.task.id;
    }

    private static int[] getTcodeIdsFromTcodeProperty(Parameters params) {
        ArrayList<Integer> tcode_ids = new ArrayList<Integer>();
        for (String tcodename : params.getStringArray("tcode")) {
            if (tcodename.contains("*")) {
                tcode_ids.addAll(Tcode.getIdsFromAsteriskSearch(tcodename, params.system, params.client));
                continue;
            }
            tcode_ids.add(Tcode.getIdFromName(tcodename, params.system, params.client));
        }
        return Utils.integerListToIntArray(tcode_ids);
    }
}

